/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.peers;

import java.util.Collection;
import net.tomp2p.connection.PeerConnection;
import net.tomp2p.connection.PeerException;
import net.tomp2p.peers.DefaultMaintenance;
import net.tomp2p.peers.LocalMapConf;
import net.tomp2p.peers.Maintainable;
import net.tomp2p.peers.Number160;
import net.tomp2p.peers.PeerAddress;
import net.tomp2p.peers.PeerMap;
import net.tomp2p.peers.PeerStatistic;
import net.tomp2p.peers.PeerStatusListener;
import net.tomp2p.utils.ConcurrentCacheMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalMap
implements Maintainable,
PeerStatusListener {
    private static final Logger LOG = LoggerFactory.getLogger(LocalMap.class);
    private final ConcurrentCacheMap<Number160, PeerStatistic> localMap;
    private final ConcurrentCacheMap<Number160, PeerAddress> localMapRev;
    private final ConcurrentCacheMap<Number160, Boolean> offlineMap;
    private final int[] intervalSeconds;

    public LocalMap() {
        this(new LocalMapConf());
    }

    public LocalMap(LocalMapConf localMapConf) {
        this.localMap = new ConcurrentCacheMap(localMapConf.localMapTimout(), localMapConf.localMapSize());
        this.localMapRev = new ConcurrentCacheMap(localMapConf.localMapRevTimeout(), localMapConf.localMapRevSize());
        this.offlineMap = new ConcurrentCacheMap(localMapConf.offlineMapTimout(), localMapConf.offlineMapSize());
        this.intervalSeconds = localMapConf.intervalSeconds();
    }

    @Override
    public PeerStatistic nextForMaintenance(Collection<PeerAddress> notInterestedAddresses) {
        for (PeerStatistic peerStatistic : this.localMap.values()) {
            if (!DefaultMaintenance.needMaintenance(peerStatistic, this.intervalSeconds)) continue;
            return peerStatistic;
        }
        return null;
    }

    @Override
    public boolean peerFailed(PeerAddress remotePeer, PeerException exception) {
        PeerStatistic ps = this.localMap.remove(remotePeer.peerId());
        this.localMapRev.remove(remotePeer.peerId());
        this.offlineMap.put(remotePeer.peerId(), Boolean.TRUE);
        return ps != null;
    }

    @Override
    public boolean peerFound(PeerAddress remotePeer, PeerAddress referrer, PeerConnection peerConnection) {
        return false;
    }

    public boolean peerFound(PeerAddress remotePeer, PeerAddress referrer) {
        LOG.debug("local peer {} is online reporter was {}", (Object)remotePeer, (Object)referrer);
        boolean firstHand = referrer == null;
        boolean secondHand = remotePeer.equals(referrer);
        if (firstHand || secondHand) {
            this.offlineMap.remove(remotePeer.peerId());
            PeerStatistic peerStatatistic = PeerMap.updateExistingVerifiedPeerAddress(this.localMap, remotePeer, firstHand);
            if (peerStatatistic == null) {
                peerStatatistic = new PeerStatistic(remotePeer);
                this.localMap.put(remotePeer.peerId(), peerStatatistic);
            }
            peerStatatistic.successfullyChecked();
            peerStatatistic.local();
            return true;
        }
        return false;
    }

    public PeerStatistic translate(PeerAddress remotePeer) {
        PeerStatistic peerStatistic = this.localMap.get(remotePeer.peerId());
        if (peerStatistic != null) {
            this.localMapRev.put(remotePeer.peerId(), remotePeer);
        }
        return peerStatistic;
    }

    public PeerAddress translateReverse(PeerAddress remotePeer) {
        PeerAddress peerAddress = this.localMapRev.get(remotePeer.peerId());
        return peerAddress;
    }

    public int size() {
        return this.localMap.size();
    }
}

