/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.message;

import io.netty.buffer.ByteBuf;
import java.net.InetSocketAddress;
import net.tomp2p.message.Message;
import net.tomp2p.peers.Number160;
import net.tomp2p.peers.PeerAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MessageHeaderCodec {
    private static final Logger LOG = LoggerFactory.getLogger(MessageHeaderCodec.class);
    public static final int HEADER_SIZE = 58;

    private MessageHeaderCodec() {
    }

    public static void encodeHeader(ByteBuf buffer, Message message) {
        int versionAndType = message.version() << 4 | message.type().ordinal() & 0xF;
        buffer.writeInt(versionAndType);
        buffer.writeInt(message.messageId());
        buffer.writeByte((int)message.command());
        buffer.writeBytes(message.sender().peerId().toByteArray());
        buffer.writeShort((int)((short)message.sender().tcpPort()));
        buffer.writeShort((int)((short)message.sender().udpPort()));
        buffer.writeBytes(message.recipient().peerId().toByteArray());
        buffer.writeInt(MessageHeaderCodec.encodeContentTypes(message.contentTypes()));
        buffer.writeByte(message.sender().options() << 3 | message.options());
    }

    public static Message decodeHeader(ByteBuf buffer, InetSocketAddress recipientSocket, InetSocketAddress senderSocket) {
        LOG.debug("Decode message. Recipient: {}, Sender:{}.", (Object)recipientSocket, (Object)senderSocket);
        Message message = new Message();
        int versionAndType = buffer.readInt();
        message.version(versionAndType >>> 4);
        message.type(Message.Type.values()[versionAndType & 0xF]);
        message.messageId(buffer.readInt());
        short command = buffer.readUnsignedByte();
        message.command((byte)command);
        Number160 senderID = MessageHeaderCodec.readID(buffer);
        int tcpPort = buffer.readUnsignedShort();
        int udpPort = buffer.readUnsignedShort();
        Number160 recipientID = MessageHeaderCodec.readID(buffer);
        message.recipient(new PeerAddress(recipientID, recipientSocket));
        int contentTypes = buffer.readInt();
        message.hasContent(contentTypes != 0);
        message.contentTypes(MessageHeaderCodec.decodeContentTypes(contentTypes, message));
        short options = buffer.readUnsignedByte();
        message.options(options & 7);
        int senderOptions = options >>> 3;
        PeerAddress peerAddress = new PeerAddress(senderID, senderSocket.getAddress(), tcpPort, udpPort, senderOptions);
        message.sender(peerAddress);
        message.senderSocket(senderSocket);
        message.recipientSocket(recipientSocket);
        return message;
    }

    private static Number160 readID(ByteBuf buffer) {
        byte[] me = new byte[20];
        buffer.readBytes(me);
        return new Number160(me);
    }

    public static int encodeContentTypes(Message.Content[] contentTypes) {
        int result = 0;
        for (int i = 0; i < 4; ++i) {
            if (contentTypes[i * 2] != null) {
                result |= contentTypes[i * 2].ordinal() << i * 8;
            }
            if (contentTypes[i * 2 + 1] == null) continue;
            result |= contentTypes[i * 2 + 1].ordinal() << 4 << i * 8;
        }
        return result;
    }

    public static Message.Content[] decodeContentTypes(int contentTypes, Message message) {
        Message.Content[] result = new Message.Content[8];
        for (int i = 0; i < 8; ++i) {
            Message.Content content;
            result[i] = content = Message.Content.values()[contentTypes & 0xF];
            if (content == Message.Content.PUBLIC_KEY_SIGNATURE) {
                message.setHintSign();
            }
            contentTypes >>>= 4;
        }
        return result;
    }
}

