/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.connection;

import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Collection;

public class DiscoverResults {
    private final Collection<InetAddress> newAddresses;
    private final Collection<InetAddress> newBroadcastAddresses;
    private final Collection<InetAddress> removedFoundAddresses;
    private final Collection<InetAddress> removedFoundBroadcastAddresses;
    private final Collection<InetAddress> existingAddresses;
    private final Collection<InetAddress> existingBroadcastAddresses;
    private final String status;
    private final boolean listenAny;

    public DiscoverResults(Collection<InetAddress> newAddresses, Collection<InetAddress> newBroadcastAddresses, Collection<InetAddress> removedFoundAddresses, Collection<InetAddress> removedFoundBroadcastAddresses, Collection<InetAddress> existingAddresses, Collection<InetAddress> existingBroadcastAddresses, boolean listenAny, String status) {
        this.newAddresses = newAddresses;
        this.newBroadcastAddresses = newBroadcastAddresses;
        this.removedFoundAddresses = removedFoundAddresses;
        this.removedFoundBroadcastAddresses = removedFoundBroadcastAddresses;
        this.existingAddresses = existingAddresses;
        this.existingBroadcastAddresses = existingBroadcastAddresses;
        this.listenAny = listenAny;
        this.status = status;
    }

    public Collection<InetAddress> newAddresses() {
        return this.newAddresses;
    }

    public Collection<InetAddress> newBroadcastAddresses() {
        return this.newBroadcastAddresses;
    }

    public Collection<InetAddress> removedFoundAddresses() {
        return this.removedFoundAddresses;
    }

    public Collection<InetAddress> removedFoundBroadcastAddresses() {
        return this.removedFoundBroadcastAddresses;
    }

    public Collection<InetAddress> existingAddresses() {
        return this.existingAddresses;
    }

    public Collection<InetAddress> existingBroadcastAddresses() {
        return this.existingBroadcastAddresses;
    }

    public boolean isListenAny() {
        return this.listenAny;
    }

    public String status() {
        return this.status;
    }

    public boolean isEmpty() {
        return this.newAddresses.isEmpty() && this.newBroadcastAddresses.isEmpty() && this.removedFoundAddresses.isEmpty() && this.removedFoundBroadcastAddresses.isEmpty();
    }

    public InetAddress foundAddress() {
        for (InetAddress inetAddress : this.newAddresses) {
            if (!(inetAddress instanceof Inet4Address)) continue;
            return inetAddress;
        }
        if (!this.newAddresses.isEmpty()) {
            return this.newAddresses.iterator().next();
        }
        return null;
    }

    public SocketAddress wildCardSocket() {
        InetAddress foundAddress = this.foundAddress();
        if (foundAddress != null) {
            return new InetSocketAddress(foundAddress, 0);
        }
        return new InetSocketAddress(0);
    }
}

