/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.relay;

import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.tomp2p.connection.ChannelCreator;
import net.tomp2p.connection.ConnectionConfiguration;
import net.tomp2p.connection.DefaultConnectionConfiguration;
import net.tomp2p.connection.PeerConnection;
import net.tomp2p.connection.Responder;
import net.tomp2p.futures.BaseFuture;
import net.tomp2p.futures.BaseFutureAdapter;
import net.tomp2p.futures.BaseFutureListener;
import net.tomp2p.futures.FutureDone;
import net.tomp2p.futures.FuturePeerConnection;
import net.tomp2p.futures.FutureResponse;
import net.tomp2p.message.Buffer;
import net.tomp2p.message.Message;
import net.tomp2p.message.NeighborSet;
import net.tomp2p.p2p.Peer;
import net.tomp2p.peers.Number160;
import net.tomp2p.peers.PeerAddress;
import net.tomp2p.peers.PeerSocketAddress;
import net.tomp2p.peers.PeerStatatistic;
import net.tomp2p.relay.RconRPC;
import net.tomp2p.relay.RelayForwarderRPC;
import net.tomp2p.relay.RelayUtils;
import net.tomp2p.rpc.DispatchHandler;
import net.tomp2p.rpc.RPC;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RelayRPC
extends DispatchHandler {
    private static final Logger LOG = LoggerFactory.getLogger(RelayRPC.class);
    private final ConnectionConfiguration config;
    private final Peer peer;
    private final RconRPC rconRPC;

    public RelayRPC(Peer peer, RconRPC rconRPC) {
        super(peer.peerBean(), peer.connectionBean());
        this.register(new int[]{RPC.Commands.RELAY.getNr()});
        this.peer = peer;
        this.rconRPC = rconRPC;
        this.config = new DefaultConnectionConfiguration();
    }

    public FutureResponse sendPeerMap(PeerAddress peerAddress, List<Map<Number160, PeerStatatistic>> map, PeerConnection peerConnection) {
        Message message = this.createMessage(peerAddress, RPC.Commands.RELAY.getNr(), Message.Type.REQUEST_3);
        message.keepAlive(true);
        message.neighborsSet(new NeighborSet(-1, RelayUtils.flatten(map)));
        FutureResponse futureResponse = new FutureResponse(message);
        return RelayUtils.sendSingle(peerConnection, futureResponse, this.peerBean(), this.connectionBean(), this.config);
    }

    public FutureResponse forwardMessage(PeerConnection peerConnection, Buffer buf, PeerSocketAddress peerSocketAddress) {
        Message message = this.createMessage(peerConnection.remotePeer(), RPC.Commands.RELAY.getNr(), Message.Type.REQUEST_2);
        message.keepAlive(true);
        message.buffer(buf);
        ArrayList<PeerSocketAddress> peerSocketAddresses = new ArrayList<PeerSocketAddress>(1);
        peerSocketAddresses.add(peerSocketAddress);
        message.peerSocketAddresses(peerSocketAddresses);
        FutureResponse futureResponse = new FutureResponse(message);
        return RelayUtils.sendSingle(peerConnection, futureResponse, this.peerBean(), this.connectionBean(), this.config);
    }

    public FutureDone<PeerConnection> setupRelay(ChannelCreator channelCreator, FuturePeerConnection fpc) {
        final FutureDone futureDone = new FutureDone();
        Message message = this.createMessage(fpc.remotePeer(), RPC.Commands.RELAY.getNr(), Message.Type.REQUEST_1);
        message.keepAlive(true);
        final FutureResponse futureResponse = new FutureResponse(message);
        LOG.debug("Setting up relay connection to peer {}, message {}", (Object)fpc.remotePeer(), (Object)message);
        fpc.addListener((BaseFutureListener)new BaseFutureAdapter<FuturePeerConnection>(){

            public void operationComplete(FuturePeerConnection futurePeerConnection) throws Exception {
                if (futurePeerConnection.isSuccess()) {
                    final PeerConnection peerConnection = (PeerConnection)futurePeerConnection.object();
                    RelayUtils.sendSingle(peerConnection, futureResponse, RelayRPC.this.peerBean(), RelayRPC.this.connectionBean(), RelayRPC.this.config).addListener((BaseFutureListener)new BaseFutureAdapter<FutureResponse>(){

                        public void operationComplete(FutureResponse future) throws Exception {
                            if (future.isSuccess()) {
                                futureDone.done((Object)peerConnection);
                            } else {
                                futureDone.failed((BaseFuture)future);
                            }
                        }
                    });
                } else {
                    futureDone.failed((BaseFuture)futurePeerConnection);
                }
            }
        });
        return futureDone;
    }

    public void handleResponse(Message message, PeerConnection peerConnection, boolean sign, Responder responder) throws Exception {
        LOG.debug("received RPC message {}", (Object)message);
        if (message.type() == Message.Type.REQUEST_1 && message.command() == RPC.Commands.RELAY.getNr()) {
            this.handleSetup(message, peerConnection, responder);
        } else if (message.type() == Message.Type.REQUEST_2 && message.command() == RPC.Commands.RELAY.getNr()) {
            this.handlePiggyBackMessage(message, responder);
        } else if (message.type() == Message.Type.REQUEST_3 && message.command() == RPC.Commands.RELAY.getNr()) {
            this.handleMap(message, responder);
        } else {
            throw new IllegalArgumentException("Message content is wrong");
        }
    }

    public Peer peer() {
        return this.peer;
    }

    private void handleSetup(Message message, PeerConnection peerConnection, Responder responder) {
        if (this.peerBean().serverPeerAddress().isRelayed()) {
            LOG.warn("I cannot be a relay since I'm relayed as well! {}", (Object)message);
            responder.response(this.createResponseMessage(message, Message.Type.DENIED));
            return;
        }
        RelayForwarderRPC.register(peerConnection, this.peer, this, this.rconRPC);
        LOG.debug("I'll be your relay! {}", (Object)message);
        responder.response(this.createResponseMessage(message, Message.Type.OK));
    }

    private void handlePiggyBackMessage(Message message, final Responder responderToRelay) throws Exception {
        Buffer requestBuffer = message.buffer(0);
        List peerSocketAddresses = message.peerSocketAddresses();
        InetSocketAddress sender = !peerSocketAddresses.isEmpty() ? PeerSocketAddress.createSocketTCP((PeerSocketAddress)((PeerSocketAddress)peerSocketAddresses.iterator().next())) : new InetSocketAddress(0);
        Message realMessage = RelayUtils.decodeMessage(requestBuffer, message.recipientSocket(), sender, this.connectionBean().channelServer().channelServerConfiguration().signatureFactory());
        boolean isRelay = realMessage.sender().isRelayed();
        if (isRelay && !realMessage.peerSocketAddresses().isEmpty()) {
            PeerAddress tmpSender = realMessage.sender().changePeerSocketAddresses((Collection)realMessage.peerSocketAddresses());
            realMessage.sender(tmpSender);
        }
        LOG.debug("Received message from relay peer: {}", (Object)realMessage);
        realMessage.restoreContentReferences();
        final Message response = this.createResponseMessage(message, Message.Type.OK);
        Responder responder = new Responder(){

            public void response(Message responseMessage) {
                LOG.debug("Send reply message to relay peer: {}", (Object)responseMessage);
                try {
                    if (responseMessage.sender().isRelayed() && !responseMessage.sender().peerSocketAddresses().isEmpty()) {
                        responseMessage.peerSocketAddresses(responseMessage.sender().peerSocketAddresses());
                    }
                    response.buffer(RelayUtils.encodeMessage(responseMessage, RelayRPC.this.connectionBean().channelServer().channelServerConfiguration().signatureFactory()));
                }
                catch (Exception e) {
                    this.failed(Message.Type.EXCEPTION, e.getMessage());
                    e.printStackTrace();
                }
                responderToRelay.response(response);
            }

            public void failed(Message.Type type, String reason) {
                responderToRelay.failed(type, reason);
            }

            public void responseFireAndForget() {
                responderToRelay.responseFireAndForget();
            }
        };
        DispatchHandler dispatchHandler = this.peer.connectionBean().dispatcher().associatedHandler(realMessage);
        if (dispatchHandler == null) {
            responder.failed(Message.Type.EXCEPTION, "handler not found, probably not relaying peer anymore");
        } else {
            dispatchHandler.handleResponse(realMessage, null, false, responder);
        }
    }

    private void handleMap(Message message, Responder responder) {
        LOG.debug("handle foreign map {}", (Object)message);
        Collection map = message.neighborsSet(0).neighbors();
        RelayForwarderRPC relayForwarderRPC = RelayForwarderRPC.find(this.peer, message.sender().peerId());
        if (relayForwarderRPC != null) {
            relayForwarderRPC.setMap(RelayUtils.unflatten(map, message.sender()));
        } else {
            LOG.error("need to call setup relay first");
        }
        Message response = this.createResponseMessage(message, Message.Type.OK);
        responder.response(response);
    }
}

