/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.peers;

import io.netty.buffer.ByteBuf;
import java.io.Serializable;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import net.tomp2p.peers.Number160;
import net.tomp2p.peers.PeerSocketAddress;
import net.tomp2p.utils.Utils;

public final class PeerAddress
implements Comparable<PeerAddress>,
Serializable {
    public static final int MAX_SIZE = 142;
    public static final int MIN_SIZE = 30;
    public static final int MAX_RELAYS = 5;
    private static final long serialVersionUID = -1316622724169272306L;
    private static final int NET6 = 1;
    private static final int FIREWALL_UDP = 2;
    private static final int FIREWALL_TCP = 4;
    private static final int IS_RELAYED = 8;
    private final Number160 peerId;
    private final PeerSocketAddress peerSocketAddress;
    private final boolean net6;
    private final boolean firewalledUDP;
    private final boolean firewalledTCP;
    private final boolean isRelayed;
    private final int hashCode;
    private final int offset;
    private final int size;
    private final int relaySize;
    private final BitSet relayType;
    private static final BitSet EMPTY_RELAY_TYPE = new BitSet(0);
    private final Collection<PeerSocketAddress> peerSocketAddresses;
    public static final Collection<PeerSocketAddress> EMPTY_PEER_SOCKET_ADDRESSES = Collections.emptySet();
    private static final int TYPE_BIT_SIZE = 5;
    private static final int HEADER_SIZE = 2;
    private static final int PORTS_SIZE = 4;
    private static final int MASK_1F = 31;
    private static final int MASK_7 = 7;

    public PeerAddress(byte[] me) {
        this(me, 0);
    }

    public PeerAddress(byte[] me, int initialOffset) {
        int offset = initialOffset;
        int options = me[offset++] & 0xFF;
        this.net6 = (options & 1) > 0;
        this.firewalledUDP = (options & 2) > 0;
        this.firewalledTCP = (options & 4) > 0;
        this.isRelayed = (options & 8) > 0;
        int relays = me[offset++] & 0xFF;
        this.relaySize = relays >>> 5 & 7;
        byte b = (byte)(relays & 0x1F);
        this.relayType = Utils.createBitSet(b);
        byte[] tmp = new byte[20];
        System.arraycopy(me, offset, tmp, 0, 20);
        this.peerId = new Number160(tmp);
        this.peerSocketAddress = PeerSocketAddress.create(me, this.isIPv4(), offset += 20);
        offset = this.peerSocketAddress.offset();
        if (this.relaySize > 0) {
            this.peerSocketAddresses = new ArrayList<PeerSocketAddress>(this.relaySize);
            for (int i = 0; i < this.relaySize; ++i) {
                PeerSocketAddress psa = PeerSocketAddress.create(me, !this.relayType.get(i), offset);
                this.peerSocketAddresses.add(psa);
                offset = psa.offset();
            }
        } else {
            this.peerSocketAddresses = EMPTY_PEER_SOCKET_ADDRESSES;
        }
        this.size = offset - initialOffset;
        this.offset = offset;
        this.hashCode = this.peerId.hashCode();
    }

    public PeerAddress(ByteBuf channelBuffer) {
        int readerIndex = channelBuffer.readerIndex();
        short options = channelBuffer.readUnsignedByte();
        this.net6 = (options & 1) > 0;
        this.firewalledUDP = (options & 2) > 0;
        this.firewalledTCP = (options & 4) > 0;
        this.isRelayed = (options & 8) > 0;
        short relays = channelBuffer.readUnsignedByte();
        this.relaySize = relays >>> 5 & 7;
        byte b = (byte)(relays & 0x1F);
        this.relayType = Utils.createBitSet(b);
        byte[] me = new byte[20];
        channelBuffer.readBytes(me);
        this.peerId = new Number160(me);
        this.peerSocketAddress = PeerSocketAddress.create(channelBuffer, this.isIPv4());
        if (this.relaySize > 0) {
            this.peerSocketAddresses = new ArrayList<PeerSocketAddress>(this.relaySize);
            for (int i = 0; i < this.relaySize; ++i) {
                this.peerSocketAddresses.add(PeerSocketAddress.create(channelBuffer, !this.relayType.get(i)));
            }
        } else {
            this.peerSocketAddresses = EMPTY_PEER_SOCKET_ADDRESSES;
        }
        this.size = channelBuffer.readerIndex() - readerIndex;
        this.offset = -1;
        this.hashCode = this.peerId.hashCode();
    }

    public PeerAddress(Number160 id) {
        this(id, (InetAddress)null, -1, -1);
    }

    public PeerAddress(Number160 id, InetAddress address) {
        this(id, address, -1, -1);
    }

    public PeerAddress(Number160 id, PeerSocketAddress peerSocketAddress, boolean firewalledTCP, boolean firewalledUDP, boolean isRelayed, Collection<PeerSocketAddress> peerSocketAddresses) {
        this.peerId = id;
        int size = 20;
        this.peerSocketAddress = peerSocketAddress;
        this.hashCode = id.hashCode();
        this.net6 = peerSocketAddress.inetAddress() instanceof Inet6Address;
        this.firewalledUDP = firewalledUDP;
        this.firewalledTCP = firewalledTCP;
        this.isRelayed = isRelayed;
        size += 6 + (this.net6 ? 16 : 4);
        if (peerSocketAddresses == null) {
            this.peerSocketAddresses = EMPTY_PEER_SOCKET_ADDRESSES;
            this.relayType = EMPTY_RELAY_TYPE;
            this.relaySize = 0;
        } else {
            this.relaySize = peerSocketAddresses.size();
            if (this.relaySize > 5) {
                throw new IllegalArgumentException("Can only store up to 5 relay peers. Tried to store: " + this.relaySize);
            }
            this.peerSocketAddresses = peerSocketAddresses;
            this.relayType = new BitSet(this.relaySize);
        }
        int index = 0;
        for (PeerSocketAddress psa : peerSocketAddresses) {
            boolean isIPV6 = psa.inetAddress() instanceof Inet6Address;
            this.relayType.set(index, isIPV6);
            size += psa.size();
            ++index;
        }
        this.size = size;
        this.offset = -1;
    }

    public PeerAddress(Number160 peerId, InetAddress inetAddress, int tcpPort, int udpPort) {
        this(peerId, new PeerSocketAddress(inetAddress, tcpPort, udpPort), false, false, false, EMPTY_PEER_SOCKET_ADDRESSES);
    }

    public PeerAddress(Number160 id, String address, int tcpPort, int udpPort) throws UnknownHostException {
        this(id, InetAddress.getByName(address), tcpPort, udpPort);
    }

    public PeerAddress(Number160 id, InetSocketAddress inetSocketAddress) {
        this(id, inetSocketAddress.getAddress(), inetSocketAddress.getPort(), inetSocketAddress.getPort());
    }

    public PeerAddress(Number160 id, InetAddress inetAddress, int tcpPort, int udpPort, int options) {
        this(id, new PeerSocketAddress(inetAddress, tcpPort, udpPort), PeerAddress.isFirewalledTCP(options), PeerAddress.isFirewalledUDP(options), PeerAddress.isRelay(options), EMPTY_PEER_SOCKET_ADDRESSES);
    }

    public int offset() {
        return this.offset;
    }

    public int size() {
        return this.size;
    }

    public byte[] toByteArray() {
        byte[] me = new byte[this.size];
        this.toByteArray(me, 0);
        return me;
    }

    public int toByteArray(byte[] me, int offset) {
        int newOffset = offset;
        me[newOffset++] = this.options();
        me[newOffset++] = this.relays();
        newOffset = this.peerId.toByteArray(me, newOffset);
        newOffset = this.peerSocketAddress.toByteArray(me, newOffset);
        for (PeerSocketAddress psa : this.peerSocketAddresses) {
            newOffset = psa.toByteArray(me, newOffset);
        }
        return newOffset;
    }

    public PeerSocketAddress peerSocketAddress() {
        return this.peerSocketAddress;
    }

    public InetAddress inetAddress() {
        return this.peerSocketAddress.inetAddress();
    }

    public InetSocketAddress createSocketTCP() {
        return new InetSocketAddress(this.peerSocketAddress.inetAddress(), this.peerSocketAddress.tcpPort());
    }

    public InetSocketAddress createSocketUDP() {
        return new InetSocketAddress(this.peerSocketAddress.inetAddress(), this.peerSocketAddress.udpPort());
    }

    public Number160 peerId() {
        return this.peerId;
    }

    public byte options() {
        byte result = 0;
        if (this.net6) {
            result = (byte)(result | 1);
        }
        if (this.firewalledUDP) {
            result = (byte)(result | 2);
        }
        if (this.firewalledTCP) {
            result = (byte)(result | 4);
        }
        if (this.isRelayed) {
            result = (byte)(result | 8);
        }
        return result;
    }

    public byte relays() {
        if (this.relaySize > 0) {
            byte result = (byte)(this.relaySize << 5);
            byte types = Utils.createByte(this.relayType);
            result = (byte)(result | (byte)(types & 0x1F));
            return result;
        }
        return 0;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("paddr[");
        return sb.append(this.peerId.toString()).append(this.peerSocketAddress.toString()).append("]/relay(").append(this.isRelayed).append(",").append(this.peerSocketAddresses.size()).append(")=").append(Arrays.toString(this.peerSocketAddresses.toArray())).toString();
    }

    @Override
    public int compareTo(PeerAddress nodeAddress) {
        return this.peerId.compareTo(nodeAddress.peerId);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof PeerAddress)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        PeerAddress pa = (PeerAddress)obj;
        return this.peerId.equals(pa.peerId);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public int udpPort() {
        return this.peerSocketAddress.udpPort();
    }

    public int tcpPort() {
        return this.peerSocketAddress.tcpPort();
    }

    public boolean isFirewalledUDP() {
        return this.firewalledUDP;
    }

    public boolean isFirewalledTCP() {
        return this.firewalledTCP;
    }

    public boolean isIPv6() {
        return this.net6;
    }

    public boolean isIPv4() {
        return !this.net6;
    }

    public boolean isRelayed() {
        return this.isRelayed;
    }

    public PeerAddress changeRelayed(boolean isRelayed) {
        return new PeerAddress(this.peerId, this.peerSocketAddress, this.firewalledTCP, this.firewalledUDP, isRelayed, this.peerSocketAddresses);
    }

    public PeerAddress changeFirewalledUDP(boolean firewalledUDP) {
        return new PeerAddress(this.peerId, this.peerSocketAddress, this.firewalledTCP, firewalledUDP, this.isRelayed, this.peerSocketAddresses);
    }

    public PeerAddress changeFirewalledTCP(boolean firewalledTCP) {
        return new PeerAddress(this.peerId, this.peerSocketAddress, firewalledTCP, this.firewalledUDP, this.isRelayed, this.peerSocketAddresses);
    }

    public PeerAddress changePorts(int tcpPort, int udpPort) {
        return new PeerAddress(this.peerId, new PeerSocketAddress(this.peerSocketAddress.inetAddress(), tcpPort, udpPort), this.firewalledTCP, this.firewalledUDP, this.isRelayed, this.peerSocketAddresses);
    }

    public PeerAddress changeAddress(InetAddress inetAddress) {
        return new PeerAddress(this.peerId, new PeerSocketAddress(inetAddress, this.peerSocketAddress.tcpPort(), this.peerSocketAddress.udpPort()), this.firewalledTCP, this.firewalledUDP, this.isRelayed, this.peerSocketAddresses);
    }

    public PeerAddress changePeerId(Number160 peerId) {
        return new PeerAddress(peerId, this.peerSocketAddress, this.firewalledTCP, this.firewalledUDP, this.isRelayed, this.peerSocketAddresses);
    }

    public PeerAddress changePeerSocketAddresses(Collection<PeerSocketAddress> peerSocketAddresses) {
        return new PeerAddress(this.peerId, this.peerSocketAddress, this.firewalledTCP, this.firewalledUDP, this.isRelayed, peerSocketAddresses);
    }

    public PeerAddress changePeerSocketAddress(PeerSocketAddress peerSocketAddress) {
        return new PeerAddress(this.peerId, peerSocketAddress, this.firewalledTCP, this.firewalledUDP, this.isRelayed, this.peerSocketAddresses);
    }

    public Collection<PeerSocketAddress> peerSocketAddresses() {
        return this.peerSocketAddresses;
    }

    private static boolean isNet6(int options) {
        return (options & 0xFF & 1) > 0;
    }

    private static boolean isFirewalledTCP(int options) {
        return (options & 0xFF & 4) > 0;
    }

    private static boolean isFirewalledUDP(int options) {
        return (options & 0xFF & 2) > 0;
    }

    private static boolean isRelay(int options) {
        return (options & 0xFF & 8) > 0;
    }

    public static int size(int header) {
        int options = header >>> 8 & 0xFF;
        int relays = header & 0xFF;
        return PeerAddress.size(options, relays);
    }

    public static int size(int options, int relays) {
        int size = 26;
        size = PeerAddress.isNet6(options) ? (size += 16) : (size += 4);
        int relaySize = relays >>> 5 & 7;
        byte b = (byte)(relays & 0x1F);
        BitSet relayType = Utils.createBitSet(b);
        for (int i = 0; i < relaySize; ++i) {
            size += 4;
            if (relayType.get(i)) {
                size += 16;
                continue;
            }
            size += 4;
        }
        return size;
    }

    public int relaySize() {
        return this.relaySize;
    }
}

