/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.p2p.builder;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import net.tomp2p.futures.BaseFuture;
import net.tomp2p.futures.BaseFutureAdapter;
import net.tomp2p.futures.BaseFutureListener;
import net.tomp2p.futures.FutureBootstrap;
import net.tomp2p.futures.FutureChannelCreator;
import net.tomp2p.futures.FutureDone;
import net.tomp2p.futures.FuturePing;
import net.tomp2p.futures.FutureRouting;
import net.tomp2p.futures.FutureWrappedBootstrap;
import net.tomp2p.p2p.Peer;
import net.tomp2p.p2p.RoutingConfiguration;
import net.tomp2p.p2p.builder.RoutingBuilder;
import net.tomp2p.peers.Number160;
import net.tomp2p.peers.PeerAddress;
import net.tomp2p.utils.Pair;
import net.tomp2p.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BootstrapBuilder {
    private static final Logger logger = LoggerFactory.getLogger(BootstrapBuilder.class);
    private static final FutureBootstrap FUTURE_BOOTSTRAP_SHUTDOWN = new FutureWrappedBootstrap().failed0("Peer is shutting down");
    private static final FutureBootstrap FUTURE_BOOTSTRAP_NO_ADDRESS = new FutureWrappedBootstrap().failed0("You did not provide information where to bootstrap to. This could be also caused if you provided a peer address with a peer ID set to zero.");
    private final Peer peer;
    private Collection<PeerAddress> bootstrapTo;
    private PeerAddress peerAddress;
    private InetAddress inetAddress;
    private int portUDP = 7700;
    private int portTCP = 7700;
    private RoutingConfiguration routingConfiguration;
    private boolean forceRoutingOnlyToSelf = false;
    private boolean broadcast = false;

    public BootstrapBuilder(Peer peer) {
        this.peer = peer;
    }

    public PeerAddress peerAddress() {
        return this.peerAddress;
    }

    public Collection<PeerAddress> bootstrapTo() {
        return this.bootstrapTo;
    }

    public BootstrapBuilder bootstrapTo(Collection<PeerAddress> bootstrapTo) {
        this.bootstrapTo = bootstrapTo;
        return this;
    }

    public BootstrapBuilder peerAddress(PeerAddress peerAddress) {
        if (peerAddress != null && peerAddress.peerId().equals(Number160.ZERO)) {
            logger.warn("You provided a peer address with peerID zero. You won't be able to bootstrap since no peer can have a peerID set to zero");
            return this;
        }
        this.peerAddress = peerAddress;
        return this;
    }

    public InetAddress inetAddress() {
        return this.inetAddress;
    }

    public BootstrapBuilder inetAddress(InetAddress inetAddress) {
        this.inetAddress = inetAddress;
        return this;
    }

    public BootstrapBuilder inetSocketAddress(InetSocketAddress socket) {
        this.inetAddress = socket.getAddress();
        this.portTCP = socket.getPort();
        this.portUDP = socket.getPort();
        return this;
    }

    public int portUDP() {
        return this.portUDP;
    }

    public BootstrapBuilder portUDP(int portUDP) {
        this.portUDP = portUDP;
        return this;
    }

    public int portTCP() {
        return this.portTCP;
    }

    public BootstrapBuilder portTCP(int portTCP) {
        this.portTCP = portTCP;
        return this;
    }

    public BootstrapBuilder ports(int port) {
        this.portTCP = port;
        this.portUDP = port;
        return this;
    }

    public RoutingConfiguration routingConfiguration() {
        return this.routingConfiguration;
    }

    public BootstrapBuilder routingConfiguration(RoutingConfiguration routingConfiguration) {
        this.routingConfiguration = routingConfiguration;
        return this;
    }

    public boolean isForceRoutingOnlyToSelf() {
        return this.forceRoutingOnlyToSelf;
    }

    public BootstrapBuilder forceRoutingOnlyToSelf() {
        this.forceRoutingOnlyToSelf = true;
        return this;
    }

    public BootstrapBuilder forceRoutingOnlyToSelf(boolean forceRoutingOnlyToSelf) {
        this.forceRoutingOnlyToSelf = forceRoutingOnlyToSelf;
        return this;
    }

    public boolean isBroadcast() {
        return this.broadcast;
    }

    public BootstrapBuilder broadcast() {
        this.broadcast = true;
        return this;
    }

    public BootstrapBuilder broadcast(boolean broadcast) {
        this.broadcast = broadcast;
        return this;
    }

    public FutureBootstrap start() {
        if (this.peer.isShutdown()) {
            return FUTURE_BOOTSTRAP_SHUTDOWN;
        }
        if (this.routingConfiguration == null) {
            this.routingConfiguration = new RoutingConfiguration(8, 10, 2);
        }
        if (this.broadcast) {
            return this.broadcast0();
        }
        if (this.peerAddress == null && this.inetAddress != null && this.bootstrapTo == null) {
            this.peerAddress = new PeerAddress(Number160.ZERO, this.inetAddress, this.portTCP, this.portUDP);
            return this.bootstrapPing(this.peerAddress);
        }
        if (this.peerAddress != null && this.bootstrapTo == null) {
            this.bootstrapTo = new ArrayList<PeerAddress>(1);
            this.bootstrapTo.add(this.peerAddress);
            return this.bootstrap();
        }
        if (this.bootstrapTo != null) {
            return this.bootstrap();
        }
        return FUTURE_BOOTSTRAP_NO_ADDRESS;
    }

    private FutureBootstrap bootstrap() {
        final FutureWrappedBootstrap result = new FutureWrappedBootstrap();
        result.bootstrapTo(this.bootstrapTo);
        int conn = this.routingConfiguration.parallel();
        FutureChannelCreator fcc = this.peer.connectionBean().reservation().create(conn, 0);
        Utils.addReleaseListener(fcc, result);
        fcc.addListener((BaseFutureListener<BaseFuture>)new BaseFutureAdapter<FutureChannelCreator>(){

            @Override
            public void operationComplete(FutureChannelCreator futureChannelCreator) throws Exception {
                if (futureChannelCreator.isSuccess()) {
                    RoutingBuilder routingBuilder = BootstrapBuilder.createBuilder(BootstrapBuilder.this.routingConfiguration, BootstrapBuilder.this.forceRoutingOnlyToSelf);
                    FutureDone<Pair<FutureRouting, FutureRouting>> futureBootstrap = BootstrapBuilder.this.peer.distributedRouting().bootstrap(BootstrapBuilder.this.bootstrapTo, routingBuilder, futureChannelCreator.channelCreator());
                    result.waitFor(futureBootstrap);
                } else {
                    result.failed(futureChannelCreator);
                }
            }
        });
        return result;
    }

    static RoutingBuilder createBuilder(RoutingConfiguration routingConfiguration, boolean forceRoutingOnlyToSelf) {
        RoutingBuilder routingBuilder = new RoutingBuilder();
        routingBuilder.parallel(routingConfiguration.parallel());
        routingBuilder.setMaxNoNewInfo(routingConfiguration.maxNoNewInfoDiff());
        routingBuilder.maxDirectHits(Integer.MAX_VALUE);
        routingBuilder.maxFailures(routingConfiguration.maxFailures());
        routingBuilder.maxSuccess(routingConfiguration.maxSuccess());
        routingBuilder.forceRoutingOnlyToSelf(forceRoutingOnlyToSelf);
        return routingBuilder;
    }

    private FutureWrappedBootstrap<FutureBootstrap> bootstrapPing(PeerAddress address) {
        final FutureWrappedBootstrap<FutureBootstrap> result = new FutureWrappedBootstrap<FutureBootstrap>();
        FuturePing futurePing = this.peer.ping().peerAddress(address).tcpPing().start();
        futurePing.addListener((BaseFutureListener<BaseFuture>)new BaseFutureAdapter<FuturePing>(){

            @Override
            public void operationComplete(FuturePing future) throws Exception {
                if (future.isSuccess()) {
                    BootstrapBuilder.this.peerAddress = future.remotePeer();
                    BootstrapBuilder.this.bootstrapTo = new ArrayList(1);
                    BootstrapBuilder.this.bootstrapTo.add(BootstrapBuilder.this.peerAddress);
                    result.bootstrapTo(BootstrapBuilder.this.bootstrapTo);
                    result.waitFor(BootstrapBuilder.this.bootstrap());
                } else {
                    result.failed("could not reach anyone with bootstrap");
                }
            }
        });
        return result;
    }

    private FutureWrappedBootstrap<FutureBootstrap> broadcast0() {
        final FutureWrappedBootstrap<FutureBootstrap> result = new FutureWrappedBootstrap<FutureBootstrap>();
        FuturePing futurePing = this.peer.ping().broadcast().port(this.portUDP).start();
        futurePing.addListener((BaseFutureListener<BaseFuture>)new BaseFutureAdapter<FuturePing>(){

            @Override
            public void operationComplete(FuturePing future) throws Exception {
                if (future.isSuccess()) {
                    if (BootstrapBuilder.this.bootstrapTo != null && BootstrapBuilder.this.bootstrapTo.size() > 0) {
                        logger.info("you added peers to bootstrapTo. However with broadcast we found our own peers.");
                    }
                    BootstrapBuilder.this.peerAddress = future.remotePeer();
                    BootstrapBuilder.this.bootstrapTo = new ArrayList(1);
                    BootstrapBuilder.this.bootstrapTo.add(BootstrapBuilder.this.peerAddress);
                    result.bootstrapTo(BootstrapBuilder.this.bootstrapTo);
                    result.waitFor(BootstrapBuilder.this.bootstrap());
                } else {
                    result.failed("could not reach anyone with the broadcast", future);
                }
            }
        });
        return result;
    }
}

