/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.tracker;

import java.security.PublicKey;
import java.util.Collection;
import java.util.Map;
import java.util.NavigableSet;
import net.tomp2p.connection.PeerConnection;
import net.tomp2p.connection.PeerException;
import net.tomp2p.message.TrackerData;
import net.tomp2p.peers.DefaultMaintenance;
import net.tomp2p.peers.Maintainable;
import net.tomp2p.peers.Number160;
import net.tomp2p.peers.Number320;
import net.tomp2p.peers.PeerAddress;
import net.tomp2p.peers.PeerMap;
import net.tomp2p.peers.PeerMapChangeListener;
import net.tomp2p.peers.PeerStatatistic;
import net.tomp2p.peers.PeerStatusListener;
import net.tomp2p.rpc.DigestInfo;
import net.tomp2p.storage.Data;
import net.tomp2p.storage.DigestTracker;
import net.tomp2p.tracker.PeerExchange;
import net.tomp2p.utils.ConcurrentCacheMap;

public class TrackerStorage
implements Maintainable,
PeerMapChangeListener,
PeerStatusListener,
DigestTracker {
    public static final int TRACKER_CACHE_SIZE = 1000;
    private final Map<Number320, TrackerData> dataMapUnverified;
    private final Map<Number320, TrackerData> dataMap;
    private final boolean verifyPeersOnTracker;
    private final int[] intervalSeconds;
    private final ConcurrentCacheMap<Number160, Boolean> peerOffline;
    private final PeerAddress self;
    private final int trackerTimoutSeconds;
    private final PeerMap peerMap;
    private final int replicationFactor;
    private PeerExchange peerExchange;

    public TrackerStorage(int trackerTimoutSeconds, int[] intervalSeconds, int replicationFactor, PeerMap peerMap, PeerAddress self, boolean verifyPeersOnTracker) {
        this.dataMapUnverified = new ConcurrentCacheMap(trackerTimoutSeconds, 1000, true);
        this.dataMap = new ConcurrentCacheMap(trackerTimoutSeconds, 1000, true);
        this.peerOffline = new ConcurrentCacheMap(trackerTimoutSeconds * 5, 1000, false);
        this.trackerTimoutSeconds = trackerTimoutSeconds;
        this.intervalSeconds = intervalSeconds;
        this.self = self;
        this.peerMap = peerMap;
        this.replicationFactor = replicationFactor;
        this.verifyPeersOnTracker = verifyPeersOnTracker;
    }

    public boolean put(Number320 key, PeerAddress peerAddress, PublicKey publicKey, Data attachement) {
        if (this.peerOffline.containsKey((Object)peerAddress.peerId())) {
            return false;
        }
        Data oldDataUnverified = this.findOld(key, peerAddress, this.dataMapUnverified);
        boolean isUnverified = false;
        boolean isVerified = false;
        if (oldDataUnverified != null) {
            if (oldDataUnverified.publicKey() != null && !oldDataUnverified.publicKey().equals(publicKey)) {
                return false;
            }
            isUnverified = true;
        } else {
            Data oldData = this.findOld(key, peerAddress, this.dataMap);
            if (oldData != null) {
                if (oldData.publicKey() != null && !oldData.publicKey().equals(publicKey)) {
                    return false;
                }
                isVerified = true;
            }
        }
        if (attachement == null) {
            attachement = new Data();
        }
        attachement.publicKey(publicKey);
        Map<Number320, TrackerData> dataMapToStore = isUnverified ? this.dataMapUnverified : (isVerified ? this.dataMap : (this.verifyPeersOnTracker ? this.dataMapUnverified : this.dataMap));
        return this.add(key, new PeerStatatistic(peerAddress), dataMapToStore, attachement);
    }

    private Data findOld(Number320 key, PeerAddress peerAddress, Map<Number320, TrackerData> dataMap) {
        for (Map.Entry<Number320, TrackerData> entry : dataMap.entrySet()) {
            for (Map.Entry entry2 : entry.getValue().peerAddresses().entrySet()) {
                if (!((PeerStatatistic)entry2.getKey()).peerAddress().equals((Object)peerAddress)) continue;
                return (Data)entry2.getValue();
            }
        }
        return null;
    }

    public PeerExchange peerExchange() {
        return this.peerExchange;
    }

    public TrackerStorage peerExchange(PeerExchange peerExchange) {
        this.peerExchange = peerExchange;
        return this;
    }

    public PeerStatatistic nextForMaintenance(Collection<PeerAddress> notInterestedAddresses) {
        for (Map.Entry<Number320, TrackerData> entry : this.dataMapUnverified.entrySet()) {
            for (Map.Entry entry2 : entry.getValue().peerAddresses().entrySet()) {
                if (!DefaultMaintenance.needMaintenance((PeerStatatistic)((PeerStatatistic)entry2.getKey()), (int[])this.intervalSeconds)) continue;
                return (PeerStatatistic)entry2.getKey();
            }
        }
        return null;
    }

    public void peerInserted(PeerAddress remotePeer, boolean verified) {
        if (verified) {
            for (Map.Entry<Number320, TrackerData> entry : this.dataMap.entrySet()) {
                if (!this.isInReplicationRange(entry.getKey().locationKey(), remotePeer, this.replicationFactor) || !this.isInReplicationRange(entry.getKey().locationKey(), this.self, this.replicationFactor)) continue;
                this.peerExchange.peerExchange(remotePeer, entry.getKey(), entry.getValue());
            }
        }
    }

    public void peerRemoved(PeerAddress remotePeer, PeerStatatistic storedPeerAddress) {
        for (Map.Entry<Number320, TrackerData> entry : this.dataMap.entrySet()) {
            if (!this.isInReplicationRange(entry.getKey().locationKey(), remotePeer, this.replicationFactor) || !this.isInReplicationRange(entry.getKey().locationKey(), this.self, this.replicationFactor)) continue;
            NavigableSet closePeers = this.peerMap.closePeers(entry.getKey().locationKey(), this.replicationFactor);
            PeerAddress newResponsible = closePeers.headSet(remotePeer).last();
            this.peerExchange.peerExchange(newResponsible, entry.getKey(), entry.getValue());
        }
    }

    public void peerUpdated(PeerAddress peerAddress, PeerStatatistic storedPeerAddress) {
    }

    private boolean isInReplicationRange(Number160 locationKey, PeerAddress peerAddress, int replicationFactor) {
        NavigableSet tmp = this.peerMap.closePeers(locationKey, replicationFactor);
        tmp.add(this.self);
        return tmp.headSet(peerAddress).size() < replicationFactor;
    }

    private boolean add(Number320 key, PeerStatatistic stat, Map<Number320, TrackerData> map, Data attachement) {
        TrackerData trackerData = map.get(key);
        if (trackerData == null) {
            trackerData = new TrackerData((Map)new ConcurrentCacheMap(this.trackerTimoutSeconds, 1000, true));
            map.put(key, trackerData);
        }
        if (trackerData.size() < 1000) {
            trackerData.put(stat, attachement);
            return true;
        }
        return false;
    }

    private boolean remove(Number320 key, PeerStatatistic stat, Map<Number320, TrackerData> map) {
        TrackerData trackerData = map.get(key);
        if (trackerData != null) {
            boolean retVal;
            boolean bl = retVal = trackerData.remove(stat.peerAddress().peerId()) != null;
            if (trackerData.peerAddresses().size() == 0) {
                map.remove(key);
            }
            return retVal;
        }
        return false;
    }

    public TrackerData peers(Number320 key) {
        return this.dataMap.get(key);
    }

    public Collection<Number320> keys() {
        return this.dataMap.keySet();
    }

    public boolean peerFailed(PeerAddress remotePeer, PeerException reason) {
        this.peerOffline.put((Object)remotePeer.peerId(), (Object)Boolean.TRUE);
        Number320 keyToRemove = null;
        PeerStatatistic statToRemove = null;
        for (Map.Entry<Number320, TrackerData> entry : this.dataMapUnverified.entrySet()) {
            for (Map.Entry entry2 : entry.getValue().peerAddresses().entrySet()) {
                if (!((PeerStatatistic)entry2.getKey()).peerAddress().equals((Object)remotePeer)) continue;
                keyToRemove = entry.getKey();
                statToRemove = (PeerStatatistic)entry2.getKey();
            }
        }
        if (keyToRemove != null) {
            this.remove(keyToRemove, statToRemove, this.dataMapUnverified);
        }
        for (Map.Entry<Number320, TrackerData> entry : this.dataMap.entrySet()) {
            for (Map.Entry entry2 : entry.getValue().peerAddresses().entrySet()) {
                if (!((PeerStatatistic)entry2.getKey()).peerAddress().equals((Object)remotePeer)) continue;
                keyToRemove = entry.getKey();
                statToRemove = (PeerStatatistic)entry2.getKey();
            }
        }
        if (keyToRemove != null) {
            this.remove(keyToRemove, statToRemove, this.dataMap);
        }
        return true;
    }

    public boolean peerFound(PeerAddress remotePeer, PeerAddress referrer, PeerConnection peerConnection) {
        boolean firsthand;
        boolean bl = firsthand = referrer == null;
        if (firsthand) {
            this.peerOffline.remove((Object)remotePeer.peerId());
            Number320 keyToRemove = null;
            PeerStatatistic statToRemove = null;
            for (Map.Entry<Number320, TrackerData> entry : this.dataMapUnverified.entrySet()) {
                for (Map.Entry entry2 : entry.getValue().peerAddresses().entrySet()) {
                    PeerAddress tmp = ((PeerStatatistic)entry2.getKey()).peerAddress();
                    if (!tmp.equals((Object)remotePeer) || !this.add(entry.getKey(), (PeerStatatistic)entry2.getKey(), this.dataMap, (Data)entry2.getValue())) continue;
                    keyToRemove = entry.getKey();
                    statToRemove = (PeerStatatistic)entry2.getKey();
                    statToRemove.successfullyChecked();
                }
            }
            if (keyToRemove != null && statToRemove != null) {
                this.remove(keyToRemove, statToRemove, this.dataMapUnverified);
            }
        }
        return true;
    }

    public int size() {
        return this.dataMap.size();
    }

    public int sizeUnverified() {
        return this.dataMapUnverified.size();
    }

    public DigestInfo digest(Number160 locationKey, Number160 domainKey, Number160 contentKey) {
        Number160 contentDigest = Number160.ZERO;
        int counter = 0;
        TrackerData trackerData = this.dataMap.get(new Number320(locationKey, domainKey));
        if (trackerData != null) {
            if (contentKey != null) {
                Map.Entry entry = trackerData.get(contentKey);
                if (entry != null) {
                    return new DigestInfo(Number160.ZERO, contentKey, 1);
                }
            } else {
                for (PeerStatatistic peerStatatistic : trackerData.peerAddresses().keySet()) {
                    contentDigest = contentDigest.xor(peerStatatistic.peerAddress().peerId());
                    ++counter;
                }
            }
        }
        return new DigestInfo(Number160.ZERO, contentKey, counter);
    }
}

