/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.dht;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.tomp2p.dht.DHTBuilder;
import net.tomp2p.dht.FutureDHT;
import net.tomp2p.dht.StorageLayer;
import net.tomp2p.futures.BaseFuture;
import net.tomp2p.peers.Number640;
import net.tomp2p.peers.PeerAddress;

public class FuturePut
extends FutureDHT<FuturePut> {
    private final int min;
    private final int dataSize;
    private Map<PeerAddress, Map<Number640, Byte>> rawResult;
    private boolean minReached;
    private Map<Number640, Integer> result;

    public FuturePut(DHTBuilder<?> builder, int min, int dataSize) {
        super(builder);
        this.min = min;
        this.dataSize = dataSize;
        this.self((BaseFuture)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storedKeys(Map<PeerAddress, Map<Number640, Byte>> rawResult) {
        Object object = this.lock;
        synchronized (object) {
            if (!this.completedAndNotify()) {
                return;
            }
            this.rawResult = rawResult;
            int size = rawResult == null ? 0 : rawResult.size();
            this.minReached = size >= this.min;
            this.type = this.minReached ? BaseFuture.FutureType.OK : BaseFuture.FutureType.FAILED;
            this.reason = this.minReached ? "Minimun number of results reached" : "Expected " + this.min + " result, but got " + size;
        }
        this.notifyListeners();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double avgStoredKeys() {
        Object object = this.lock;
        synchronized (object) {
            int size = this.rawResult.size();
            int total = 0;
            for (Map<Number640, Byte> map : this.rawResult.values()) {
                Set<Number640> collection = map.keySet();
                if (collection == null) continue;
                total += collection.size();
            }
            return (double)total / (double)size;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<PeerAddress, Map<Number640, Byte>> rawResult() {
        Object object = this.lock;
        synchronized (object) {
            return this.rawResult;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isMinReached() {
        Object object = this.lock;
        synchronized (object) {
            return this.minReached;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Number640, Integer> result() {
        Object object = this.lock;
        synchronized (object) {
            if (this.result == null) {
                this.result = this.evaluate(this.rawResult);
            }
            return this.result;
        }
    }

    private Map<Number640, Integer> evaluate(Map<PeerAddress, Map<Number640, Byte>> rawResult2) {
        HashMap<Number640, Integer> result = new HashMap<Number640, Integer>();
        for (Map<Number640, Byte> map : rawResult2.values()) {
            for (Map.Entry<Number640, Byte> entry : map.entrySet()) {
                if (entry.getValue().intValue() != StorageLayer.PutStatus.OK.ordinal() && entry.getValue().intValue() != StorageLayer.PutStatus.VERSION_FORK.ordinal() && entry.getValue().intValue() != StorageLayer.PutStatus.DELETED.ordinal()) continue;
                Integer integer = (Integer)result.get(entry.getKey());
                if (integer == null) {
                    result.put(entry.getKey(), 1);
                    continue;
                }
                result.put(entry.getKey(), integer + 1);
            }
        }
        return result;
    }

    public boolean isSuccess() {
        if (!super.isSuccess()) {
            return false;
        }
        return this.checkResults(this.result(), this.rawResult.size(), this.dataSize);
    }

    private boolean checkResults(Map<Number640, Integer> result2, int peerReports, int dataSize) {
        for (Map.Entry<Number640, Integer> entry : result2.entrySet()) {
            if (entry.getValue() == peerReports) continue;
            return false;
        }
        return result2.size() == dataSize;
    }

    public boolean isSuccessPartially() {
        boolean networkSuccess = super.isSuccess();
        return networkSuccess && this.result().size() > 0;
    }
}

