/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.storage;

import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SignatureException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import net.tomp2p.connection.DSASignatureFactory;
import net.tomp2p.connection.SignatureFactory;
import net.tomp2p.message.SignatureCodec;
import net.tomp2p.p2p.PeerBuilder;
import net.tomp2p.peers.Number160;
import net.tomp2p.storage.AlternativeCompositeByteBuf;
import net.tomp2p.storage.DataBuffer;
import net.tomp2p.utils.Utils;

public class Data {
    private static final int MAX_BYTE_SIZE = 256;
    private final Type type;
    private final int length;
    private final DataBuffer buffer;
    private boolean basedOnFlag;
    private boolean signed;
    private boolean flag1;
    private boolean ttl;
    private boolean flag2;
    private boolean protectedEntry;
    private boolean publicKeyFlag;
    private boolean prepareFlag;
    private SignatureCodec signature;
    private int ttlSeconds = -1;
    private Collection<Number160> basedOnSet = new ArrayList<Number160>(0);
    private PublicKey publicKey;
    private transient PrivateKey privateKey;
    private long validFromMillis;
    private SignatureFactory signatureFactory;
    private Number160 hash;
    private boolean meta;

    public Data(DataBuffer buffer) {
        this(buffer, buffer.length());
    }

    public Data(DataBuffer buffer, int length) {
        this.length = length;
        this.type = length < 256 ? Type.SMALL : Type.LARGE;
        this.buffer = buffer;
        this.validFromMillis = System.currentTimeMillis();
    }

    public Data(int header, int length) {
        this.publicKeyFlag = Data.hasPublicKey(header);
        this.flag1 = Data.isFlag1(header);
        this.flag2 = Data.isFlag2(header);
        this.basedOnFlag = Data.hasBasedOn(header);
        this.signed = Data.isSigned(header);
        this.ttl = Data.hasTTL(header);
        this.protectedEntry = Data.isProtectedEntry(header);
        this.type = Data.type(header);
        this.prepareFlag = Data.hasPrepareFlag(header);
        if (this.type == Type.SMALL && length > 255) {
            throw new IllegalArgumentException("Type is not small");
        }
        if (this.type == Type.LARGE && length <= 255) {
            throw new IllegalArgumentException("Type is not large");
        }
        this.length = length;
        this.buffer = new DataBuffer();
        this.validFromMillis = System.currentTimeMillis();
    }

    public Data(Object object) throws IOException {
        this(Utils.encodeJavaObject(object));
    }

    public Data(byte[] buffer) {
        this(buffer, 0, buffer.length);
    }

    public Data() {
        this(Utils.EMPTY_BYTE_ARRAY);
    }

    public Data(byte[] buffer, int offest, int length) {
        this.buffer = buffer.length == 0 ? new DataBuffer(0) : new DataBuffer(buffer, offest, length);
        this.length = length;
        this.type = length < 256 ? Type.SMALL : Type.LARGE;
        this.validFromMillis = System.currentTimeMillis();
    }

    public boolean isEmpty() {
        return this.length == 0;
    }

    public static Data decodeHeader(ByteBuf buf, SignatureFactory signatureFactory) {
        PublicKey publicKey;
        int publicKeySize;
        int indexPublicKeySize;
        int ttl;
        int indexBasedOnNr;
        int indexTTL;
        int length;
        if (buf.readableBytes() < 2) {
            return null;
        }
        short header = buf.getUnsignedByte(buf.readerIndex());
        Type type = Data.type(header);
        boolean indexLength = true;
        switch (type) {
            case SMALL: {
                length = buf.getUnsignedByte(buf.readerIndex() + 1);
                indexTTL = 2;
                break;
            }
            case LARGE: {
                indexTTL = 5;
                if (buf.readableBytes() < indexTTL) {
                    return null;
                }
                length = buf.getInt(buf.readerIndex() + 1);
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown type");
            }
        }
        if (Data.hasTTL(header)) {
            indexBasedOnNr = indexTTL + 4;
            if (buf.readableBytes() < indexBasedOnNr) {
                return null;
            }
            ttl = buf.getInt(buf.readerIndex() + indexTTL);
        } else {
            ttl = -1;
            indexBasedOnNr = indexTTL;
        }
        ArrayList<Number160> basedOn = new ArrayList<Number160>();
        if (Data.hasBasedOn(header)) {
            int indexBasedOn = indexBasedOnNr + 1;
            if (buf.readableBytes() < indexBasedOn) {
                return null;
            }
            int numBasedOn = buf.getUnsignedByte(buf.readerIndex() + indexBasedOnNr) + 1;
            indexPublicKeySize = indexBasedOn + numBasedOn * 20;
            if (buf.readableBytes() < indexPublicKeySize) {
                return null;
            }
            int index = buf.readerIndex() + indexBasedOnNr + 1;
            byte[] me = new byte[20];
            for (int i = 0; i < numBasedOn; ++i) {
                buf.getBytes(index, me);
                index += 20;
                basedOn.add(new Number160(me));
            }
        } else {
            indexPublicKeySize = indexBasedOnNr;
            boolean numBasedOn = false;
        }
        if (Data.hasPublicKey(header)) {
            int indexPublicKey = indexPublicKeySize + 2;
            if (buf.readableBytes() < indexPublicKey) {
                return null;
            }
            publicKeySize = buf.getUnsignedShort(buf.readerIndex() + indexPublicKeySize);
            int indexEnd = indexPublicKey + publicKeySize;
            if (buf.readableBytes() < indexEnd) {
                return null;
            }
            buf.skipBytes(indexPublicKeySize);
            publicKey = signatureFactory.decodePublicKey(buf);
        } else {
            publicKeySize = 0;
            int indexPublicKey = indexPublicKeySize;
            buf.skipBytes(indexPublicKey);
            publicKey = null;
        }
        Data data = new Data(header, length);
        data.ttlSeconds = ttl;
        data.basedOnSet = basedOn;
        data.publicKey = publicKey;
        return data;
    }

    public boolean decodeBuffer(ByteBuf buf) {
        int already = this.buffer.alreadyTransferred();
        int remaining = this.length() - already;
        if (remaining == 0) {
            return true;
        }
        int transfered = this.buffer.transferFrom(buf, remaining);
        return transfered == remaining;
    }

    public boolean decodeDone(ByteBuf buf, SignatureFactory signatureFactory) {
        if (this.signed) {
            this.signature = signatureFactory.signatureCodec();
            if (buf.readableBytes() < this.signature.signatureSize()) {
                return false;
            }
            this.signature.read(buf);
        }
        return true;
    }

    public boolean decodeDone(ByteBuf buf, PublicKey publicKey, SignatureFactory signatureFactory) {
        if (this.signed) {
            if (publicKey == PeerBuilder.EMPTY_PUBLICKEY) {
                this.publicKey = publicKey;
            }
            this.signature = signatureFactory.signatureCodec();
            if (buf.readableBytes() < this.signature.signatureSize()) {
                return false;
            }
            this.signature.read(buf);
        }
        return true;
    }

    public boolean verify(SignatureFactory signatureFactory) throws InvalidKeyException, SignatureException, IOException {
        return this.verify(this.publicKey, signatureFactory);
    }

    public boolean verify(PublicKey publicKey, SignatureFactory signatureFactory) throws InvalidKeyException, SignatureException, IOException {
        return signatureFactory.verify(publicKey, this.buffer.toByteBuf(), this.signature);
    }

    public void encodeHeader(ByteBuf buf, SignatureFactory signatureFactory) {
        int header = this.type.ordinal();
        if (this.prepareFlag) {
            header |= 2;
        }
        if (this.flag1) {
            header |= 4;
        }
        if (this.flag2) {
            header |= 8;
        }
        if (this.ttl) {
            header |= 0x10;
        }
        if (this.signed && this.publicKeyFlag && this.protectedEntry) {
            header |= 0x60;
        } else if (this.signed && this.publicKeyFlag) {
            header |= 0x40;
        } else if (this.publicKeyFlag) {
            header |= 0x20;
        }
        if (this.basedOnFlag) {
            header |= 0x80;
        }
        switch (this.type) {
            case SMALL: {
                buf.writeByte(header);
                buf.writeByte(this.length);
                break;
            }
            case LARGE: {
                buf.writeByte(header);
                buf.writeInt(this.length);
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown size");
            }
        }
        if (this.ttl) {
            buf.writeInt(this.ttlSeconds);
        }
        if (this.basedOnFlag) {
            buf.writeByte(this.basedOnSet.size() - 1);
            for (Number160 basedOn : this.basedOnSet) {
                buf.writeBytes(basedOn.toByteArray());
            }
        }
        if (this.publicKeyFlag) {
            if (this.publicKey == null) {
                buf.writeShort(0);
            } else {
                signatureFactory.encodePublicKey(this.publicKey, buf);
            }
        }
    }

    public boolean encodeBuffer(AlternativeCompositeByteBuf buf) {
        int already = this.buffer.alreadyTransferred();
        int remaining = this.length() - already;
        if (remaining == 0) {
            return true;
        }
        this.buffer.transferTo(buf);
        return this.buffer.alreadyTransferred() == this.length();
    }

    public void encodeDone(ByteBuf buf, SignatureFactory signatureFactory) throws InvalidKeyException, SignatureException, IOException {
        this.encodeDone(buf, signatureFactory, null);
    }

    public void encodeDone(ByteBuf buf, SignatureFactory signatureFactory, PrivateKey messagePrivateKey) throws InvalidKeyException, SignatureException, IOException {
        if (this.signed) {
            if (this.signature == null && this.privateKey != null) {
                this.signature = signatureFactory.sign(this.privateKey, this.buffer.toByteBuf());
            } else if (this.signature == null && messagePrivateKey != null) {
                this.signature = signatureFactory.sign(messagePrivateKey, this.buffer.toByteBuf());
            } else if (this.signature == null) {
                throw new IllegalArgumentException("you need a private key from somewhere");
            }
            this.signature.write(buf);
        }
    }

    public ByteBuf buffer() {
        return this.buffer.toByteBuf();
    }

    public Object object() throws ClassNotFoundException, IOException {
        return Utils.decodeJavaObject(this.buffer);
    }

    public long validFromMillis() {
        return this.validFromMillis;
    }

    public Data validFromMillis(long validFromMillis) {
        this.validFromMillis = validFromMillis;
        return this;
    }

    public Data signNow(KeyPair keyPair, SignatureFactory signatureFactory) throws InvalidKeyException, SignatureException, IOException {
        return this.signNow(keyPair, signatureFactory, false);
    }

    public Data protectEntryNow(KeyPair keyPair, SignatureFactory signatureFactory) throws InvalidKeyException, SignatureException, IOException {
        return this.signNow(keyPair, signatureFactory, true);
    }

    private Data signNow(KeyPair keyPair, SignatureFactory signatureFactory, boolean protectedEntry) throws InvalidKeyException, SignatureException, IOException {
        if (this.signature == null) {
            this.signed = true;
            this.signature = signatureFactory.sign(keyPair.getPrivate(), this.buffer.toByteBuf());
            this.publicKey = keyPair.getPublic();
            this.publicKeyFlag = true;
            this.protectedEntry = protectedEntry;
        }
        return this;
    }

    public Data signNow(PrivateKey privateKey, SignatureFactory signatureFactory) throws InvalidKeyException, SignatureException, IOException {
        return this.signNow(privateKey, signatureFactory, false);
    }

    public Data protectEntryNow(PrivateKey privateKey, SignatureFactory signatureFactory) throws InvalidKeyException, SignatureException, IOException {
        return this.signNow(privateKey, signatureFactory, true);
    }

    private Data signNow(PrivateKey privateKey, SignatureFactory signatureFactory, boolean protectedEntry) throws InvalidKeyException, SignatureException, IOException {
        if (this.signature == null) {
            this.signed = true;
            this.signature = signatureFactory.sign(privateKey, this.buffer.toByteBuf());
            this.publicKeyFlag = true;
            this.protectedEntry = protectedEntry;
        }
        return this;
    }

    public Data sign(KeyPair keyPair) {
        return this.sign(keyPair, false);
    }

    public Data protectEntry(KeyPair keyPair) {
        return this.sign(keyPair, true);
    }

    private Data sign(KeyPair keyPair, boolean protectedEntry) {
        this.signed = true;
        this.privateKey = keyPair.getPrivate();
        this.publicKey = keyPair.getPublic();
        this.publicKeyFlag = true;
        this.protectedEntry = protectedEntry;
        return this;
    }

    public Data sign() {
        return this.sign((PrivateKey)null, false);
    }

    public Data sign(PrivateKey privateKey) {
        return this.sign(privateKey, false);
    }

    public Data protectEntry() {
        return this.sign((PrivateKey)null, true);
    }

    public Data protectEntry(PrivateKey privateKey) {
        return this.sign(privateKey, true);
    }

    private Data sign(PrivateKey privateKey, boolean protectedEntry) {
        this.signed = true;
        this.privateKey = privateKey;
        this.publicKeyFlag = true;
        this.protectedEntry = protectedEntry;
        return this;
    }

    public int length() {
        return this.length;
    }

    public long expirationMillis() {
        return this.ttlSeconds <= 0 ? Long.MAX_VALUE : this.validFromMillis + (long)this.ttlSeconds * 1000L;
    }

    public int ttlSeconds() {
        return this.ttlSeconds;
    }

    public Data ttlSeconds(int ttlSeconds) {
        this.ttlSeconds = ttlSeconds;
        this.ttl = true;
        return this;
    }

    public Data addBasedOn(Number160 basedOn) {
        this.basedOnSet.add(basedOn);
        this.basedOnFlag = true;
        return this;
    }

    public Collection<Number160> basedOnSet() {
        return this.basedOnSet;
    }

    public SignatureFactory signatureFactory() {
        if (this.signatureFactory == null) {
            return new DSASignatureFactory();
        }
        return this.signatureFactory;
    }

    public Data signatureFactory(SignatureFactory signatureFactory) {
        this.signatureFactory = signatureFactory;
        return this;
    }

    public boolean isProtectedEntry() {
        return this.protectedEntry;
    }

    public boolean isSigned() {
        return this.signed;
    }

    public Data signed(boolean signed) {
        this.signed = signed;
        this.publicKeyFlag = signed;
        return this;
    }

    public Data signed() {
        this.signed(true);
        return this;
    }

    public boolean isFlag1() {
        return this.flag1;
    }

    public Data flag1(boolean flag1) {
        if (flag1 && this.flag2) {
            throw new IllegalArgumentException("cannot set both flags, this means data is deleted");
        }
        this.flag1 = flag1;
        return this;
    }

    public Data flag1() {
        return this.flag1(true);
    }

    public boolean isFlag2() {
        return this.flag2;
    }

    public Data flag2(boolean flag2) {
        if (flag2 && this.flag1) {
            throw new IllegalArgumentException("cannot set both flags, this means data is deleted");
        }
        this.flag2 = flag2;
        return this;
    }

    public Data flag2() {
        return this.flag2(true);
    }

    public boolean hasPrepareFlag() {
        return this.prepareFlag;
    }

    public Data prepareFlag(boolean prepareFlag) {
        this.prepareFlag = prepareFlag;
        return this;
    }

    public Data prepareFlag() {
        this.prepareFlag = true;
        return this;
    }

    public Data deleted() {
        return this.deleted(true);
    }

    public Data deleted(boolean deleted) {
        if (this.flag1 || this.flag2) {
            throw new IllegalArgumentException("cannot set deleted, as one flag is already set");
        }
        this.flag1 = deleted;
        this.flag2 = deleted;
        return this;
    }

    public boolean isDeleted() {
        return this.flag1 && this.flag2;
    }

    public boolean hasPublicKey() {
        return this.publicKeyFlag;
    }

    public Data publicKeyFlag(boolean publicKeyFlag) {
        this.publicKeyFlag = publicKeyFlag;
        return this;
    }

    public Data publicKeyFlag() {
        this.publicKeyFlag = true;
        return this;
    }

    public boolean isMeta() {
        return this.meta;
    }

    public Data meta(boolean meta) {
        this.meta = meta;
        return this;
    }

    public Data meta() {
        this.meta = true;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Data[l:");
        sb.append(this.length).append(",t:");
        sb.append(this.ttlSeconds()).append(",hasPK:");
        sb.append(this.publicKey != null).append(",h:");
        sb.append(this.signature).append("]");
        return sb.toString();
    }

    public void resetAlreadyTransferred() {
        this.buffer.resetAlreadyTransferred();
    }

    public Data duplicate() {
        Data data = new Data(this.buffer.shallowCopy(), this.length).publicKey(this.publicKey).signature(this.signature).ttlSeconds(this.ttlSeconds);
        data.basedOnSet.addAll(this.basedOnSet);
        data.publicKeyFlag = this.publicKeyFlag;
        data.flag1 = this.flag1;
        data.flag2 = this.flag2;
        data.basedOnFlag = this.basedOnFlag;
        data.signed = this.signed;
        data.ttl = this.ttl;
        data.protectedEntry = this.protectedEntry;
        data.privateKey = this.privateKey;
        data.validFromMillis = this.validFromMillis;
        data.prepareFlag = this.prepareFlag;
        return data;
    }

    public Data duplicateMeta() {
        Data data = new Data().publicKey(this.publicKey).signature(this.signature).ttlSeconds(this.ttlSeconds);
        data.basedOnSet.addAll(this.basedOnSet);
        data.publicKeyFlag = this.publicKeyFlag;
        data.flag1 = this.flag1;
        data.flag2 = this.flag2;
        data.basedOnFlag = this.basedOnFlag;
        data.signed = this.signed;
        data.ttl = this.ttl;
        data.protectedEntry = this.protectedEntry;
        data.privateKey = this.privateKey;
        data.validFromMillis = this.validFromMillis;
        data.prepareFlag = this.prepareFlag;
        return data;
    }

    public static Type type(int header) {
        return Type.values()[header & 1];
    }

    private static boolean hasPrepareFlag(int header) {
        return (header & 2) > 0;
    }

    private static boolean isFlag1(int header) {
        return (header & 4) > 0;
    }

    private static boolean isFlag2(int header) {
        return (header & 8) > 0;
    }

    private static boolean hasTTL(int header) {
        return (header & 0x10) > 0;
    }

    private static boolean hasPublicKey(int header) {
        return (header >> 5 & 3) > 0;
    }

    private static boolean isProtectedEntry(int header) {
        return (header >> 5 & 3) > 2;
    }

    private static boolean isSigned(int header) {
        return (header >> 5 & 3) > 1;
    }

    private static boolean hasBasedOn(int header) {
        return (header & 0x80) > 0;
    }

    public byte[] toBytes() {
        ByteBuf buf = this.buffer.toByteBuf();
        byte[] me = new byte[buf.readableBytes()];
        buf.readBytes(me);
        return me;
    }

    public ByteBuffer[] toByteBuffers() {
        return this.buffer.toByteBuffer();
    }

    public PublicKey publicKey() {
        return this.publicKey;
    }

    public PrivateKey privateKey() {
        return this.privateKey;
    }

    public Data publicKey(PublicKey publicKey) {
        this.publicKeyFlag = true;
        this.publicKey = publicKey;
        return this;
    }

    public SignatureCodec signature() {
        return this.signature;
    }

    public Data signature(SignatureCodec signature) {
        this.signature = signature;
        return this;
    }

    public int hashCode() {
        BitSet bs = new BitSet(5);
        bs.set(0, this.signed);
        bs.set(1, this.ttl);
        bs.set(2, this.basedOnFlag);
        bs.set(3, this.protectedEntry);
        bs.set(4, this.publicKeyFlag);
        bs.set(5, this.flag1);
        bs.set(6, this.flag2);
        bs.set(7, this.prepareFlag);
        int hashCode = bs.hashCode() ^ this.ttlSeconds ^ this.type.ordinal() ^ this.length;
        for (Number160 basedOn : this.basedOnSet) {
            hashCode ^= basedOn.hashCode();
        }
        return hashCode ^ this.buffer.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Data)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        Data d = (Data)obj;
        if (d.signed != this.signed || d.basedOnFlag != this.basedOnFlag || d.protectedEntry != this.protectedEntry || d.publicKeyFlag != this.publicKeyFlag || this.flag1 != d.flag1 || this.flag2 != d.flag2 || this.prepareFlag != d.prepareFlag) {
            return false;
        }
        if (d.type != this.type || d.length != this.length) {
            return false;
        }
        return Utils.equals(this.basedOnSet, d.basedOnSet) && Utils.equals(this.signature, d.signature) && d.buffer.equals(this.buffer);
    }

    public Number160 hash() {
        if (this.hash == null) {
            this.hash = Utils.makeSHAHash(this.buffer.toByteBuf());
        }
        return this.hash;
    }

    public static enum Type {
        SMALL,
        LARGE;

    }
}

