/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.connection;

import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import net.tomp2p.connection.PeerConnection;
import net.tomp2p.connection.PingBuilderFactory;
import net.tomp2p.futures.FuturePing;
import net.tomp2p.p2p.builder.PingBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HeartBeat
extends ChannelDuplexHandler {
    private static int MIN_TIME_TO_HEARTBEAT_MILLIS = 500;
    private static final Logger LOG = LoggerFactory.getLogger(HeartBeat.class);
    private final long timeToHeartBeatMillis;
    private volatile long lastReadTime;
    private volatile long lastWriteTime;
    private volatile ScheduledFuture<?> heartBeatFuture;
    private volatile int state;
    private final PingBuilderFactory pingBuilderFactory;
    private volatile PeerConnection peerConnection;

    public HeartBeat(long allIdleTime, TimeUnit unit, PingBuilderFactory pingBuilderFactory) {
        if (unit == null) {
            throw new NullPointerException("unit");
        }
        this.timeToHeartBeatMillis = allIdleTime <= 0L ? 0L : Math.max(unit.toMillis(allIdleTime), (long)MIN_TIME_TO_HEARTBEAT_MILLIS);
        this.pingBuilderFactory = pingBuilderFactory;
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        this.lastReadTime = System.currentTimeMillis();
        ctx.fireChannelRead(msg);
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        promise.addListener((GenericFutureListener)new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) throws Exception {
                HeartBeat.this.lastWriteTime = System.currentTimeMillis();
            }
        });
        ctx.write(msg, promise);
    }

    public long getAllIdleTimeInMillis() {
        return this.timeToHeartBeatMillis;
    }

    public PeerConnection peerConnection() {
        return this.peerConnection;
    }

    public HeartBeat peerConnection(PeerConnection peerConnection) {
        this.peerConnection = peerConnection;
        return this;
    }

    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        if (ctx.channel().isActive() && ctx.channel().isRegistered()) {
            this.initialize(ctx);
        }
    }

    public void channelRegistered(ChannelHandlerContext ctx) throws Exception {
        if (ctx.channel().isActive()) {
            this.initialize(ctx);
        }
        super.channelRegistered(ctx);
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        this.initialize(ctx);
        super.channelActive(ctx);
    }

    public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
        this.destroy();
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        this.destroy();
        super.channelInactive(ctx);
    }

    private void initialize(ChannelHandlerContext ctx) {
        switch (this.state) {
            case 1: 
            case 2: {
                return;
            }
        }
        this.state = 1;
        EventExecutor loop = ctx.executor();
        this.lastReadTime = this.lastWriteTime = System.currentTimeMillis();
        this.heartBeatFuture = loop.scheduleAtFixedRate((Runnable)new Heartbeating(ctx), this.timeToHeartBeatMillis, this.timeToHeartBeatMillis, TimeUnit.MILLISECONDS);
    }

    private void destroy() {
        this.state = 2;
        if (this.heartBeatFuture != null) {
            this.heartBeatFuture.cancel(false);
            this.heartBeatFuture = null;
        }
    }

    private final class Heartbeating
    implements Runnable {
        private final ChannelHandlerContext ctx;

        Heartbeating(ChannelHandlerContext ctx) {
            this.ctx = ctx;
        }

        @Override
        public void run() {
            if (!this.ctx.channel().isOpen()) {
                return;
            }
            long currentTime = System.currentTimeMillis();
            long lastIoTime = Math.max(HeartBeat.this.lastReadTime, HeartBeat.this.lastWriteTime);
            long nextDelay = HeartBeat.this.timeToHeartBeatMillis - (currentTime - lastIoTime);
            if (HeartBeat.this.peerConnection != null && nextDelay <= 0L) {
                LOG.debug("sending heart beat to {}, {}", (Object)HeartBeat.this.peerConnection.remotePeer(), HeartBeat.this.peerConnection.channelFuture() != null ? HeartBeat.this.peerConnection.channelFuture().channel() : null);
                PingBuilder builder = HeartBeat.this.pingBuilderFactory.create();
                FuturePing baseFuture = builder.peerConnection(HeartBeat.this.peerConnection).start();
                builder.notifyAutomaticFutures(baseFuture);
            } else {
                LOG.debug("Not sending heart beat to {}, {}", (Object)HeartBeat.this.peerConnection.remotePeer(), HeartBeat.this.peerConnection.channelFuture() != null ? HeartBeat.this.peerConnection.channelFuture().channel() : null);
            }
        }
    }
}

