/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.tracker;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import net.tomp2p.message.TrackerData;
import net.tomp2p.peers.Number160;
import net.tomp2p.peers.PeerStatatistic;
import net.tomp2p.rpc.SimpleBloomFilter;
import net.tomp2p.storage.Data;

public class UtilsTracker {
    public static TrackerData limit(TrackerData peers, int size) {
        HashMap<PeerStatatistic, Data> retVal = new HashMap<PeerStatatistic, Data>(size);
        Random random = new Random();
        ArrayList keys = new ArrayList(peers.peerAddresses().keySet());
        for (int i = 0; i < size && !keys.isEmpty(); ++i) {
            PeerStatatistic key = (PeerStatatistic)keys.get(random.nextInt(keys.size()));
            Data value = (Data)peers.peerAddresses().get(key);
            if (value != null) {
                retVal.put(key, value);
                continue;
            }
            --i;
        }
        TrackerData data = new TrackerData(retVal, peers.peerAddresses().size() > size);
        return data;
    }

    public static TrackerData disjunction(TrackerData meshPeers, SimpleBloomFilter<Number160> knownPeers) {
        TrackerData trackerData = new TrackerData(new HashMap());
        for (Map.Entry entry : meshPeers.peerAddresses().entrySet()) {
            if (knownPeers.contains((Object)((PeerStatatistic)entry.getKey()).peerAddress().peerId())) continue;
            trackerData.put((PeerStatatistic)entry.getKey(), (Data)entry.getValue());
        }
        return trackerData;
    }
}

