/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.relay;

import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SignatureException;
import java.security.spec.InvalidKeySpecException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.tomp2p.connection.ConnectionBean;
import net.tomp2p.connection.ConnectionConfiguration;
import net.tomp2p.connection.PeerBean;
import net.tomp2p.connection.PeerConnection;
import net.tomp2p.connection.RequestHandler;
import net.tomp2p.connection.SignatureFactory;
import net.tomp2p.futures.BaseFuture;
import net.tomp2p.futures.BaseFutureAdapter;
import net.tomp2p.futures.BaseFutureListener;
import net.tomp2p.futures.FutureChannelCreator;
import net.tomp2p.futures.FutureResponse;
import net.tomp2p.message.Buffer;
import net.tomp2p.message.Decoder;
import net.tomp2p.message.Encoder;
import net.tomp2p.message.Message;
import net.tomp2p.peers.Number160;
import net.tomp2p.peers.PeerAddress;
import net.tomp2p.peers.PeerMap;
import net.tomp2p.peers.PeerMapConfiguration;
import net.tomp2p.peers.PeerStatatistic;
import net.tomp2p.storage.AlternativeCompositeByteBuf;

public class RelayUtils {
    public static Buffer encodeMessage(Message message, SignatureFactory signatureFactory) throws InvalidKeyException, SignatureException, IOException {
        Encoder e = new Encoder(signatureFactory);
        AlternativeCompositeByteBuf buf = AlternativeCompositeByteBuf.compBuffer();
        e.write(buf, message, message.receivedSignature());
        return new Buffer((ByteBuf)buf);
    }

    public static Message decodeMessage(Buffer buf, InetSocketAddress recipient, InetSocketAddress sender, SignatureFactory signatureFactory) throws InvalidKeyException, NoSuchAlgorithmException, InvalidKeySpecException, SignatureException, IOException {
        Decoder d = new Decoder(signatureFactory);
        int readerBefore = buf.buffer().readerIndex();
        d.decodeHeader(buf.buffer(), recipient, sender);
        boolean donePayload = d.decodePayload(buf.buffer());
        d.decodeSignature(buf.buffer(), readerBefore, donePayload);
        return d.message();
    }

    public static List<Map<Number160, PeerStatatistic>> unflatten(Collection<PeerAddress> map, PeerAddress sender) {
        PeerMapConfiguration peerMapConfiguration = new PeerMapConfiguration(sender.peerId());
        PeerMap peerMap = new PeerMap(peerMapConfiguration);
        for (PeerAddress peerAddress : map) {
            peerMap.peerFound(peerAddress, null, null);
        }
        return peerMap.peerMapVerified();
    }

    public static Collection<PeerAddress> flatten(List<Map<Number160, PeerStatatistic>> maps) {
        ArrayList<PeerAddress> result = new ArrayList<PeerAddress>();
        for (Map<Number160, PeerStatatistic> map : maps) {
            for (PeerStatatistic peerStatatistic : map.values()) {
                result.add(peerStatatistic.peerAddress());
            }
        }
        return result;
    }

    public static FutureResponse sendSingle(final PeerConnection peerConnection, final FutureResponse futureResponse, PeerBean peerBean, ConnectionBean connectionBean, ConnectionConfiguration config) {
        final RequestHandler requestHandler = new RequestHandler(futureResponse, peerBean, connectionBean, config);
        FutureChannelCreator fcc = peerConnection.acquire(futureResponse);
        fcc.addListener((BaseFutureListener)new BaseFutureAdapter<FutureChannelCreator>(){

            public void operationComplete(FutureChannelCreator future) throws Exception {
                if (future.isSuccess()) {
                    requestHandler.sendTCP(peerConnection.channelCreator(), peerConnection);
                } else {
                    futureResponse.failed((BaseFuture)future);
                }
            }
        });
        return futureResponse;
    }
}

