/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.nat;

import java.util.Collection;
import java.util.concurrent.TimeUnit;
import net.tomp2p.connection.ConnectionConfiguration;
import net.tomp2p.connection.DefaultConnectionConfiguration;
import net.tomp2p.connection.PeerConnection;
import net.tomp2p.connection.Ports;
import net.tomp2p.futures.BaseFuture;
import net.tomp2p.futures.BaseFutureAdapter;
import net.tomp2p.futures.BaseFutureListener;
import net.tomp2p.futures.FutureBootstrap;
import net.tomp2p.futures.FutureDiscover;
import net.tomp2p.futures.FutureDone;
import net.tomp2p.futures.FuturePeerConnection;
import net.tomp2p.futures.FutureResponse;
import net.tomp2p.message.Message;
import net.tomp2p.nat.FutureNAT;
import net.tomp2p.nat.FutureRelayNAT;
import net.tomp2p.nat.NATUtils;
import net.tomp2p.nat.PeerMapUpdateTask;
import net.tomp2p.natpmp.NatPmpException;
import net.tomp2p.p2p.Peer;
import net.tomp2p.p2p.Shutdown;
import net.tomp2p.p2p.builder.BootstrapBuilder;
import net.tomp2p.p2p.builder.DiscoverBuilder;
import net.tomp2p.peers.PeerAddress;
import net.tomp2p.relay.DistributedRelay;
import net.tomp2p.relay.FutureRelay;
import net.tomp2p.relay.RelayListener;
import net.tomp2p.relay.RelayRPC;
import net.tomp2p.relay.RelayUtils;
import net.tomp2p.rpc.RPC;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PeerNAT {
    private static final Logger LOG = LoggerFactory.getLogger(PeerNAT.class);
    private final Peer peer;
    private final NATUtils natUtils;
    private final RelayRPC relayRPC;
    private final int peerMapUpdateInterval;
    private final int failedRelayWaitTime;
    private final int maxFail;
    private final boolean manualPorts;
    private final Collection<PeerAddress> manualRelays;
    private static final int MESSAGE_VERSION = 1;
    private static final int PERMANENT_FLAG = 1;

    public PeerNAT(Peer peer, NATUtils natUtils, RelayRPC relayRPC, Collection<PeerAddress> manualRelays, int failedRelayWaitTime, int maxFail, int peerMapUpdateInterval, boolean manualPorts) {
        this.peer = peer;
        this.natUtils = natUtils;
        this.relayRPC = relayRPC;
        this.manualRelays = manualRelays;
        this.failedRelayWaitTime = failedRelayWaitTime;
        this.maxFail = maxFail;
        this.peerMapUpdateInterval = peerMapUpdateInterval;
        this.manualPorts = manualPorts;
    }

    public Peer peer() {
        return this.peer;
    }

    public NATUtils natUtils() {
        return this.natUtils;
    }

    public RelayRPC relayRPC() {
        return this.relayRPC;
    }

    public int peerMapUpdateInterval() {
        return this.peerMapUpdateInterval;
    }

    public int failedRelayWaitTime() {
        return this.failedRelayWaitTime;
    }

    public int maxFail() {
        return this.maxFail;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRelay(PeerAddress relay) {
        Collection<PeerAddress> collection = this.manualRelays;
        synchronized (collection) {
            this.manualRelays.add(relay);
        }
    }

    public Collection<PeerAddress> manualRelays() {
        return this.manualRelays;
    }

    public boolean isManualPorts() {
        return this.manualPorts;
    }

    public FutureNAT startSetupPortforwarding(final FutureDiscover futureDiscover) {
        final FutureNAT futureNAT = new FutureNAT();
        futureDiscover.addListener((BaseFutureListener)new BaseFutureAdapter<FutureDiscover>(){

            public void operationComplete(FutureDiscover future) throws Exception {
                if (future.reporter() != null) {
                    futureNAT.reporter(future.reporter());
                }
                if (future.isFailed() && future.isNat() && !PeerNAT.this.isManualPorts()) {
                    Ports externalPorts = PeerNAT.this.setupPortforwarding(future.internalAddress().getHostAddress(), PeerNAT.this.peer.connectionBean().channelServer().channelServerConfiguration().portsForwarding());
                    if (externalPorts != null) {
                        PeerAddress serverAddress = PeerNAT.this.peer.peerBean().serverPeerAddress().changePorts(externalPorts.tcpPort(), externalPorts.udpPort()).changeAddress(future.externalAddress());
                        PeerNAT.this.peer.peerBean().serverPeerAddress(serverAddress);
                        DiscoverBuilder builder = new DiscoverBuilder(PeerNAT.this.peer).peerAddress(futureNAT.reporter());
                        builder.start().addListener((BaseFutureListener)new BaseFutureAdapter<FutureDiscover>(){

                            public void operationComplete(FutureDiscover future) throws Exception {
                                if (future.isSuccess()) {
                                    futureNAT.done(future.peerAddress(), future.reporter());
                                } else {
                                    PeerAddress pa = PeerNAT.this.peer.peerBean().serverPeerAddress().changeFirewalledTCP(true).changeFirewalledUDP(true);
                                    PeerNAT.this.peer.peerBean().serverPeerAddress(pa);
                                    futureNAT.failed((BaseFuture)future);
                                }
                            }
                        });
                    } else {
                        PeerAddress pa = PeerNAT.this.peer.peerBean().serverPeerAddress().changeFirewalledTCP(true).changeFirewalledUDP(true);
                        PeerNAT.this.peer.peerBean().serverPeerAddress(pa);
                        futureNAT.failed("could not setup NAT");
                    }
                } else if (future.isSuccess()) {
                    LOG.info("nothing to do, you are reachable from outside");
                    futureNAT.done(futureDiscover.peerAddress(), futureDiscover.reporter());
                } else {
                    LOG.info("not reachable, maybe your setup is wrong");
                    futureNAT.failed("could discover anything", (BaseFuture)future);
                }
            }
        });
        return futureNAT;
    }

    public Ports setupPortforwarding(String internalHost, Ports ports) {
        boolean success;
        block8: {
            try {
                success = this.natUtils.mapUPNP(internalHost, this.peer.peerAddress().tcpPort(), this.peer.peerAddress().udpPort(), ports.udpPort(), ports.tcpPort());
            }
            catch (Exception e) {
                success = false;
            }
            if (!success) {
                if (LOG.isWarnEnabled()) {
                    LOG.warn("cannot find UPNP devices");
                }
                try {
                    success = this.natUtils.mapPMP(this.peer.peerAddress().tcpPort(), this.peer.peerAddress().udpPort(), ports.udpPort(), ports.tcpPort());
                    if (!success && LOG.isWarnEnabled()) {
                        LOG.warn("cannot find NAT-PMP devices");
                    }
                }
                catch (NatPmpException e1) {
                    if (!LOG.isWarnEnabled()) break block8;
                    LOG.warn("cannot find NAT-PMP devices ", (Throwable)e1);
                }
            }
        }
        if (success) {
            return ports;
        }
        return null;
    }

    public DistributedRelay startSetupRelay(FutureRelay futureRelay) {
        final DistributedRelay distributedRelay = new DistributedRelay(this.peer, this.relayRPC, this.failedRelayWaitTime());
        this.peer.addShutdownListener(new Shutdown(){

            public BaseFuture shutdown() {
                return distributedRelay.shutdown();
            }
        });
        distributedRelay.addRelayListener(new RelayListener(){

            @Override
            public void relayFailed(DistributedRelay distributedRelay, PeerConnection peerConnection) {
                FutureRelay futureRelay2 = new FutureRelay();
                distributedRelay.setupRelays(futureRelay2, PeerNAT.this.manualRelays, PeerNAT.this.maxFail);
                PeerNAT.this.peer.notifyAutomaticFutures((BaseFuture)futureRelay2);
            }
        });
        distributedRelay.setupRelays(futureRelay, this.manualRelays, this.maxFail);
        return distributedRelay;
    }

    public Shutdown startRelayMaintenance(FutureRelay futureRelay, BootstrapBuilder bootstrapBuilder, DistributedRelay distributedRelay) {
        final PeerMapUpdateTask peerMapUpdateTask = new PeerMapUpdateTask(this.relayRPC, bootstrapBuilder, distributedRelay, this.manualRelays, this.maxFail);
        this.peer.connectionBean().timer().scheduleAtFixedRate(peerMapUpdateTask, 0L, this.peerMapUpdateInterval(), TimeUnit.SECONDS);
        final Shutdown shutdown = new Shutdown(){

            public BaseFuture shutdown() {
                peerMapUpdateTask.cancel();
                return new FutureDone().done();
            }
        };
        this.peer.addShutdownListener(shutdown);
        return new Shutdown(){

            public BaseFuture shutdown() {
                peerMapUpdateTask.cancel();
                PeerNAT.this.peer.removeShutdownListener(shutdown);
                return new FutureDone().done();
            }
        };
    }

    public FutureRelayNAT startRelay(PeerAddress peerAddress) {
        BootstrapBuilder bootstrapBuilder = this.peer.bootstrap().peerAddress(peerAddress);
        return this.startRelay(bootstrapBuilder);
    }

    public FutureRelayNAT startRelay(BootstrapBuilder bootstrapBuilder) {
        FutureRelayNAT futureBootstrapNAT = new FutureRelayNAT();
        return this.startRelay(futureBootstrapNAT, bootstrapBuilder);
    }

    public FutureRelayNAT startRelay(FutureDiscover futureDiscover) {
        return this.startRelay(futureDiscover, null);
    }

    public FutureRelayNAT startRelay(final FutureDiscover futureDiscover, final FutureNAT futureNAT) {
        final FutureRelayNAT futureRelayNAT = new FutureRelayNAT();
        futureDiscover.addListener((BaseFutureListener)new BaseFutureAdapter<FutureDiscover>(){

            public void operationComplete(FutureDiscover future) throws Exception {
                if (future.isFailed()) {
                    if (futureNAT != null) {
                        PeerNAT.this.handleFutureNat(futureDiscover.reporter(), futureNAT, futureRelayNAT);
                    } else {
                        BootstrapBuilder bootstrapBuilder = PeerNAT.this.peer.bootstrap().peerAddress(futureDiscover.reporter());
                        PeerNAT.this.startRelay(futureRelayNAT, bootstrapBuilder);
                    }
                } else {
                    futureRelayNAT.done();
                }
            }
        });
        return futureRelayNAT;
    }

    private void handleFutureNat(final PeerAddress peerAddress, FutureNAT futureNAT, final FutureRelayNAT futureRelayNAT) {
        futureNAT.addListener((BaseFutureListener)new BaseFutureAdapter<FutureNAT>(){

            public void operationComplete(FutureNAT future) throws Exception {
                if (future.isSuccess()) {
                    futureRelayNAT.done();
                } else {
                    BootstrapBuilder bootstrapBuilder = PeerNAT.this.peer.bootstrap().peerAddress(peerAddress);
                    PeerNAT.this.startRelay(futureRelayNAT, bootstrapBuilder);
                }
            }
        });
    }

    private FutureRelayNAT startRelay(final FutureRelayNAT futureBootstrapNAT, final BootstrapBuilder bootstrapBuilder) {
        PeerAddress upa = this.peer.peerBean().serverPeerAddress();
        upa = upa.changeFirewalledTCP(true).changeFirewalledUDP(true);
        this.peer.peerBean().serverPeerAddress(upa);
        FutureBootstrap futureBootstrap = bootstrapBuilder.start();
        futureBootstrapNAT.futureBootstrap0(futureBootstrap);
        futureBootstrap.addListener((BaseFutureListener)new BaseFutureAdapter<FutureBootstrap>(){

            public void operationComplete(FutureBootstrap future) throws Exception {
                if (future.isSuccess()) {
                    LOG.debug("bootstrap completed");
                    final FutureRelay futureRelay = new FutureRelay();
                    final DistributedRelay distributedRelay = PeerNAT.this.startSetupRelay(futureRelay);
                    futureBootstrapNAT.futureRelay(futureRelay);
                    futureRelay.addListener((BaseFutureListener)new BaseFutureAdapter<FutureRelay>(){

                        public void operationComplete(FutureRelay future) throws Exception {
                            if (future.isSuccess()) {
                                FutureBootstrap futureBootstrap = bootstrapBuilder.start();
                                futureBootstrapNAT.futureBootstrap1(futureBootstrap);
                                futureBootstrap.addListener((BaseFutureListener)new BaseFutureAdapter<FutureBootstrap>(){

                                    public void operationComplete(FutureBootstrap future) throws Exception {
                                        if (future.isSuccess()) {
                                            Shutdown shutdown = PeerNAT.this.startRelayMaintenance(futureRelay, bootstrapBuilder, distributedRelay);
                                            futureBootstrapNAT.done(shutdown);
                                        } else {
                                            futureBootstrapNAT.failed("2nd FutureBootstrap failed", (BaseFuture)future);
                                        }
                                    }
                                });
                            } else {
                                futureBootstrapNAT.failed("FutureRelay failed", (BaseFuture)future);
                            }
                        }
                    });
                } else {
                    futureBootstrapNAT.failed("FutureBootstrap failed", (BaseFuture)future);
                }
            }
        });
        return futureBootstrapNAT;
    }

    public FutureDone<PeerConnection> startSetupRcon(final PeerAddress relayPeerAddress, final PeerAddress unreachablePeerAddress) {
        this.checkRconPreconditions(relayPeerAddress, unreachablePeerAddress);
        final FutureDone futureDone = new FutureDone();
        final FuturePeerConnection fpc = this.peer.createPeerConnection(relayPeerAddress);
        fpc.addListener((BaseFutureListener)new BaseFutureAdapter<FuturePeerConnection>(){

            public void operationComplete(FuturePeerConnection future) throws Exception {
                if (fpc.isSuccess()) {
                    PeerConnection peerConnection = fpc.peerConnection();
                    if (peerConnection != null) {
                        Message setUpMessage = this.createSetupMessage(relayPeerAddress, unreachablePeerAddress);
                        FutureResponse futureResponse = new FutureResponse(setUpMessage);
                        futureResponse = RelayUtils.sendSingle(peerConnection, futureResponse, PeerNAT.this.peer.peerBean(), PeerNAT.this.peer.connectionBean(), (ConnectionConfiguration)new DefaultConnectionConfiguration());
                        futureResponse.addListener((BaseFutureListener)new BaseFutureAdapter<FutureResponse>(){

                            public void operationComplete(FutureResponse future) throws Exception {
                                if (future.isSuccess()) {
                                    PeerConnection openPeerConnection = PeerNAT.this.peer.peerBean().peerConnection(unreachablePeerAddress.peerId());
                                    futureDone.done((Object)openPeerConnection);
                                } else {
                                    this.handleFail((FutureDone<PeerConnection>)futureDone, "No reverse connection could be established");
                                }
                            }
                        });
                    } else {
                        this.handleFail((FutureDone<PeerConnection>)futureDone, "The PeerConnection was null!");
                    }
                } else {
                    this.handleFail((FutureDone<PeerConnection>)futureDone, "no channel could be established");
                }
            }

            private void handleFail(FutureDone<PeerConnection> futureDone2, String failMessage) {
                LOG.error(failMessage);
                futureDone2.failed(failMessage);
            }

            private Message createSetupMessage(PeerAddress relayPeerAddress2, PeerAddress unreachablePeerAddress2) {
                Message setUpMessage = new Message();
                setUpMessage.version(1);
                setUpMessage.sender(PeerNAT.this.peer.peerAddress());
                setUpMessage.recipient(relayPeerAddress2.changePeerId(unreachablePeerAddress2.peerId()));
                setUpMessage.command(RPC.Commands.RCON.getNr());
                setUpMessage.type(Message.Type.REQUEST_1);
                setUpMessage.longValue(1L);
                return setUpMessage;
            }
        });
        return futureDone;
    }

    private void checkRconPreconditions(PeerAddress relayPeerAddress, PeerAddress unreachablePeerAddress) {
        if (this.peer.peerAddress().peerId().equals((Object)relayPeerAddress.peerId())) {
            throw new IllegalStateException("We are alredy a relay for the target peer. We shouldn't use a reverse connection to connect to the targeted peer!");
        }
        if (relayPeerAddress == null || unreachablePeerAddress == null) {
            throw new IllegalArgumentException("either the relay PeerAddress or the unreachablePeerAddress or both was/were null!");
        }
    }
}

