/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.synchronization;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import net.tomp2p.peers.Number160;
import net.tomp2p.storage.AlternativeCompositeByteBuf;
import net.tomp2p.storage.DataBuffer;
import net.tomp2p.synchronization.Checksum;
import net.tomp2p.synchronization.Instruction;

public class SyncUtils {
    public static List<Instruction> decodeInstructions(ByteBuf buf) {
        ArrayList<Instruction> result = new ArrayList<Instruction>();
        while (buf.isReadable()) {
            int header = buf.readInt();
            if ((header & Integer.MIN_VALUE) != 0) {
                int reference = header & Integer.MAX_VALUE;
                result.add(new Instruction(reference));
                continue;
            }
            int length = header;
            int remaining = Math.min(length, buf.readableBytes());
            DataBuffer literal = new DataBuffer(buf.slice(buf.readerIndex(), remaining));
            buf.skipBytes(remaining);
            result.add(new Instruction(literal));
        }
        return result;
    }

    public static Number160 decodeHeader(ByteBuf buf) {
        byte[] me = new byte[20];
        buf.readBytes(me);
        return new Number160(me);
    }

    public static int encodeInstructions(List<Instruction> instructions, Number160 versionKey, Number160 hash, AlternativeCompositeByteBuf buf) {
        int size = 0;
        buf.writeBytes(versionKey.toByteArray());
        buf.writeBytes(hash.toByteArray());
        for (Instruction instruction : instructions) {
            int header = instruction.reference();
            size += 4;
            if (header != -1) {
                buf.writeInt(header |= Integer.MIN_VALUE);
                continue;
            }
            header = instruction.length();
            size += header;
            buf.writeInt(header);
            instruction.literal().transferTo(buf);
        }
        return size;
    }

    public static DataBuffer encodeChecksum(List<Checksum> checksums, Number160 versionKey, Number160 hash, ByteBuf buf) {
        buf.writeBytes(versionKey.toByteArray());
        buf.writeBytes(hash.toByteArray());
        for (Checksum checksum : checksums) {
            buf.writeInt(checksum.weakChecksum());
            buf.writeBytes(checksum.strongChecksum());
        }
        return new DataBuffer(buf);
    }

    public static List<Checksum> decodeChecksums(ByteBuf buf) {
        ArrayList<Checksum> result = new ArrayList<Checksum>();
        while (buf.isReadable()) {
            byte[] me = new byte[16];
            int weak = buf.readInt();
            buf.readBytes(me);
            result.add(new Checksum(weak, me));
        }
        return result;
    }
}

