/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.replication;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import net.tomp2p.connection.ChannelCreator;
import net.tomp2p.dht.PeerDHT;
import net.tomp2p.dht.PutBuilder;
import net.tomp2p.dht.ReplicationListener;
import net.tomp2p.dht.StorageRPC;
import net.tomp2p.futures.BaseFuture;
import net.tomp2p.futures.BaseFutureAdapter;
import net.tomp2p.futures.BaseFutureListener;
import net.tomp2p.futures.FutureChannelCreator;
import net.tomp2p.futures.FutureDone;
import net.tomp2p.futures.FutureResponse;
import net.tomp2p.p2p.ResponsibilityListener;
import net.tomp2p.p2p.Shutdown;
import net.tomp2p.peers.Number160;
import net.tomp2p.peers.Number640;
import net.tomp2p.peers.PeerAddress;
import net.tomp2p.replication.AutoReplication;
import net.tomp2p.replication.Replication;
import net.tomp2p.replication.ReplicationFactor;
import net.tomp2p.replication.ReplicationSender;
import net.tomp2p.storage.Data;
import net.tomp2p.synchronization.PeerSync;
import net.tomp2p.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndirectReplication
implements ResponsibilityListener,
Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(IndirectReplication.class);
    private static final int DEFAULT_REPLICATION_FACTOR = 6;
    private final PeerDHT peer;
    private boolean autoReplication = false;
    private ReplicationFactor replicationFactor;
    private int delayMillis = -1;
    private int intervalMillis = -1;
    private boolean rsync = false;
    private int blockSize = -1;
    private ReplicationSender replicationSender;
    private boolean nRoot = false;
    private boolean keepData = false;
    private Replication replication;
    private ScheduledFuture<?> scheduledFuture;
    private List<ResponsibilityListener> responsibilityListeners = null;

    public IndirectReplication(PeerDHT peer) {
        this.peer = peer;
        peer.peer().addShutdownListener(new Shutdown(){

            public BaseFuture shutdown() {
                IndirectReplication.this.shutdown();
                return new FutureDone().done();
            }
        });
    }

    public boolean isAutoReplication() {
        return this.autoReplication;
    }

    public IndirectReplication autoReplication(boolean autoReplication) {
        this.autoReplication = autoReplication;
        return this;
    }

    public IndirectReplication autoReplication() {
        this.autoReplication = true;
        return this;
    }

    public boolean isRsync() {
        return this.rsync;
    }

    public IndirectReplication rsync(boolean rsync) {
        this.rsync = rsync;
        return this;
    }

    public IndirectReplication rsync() {
        this.rsync = true;
        return this;
    }

    public boolean isNRoot() {
        return this.nRoot;
    }

    public IndirectReplication nRoot(boolean nRoot) {
        this.nRoot = nRoot;
        return this;
    }

    public IndirectReplication nRoot() {
        this.nRoot = true;
        return this;
    }

    public boolean isKeepingData() {
        return this.keepData;
    }

    public IndirectReplication keepData(boolean keepData) {
        this.keepData = keepData;
        return this;
    }

    public IndirectReplication keepData() {
        this.keepData = false;
        return this;
    }

    public IndirectReplication replicationFactor(ReplicationFactor replicationFactor) {
        this.replicationFactor = replicationFactor;
        return this;
    }

    public IndirectReplication replicationFactor(final int replicationFactor) {
        this.replicationFactor = new ReplicationFactor(){

            @Override
            public int replicationFactor() {
                return replicationFactor;
            }
        };
        return this;
    }

    public ReplicationFactor replicationFactor() {
        return this.replicationFactor;
    }

    public IndirectReplication delayMillis(int delayMillis) {
        this.delayMillis = delayMillis;
        return this;
    }

    public int delayMillis() {
        return this.delayMillis;
    }

    public IndirectReplication intervalMillis(int intervalMillis) {
        this.intervalMillis = intervalMillis;
        return this;
    }

    public int intervalMillis() {
        return this.intervalMillis;
    }

    public IndirectReplication blockSize(int blockSize) {
        this.blockSize = blockSize;
        return this;
    }

    public int blockSize() {
        return this.blockSize;
    }

    public IndirectReplication start() {
        if (this.intervalMillis == -1) {
            this.intervalMillis = 60000;
        }
        if (this.delayMillis == -1) {
            this.delayMillis = 30000;
        }
        if (this.blockSize == -1) {
            this.blockSize = 700;
        }
        if (this.autoReplication) {
            this.replicationFactor = new AutoReplication(this.peer.peer());
        } else if (this.replicationFactor == null) {
            this.replicationFactor = new ReplicationFactor(){

                @Override
                public int replicationFactor() {
                    return 6;
                }
            };
        }
        this.replication = new Replication(this.peer.storageLayer(), this.peer.peerAddress(), this.peer.peer().peerBean().peerMap(), this.replicationFactor.replicationFactor(), this.nRoot, this.keepData);
        this.replication.addResponsibilityListener(this);
        if (this.responsibilityListeners != null) {
            for (ResponsibilityListener responsibilityListener : this.responsibilityListeners) {
                this.replication.addResponsibilityListener(responsibilityListener);
            }
            this.responsibilityListeners = null;
        }
        this.peer.storeRPC().replicationListener((ReplicationListener)this.replication);
        if (this.rsync) {
            this.replicationSender = new PeerSync(this.peer, this.replication, this.blockSize);
        } else if (this.replicationSender == null) {
            this.replicationSender = new DefaultReplicationSender(this.peer);
        }
        this.scheduledFuture = this.peer.peer().connectionBean().timer().scheduleAtFixedRate(this, this.intervalMillis, this.intervalMillis, TimeUnit.MILLISECONDS);
        return this;
    }

    public IndirectReplication addResponsibilityListener(ResponsibilityListener responsibilityListener) {
        if (this.replication == null) {
            if (this.responsibilityListeners == null) {
                this.responsibilityListeners = new ArrayList<ResponsibilityListener>();
            }
            this.responsibilityListeners.add(responsibilityListener);
        } else {
            this.replication.addResponsibilityListener(responsibilityListener);
        }
        return this;
    }

    public IndirectReplication removeResponsibilityListener(ResponsibilityListener responsibilityListener) {
        if (this.replication == null) {
            if (this.responsibilityListeners != null) {
                this.responsibilityListeners.remove(responsibilityListener);
            }
        } else {
            this.replication.removeResponsibilityListener(responsibilityListener);
        }
        return this;
    }

    public void otherResponsible(Number160 locationKey, PeerAddress other) {
        if (!this.nRoot) {
            return;
        }
        LOG.debug("Other peer {} is responsible for {}. I'm {}", new Object[]{other, locationKey, this.peer.peerAddress()});
        Number640 min = new Number640(locationKey, Number160.ZERO, Number160.ZERO, Number160.ZERO);
        Number640 max = new Number640(locationKey, Number160.MAX_VALUE, Number160.MAX_VALUE, Number160.MAX_VALUE);
        NavigableMap dataMap = this.peer.storageLayer().get(min, max, -1, true);
        this.replicationSender.sendDirect(other, locationKey, dataMap);
        LOG.debug("transfer from {} to {} for key {}", new Object[]{this.peer.peerAddress(), other, locationKey});
    }

    public void meResponsible(Number160 locationKey) {
        LOG.debug("I ({}) now responsible for {}", (Object)this.peer.peerAddress(), (Object)locationKey);
        this.synchronizeData(locationKey);
    }

    public void meResponsible(Number160 locationKey, PeerAddress newPeer) {
        LOG.debug("I ({}) sync {} to {}", new Object[]{this.peer.peerAddress(), locationKey, newPeer});
        Number640 min = new Number640(locationKey, Number160.ZERO, Number160.ZERO, Number160.ZERO);
        Number640 max = new Number640(locationKey, Number160.MAX_VALUE, Number160.MAX_VALUE, Number160.MAX_VALUE);
        NavigableMap dataMap = this.peer.storageLayer().get(min, max, -1, true);
        this.replicationSender.sendDirect(newPeer, locationKey, dataMap);
    }

    @Override
    public void run() {
        Collection locationKeys = this.peer.storageLayer().findContentForResponsiblePeerID(this.peer.peerID());
        for (Number160 locationKey : locationKeys) {
            this.synchronizeData(locationKey);
        }
        int replicationFactor = this.replicationFactor.replicationFactor();
        this.replication.replicationFactor(replicationFactor);
    }

    private void synchronizeData(Number160 locationKey) {
        Number640 min = new Number640(locationKey, Number160.ZERO, Number160.ZERO, Number160.ZERO);
        Number640 max = new Number640(locationKey, Number160.MAX_VALUE, Number160.MAX_VALUE, Number160.MAX_VALUE);
        NavigableMap dataMap = this.peer.storageLayer().get(min, max, -1, true);
        List<PeerAddress> closePeers = this.send(locationKey, dataMap);
        LOG.debug("[storage refresh] I ({}) restore {} to {}", new Object[]{this.peer.peerAddress(), locationKey, closePeers});
    }

    protected List<PeerAddress> send(Number160 locationKey, Map<Number640, Data> dataMapConverted) {
        int replicationFactor = this.replication.replicationFactor() - 1;
        ArrayList<PeerAddress> closePeers = new ArrayList<PeerAddress>();
        NavigableSet sortedSet = this.peer.peerBean().peerMap().closePeers(locationKey, replicationFactor);
        int count = 0;
        for (PeerAddress peerAddress : sortedSet) {
            closePeers.add(peerAddress);
            this.replicationSender.sendDirect(peerAddress, locationKey, dataMapConverted);
            if (++count != replicationFactor) continue;
            break;
        }
        return closePeers;
    }

    public void shutdown() {
        if (this.scheduledFuture != null) {
            this.scheduledFuture.cancel(false);
        }
    }

    private static class DefaultReplicationSender
    implements ReplicationSender {
        private StorageRPC storageRPC;
        private PeerDHT peer;

        private DefaultReplicationSender(PeerDHT peer) {
            this.peer = peer;
            this.storageRPC = peer.storeRPC();
        }

        @Override
        public void sendDirect(final PeerAddress other, final Number160 locationKey, final Map<Number640, Data> dataMap) {
            FutureChannelCreator futureChannelCreator = this.peer.peer().connectionBean().reservation().create(0, 1);
            futureChannelCreator.addListener((BaseFutureListener)new BaseFutureAdapter<FutureChannelCreator>(){

                public void operationComplete(FutureChannelCreator future) throws Exception {
                    if (future.isSuccess()) {
                        PutBuilder putBuilder = new PutBuilder(DefaultReplicationSender.this.peer, locationKey);
                        putBuilder.dataMap(dataMap);
                        FutureResponse futureResponse = DefaultReplicationSender.this.storageRPC.put(other, putBuilder, future.channelCreator());
                        Utils.addReleaseListener((ChannelCreator)future.channelCreator(), (BaseFuture[])new BaseFuture[]{futureResponse});
                        DefaultReplicationSender.this.peer.peer().notifyAutomaticFutures((BaseFuture)futureResponse);
                    } else if (LOG.isErrorEnabled()) {
                        LOG.error("otherResponsible failed " + future.failedReason());
                    }
                }
            });
        }
    }
}

