/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.tracker;

import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.NavigableSet;
import net.tomp2p.connection.PeerConnection;
import net.tomp2p.connection.PeerException;
import net.tomp2p.message.TrackerData;
import net.tomp2p.p2p.Peer;
import net.tomp2p.peers.DefaultMaintenance;
import net.tomp2p.peers.Maintainable;
import net.tomp2p.peers.Number160;
import net.tomp2p.peers.Number320;
import net.tomp2p.peers.PeerAddress;
import net.tomp2p.peers.PeerMap;
import net.tomp2p.peers.PeerMapChangeListener;
import net.tomp2p.peers.PeerStatatistic;
import net.tomp2p.peers.PeerStatusListener;
import net.tomp2p.rpc.DigestInfo;
import net.tomp2p.storage.Data;
import net.tomp2p.storage.DigestTracker;
import net.tomp2p.tracker.PeerExchange;
import net.tomp2p.utils.ConcurrentCacheMap;

public class TrackerStorage
implements Maintainable,
PeerMapChangeListener,
PeerStatusListener,
DigestTracker {
    public static final int TRACKER_CACHE_SIZE = 1000;
    private final Map<Number320, TrackerData> dataMapUnverified;
    private final Map<Number320, TrackerData> dataMap;
    private final boolean verifyPeersOnTracker;
    private final int[] intervalSeconds;
    private final ConcurrentCacheMap<Number160, Boolean> peerOffline;
    private final PeerAddress self;
    private final int trackerTimoutSeconds;
    private final PeerMap peerMap;
    private final int replicationFactor;
    private PeerExchange peerExchange;

    public TrackerStorage(int trackerTimoutSeconds, int[] intervalSeconds, int replicationFactor, Peer peer, boolean verifyPeersOnTracker) {
        this.dataMapUnverified = new ConcurrentCacheMap(trackerTimoutSeconds, 1000, true);
        this.dataMap = new ConcurrentCacheMap(trackerTimoutSeconds, 1000, true);
        this.peerOffline = new ConcurrentCacheMap(trackerTimoutSeconds * 5, 1000, false);
        this.trackerTimoutSeconds = trackerTimoutSeconds;
        this.intervalSeconds = intervalSeconds;
        this.self = peer.peerAddress();
        this.peerMap = peer.peerBean().peerMap();
        this.replicationFactor = replicationFactor;
        this.verifyPeersOnTracker = verifyPeersOnTracker;
    }

    public boolean put(Number320 key, PeerAddress peerAddress, PublicKey publicKey, Data attachement) {
        if (this.peerOffline.containsKey((Object)peerAddress.peerId())) {
            return false;
        }
        Data oldData = this.findOld(key, peerAddress);
        if (oldData != null && oldData.publicKey() != null && !oldData.publicKey().equals(publicKey)) {
            return false;
        }
        if (attachement == null) {
            attachement = new Data();
        }
        attachement.publicKey(publicKey);
        return this.add(key, new PeerStatatistic(peerAddress), this.verifyPeersOnTracker ? this.dataMapUnverified : this.dataMap, attachement);
    }

    private Data findOld(Number320 key, PeerAddress peerAddress) {
        for (Map.Entry<Number320, TrackerData> entry : this.dataMapUnverified.entrySet()) {
            for (Map.Entry entry2 : entry.getValue().peerAddresses().entrySet()) {
                if (!((PeerStatatistic)entry2.getKey()).peerAddress().equals((Object)peerAddress)) continue;
                return (Data)entry2.getValue();
            }
        }
        for (Map.Entry<Number320, TrackerData> entry : this.dataMap.entrySet()) {
            for (Map.Entry entry2 : entry.getValue().peerAddresses().entrySet()) {
                if (!((PeerStatatistic)entry2.getKey()).peerAddress().equals((Object)peerAddress)) continue;
                return (Data)entry2.getValue();
            }
        }
        return null;
    }

    public PeerExchange peerExchange() {
        return this.peerExchange;
    }

    public TrackerStorage peerExchange(PeerExchange peerExchange) {
        this.peerExchange = peerExchange;
        return this;
    }

    public PeerStatatistic nextForMaintenance(Collection<PeerAddress> notInterestedAddresses) {
        for (Map.Entry<Number320, TrackerData> entry : this.dataMapUnverified.entrySet()) {
            for (Map.Entry entry2 : entry.getValue().peerAddresses().entrySet()) {
                if (!DefaultMaintenance.needMaintenance((PeerStatatistic)((PeerStatatistic)entry2.getKey()), (int[])this.intervalSeconds)) continue;
                return (PeerStatatistic)entry2.getKey();
            }
        }
        return null;
    }

    public void peerInserted(PeerAddress remotePeer, boolean verified) {
        if (verified) {
            this.checkCloserFound(remotePeer, this.self);
        }
    }

    public void peerRemoved(PeerAddress remotePeer, PeerStatatistic storedPeerAddress) {
        this.checkCloserRemoved(remotePeer, this.self);
    }

    public void peerUpdated(PeerAddress peerAddress, PeerStatatistic storedPeerAddress) {
    }

    private void checkCloserRemoved(PeerAddress remotePeer, PeerAddress self) {
        for (Map.Entry<Number320, TrackerData> entry : this.dataMap.entrySet()) {
            NavigableSet closePeers = this.peerMap.closePeers(entry.getKey().locationKey(), this.replicationFactor);
            boolean meClosest = closePeers.size() > 1 ? ((PeerAddress)closePeers.first()).equals((Object)self) : false;
            if (!meClosest || !this.isInReplicationRange(entry.getKey().locationKey(), remotePeer, this.replicationFactor)) continue;
            ArrayList tmp = new ArrayList();
            tmp.addAll(closePeers);
            if (tmp.size() <= this.replicationFactor || this.peerExchange == null) continue;
            PeerAddress nextRemotePeer = (PeerAddress)tmp.get(this.replicationFactor - 1);
            this.peerExchange.peerExchange(nextRemotePeer, entry.getKey(), entry.getValue());
        }
    }

    private void checkCloserFound(PeerAddress remotePeer, PeerAddress self) {
        for (Map.Entry<Number320, TrackerData> entry : this.dataMap.entrySet()) {
            NavigableSet closePeers = this.peerMap.closePeers(entry.getKey().locationKey(), this.replicationFactor);
            closePeers.remove(remotePeer);
            boolean meClosest = closePeers.size() > 1 ? ((PeerAddress)closePeers.first()).equals((Object)self) : false;
            if (!meClosest || !this.isInReplicationRange(entry.getKey().locationKey(), remotePeer, this.replicationFactor) || this.peerExchange == null) continue;
            this.peerExchange.peerExchange(remotePeer, entry.getKey(), entry.getValue());
        }
    }

    private boolean isInReplicationRange(Number160 locationKey, PeerAddress peerAddress, int replicationFactor) {
        NavigableSet tmp = this.peerMap.closePeers(locationKey, replicationFactor);
        tmp.add(this.self);
        return tmp.headSet(peerAddress).size() < replicationFactor;
    }

    private boolean add(Number320 key, PeerStatatistic stat, Map<Number320, TrackerData> map, Data attachement) {
        TrackerData trackerData = map.get(key);
        if (trackerData == null) {
            trackerData = new TrackerData((Map)new ConcurrentCacheMap(this.trackerTimoutSeconds, 1000, true));
            map.put(key, trackerData);
        }
        if (trackerData.size() < 1000) {
            trackerData.put(stat, attachement);
            return true;
        }
        return false;
    }

    private boolean remove(Number320 key, PeerStatatistic stat, Map<Number320, TrackerData> map) {
        TrackerData trackerData = map.get(key);
        if (trackerData != null) {
            return trackerData.remove(stat.peerAddress().peerId()) != null;
        }
        return false;
    }

    public TrackerData peers(Number320 key) {
        return this.dataMap.get(key);
    }

    public Collection<Number320> keys() {
        return this.dataMap.keySet();
    }

    public boolean peerFailed(PeerAddress remotePeer, PeerException reason) {
        this.peerOffline.put((Object)remotePeer.peerId(), (Object)Boolean.TRUE);
        Number320 keyToRemove = null;
        PeerStatatistic statToRemove = null;
        for (Map.Entry<Number320, TrackerData> entry : this.dataMapUnverified.entrySet()) {
            for (Map.Entry entry2 : entry.getValue().peerAddresses().entrySet()) {
                if (!((PeerStatatistic)entry2.getKey()).peerAddress().equals((Object)remotePeer)) continue;
                keyToRemove = entry.getKey();
                statToRemove = (PeerStatatistic)entry2.getKey();
            }
        }
        if (keyToRemove != null) {
            this.remove(keyToRemove, statToRemove, this.dataMapUnverified);
        }
        for (Map.Entry<Number320, TrackerData> entry : this.dataMap.entrySet()) {
            for (Map.Entry entry2 : entry.getValue().peerAddresses().entrySet()) {
                if (!((PeerStatatistic)entry2.getKey()).peerAddress().equals((Object)remotePeer)) continue;
                keyToRemove = entry.getKey();
                statToRemove = (PeerStatatistic)entry2.getKey();
            }
        }
        if (keyToRemove != null) {
            this.remove(keyToRemove, statToRemove, this.dataMap);
        }
        return true;
    }

    public boolean peerFound(PeerAddress remotePeer, PeerAddress referrer, PeerConnection peerConnection) {
        boolean firsthand;
        boolean bl = firsthand = referrer == null;
        if (firsthand) {
            this.peerOffline.remove((Object)remotePeer.peerId());
            Number320 keyToRemove = null;
            PeerStatatistic statToRemove = null;
            for (Map.Entry<Number320, TrackerData> entry : this.dataMapUnverified.entrySet()) {
                for (Map.Entry entry2 : entry.getValue().peerAddresses().entrySet()) {
                    if (!((PeerStatatistic)entry2.getKey()).peerAddress().equals((Object)remotePeer) || !this.add(entry.getKey(), (PeerStatatistic)entry2.getKey(), this.dataMap, (Data)entry2.getValue())) continue;
                    keyToRemove = entry.getKey();
                    statToRemove = (PeerStatatistic)entry2.getKey();
                    statToRemove.successfullyChecked();
                }
            }
            if (keyToRemove != null && statToRemove != null) {
                this.remove(keyToRemove, statToRemove, this.dataMapUnverified);
            }
        }
        return true;
    }

    public int size() {
        return this.dataMap.size();
    }

    public int sizeUnverified() {
        return this.dataMapUnverified.size();
    }

    public DigestInfo digest(Number160 locationKey, Number160 domainKey, Number160 contentKey) {
        Number160 contentDigest = Number160.ZERO;
        int counter = 0;
        TrackerData trackerData = this.dataMap.get(new Number320(locationKey, domainKey));
        if (trackerData != null) {
            if (contentKey != null) {
                Map.Entry entry = trackerData.get(contentKey);
                if (entry != null) {
                    return new DigestInfo(Number160.ZERO, contentKey, 1);
                }
            } else {
                for (PeerStatatistic peerStatatistic : trackerData.peerAddresses().keySet()) {
                    contentDigest = contentDigest.xor(peerStatatistic.peerAddress().peerId());
                    ++counter;
                }
            }
        }
        return new DigestInfo(Number160.ZERO, contentKey, counter);
    }
}

