/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.tracker;

import net.tomp2p.connection.ChannelCreator;
import net.tomp2p.connection.ConnectionConfiguration;
import net.tomp2p.futures.BaseFuture;
import net.tomp2p.futures.BaseFutureAdapter;
import net.tomp2p.futures.BaseFutureListener;
import net.tomp2p.futures.FutureChannelCreator;
import net.tomp2p.futures.FutureDone;
import net.tomp2p.futures.FutureResponse;
import net.tomp2p.message.TrackerData;
import net.tomp2p.p2p.Peer;
import net.tomp2p.peers.Number320;
import net.tomp2p.peers.PeerAddress;
import net.tomp2p.tracker.PeerExchangeRPC;

public class PeerExchange {
    private final Peer peer;
    private final PeerExchangeRPC peerExchangeRPC;
    private final ConnectionConfiguration connectionConfiguration;

    public PeerExchange(Peer peer, PeerExchangeRPC peerExchangeRPC, ConnectionConfiguration connectionConfiguration) {
        this.peer = peer;
        this.peerExchangeRPC = peerExchangeRPC;
        this.connectionConfiguration = connectionConfiguration;
    }

    public FutureDone<Void> peerExchange(PeerAddress remotePeer, Number320 key, TrackerData data) {
        return this.peerExchange(remotePeer, key, data, this.connectionConfiguration);
    }

    public FutureDone<Void> peerExchange(final PeerAddress remotePeer, final Number320 key, final TrackerData data, final ConnectionConfiguration connectionConfiguration) {
        final FutureDone futureDone = new FutureDone();
        FutureChannelCreator futureChannelCreator = this.peer.connectionBean().reservation().create(1, 0);
        futureChannelCreator.addListener((BaseFutureListener)new BaseFutureAdapter<FutureChannelCreator>(){

            public void operationComplete(FutureChannelCreator future) throws Exception {
                if (future.isSuccess()) {
                    final ChannelCreator channelCreator = future.channelCreator();
                    FutureResponse futureResponse = PeerExchange.this.peerExchangeRPC.peerExchange(remotePeer, key, channelCreator, data, connectionConfiguration);
                    futureResponse.addListener((BaseFutureListener)new BaseFutureAdapter<FutureResponse>(){

                        public void operationComplete(FutureResponse future) throws Exception {
                            if (future.isSuccess()) {
                                futureDone.done();
                            } else {
                                futureDone.failed((BaseFuture)future);
                            }
                            channelCreator.shutdown();
                        }
                    });
                } else {
                    futureDone.failed((BaseFuture)future);
                }
            }
        });
        return futureDone;
    }

    public PeerExchangeRPC peerExchangeRPC() {
        return this.peerExchangeRPC;
    }
}

