/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.tracker;

import net.tomp2p.futures.BaseFuture;
import net.tomp2p.futures.FutureCreate;
import net.tomp2p.futures.FutureCreator;
import net.tomp2p.futures.FutureLateJoin;
import net.tomp2p.futures.FutureResponse;
import net.tomp2p.futures.FutureTracker;
import net.tomp2p.peers.Number160;
import net.tomp2p.peers.Number320;
import net.tomp2p.peers.PeerAddress;
import net.tomp2p.rpc.SimpleBloomFilter;
import net.tomp2p.storage.Data;
import net.tomp2p.tracker.PeerTracker;
import net.tomp2p.tracker.TrackerBuilder;

public class AddTrackerBuilder
extends TrackerBuilder<AddTrackerBuilder> {
    private Data attachement;
    private SimpleBloomFilter<Number160> bloomFilter;
    private FutureCreate<BaseFuture> futureCreate;
    private FutureCreator<FutureTracker> defaultDirectReplication;
    private FutureCreator<FutureLateJoin<FutureResponse>> defaultPEX;
    private boolean tcpPEX = false;
    private PeerAddress peerAddressToAnnounce;

    public AddTrackerBuilder(PeerTracker peer, Number160 locationKey) {
        super(peer, locationKey);
        this.self(this);
    }

    public Data attachement() {
        return this.attachement;
    }

    public AddTrackerBuilder attachement(Data attachement) {
        this.attachement = attachement;
        return this;
    }

    public SimpleBloomFilter<Number160> getBloomFilter() {
        return this.bloomFilter;
    }

    public AddTrackerBuilder setBloomFilter(SimpleBloomFilter<Number160> bloomFilter) {
        this.bloomFilter = bloomFilter;
        return this;
    }

    public FutureCreate<BaseFuture> getFutureCreate() {
        return this.futureCreate;
    }

    public AddTrackerBuilder setFutureCreate(FutureCreate<BaseFuture> futureCreate) {
        this.futureCreate = futureCreate;
        return this;
    }

    public FutureCreator<FutureTracker> getDefaultDirectReplication() {
        return this.defaultDirectReplication;
    }

    public AddTrackerBuilder setDefaultDirectReplication(FutureCreator<FutureTracker> defaultDirectReplication) {
        this.defaultDirectReplication = defaultDirectReplication;
        return this;
    }

    public FutureCreator<FutureLateJoin<FutureResponse>> getDefaultPEX() {
        return this.defaultPEX;
    }

    public AddTrackerBuilder setDefaultPEX(FutureCreator<FutureLateJoin<FutureResponse>> defaultPEX) {
        this.defaultPEX = defaultPEX;
        return this;
    }

    public boolean isTcpPEX() {
        return this.tcpPEX;
    }

    public AddTrackerBuilder setTcpPEX() {
        this.tcpPEX = true;
        return this;
    }

    public AddTrackerBuilder setTcpPEX(boolean tcpPEX) {
        this.tcpPEX = tcpPEX;
        return this;
    }

    public PeerAddress peerAddressToAnnounce() {
        return this.peerAddressToAnnounce;
    }

    public AddTrackerBuilder peerAddressToAnnounce(PeerAddress peerAddressToAnnounce) {
        this.peerAddressToAnnounce = peerAddressToAnnounce;
        return this;
    }

    @Override
    public FutureTracker start() {
        if (this.peer.peer().isShutdown()) {
            return FUTURE_TRACKER_SHUTDOWN;
        }
        this.preBuild("add-tracker-build");
        if (this.bloomFilter == null) {
            this.bloomFilter = new SimpleBloomFilter(1024, 1024);
        }
        this.peer.trackerStorage().put(new Number320(this.locationKey, this.domainKey), this.peer.peerAddress(), this.keyPair() == null ? null : this.keyPair().getPublic(), this.attachement);
        FutureTracker futureTracker = this.peer.distributedTracker().add(this);
        return futureTracker;
    }
}

