/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.dht;

import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListMap;
import net.tomp2p.peers.Number160;
import net.tomp2p.peers.Number320;
import net.tomp2p.peers.Number480;
import net.tomp2p.peers.Number640;
import net.tomp2p.storage.Data;
import net.tomp2p.storage.Storage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StorageMemory
implements Storage {
    public static final int DEFAULT_STORAGE_CHECK_INTERVAL = 60000;
    private static final Logger LOG = LoggerFactory.getLogger(StorageMemory.class);
    private final NavigableMap<Number640, Data> dataMap = new ConcurrentSkipListMap<Number640, Data>();
    private final Map<Number640, Long> timeoutMap = new ConcurrentHashMap<Number640, Long>();
    private final ConcurrentSkipListMap<Long, Set<Number640>> timeoutMapRev = new ConcurrentSkipListMap();
    private final Map<Number320, PublicKey> protectedMap = new ConcurrentHashMap<Number320, PublicKey>();
    private final Map<Number480, PublicKey> entryMap = new ConcurrentHashMap<Number480, PublicKey>();
    private final Map<Number160, Set<Number160>> responsibilityMap = new ConcurrentHashMap<Number160, Set<Number160>>();
    private final Map<Number160, Set<Number160>> responsibilityMapRev = new ConcurrentHashMap<Number160, Set<Number160>>();
    final int storageCheckIntervalMillis;

    public StorageMemory() {
        this(60000);
    }

    public StorageMemory(int storageCheckIntervalMillis) {
        this.storageCheckIntervalMillis = storageCheckIntervalMillis;
    }

    public boolean put(Number640 key, Data value) {
        this.dataMap.put(key, value);
        return true;
    }

    public Data get(Number640 key) {
        return (Data)this.dataMap.get(key);
    }

    public boolean contains(Number640 key) {
        return this.dataMap.containsKey(key);
    }

    public int contains(Number640 fromKey, Number640 toKey) {
        NavigableMap<Number640, Data> tmp = this.dataMap.subMap(fromKey, true, toKey, true);
        return tmp.size();
    }

    public Data remove(Number640 key, boolean returnData) {
        return (Data)this.dataMap.remove(key);
    }

    public NavigableMap<Number640, Data> remove(Number640 fromKey, Number640 toKey, boolean returnData) {
        NavigableMap<Number640, Data> tmp = this.dataMap.subMap(fromKey, true, toKey, true);
        TreeMap<Number640, Data> retVal = new TreeMap<Number640, Data>();
        for (Map.Entry entry : tmp.entrySet()) {
            retVal.put((Number640)entry.getKey(), (Data)entry.getValue());
        }
        tmp.clear();
        return retVal;
    }

    public NavigableMap<Number640, Data> subMap(Number640 fromKey, Number640 toKey, int limit, boolean ascending) {
        NavigableMap<Number640, Data> tmp = this.dataMap.subMap(fromKey, true, toKey, true);
        TreeMap<Number640, Data> retVal = new TreeMap<Number640, Data>();
        if (limit < 0) {
            for (Map.Entry entry : (ascending ? tmp : tmp.descendingMap()).entrySet()) {
                retVal.put((Number640)entry.getKey(), (Data)entry.getValue());
            }
        } else {
            limit = Math.min(limit, tmp.size());
            Iterator iterator = ascending ? tmp.entrySet().iterator() : tmp.descendingMap().entrySet().iterator();
            for (int i = 0; iterator.hasNext() && i < limit; ++i) {
                Map.Entry entry = iterator.next();
                retVal.put((Number640)entry.getKey(), (Data)entry.getValue());
            }
        }
        return retVal;
    }

    public NavigableMap<Number640, Data> map() {
        TreeMap<Number640, Data> retVal = new TreeMap<Number640, Data>();
        for (Map.Entry entry : this.dataMap.entrySet()) {
            retVal.put((Number640)entry.getKey(), (Data)entry.getValue());
        }
        return retVal;
    }

    public void addTimeout(Number640 key, long expiration) {
        Long oldExpiration = this.timeoutMap.put(key, expiration);
        Set<Number640> tmp = this.putIfAbsent2(expiration, Collections.newSetFromMap(new ConcurrentHashMap()));
        tmp.add(key);
        if (oldExpiration == null) {
            return;
        }
        this.removeRevTimeout(key, oldExpiration);
    }

    public void removeTimeout(Number640 key) {
        Long expiration = this.timeoutMap.remove(key);
        if (expiration == null) {
            return;
        }
        this.removeRevTimeout(key, expiration);
    }

    private void removeRevTimeout(Number640 key, Long expiration) {
        Set<Number640> tmp = this.timeoutMapRev.get(expiration);
        if (tmp != null) {
            tmp.remove(key);
            if (tmp.isEmpty()) {
                this.timeoutMapRev.remove(expiration);
            }
        }
    }

    public Collection<Number640> subMapTimeout(long to) {
        SortedMap tmp = this.timeoutMapRev.subMap((Object)0L, (Object)to);
        ArrayList<Number640> toRemove = new ArrayList<Number640>();
        for (Set set : tmp.values()) {
            toRemove.addAll(set);
        }
        return toRemove;
    }

    public boolean protectDomain(Number320 key, PublicKey publicKey) {
        this.protectedMap.put(key, publicKey);
        return true;
    }

    public boolean isDomainProtectedByOthers(Number320 key, PublicKey publicKey) {
        PublicKey other = this.protectedMap.get(key);
        if (other == null) {
            return false;
        }
        return !other.equals(publicKey);
    }

    private Set<Number640> putIfAbsent2(long expiration, Set<Number640> hashSet) {
        Set<Number640> timeouts = this.timeoutMapRev.putIfAbsent(expiration, hashSet);
        return timeouts == null ? hashSet : timeouts;
    }

    public Collection<Number160> findPeerIDsForResponsibleContent(Number160 locationKey) {
        return this.responsibilityMap.get(locationKey);
    }

    public Collection<Number160> findContentForResponsiblePeerID(Number160 peerID) {
        return this.responsibilityMapRev.get(peerID);
    }

    public boolean updateResponsibilities(Number160 locationKey, Number160 peerId) {
        Set<Number160> peerIDs = this.putIfAbsent(locationKey, new HashSet<Number160>());
        boolean isNew = peerIDs.add(peerId);
        Set<Number160> contentIDs = this.putIfAbsentRev(peerId, new HashSet<Number160>());
        contentIDs.add(locationKey);
        if (isNew && LOG.isDebugEnabled()) {
            LOG.debug("Update {} is responsible for key {}.", (Object)peerId, (Object)locationKey);
        }
        return isNew;
    }

    private Set<Number160> putIfAbsent(Number160 locationKey, Set<Number160> hashSet) {
        Set<Number160> peerIDs = ((ConcurrentMap)this.responsibilityMap).putIfAbsent(locationKey, hashSet);
        return peerIDs == null ? hashSet : peerIDs;
    }

    private Set<Number160> putIfAbsentRev(Number160 peerId, Set<Number160> hashSet) {
        Set<Number160> contentIDs = ((ConcurrentMap)this.responsibilityMapRev).putIfAbsent(peerId, hashSet);
        return contentIDs == null ? hashSet : contentIDs;
    }

    public void removeResponsibility(Number160 locationKey) {
        Set<Number160> peerIds = this.responsibilityMap.remove(locationKey);
        if (peerIds != null) {
            for (Number160 peerId : peerIds) {
                this.removeRevResponsibility(peerId, locationKey);
            }
            LOG.debug("Remove responsiblity for {}.", (Object)locationKey);
        }
    }

    private void removeRevResponsibility(Number160 peerId, Number160 locationKey) {
        Set<Number160> contentIDs = this.responsibilityMapRev.get(peerId);
        if (contentIDs != null) {
            contentIDs.remove(locationKey);
            if (contentIDs.isEmpty()) {
                this.responsibilityMapRev.remove(peerId);
            }
        }
    }

    public void removeResponsibility(Number160 locationKey, Number160 peerId) {
        Set<Number160> peerIds = this.responsibilityMap.get(locationKey);
        if (peerIds != null && peerIds.remove(peerId)) {
            this.removeRevResponsibility(peerId, locationKey);
            LOG.debug("Remove responsibility of {} for {}.", (Object)peerId, (Object)locationKey);
        }
    }

    public void close() {
        this.dataMap.clear();
        this.protectedMap.clear();
        this.timeoutMap.clear();
        this.timeoutMapRev.clear();
    }

    public boolean protectEntry(Number480 key, PublicKey publicKey) {
        this.entryMap.put(key, publicKey);
        return true;
    }

    public boolean isEntryProtectedByOthers(Number480 key, PublicKey publicKey) {
        PublicKey other = this.entryMap.get(key);
        if (other == null) {
            return false;
        }
        return !other.equals(publicKey);
    }

    public int storageCheckIntervalMillis() {
        return this.storageCheckIntervalMillis;
    }
}

