/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.dht;

import java.util.NavigableSet;
import java.util.TreeSet;
import net.tomp2p.dht.DHTBuilder;
import net.tomp2p.dht.DistributedHashTable;
import net.tomp2p.dht.FutureDHT;
import net.tomp2p.dht.OperationMapper;
import net.tomp2p.dht.PeerDHT;
import net.tomp2p.peers.Number160;
import net.tomp2p.peers.PeerAddress;

public class ParallelRequestBuilder<K extends FutureDHT<?>>
extends DHTBuilder<ParallelRequestBuilder<K>> {
    private NavigableSet<PeerAddress> queue;
    private OperationMapper<K> operation;
    private boolean cancelOnFinish = false;
    private K futureDHT;

    public ParallelRequestBuilder(PeerDHT peer, Number160 locationKey) {
        super(peer, locationKey);
        this.self(this);
    }

    public NavigableSet<PeerAddress> queue() {
        return this.queue;
    }

    public ParallelRequestBuilder<K> queue(NavigableSet<PeerAddress> queue) {
        this.queue = queue;
        return this;
    }

    public ParallelRequestBuilder<K> add(PeerAddress peerAddress) {
        if (this.queue == null) {
            this.queue = new TreeSet<PeerAddress>(this.peer.peer().peerBean().peerMap().createComparator());
        }
        this.queue.add(peerAddress);
        return this;
    }

    public OperationMapper<K> operation() {
        return this.operation;
    }

    public ParallelRequestBuilder<K> operation(OperationMapper<K> operation) {
        this.operation = operation;
        return this;
    }

    public boolean isCancelOnFinish() {
        return this.cancelOnFinish;
    }

    public ParallelRequestBuilder<K> cancelOnFinish() {
        this.cancelOnFinish = true;
        return this;
    }

    public ParallelRequestBuilder<K> cancelOnFinish(boolean cancelOnFinish) {
        this.cancelOnFinish = cancelOnFinish;
        return this;
    }

    public ParallelRequestBuilder<K> futureDHT(K futureDHT) {
        this.futureDHT = futureDHT;
        return this;
    }

    public K futureDHT() {
        return this.futureDHT;
    }

    public K start() {
        this.preBuild("parallel-builder");
        if (this.queue == null || this.queue.size() == 0) {
            throw new IllegalArgumentException("queue cannot be empty");
        }
        return DistributedHashTable.parallelRequests(this.requestP2PConfiguration, this.queue, this.cancelOnFinish, this.futureChannelCreator, this.operation, this.futureDHT);
    }
}

