/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.rpc;

import io.netty.buffer.Unpooled;
import java.io.IOException;
import net.tomp2p.connection.ChannelCreator;
import net.tomp2p.connection.ConnectionBean;
import net.tomp2p.connection.PeerBean;
import net.tomp2p.connection.PeerConnection;
import net.tomp2p.connection.RequestHandler;
import net.tomp2p.connection.Responder;
import net.tomp2p.futures.FutureResponse;
import net.tomp2p.message.Buffer;
import net.tomp2p.message.Message;
import net.tomp2p.peers.PeerAddress;
import net.tomp2p.rpc.DispatchHandler;
import net.tomp2p.rpc.ObjectDataReply;
import net.tomp2p.rpc.RPC;
import net.tomp2p.rpc.RawDataReply;
import net.tomp2p.rpc.SendDirectBuilderI;
import net.tomp2p.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirectDataRPC
extends DispatchHandler {
    private static final Logger LOG = LoggerFactory.getLogger(DirectDataRPC.class);
    private volatile RawDataReply rawDataReply;
    private volatile ObjectDataReply objectDataReply;

    public DirectDataRPC(PeerBean peerBean, ConnectionBean connectionBean) {
        super(peerBean, connectionBean);
        this.register(RPC.Commands.DIRECT_DATA.getNr());
    }

    public RequestHandler<FutureResponse> sendInternal(PeerAddress remotePeer, SendDirectBuilderI sendDirectBuilder) {
        Message message = this.createMessage(remotePeer, RPC.Commands.DIRECT_DATA.getNr(), sendDirectBuilder.isRaw() ? Message.Type.REQUEST_1 : Message.Type.REQUEST_2);
        FutureResponse futureResponse = new FutureResponse(message, sendDirectBuilder.progressListener());
        if (sendDirectBuilder.isSign()) {
            message.publicKeyAndSign(sendDirectBuilder.keyPair());
        }
        message.streaming(sendDirectBuilder.isStreaming());
        if (sendDirectBuilder.isRaw()) {
            message.buffer(sendDirectBuilder.buffer());
        } else {
            try {
                byte[] me = Utils.encodeJavaObject(sendDirectBuilder.object());
                message.buffer(new Buffer(Unpooled.wrappedBuffer((byte[])me)));
            }
            catch (IOException e) {
                futureResponse.failed("cannot convert object", e);
            }
        }
        return new RequestHandler<FutureResponse>(futureResponse, this.peerBean(), this.connectionBean(), sendDirectBuilder);
    }

    public FutureResponse send(PeerAddress remotePeer, SendDirectBuilderI sendDirectBuilder, ChannelCreator channelCreator) {
        RequestHandler<FutureResponse> requestHandler = this.sendInternal(remotePeer, sendDirectBuilder);
        if (!sendDirectBuilder.isForceUDP()) {
            return requestHandler.sendTCP(channelCreator);
        }
        return requestHandler.sendUDP(channelCreator);
    }

    public void rawDataReply(RawDataReply rawDataReply) {
        this.rawDataReply = rawDataReply;
    }

    public void objectDataReply(ObjectDataReply objectDataReply) {
        this.objectDataReply = objectDataReply;
    }

    public boolean hasRawDataReply() {
        return this.rawDataReply != null;
    }

    public boolean hasObjectDataReply() {
        return this.objectDataReply != null;
    }

    @Override
    public void handleResponse(Message message, PeerConnection peerConnection, boolean sign, Responder responder) throws Exception {
        if (message.type() != Message.Type.REQUEST_1 && message.type() != Message.Type.REQUEST_2 || message.command() != RPC.Commands.DIRECT_DATA.getNr()) {
            throw new IllegalArgumentException("Message content is wrong");
        }
        Message responseMessage = this.createResponseMessage(message, Message.Type.OK);
        if (sign) {
            responseMessage.publicKeyAndSign(this.peerBean().getKeyPair());
        }
        RawDataReply rawDataReply2 = this.rawDataReply;
        ObjectDataReply objectDataReply2 = this.objectDataReply;
        if (message.type() == Message.Type.REQUEST_1 && rawDataReply2 == null) {
            responseMessage.type(Message.Type.NOT_FOUND);
        } else if (message.type() == Message.Type.REQUEST_2 && objectDataReply2 == null) {
            responseMessage.type(Message.Type.NOT_FOUND);
        } else {
            Buffer requestBuffer = message.buffer(0);
            if (message.type() == Message.Type.REQUEST_1) {
                LOG.debug("handling request1");
                Buffer replyBuffer = rawDataReply2.reply(message.sender(), requestBuffer, message.isDone());
                if (replyBuffer == null && message.isDone()) {
                    responseMessage.type(Message.Type.NOT_FOUND);
                } else if (replyBuffer != requestBuffer) {
                    if (!replyBuffer.isComplete()) {
                        responseMessage.streaming();
                    }
                    responseMessage.buffer(replyBuffer);
                }
            } else {
                Object obj = Utils.decodeJavaObject(requestBuffer.buffer());
                LOG.debug("handling {}", obj);
                Object reply = objectDataReply2.reply(message.sender(), obj);
                if (reply == null) {
                    responseMessage.type(Message.Type.NOT_FOUND);
                } else if (reply == obj) {
                    responseMessage.type(Message.Type.OK);
                } else {
                    byte[] me = Utils.encodeJavaObject(reply);
                    responseMessage.buffer(new Buffer(Unpooled.wrappedBuffer((byte[])me)));
                }
            }
        }
        responder.response(responseMessage);
    }
}

