/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.peers;

import net.tomp2p.peers.Number160;
import net.tomp2p.peers.Number480;

public final class Number320
extends Number
implements Comparable<Number320> {
    private static final long serialVersionUID = -7200924461230885512L;
    public static final Number320 ZERO = new Number320(Number160.ZERO, Number160.ZERO);
    private final Number160 locationKey;
    private final Number160 domainKey;

    public Number320(Number160 locationKey, Number160 domainKey) {
        if (locationKey == null) {
            throw new RuntimeException("locationKey cannot be null");
        }
        this.locationKey = locationKey;
        if (domainKey == null) {
            throw new RuntimeException("domainKey cannot be null");
        }
        this.domainKey = domainKey;
    }

    public Number160 locationKey() {
        return this.locationKey;
    }

    public Number160 domainKey() {
        return this.domainKey;
    }

    public int hashCode() {
        return this.locationKey.hashCode() ^ this.domainKey.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Number320)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        Number320 cmp = (Number320)obj;
        return this.locationKey.equals(cmp.locationKey) && this.domainKey.equals(cmp.domainKey);
    }

    @Override
    public int compareTo(Number320 o) {
        int diff = this.locationKey.compareTo(o.locationKey);
        if (diff != 0) {
            return diff;
        }
        return this.domainKey.compareTo(o.domainKey);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("[");
        sb.append(this.locationKey.toString()).append(",");
        sb.append(this.domainKey.toString()).append("]");
        return sb.toString();
    }

    public Number480 min() {
        return new Number480(this.locationKey, this.domainKey, Number160.ZERO);
    }

    public Number480 max() {
        return new Number480(this.locationKey, this.domainKey, Number160.MAX_VALUE);
    }

    @Override
    public int intValue() {
        return this.domainKey.intValue();
    }

    @Override
    public long longValue() {
        return this.domainKey.longValue();
    }

    @Override
    public float floatValue() {
        return (float)this.doubleValue();
    }

    @Override
    public double doubleValue() {
        return this.locationKey.doubleValue() * Math.pow(2.0, 160.0) + this.domainKey.doubleValue();
    }
}

