/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.message;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPromise;
import java.net.SocketAddress;
import java.util.concurrent.atomic.AtomicInteger;

@ChannelHandler.Sharable
public class CountConnectionOutboundHandler
extends ChannelOutboundHandlerAdapter {
    private final AtomicInteger counterCurrent = new AtomicInteger();
    private final AtomicInteger counterTotal = new AtomicInteger();

    public void connect(ChannelHandlerContext ctx, SocketAddress remoteAddress, SocketAddress localAddress, ChannelPromise promise) throws Exception {
        this.counterCurrent.incrementAndGet();
        this.counterTotal.incrementAndGet();
        ctx.connect(remoteAddress, localAddress, promise);
    }

    public void close(ChannelHandlerContext ctx, ChannelPromise promise) throws Exception {
        this.counterCurrent.decrementAndGet();
        ctx.close(promise);
    }

    public int current() {
        return this.counterCurrent.get();
    }

    public int total() {
        return this.counterTotal.get();
    }

    public void reset() {
        this.counterCurrent.set(0);
        this.counterTotal.set(0);
    }
}

