/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.relay;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicReferenceArray;
import net.tomp2p.connection.ChannelCreator;
import net.tomp2p.connection.PeerConnection;
import net.tomp2p.futures.BaseFuture;
import net.tomp2p.futures.BaseFutureAdapter;
import net.tomp2p.futures.BaseFutureListener;
import net.tomp2p.futures.FutureBootstrap;
import net.tomp2p.futures.FutureChannelCreator;
import net.tomp2p.futures.FutureDone;
import net.tomp2p.futures.FutureForkJoin;
import net.tomp2p.futures.FuturePeerConnection;
import net.tomp2p.futures.FutureResponse;
import net.tomp2p.p2p.Peer;
import net.tomp2p.p2p.builder.BootstrapBuilder;
import net.tomp2p.peers.PeerAddress;
import net.tomp2p.peers.PeerSocketAddress;
import net.tomp2p.relay.RelayFuture;
import net.tomp2p.relay.RelayRPC;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RelayManager {
    private static final Logger logger = LoggerFactory.getLogger(RelayManager.class);
    private static final long ROUTING_UPDATE_TIME = 10000L;
    private final RelayManager self = this;
    private final int maxRelays;
    private final Peer peer;
    private final LinkedHashSet<PeerAddress> relayCandidates;
    private Set<PeerAddress> relayAddresses;
    private final RelayRPC relayRPC;

    public RelayManager(Peer peer, RelayRPC relayRPC) {
        this(peer, 5, relayRPC);
    }

    public RelayManager(Peer peer, int maxRelays, RelayRPC relayRPC) {
        this.peer = peer;
        this.relayCandidates = new LinkedHashSet();
        if (maxRelays > 5 || maxRelays < 0) {
            logger.warn("at most {} relays are allowed.", (Object)5);
            maxRelays = 5;
        }
        this.maxRelays = maxRelays;
        this.relayAddresses = new CopyOnWriteArraySet<PeerAddress>();
        this.relayRPC = relayRPC;
    }

    private void updatePeerAddress() {
        boolean hasRelays = !this.relayAddresses.isEmpty();
        PeerSocketAddress[] socketAddresses = null;
        if (hasRelays) {
            socketAddresses = new PeerSocketAddress[this.relayAddresses.size()];
            int index = 0;
            for (PeerAddress pa : this.relayAddresses) {
                socketAddresses[index] = new PeerSocketAddress(pa.getInetAddress(), pa.tcpPort(), pa.udpPort());
                ++index;
            }
        } else {
            socketAddresses = new PeerSocketAddress[]{};
        }
        PeerAddress pa = this.peer.getPeerAddress();
        PeerSocketAddress psa = new PeerSocketAddress(pa.getInetAddress(), pa.tcpPort(), pa.udpPort());
        PeerAddress newAddress = new PeerAddress(pa.getPeerId(), psa, !hasRelays, !hasRelays, hasRelays, socketAddresses);
        this.peer.getPeerBean().serverPeerAddress(newAddress);
    }

    private FutureDone<Void> getNeighbors(BootstrapBuilder bootstrapBuilder) {
        final FutureDone futureDone = new FutureDone();
        FutureBootstrap fb = bootstrapBuilder.start();
        fb.addListener((BaseFutureListener)new BaseFutureAdapter<FutureBootstrap>(){

            public void operationComplete(FutureBootstrap future) throws Exception {
                if (future.isSuccess()) {
                    RelayManager.this.relayCandidates.addAll(RelayManager.this.peer.getDistributedRouting().peerMap().getAll());
                    RelayManager.this.relayCandidates.removeAll(RelayManager.this.relayAddresses);
                    logger.debug("Found {} peers that could act as relays", (Object)RelayManager.this.relayCandidates.size());
                    if (RelayManager.this.relayCandidates.isEmpty()) {
                        futureDone.setFailed("No peers that could act as relays were found");
                    }
                    futureDone.setDone();
                } else {
                    logger.error("Bootstrapping failed: {}", (Object)future.getFailedReason());
                    futureDone.setFailed((BaseFuture)future);
                }
            }
        });
        return futureDone;
    }

    public Collection<PeerAddress> getRelayAddresses() {
        return this.relayAddresses;
    }

    public Collection<PeerAddress> getRelayCandidates() {
        return this.relayCandidates;
    }

    public int maxRelays() {
        return this.maxRelays;
    }

    private FutureDone<Void> relaySetupLoop(final FutureDone<PeerConnection>[] futures, final LinkedHashSet<PeerAddress> relayCandidates, final ChannelCreator cc, final int numberOfRelays, final FutureDone<Void> futureDone, final BootstrapBuilder bootstrapBuilder) {
        if (numberOfRelays == 0) {
            futureDone.setDone();
            return futureDone;
        }
        int active = 0;
        for (int i = 0; i < numberOfRelays; ++i) {
            if (futures[i] == null) {
                PeerAddress candidate = (PeerAddress)relayCandidates.iterator().next();
                relayCandidates.remove(candidate);
                FuturePeerConnection fpc = this.peer.createPeerConnection(candidate);
                futures[i] = this.relayRPC.setupRelay(cc, fpc);
                if (futures[i] == null) continue;
                ++active;
                continue;
            }
            if (futures[i] == null) continue;
            ++active;
        }
        if (active == 0) {
            this.updatePeerAddress();
            futureDone.setDone();
        }
        FutureForkJoin ffj = new FutureForkJoin(new AtomicReferenceArray<FutureDone<PeerConnection>>(futures));
        ffj.addListener((BaseFutureListener)new BaseFutureAdapter<FutureForkJoin<FutureDone<PeerConnection>>>(){

            public void operationComplete(FutureForkJoin<FutureDone<PeerConnection>> future) throws Exception {
                if (future.isSuccess()) {
                    List reponses = future.getCompleted();
                    for (FutureDone fr : reponses) {
                        PeerConnection peerConnection = (PeerConnection)fr.getObject();
                        PeerAddress relayAddress = peerConnection.remotePeer();
                        if (fr.isSuccess()) {
                            logger.debug("Adding peer {} as a relay", (Object)relayAddress);
                            RelayManager.this.relayAddresses.add(relayAddress);
                            RelayManager.this.addCloseListener(peerConnection, bootstrapBuilder);
                            continue;
                        }
                        logger.debug("Peer {} denied relay request", (Object)relayAddress);
                    }
                    RelayManager.this.updatePeerAddress();
                    futureDone.setDone();
                } else {
                    RelayManager.this.relaySetupLoop(futures, relayCandidates, cc, numberOfRelays, (FutureDone<Void>)futureDone, bootstrapBuilder);
                }
            }
        });
        return futureDone;
    }

    private void addCloseListener(final PeerConnection peerConnection, final BootstrapBuilder bootstrapBuilder) {
        peerConnection.closeFuture().addListener((BaseFutureListener)new BaseFutureAdapter<FutureDone<Void>>(){

            public void operationComplete(FutureDone<Void> future) throws Exception {
                if (!RelayManager.this.peer.isShutdown()) {
                    logger.debug("Relay " + peerConnection.remotePeer() + " failed, setting up a new relay peer");
                    RelayManager.this.removeRelay(peerConnection.remotePeer());
                    RelayManager.this.setupRelays(bootstrapBuilder);
                }
            }
        });
    }

    private void removeRelay(PeerAddress pa) {
        this.relayAddresses.remove(pa);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FutureDone<Void> setupPeerConnections(ChannelCreator cc, BootstrapBuilder bootstrapBuilder) {
        System.err.println("setup called");
        RelayManager relayManager = this;
        synchronized (relayManager) {
            FutureDone fd = new FutureDone();
            int nrOfRelays = Math.min(this.maxRelays - this.relayAddresses.size(), this.relayCandidates.size());
            if (nrOfRelays > 0) {
                FutureDone[] relayConnectionFutures = new FutureDone[nrOfRelays];
                this.relaySetupLoop(relayConnectionFutures, this.relayCandidates, cc, nrOfRelays, (FutureDone<Void>)fd, bootstrapBuilder);
            } else {
                fd.setFailed("done");
            }
            return fd;
        }
    }

    public RelayFuture setupRelays(final BootstrapBuilder bootstrapBuilder) {
        final RelayFuture rf = new RelayFuture();
        rf.addListener((BaseFutureListener)new BaseFutureAdapter<RelayFuture>(){

            public void operationComplete(RelayFuture future) throws Exception {
                if (future.isSuccess()) {
                    RelayManager.this.startPeerMapUpdateTask(bootstrapBuilder);
                }
            }
        });
        if (!this.peer.getPeerAddress().isRelayed()) {
            PeerAddress pa = this.peer.getPeerBean().serverPeerAddress().changeFirewalledTCP(true).changeFirewalledUDP(true);
            this.peer.getPeerBean().serverPeerAddress(pa);
        }
        FutureChannelCreator fcc = this.peer.getConnectionBean().reservation().create(0, this.maxRelays);
        fcc.addListener((BaseFutureListener)new BaseFutureAdapter<FutureChannelCreator>(){

            public void operationComplete(FutureChannelCreator future) throws Exception {
                if (future.isSuccess()) {
                    final ChannelCreator cc = future.getChannelCreator();
                    FutureDone fd = RelayManager.this.getNeighbors(bootstrapBuilder);
                    fd.addListener((BaseFutureListener)new BaseFutureAdapter<FutureDone<Void>>(){

                        public void operationComplete(FutureDone<Void> future) throws Exception {
                            if (future.isSuccess()) {
                                FutureDone fd = RelayManager.this.setupPeerConnections(cc, bootstrapBuilder);
                                fd.addListener((BaseFutureListener)new BaseFutureAdapter<FutureDone<Void>>(){

                                    public void operationComplete(FutureDone<Void> future) throws Exception {
                                        if (future.isSuccess()) {
                                            FutureBootstrap fb = bootstrapBuilder.start();
                                            fb.addListener((BaseFutureListener)new BaseFutureAdapter<FutureBootstrap>(){

                                                public void operationComplete(FutureBootstrap future) throws Exception {
                                                    if (future.isSuccess()) {
                                                        rf.relayManager(RelayManager.this.self);
                                                    } else {
                                                        future.setFailed((BaseFuture)future);
                                                    }
                                                }
                                            });
                                        } else {
                                            rf.setFailed((BaseFuture)future);
                                        }
                                    }
                                });
                            } else {
                                rf.setFailed((BaseFuture)future);
                            }
                        }
                    });
                } else {
                    rf.setFailed((BaseFuture)future);
                }
            }
        });
        return rf;
    }

    private void startPeerMapUpdateTask(BootstrapBuilder bootstrapBuilder) {
        new Timer().schedule((TimerTask)new PeerMapUpdateTask(this.relayRPC, bootstrapBuilder), 0L, 10000L);
    }

    private class PeerMapUpdateTask
    extends TimerTask {
        private final RelayRPC relayRPC;
        private final BootstrapBuilder bootstrapBuilder;

        public PeerMapUpdateTask(RelayRPC relayRPC, BootstrapBuilder bootstrapBuilder) {
            this.relayRPC = relayRPC;
            this.bootstrapBuilder = bootstrapBuilder;
        }

        @Override
        public void run() {
            if (RelayManager.this.peer.isShutdown()) {
                this.cancel();
                return;
            }
            FutureBootstrap fb = this.bootstrapBuilder.start();
            fb.addListener((BaseFutureListener)new BaseFutureAdapter<FutureBootstrap>(){

                public void operationComplete(FutureBootstrap future) throws Exception {
                    if (future.isSuccess()) {
                        List peerMapVerified = RelayManager.this.peer.getPeerBean().peerMap().peerMapVerified();
                        for (final PeerAddress relay : RelayManager.this.relayAddresses) {
                            FutureChannelCreator fcc = RelayManager.this.peer.getConnectionBean().reservation().create(0, 1);
                            FutureResponse fr = PeerMapUpdateTask.this.relayRPC.sendPeerMap(relay, peerMapVerified, fcc);
                            fr.addListener((BaseFutureListener)new BaseFutureAdapter<BaseFuture>(){

                                public void operationComplete(BaseFuture future) throws Exception {
                                    if (future.isFailed()) {
                                        logger.warn("failed to update peer map on relay peer {}: {}", (Object)relay, (Object)future.getFailedReason());
                                    } else {
                                        logger.trace("Updated peer map on relay {}", (Object)relay);
                                    }
                                }
                            });
                        }
                    }
                }
            });
        }
    }
}

