/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.relay;

import java.net.InetAddress;
import net.tomp2p.p2p.Peer;
import net.tomp2p.p2p.builder.BootstrapBuilder;
import net.tomp2p.p2p.builder.Builder;
import net.tomp2p.peers.PeerAddress;
import net.tomp2p.relay.RelayFuture;
import net.tomp2p.relay.RelayManager;
import net.tomp2p.relay.RelayPeer;

public class RelayBuilder
implements Builder {
    private static final RelayFuture FUTURE_RELAY_NO_BOOTSTRAP_ADDRESS = (RelayFuture)new RelayFuture().setFailed("No bootrap address has been set");
    private final Peer peer;
    private final RelayManager relayManager;
    private PeerAddress bootstrapAddress;
    private InetAddress bootstrapInetAddress;
    private int port = 7700;
    private BootstrapBuilder bootstrapBuilder;

    public RelayBuilder(RelayPeer relayPeer) {
        this.peer = relayPeer.peer();
        this.relayManager = relayPeer.relayManager();
    }

    public RelayBuilder bootstrapAddress(PeerAddress bootrapAddress) {
        this.bootstrapAddress = bootrapAddress;
        return this;
    }

    public RelayBuilder bootstrapInetAddress(InetAddress bootstrapInetAddress) {
        this.bootstrapInetAddress = bootstrapInetAddress;
        return this;
    }

    public RelayBuilder ports(int port) {
        this.port = port;
        return this;
    }

    public RelayBuilder bootstrapBuilder(BootstrapBuilder bootstrapBuilder) {
        this.bootstrapBuilder = bootstrapBuilder;
        return this;
    }

    public RelayFuture start() {
        BootstrapBuilder bootstrapBuilder = null;
        if (this.bootstrapAddress != null) {
            bootstrapBuilder = this.peer.bootstrap().setPeerAddress(this.bootstrapAddress);
        } else if (this.bootstrapInetAddress != null) {
            bootstrapBuilder = this.peer.bootstrap().setInetAddress(this.bootstrapInetAddress).setPorts(this.port);
        } else if (this.bootstrapBuilder != null) {
            bootstrapBuilder = this.bootstrapBuilder;
        } else {
            return FUTURE_RELAY_NO_BOOTSTRAP_ADDRESS;
        }
        return this.relayManager.setupRelays(bootstrapBuilder);
    }
}

