/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.rpc;

import java.util.NavigableMap;
import net.tomp2p.peers.Number160;
import net.tomp2p.peers.Number640;
import net.tomp2p.rpc.SimpleBloomFilter;
import net.tomp2p.utils.Utils;

public class DigestResult {
    private final SimpleBloomFilter<Number160> contentBloomFilter;
    private final SimpleBloomFilter<Number160> versoinBloomFilter;
    private final NavigableMap<Number640, Number160> keyDigest;

    public DigestResult(SimpleBloomFilter<Number160> contentBloomFilter, SimpleBloomFilter<Number160> versoinBloomFilter) {
        this.contentBloomFilter = contentBloomFilter;
        this.versoinBloomFilter = versoinBloomFilter;
        this.keyDigest = null;
    }

    public DigestResult(NavigableMap<Number640, Number160> keyDigest) {
        this.keyDigest = keyDigest;
        this.contentBloomFilter = null;
        this.versoinBloomFilter = null;
    }

    public SimpleBloomFilter<Number160> contentBloomFilter() {
        return this.contentBloomFilter;
    }

    public SimpleBloomFilter<Number160> versoinBloomFilter() {
        return this.versoinBloomFilter;
    }

    public NavigableMap<Number640, Number160> keyDigest() {
        return this.keyDigest;
    }

    public int hashCode() {
        int hashCode = 0;
        if (this.keyDigest != null) {
            hashCode ^= this.keyDigest.hashCode();
        }
        if (this.contentBloomFilter != null) {
            hashCode ^= this.contentBloomFilter.hashCode();
        }
        if (this.versoinBloomFilter != null) {
            hashCode ^= this.versoinBloomFilter.hashCode();
        }
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DigestResult)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        DigestResult o = (DigestResult)obj;
        return Utils.equals(this.keyDigest, o.keyDigest) && Utils.equals(this.contentBloomFilter, o.contentBloomFilter) && Utils.equals(this.versoinBloomFilter, o.versoinBloomFilter);
    }
}

