/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.p2p.builder;

import java.util.ArrayList;
import java.util.Collection;
import net.tomp2p.futures.FutureDigest;
import net.tomp2p.p2p.EvaluatingSchemeDHT;
import net.tomp2p.p2p.Peer;
import net.tomp2p.p2p.VotingSchemeDHT;
import net.tomp2p.p2p.builder.DHTBuilder;
import net.tomp2p.p2p.builder.SearchableBuilder;
import net.tomp2p.peers.Number160;
import net.tomp2p.peers.Number640;
import net.tomp2p.rpc.SimpleBloomFilter;

public class DigestBuilder
extends DHTBuilder<DigestBuilder>
implements SearchableBuilder {
    private static final FutureDigest FUTURE_SHUTDOWN = (FutureDigest)new FutureDigest(null).setFailed("digest builder - peer is shutting down");
    private static final Collection<Number160> NUMBER_ZERO_CONTENT_KEYS = new ArrayList<Number160>(1);
    private Collection<Number160> contentKeys;
    private Collection<Number640> keys;
    private Number160 contentKey;
    private SimpleBloomFilter<Number160> keyBloomFilter;
    private SimpleBloomFilter<Number160> contentBloomFilter;
    private EvaluatingSchemeDHT evaluationScheme;
    private Number640 from;
    private Number640 to;
    private boolean all = false;
    private boolean returnBloomFilter = false;
    private boolean ascending = true;
    private boolean bloomFilterAnd = true;
    private int returnNr = -1;

    public DigestBuilder(Peer peer, Number160 locationKey) {
        super(peer, locationKey);
        this.self(this);
    }

    @Override
    public Collection<Number160> contentKeys() {
        return this.contentKeys;
    }

    public DigestBuilder contentKeys(Collection<Number160> contentKeys) {
        this.contentKeys = contentKeys;
        return this;
    }

    public Collection<Number640> keys() {
        return this.keys;
    }

    public DigestBuilder setKey(Collection<Number640> keys) {
        this.keys = keys;
        return this;
    }

    public Number160 getContentKey() {
        return this.contentKey;
    }

    public DigestBuilder setContentKey(Number160 contentKey) {
        this.contentKey = contentKey;
        return this;
    }

    public SimpleBloomFilter<Number160> getKeyBloomFilter() {
        return this.keyBloomFilter;
    }

    public DigestBuilder setKeyBloomFilter(SimpleBloomFilter<Number160> keyBloomFilter) {
        this.keyBloomFilter = keyBloomFilter;
        return this;
    }

    public SimpleBloomFilter<Number160> getContentBloomFilter() {
        return this.contentBloomFilter;
    }

    public DigestBuilder setContentBloomFilter(SimpleBloomFilter<Number160> contentBloomFilter) {
        this.contentBloomFilter = contentBloomFilter;
        return this;
    }

    public EvaluatingSchemeDHT getEvaluationScheme() {
        return this.evaluationScheme;
    }

    public DigestBuilder setEvaluationScheme(EvaluatingSchemeDHT evaluationScheme) {
        this.evaluationScheme = evaluationScheme;
        return this;
    }

    public boolean isAll() {
        return this.all;
    }

    public DigestBuilder setAll(boolean all) {
        this.all = all;
        return this;
    }

    public DigestBuilder setAll() {
        this.all = true;
        return this;
    }

    public boolean isReturnBloomFilter() {
        return this.returnBloomFilter;
    }

    public DigestBuilder returnBloomFilter(boolean returnBloomFilter) {
        this.returnBloomFilter = returnBloomFilter;
        return this;
    }

    public DigestBuilder returnBloomFilter() {
        this.returnBloomFilter = true;
        return this;
    }

    public boolean isAscending() {
        return this.ascending;
    }

    public DigestBuilder ascending(boolean ascending) {
        this.ascending = ascending;
        return this;
    }

    public DigestBuilder ascending() {
        this.ascending = true;
        return this;
    }

    public boolean isDescending() {
        return !this.ascending;
    }

    public DigestBuilder descending() {
        this.ascending = false;
        return this;
    }

    public boolean isBloomFilterAnd() {
        return this.bloomFilterAnd;
    }

    public DigestBuilder bloomFilterAnd(boolean bloomFilterAnd) {
        this.bloomFilterAnd = bloomFilterAnd;
        return this;
    }

    public DigestBuilder bloomFilterAnd() {
        this.bloomFilterAnd = true;
        return this;
    }

    public DigestBuilder returnNr(int returnNr) {
        this.returnNr = returnNr;
        return this;
    }

    public int returnNr() {
        return this.returnNr;
    }

    public DigestBuilder from(Number640 from) {
        this.from = from;
        return this;
    }

    @Override
    public Number640 from() {
        return this.from;
    }

    public DigestBuilder to(Number640 to) {
        this.to = to;
        return this;
    }

    @Override
    public Number640 to() {
        return this.to;
    }

    public boolean isRange() {
        return this.from != null && this.to != null;
    }

    @Override
    public FutureDigest start() {
        if (this.peer.isShutdown()) {
            return FUTURE_SHUTDOWN;
        }
        this.preBuild("digest-builder");
        if (this.all) {
            this.contentKeys = null;
        } else if (this.contentKeys == null && !this.all) {
            if (this.contentKey == null) {
                this.contentKeys = NUMBER_ZERO_CONTENT_KEYS;
            } else {
                this.contentKeys = new ArrayList<Number160>(1);
                this.contentKeys.add(this.contentKey);
            }
        }
        if (this.evaluationScheme == null) {
            this.evaluationScheme = new VotingSchemeDHT();
        }
        return this.peer.getDistributedHashMap().digest(this);
    }

    static {
        NUMBER_ZERO_CONTENT_KEYS.add(Number160.ZERO);
    }
}

