/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.p2p.builder;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collection;
import net.tomp2p.futures.BaseFuture;
import net.tomp2p.futures.BaseFutureAdapter;
import net.tomp2p.futures.BaseFutureListener;
import net.tomp2p.futures.FutureBootstrap;
import net.tomp2p.futures.FutureChannelCreator;
import net.tomp2p.futures.FutureLateJoin;
import net.tomp2p.futures.FutureResponse;
import net.tomp2p.futures.FutureRouting;
import net.tomp2p.futures.FutureWrappedBootstrap;
import net.tomp2p.futures.FutureWrapper;
import net.tomp2p.p2p.Peer;
import net.tomp2p.p2p.RequestP2PConfiguration;
import net.tomp2p.p2p.RoutingConfiguration;
import net.tomp2p.p2p.builder.RoutingBuilder;
import net.tomp2p.peers.Number160;
import net.tomp2p.peers.PeerAddress;
import net.tomp2p.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BootstrapBuilder {
    private static final Logger logger = LoggerFactory.getLogger(BootstrapBuilder.class);
    private static final FutureBootstrap FUTURE_BOOTSTRAP_SHUTDOWN = new FutureWrappedBootstrap().setFailed0("Peer is shutting down");
    private static final FutureBootstrap FUTURE_BOOTSTRAP_NO_ADDRESS = new FutureWrappedBootstrap().setFailed0("You did not provide information where to bootstrap to. This could be also caused if you provided a peer address with a peer ID set to zero.");
    private final Peer peer;
    private Collection<PeerAddress> bootstrapTo;
    private PeerAddress peerAddress;
    private InetAddress inetAddress;
    private int portUDP = 7700;
    private int portTCP = 7700;
    private RoutingConfiguration routingConfiguration;
    private RequestP2PConfiguration requestP2PConfiguration;
    private boolean forceRoutingOnlyToSelf = false;
    private boolean broadcast = false;

    public BootstrapBuilder(Peer peer) {
        this.peer = peer;
    }

    public Collection<PeerAddress> getBootstrapTo() {
        return this.bootstrapTo;
    }

    public BootstrapBuilder setBootstrapTo(Collection<PeerAddress> bootstrapTo) {
        this.bootstrapTo = bootstrapTo;
        return this;
    }

    public PeerAddress getPeerAddress() {
        return this.peerAddress;
    }

    public BootstrapBuilder setPeerAddress(PeerAddress peerAddress) {
        if (peerAddress != null && peerAddress.getPeerId().equals(Number160.ZERO)) {
            logger.warn("You provided a peer address with peerID zero. You won't be able to bootstrap since no peer can have a peerID set to zero");
            return this;
        }
        this.peerAddress = peerAddress;
        return this;
    }

    public InetAddress getInetAddress() {
        return this.inetAddress;
    }

    public BootstrapBuilder setInetAddress(InetAddress inetAddress) {
        this.inetAddress = inetAddress;
        return this;
    }

    public int getPortUDP() {
        return this.portUDP;
    }

    public BootstrapBuilder setPortUDP(int portUDP) {
        this.portUDP = portUDP;
        return this;
    }

    public int getPortTCP() {
        return this.portTCP;
    }

    public BootstrapBuilder setPortTCP(int portTCP) {
        this.portTCP = portTCP;
        return this;
    }

    public BootstrapBuilder setPorts(int port) {
        this.portTCP = port;
        this.portUDP = port;
        return this;
    }

    public RoutingConfiguration getRoutingConfiguration() {
        return this.routingConfiguration;
    }

    public BootstrapBuilder setRoutingConfiguration(RoutingConfiguration routingConfiguration) {
        this.routingConfiguration = routingConfiguration;
        return this;
    }

    public RequestP2PConfiguration getRequestP2PConfiguration() {
        return this.requestP2PConfiguration;
    }

    public BootstrapBuilder setRequestP2PConfiguration(RequestP2PConfiguration requestP2PConfiguration) {
        this.requestP2PConfiguration = requestP2PConfiguration;
        return this;
    }

    public boolean isForceRoutingOnlyToSelf() {
        return this.forceRoutingOnlyToSelf;
    }

    public BootstrapBuilder setForceRoutingOnlyToSelf() {
        this.forceRoutingOnlyToSelf = true;
        return this;
    }

    public BootstrapBuilder setForceRoutingOnlyToSelf(boolean forceRoutingOnlyToSelf) {
        this.forceRoutingOnlyToSelf = forceRoutingOnlyToSelf;
        return this;
    }

    public boolean isBroadcast() {
        return this.broadcast;
    }

    public BootstrapBuilder setBroadcast() {
        this.broadcast = true;
        return this;
    }

    public BootstrapBuilder setBroadcast(boolean broadcast) {
        this.broadcast = broadcast;
        return this;
    }

    public FutureBootstrap start() {
        if (this.peer.isShutdown()) {
            return FUTURE_BOOTSTRAP_SHUTDOWN;
        }
        if (this.routingConfiguration == null) {
            this.routingConfiguration = new RoutingConfiguration(5, 10, 2);
        }
        if (this.requestP2PConfiguration == null) {
            int size = this.peer.getPeerBean().peerMap().size() + 1;
            this.requestP2PConfiguration = new RequestP2PConfiguration(Math.min(size, 3), 5, 3);
        }
        if (this.broadcast) {
            return this.broadcast();
        }
        if (this.peerAddress == null && this.inetAddress != null && this.bootstrapTo == null) {
            this.peerAddress = new PeerAddress(Number160.ZERO, this.inetAddress, this.portTCP, this.portUDP);
            return this.bootstrapPing(this.peerAddress);
        }
        if (this.peerAddress != null && this.bootstrapTo == null) {
            this.bootstrapTo = new ArrayList<PeerAddress>(1);
            this.bootstrapTo.add(this.peerAddress);
            return this.bootstrap();
        }
        if (this.bootstrapTo != null) {
            return this.bootstrap();
        }
        return FUTURE_BOOTSTRAP_NO_ADDRESS;
    }

    private FutureBootstrap bootstrap() {
        final FutureWrappedBootstrap result = new FutureWrappedBootstrap();
        result.setBootstrapTo(this.bootstrapTo);
        int conn = Math.max(this.routingConfiguration.getParallel(), this.requestP2PConfiguration.getParallel());
        FutureChannelCreator fcc = this.peer.getConnectionBean().reservation().create(conn, 0);
        fcc.addListener((BaseFutureListener<BaseFuture>)new BaseFutureAdapter<FutureChannelCreator>(){

            @Override
            public void operationComplete(FutureChannelCreator futureChannelCreator) throws Exception {
                if (futureChannelCreator.isSuccess()) {
                    RoutingBuilder routingBuilder = BootstrapBuilder.this.createBuilder(BootstrapBuilder.this.requestP2PConfiguration, BootstrapBuilder.this.routingConfiguration);
                    FutureWrapper<FutureRouting> futureBootstrap = BootstrapBuilder.this.peer.getDistributedRouting().bootstrap(BootstrapBuilder.this.bootstrapTo, routingBuilder, futureChannelCreator.getChannelCreator());
                    Utils.addReleaseListener(futureChannelCreator.getChannelCreator(), futureBootstrap);
                    result.waitFor(futureBootstrap);
                } else {
                    result.setFailed(futureChannelCreator);
                }
            }
        });
        return result;
    }

    private RoutingBuilder createBuilder(RequestP2PConfiguration requestP2PConfiguration, RoutingConfiguration routingConfiguration) {
        RoutingBuilder routingBuilder = new RoutingBuilder();
        routingBuilder.setParallel(routingConfiguration.getParallel());
        routingBuilder.setMaxNoNewInfo(routingConfiguration.getMaxNoNewInfo(requestP2PConfiguration.getMinimumResults()));
        routingBuilder.setMaxDirectHits(Integer.MAX_VALUE);
        routingBuilder.setMaxFailures(routingConfiguration.getMaxFailures());
        routingBuilder.setMaxSuccess(routingConfiguration.getMaxSuccess());
        routingBuilder.setForceRoutingOnlyToSelf(this.forceRoutingOnlyToSelf);
        return routingBuilder;
    }

    private FutureWrappedBootstrap<FutureBootstrap> bootstrapPing(PeerAddress address) {
        final FutureWrappedBootstrap<FutureBootstrap> result = new FutureWrappedBootstrap<FutureBootstrap>();
        FutureResponse tmp = (FutureResponse)this.peer.ping().setPeerAddress(address).setTcpPing().start();
        tmp.addListener((BaseFutureListener<BaseFuture>)new BaseFutureAdapter<FutureResponse>(){

            @Override
            public void operationComplete(FutureResponse future) throws Exception {
                if (future.isSuccess()) {
                    BootstrapBuilder.this.peerAddress = future.getResponse().getSender();
                    BootstrapBuilder.this.bootstrapTo = new ArrayList(1);
                    BootstrapBuilder.this.bootstrapTo.add(BootstrapBuilder.this.peerAddress);
                    result.setBootstrapTo(BootstrapBuilder.this.bootstrapTo);
                    result.waitFor(BootstrapBuilder.this.bootstrap());
                } else {
                    result.setFailed("could not reach anyone with bootstrap");
                }
            }
        });
        return result;
    }

    private FutureWrappedBootstrap<FutureBootstrap> broadcast() {
        final FutureWrappedBootstrap<FutureBootstrap> result = new FutureWrappedBootstrap<FutureBootstrap>();
        FutureLateJoin tmp = (FutureLateJoin)this.peer.ping().setBroadcast().setPort(this.portUDP).start();
        tmp.addListener((BaseFutureListener<BaseFuture>)new BaseFutureAdapter<FutureLateJoin<FutureResponse>>(){

            @Override
            public void operationComplete(FutureLateJoin<FutureResponse> future) throws Exception {
                if (future.isSuccess()) {
                    FutureResponse futureResponse = future.getLastSuceessFuture();
                    if (futureResponse == null) {
                        result.setFailed("no futures found", future);
                        return;
                    }
                    if (BootstrapBuilder.this.bootstrapTo != null && BootstrapBuilder.this.bootstrapTo.size() > 0) {
                        logger.info("you added peers to bootstrapTo. However with broadcast we found our own peers.");
                    }
                    BootstrapBuilder.this.peerAddress = futureResponse.getResponse().getSender();
                    BootstrapBuilder.this.bootstrapTo = new ArrayList(1);
                    BootstrapBuilder.this.bootstrapTo.add(BootstrapBuilder.this.peerAddress);
                    result.setBootstrapTo(BootstrapBuilder.this.bootstrapTo);
                    result.waitFor(BootstrapBuilder.this.bootstrap());
                } else {
                    result.setFailed("could not reach anyone with the broadcast", future);
                }
            }
        });
        return result;
    }
}

