/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.p2p;

import java.util.Collection;
import java.util.Comparator;
import java.util.NavigableSet;
import java.util.Random;
import java.util.TreeMap;
import java.util.TreeSet;
import net.tomp2p.connection.ChannelCreator;
import net.tomp2p.connection.PeerBean;
import net.tomp2p.futures.BaseFuture;
import net.tomp2p.futures.BaseFutureAdapter;
import net.tomp2p.futures.BaseFutureListener;
import net.tomp2p.futures.FutureForkJoin;
import net.tomp2p.futures.FutureResponse;
import net.tomp2p.futures.FutureRouting;
import net.tomp2p.futures.FutureWrapper;
import net.tomp2p.message.Message;
import net.tomp2p.p2p.RoutingMechanism;
import net.tomp2p.p2p.builder.RoutingBuilder;
import net.tomp2p.peers.Number160;
import net.tomp2p.peers.Number640;
import net.tomp2p.peers.PeerAddress;
import net.tomp2p.peers.PeerMap;
import net.tomp2p.rpc.DigestInfo;
import net.tomp2p.rpc.NeighborRPC;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DistributedRouting {
    private static final Logger LOG = LoggerFactory.getLogger(DistributedRouting.class);
    private final NeighborRPC neighbors;
    private final PeerBean peerBean;
    private final Random rnd;

    public DistributedRouting(PeerBean peerBean, NeighborRPC neighbors) {
        this.neighbors = neighbors;
        this.peerBean = peerBean;
        this.rnd = new Random(peerBean.serverPeerAddress().getPeerId().hashCode());
    }

    public FutureWrapper<FutureRouting> bootstrap(final Collection<PeerAddress> peerAddresses, final RoutingBuilder routingBuilder, final ChannelCreator cc) {
        LOG.debug("broadcast to {}", peerAddresses);
        routingBuilder.setBootstrap(true);
        FutureRouting futureRouting = this.routing(peerAddresses, routingBuilder, Message.Type.REQUEST_1, cc);
        final FutureWrapper<FutureRouting> futureWrapper = new FutureWrapper<FutureRouting>();
        futureRouting.addListener((BaseFutureListener<BaseFuture>)new BaseFutureAdapter<FutureRouting>(){

            @Override
            public void operationComplete(FutureRouting future) throws Exception {
                routingBuilder.setLocationKey(null);
                FutureRouting futureRouting = DistributedRouting.this.routing(peerAddresses, routingBuilder, Message.Type.REQUEST_1, cc);
                futureWrapper.waitFor(futureRouting);
            }
        });
        return futureWrapper;
    }

    public FutureRouting route(RoutingBuilder routingBuilder, Message.Type type, ChannelCreator cc) {
        NavigableSet<PeerAddress> startPeers = this.peerBean.peerMap().closePeers(routingBuilder.getLocationKey(), routingBuilder.getParallel() * 2);
        return this.routing(startPeers, routingBuilder, type, cc);
    }

    private FutureRouting routing(Collection<PeerAddress> peerAddresses, RoutingBuilder routingBuilder, Message.Type type, ChannelCreator cc) {
        DigestInfo digestInfo;
        if (peerAddresses == null) {
            throw new IllegalArgumentException("you need to specify some nodes");
        }
        boolean randomSearch = routingBuilder.getLocationKey() == null;
        FutureRouting futureRouting = new FutureRouting();
        Comparator<PeerAddress> comparator = randomSearch ? this.peerBean.peerMap().createComparator() : PeerMap.createComparator(routingBuilder.getLocationKey());
        TreeSet<PeerAddress> queueToAsk = new TreeSet<PeerAddress>(comparator);
        TreeSet<PeerAddress> alreadyAsked = new TreeSet<PeerAddress>(comparator);
        TreeMap<PeerAddress, DigestInfo> directHits = new TreeMap<PeerAddress, DigestInfo>(this.peerBean.peerMap().createComparator());
        TreeSet<PeerAddress> potentialHits = new TreeSet<PeerAddress>(comparator);
        queueToAsk.addAll(peerAddresses);
        alreadyAsked.add(this.peerBean.serverPeerAddress());
        potentialHits.add(this.peerBean.serverPeerAddress());
        if (type == Message.Type.REQUEST_2 && routingBuilder.getDomainKey() != null && !randomSearch) {
            Number640 to;
            Number640 from;
            if (routingBuilder.getDomainKey() == null) {
                from = new Number640(routingBuilder.getLocationKey(), Number160.ZERO, Number160.ZERO, Number160.ZERO);
                to = new Number640(routingBuilder.getLocationKey(), Number160.MAX_VALUE, Number160.MAX_VALUE, Number160.MAX_VALUE);
            } else if (routingBuilder.getContentKey() == null) {
                from = new Number640(routingBuilder.getLocationKey(), routingBuilder.getDomainKey(), Number160.ZERO, Number160.ZERO);
                to = new Number640(routingBuilder.getLocationKey(), routingBuilder.getDomainKey(), Number160.MAX_VALUE, Number160.MAX_VALUE);
            } else {
                from = new Number640(routingBuilder.getLocationKey(), routingBuilder.getDomainKey(), routingBuilder.getContentKey(), Number160.ZERO);
                to = new Number640(routingBuilder.getLocationKey(), routingBuilder.getDomainKey(), routingBuilder.getContentKey(), Number160.MAX_VALUE);
            }
            DigestInfo digestBean = this.peerBean.storage().digest(from, to, -1, true);
            if (digestBean.getSize() > 0) {
                directHits.put(this.peerBean.serverPeerAddress(), digestBean);
            }
        } else if (type == Message.Type.REQUEST_3 && !randomSearch && (digestInfo = this.peerBean.trackerStorage().digest(routingBuilder.getLocationKey(), routingBuilder.getDomainKey(), routingBuilder.getContentKey())).getSize() > 0) {
            directHits.put(this.peerBean.serverPeerAddress(), digestInfo);
        }
        if (peerAddresses.size() == 0) {
            futureRouting.setNeighbors(directHits, potentialHits, alreadyAsked, routingBuilder.isBootstrap(), false);
        } else {
            boolean isRoutingOnlyToSelf = peerAddresses.size() == 1 && peerAddresses.iterator().next().equals(this.peerBean.serverPeerAddress());
            RoutingMechanism routingMechanism = routingBuilder.createRoutingMechanism(futureRouting);
            routingMechanism.queueToAsk(queueToAsk);
            routingMechanism.potentialHits(potentialHits);
            routingMechanism.directHits(directHits);
            routingMechanism.alreadyAsked(alreadyAsked);
            routingBuilder.routingOnlyToSelf(isRoutingOnlyToSelf);
            this.routingRec(routingBuilder, routingMechanism, type, cc);
        }
        return futureRouting;
    }

    private void routingRec(final RoutingBuilder routingBuilder, final RoutingMechanism routingMechanism, final Message.Type type, final ChannelCreator channelCreator) {
        boolean randomSearch = routingBuilder.getLocationKey() == null;
        int active = 0;
        for (int i = 0; i < routingMechanism.parallel(); ++i) {
            if (routingMechanism.futureResponse(i) == null && !routingMechanism.isStopCreatingNewFutures()) {
                PeerAddress next = randomSearch ? routingMechanism.pollRandomInQueueToAsk(this.rnd) : routingMechanism.pollFirstInQueueToAsk();
                if (next == null) continue;
                routingMechanism.addToAlreadyAsked(next);
                ++active;
                Number160 locationKey2 = randomSearch ? next.getPeerId().xor(Number160.MAX_VALUE) : routingBuilder.getLocationKey();
                routingBuilder.setLocationKey(locationKey2);
                if (LOG.isWarnEnabled() && channelCreator.availableUDPPermits() == 0) {
                    LOG.warn("sanity check faild: {}, {}", (Object)i, (Object)Thread.currentThread().getName());
                }
                routingMechanism.futureResponse(i, this.neighbors.closeNeighbors(next, routingBuilder.searchValues(), type, channelCreator, routingBuilder));
                LOG.debug("get close neighbors: {} on {}", (Object)next, (Object)i);
                continue;
            }
            if (routingMechanism.futureResponse(i) == null) continue;
            LOG.debug("activity on {}", (Object)i);
            ++active;
        }
        if (active == 0) {
            LOG.debug("no activity, closing");
            routingMechanism.setNeighbors(routingBuilder);
            routingMechanism.cancel();
            return;
        }
        final boolean last = active == 1;
        FutureForkJoin<FutureResponse> fp = new FutureForkJoin<FutureResponse>(1, false, routingMechanism.futureResponses());
        fp.addListener((BaseFutureListener<BaseFuture>)new BaseFutureAdapter<FutureForkJoin<FutureResponse>>(){

            @Override
            public void operationComplete(FutureForkJoin<FutureResponse> future) throws Exception {
                boolean finished;
                if (future.isSuccess()) {
                    Message lastResponse = future.getLast().getResponse();
                    PeerAddress remotePeer = lastResponse.getSender();
                    routingMechanism.addPotentialHits(remotePeer);
                    Collection<PeerAddress> newNeighbors = lastResponse.getNeighborsSet(0).neighbors();
                    Integer resultSize = lastResponse.getInteger(0);
                    Number160 keyDigest = lastResponse.getKey(0);
                    Number160 contentDigest = lastResponse.getKey(1);
                    DigestInfo digestBean = new DigestInfo(keyDigest, contentDigest, resultSize == null ? 0 : resultSize);
                    LOG.debug("Peer ({}) {} reported {}", new Object[]{digestBean.getSize() > 0 ? "direct" : "none", remotePeer, newNeighbors});
                    finished = routingMechanism.evaluateSuccess(remotePeer, digestBean, newNeighbors, last);
                    LOG.debug("Routing finished {} / {}", (Object)finished, (Object)routingMechanism.isStopCreatingNewFutures());
                } else {
                    LOG.debug("routing error {}", (Object)future.getFailedReason());
                    finished = routingMechanism.evaluateFailed();
                    routingMechanism.stopCreatingNewFutures(finished);
                }
                if (finished) {
                    LOG.debug("finished routing, direct hits: {} potential: {}", routingMechanism.directHits(), routingMechanism.potentialHits());
                    routingMechanism.setNeighbors(routingBuilder);
                    routingMechanism.cancel();
                } else {
                    DistributedRouting.this.routingRec(routingBuilder, routingMechanism, type, channelCreator);
                }
            }
        });
    }

    public PeerMap peerMap() {
        return this.peerBean.peerMap();
    }
}

