/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.replication;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import net.tomp2p.futures.BaseFuture;
import net.tomp2p.futures.FutureDone;
import net.tomp2p.p2p.AutomaticFuture;
import net.tomp2p.p2p.Peer;
import net.tomp2p.p2p.Shutdown;
import net.tomp2p.p2p.builder.Builder;

public class DirectReplication
implements Shutdown {
    private final ScheduledExecutorService scheduledExecutorService;
    private final Peer peer;
    private final AtomicInteger runnerCounter = new AtomicInteger(0);
    private final FutureDone<Void> shutdownFuture = new FutureDone();
    private boolean shutdown = false;

    public DirectReplication(Peer peer) {
        this(peer, 1, Executors.defaultThreadFactory());
    }

    public DirectReplication(Peer peer, int corePoolSize) {
        this(peer, corePoolSize, Executors.defaultThreadFactory());
    }

    public DirectReplication(Peer peer, int corePoolSize, ThreadFactory threadFactory) {
        this.scheduledExecutorService = Executors.newScheduledThreadPool(corePoolSize, threadFactory);
        this.peer = peer;
        peer.addShutdownListener((Shutdown)this);
    }

    public Shutdown start(Builder builder, int intervalMillis, int repetitions) {
        return this.start(builder, intervalMillis, repetitions, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Shutdown start(Builder builder, int intervalMillis, int repetitions, AutomaticFuture automaticFuture) {
        DirectReplication directReplication = this;
        synchronized (directReplication) {
            if (this.shutdown) {
                return null;
            }
            CountDownLatch latch = new CountDownLatch(1);
            final DirectReplicationWorker worker = new DirectReplicationWorker(builder, automaticFuture, repetitions, latch);
            ScheduledFuture<?> future = this.scheduledExecutorService.scheduleWithFixedDelay(worker, 0L, intervalMillis, TimeUnit.MILLISECONDS);
            worker.future = future;
            latch.countDown();
            return new Shutdown(){

                public BaseFuture shutdown() {
                    worker.shutdown();
                    return new FutureDone().done();
                }
            };
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FutureDone<Void> shutdown() {
        DirectReplication directReplication = this;
        synchronized (directReplication) {
            this.shutdown = true;
        }
        for (Runnable worker : this.scheduledExecutorService.shutdownNow()) {
            worker.run();
        }
        this.peer.removeShutdownListener((Shutdown)this);
        return this.shutdownFuture;
    }

    private final class DirectReplicationWorker
    implements Runnable {
        private int counter = 0;
        private ScheduledFuture<?> future;
        final int repetitions;
        final AutomaticFuture automaticFuture;
        final Builder builder;
        final CountDownLatch latch;

        private DirectReplicationWorker(Builder builder, AutomaticFuture automaticFuture, int repetitions, CountDownLatch latch) {
            DirectReplication.this.runnerCounter.incrementAndGet();
            this.builder = builder;
            this.repetitions = repetitions;
            this.automaticFuture = automaticFuture;
            this.latch = latch;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            boolean shutdownNow = false;
            DirectReplication directReplication = DirectReplication.this;
            synchronized (directReplication) {
                shutdownNow = DirectReplication.this.shutdown;
            }
            try {
                if (shutdownNow || this.repetitions >= 0 && this.counter++ > this.repetitions) {
                    this.shutdown();
                } else {
                    BaseFuture baseFuture = this.builder.start();
                    DirectReplication.this.peer.notifyAutomaticFutures(baseFuture);
                    if (this.automaticFuture != null) {
                        this.automaticFuture.futureCreated(baseFuture);
                    }
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }

        private void shutdown() {
            try {
                this.latch.await();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.future != null) {
                this.future.cancel(false);
            }
            if (DirectReplication.this.runnerCounter.decrementAndGet() == 0) {
                DirectReplication.this.shutdownFuture.done();
            }
        }
    }
}

