/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.dht;

import net.tomp2p.connection.PeerBean;
import net.tomp2p.dht.AddBuilder;
import net.tomp2p.dht.DigestBuilder;
import net.tomp2p.dht.DistributedHashTable;
import net.tomp2p.dht.GetBuilder;
import net.tomp2p.dht.ParallelRequestBuilder;
import net.tomp2p.dht.PutBuilder;
import net.tomp2p.dht.RemoveBuilder;
import net.tomp2p.dht.SendBuilder;
import net.tomp2p.dht.StorageLayer;
import net.tomp2p.dht.StorageMemory;
import net.tomp2p.dht.StorageRPC;
import net.tomp2p.futures.BaseFuture;
import net.tomp2p.p2p.Peer;
import net.tomp2p.peers.Number160;
import net.tomp2p.peers.PeerAddress;
import net.tomp2p.storage.DigestStorage;
import net.tomp2p.storage.Storage;

public class PeerDHT {
    private final Peer peer;
    private final StorageRPC storageRPC;
    private final DistributedHashTable dht;
    private final StorageLayer storageLayer;

    public PeerDHT(Peer peer) {
        this(peer, new StorageMemory());
    }

    public PeerDHT(Peer peer, Storage backend) {
        this(peer, new StorageLayer(backend));
    }

    public PeerDHT(Peer peer, StorageLayer storageLayer) {
        this.peer = peer;
        this.storageLayer = storageLayer;
        this.storageLayer.start(peer.connectionBean().timer(), storageLayer.storageCheckIntervalMillis());
        this.storageRPC = new StorageRPC(peer.peerBean(), peer.connectionBean(), storageLayer);
        this.dht = new DistributedHashTable(peer.distributedRouting(), this.storageRPC, peer.directDataRPC());
        peer.peerBean().digestStorage((DigestStorage)storageLayer);
    }

    public Peer peer() {
        return this.peer;
    }

    public StorageRPC storeRPC() {
        return this.storageRPC;
    }

    public DistributedHashTable distributedHashTable() {
        return this.dht;
    }

    public StorageLayer storageLayer() {
        return this.storageLayer;
    }

    public AddBuilder add(Number160 locationKey) {
        return new AddBuilder(this, locationKey);
    }

    public PutBuilder put(Number160 locationKey) {
        return new PutBuilder(this, locationKey);
    }

    public GetBuilder get(Number160 locationKey) {
        return new GetBuilder(this, locationKey);
    }

    public DigestBuilder digest(Number160 locationKey) {
        return new DigestBuilder(this, locationKey);
    }

    public RemoveBuilder remove(Number160 locationKey) {
        return new RemoveBuilder(this, locationKey);
    }

    public SendBuilder send(Number160 locationKey) {
        return new SendBuilder(this, locationKey);
    }

    public ParallelRequestBuilder<?> parallelRequest(Number160 locationKey) {
        return new ParallelRequestBuilder(this, locationKey);
    }

    public BaseFuture shutdown() {
        return this.peer.shutdown();
    }

    public PeerBean peerBean() {
        return this.peer.peerBean();
    }

    public Number160 peerID() {
        return this.peer.peerID();
    }

    public PeerAddress peerAddress() {
        return this.peer.peerAddress();
    }
}

