/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.p2p.builder;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import net.tomp2p.connection.Bindings;
import net.tomp2p.connection.ConnectionConfiguration;
import net.tomp2p.connection.DefaultConnectionConfiguration;
import net.tomp2p.connection.PeerConnection;
import net.tomp2p.connection.RequestHandler;
import net.tomp2p.futures.BaseFuture;
import net.tomp2p.futures.BaseFutureAdapter;
import net.tomp2p.futures.BaseFutureImpl;
import net.tomp2p.futures.BaseFutureListener;
import net.tomp2p.futures.FutureChannelCreator;
import net.tomp2p.futures.FutureDone;
import net.tomp2p.futures.FutureLateJoin;
import net.tomp2p.futures.FutureResponse;
import net.tomp2p.p2p.Peer;
import net.tomp2p.peers.Number160;
import net.tomp2p.peers.PeerAddress;
import net.tomp2p.utils.Utils;

public class PingBuilder {
    private static final BaseFuture FUTURE_PING_SHUTDOWN = new FutureDone().failed("Peer is shutting down");
    private final Peer peer;
    private PeerAddress peerAddress;
    private InetAddress inetAddress;
    private int port = 7700;
    private boolean broadcast = false;
    private boolean tcpPing = false;
    private PeerConnection peerConnection;
    private ConnectionConfiguration connectionConfiguration;

    public PingBuilder(Peer peer) {
        this.peer = peer;
    }

    public PingBuilder notifyAutomaticFutures(BaseFuture future) {
        this.peer.notifyAutomaticFutures(future);
        return this;
    }

    public PeerAddress getPeerAddress() {
        return this.peerAddress;
    }

    public PingBuilder peerAddress(PeerAddress peerAddress) {
        this.peerAddress = peerAddress;
        return this;
    }

    public InetAddress inetAddress() {
        return this.inetAddress;
    }

    public PingBuilder inetAddress(InetAddress inetAddress) {
        this.inetAddress = inetAddress;
        return this;
    }

    public int port() {
        return this.port;
    }

    public PingBuilder port(int port) {
        this.port = port;
        return this;
    }

    public boolean isBroadcast() {
        return this.broadcast;
    }

    public PingBuilder broadcast() {
        this.broadcast = true;
        return this;
    }

    public PingBuilder broadcast(boolean broadcast) {
        this.broadcast = broadcast;
        return this;
    }

    public boolean isTcpPing() {
        return this.tcpPing;
    }

    public PingBuilder tcpPing() {
        this.tcpPing = true;
        return this;
    }

    public PingBuilder tcpPing(boolean tcpPing) {
        this.tcpPing = tcpPing;
        return this;
    }

    public PingBuilder peerConnection(PeerConnection peerConnection) {
        this.peerConnection = peerConnection;
        return this;
    }

    public PeerConnection peerConnection() {
        return this.peerConnection;
    }

    public BaseFuture start() {
        if (this.peer.isShutdown()) {
            return FUTURE_PING_SHUTDOWN;
        }
        if (this.connectionConfiguration == null) {
            this.connectionConfiguration = new DefaultConnectionConfiguration();
        }
        if (this.broadcast) {
            return this.pingBroadcast(this.port);
        }
        if (this.peerAddress != null) {
            if (this.tcpPing) {
                return this.ping(this.peerAddress, false);
            }
            return this.ping(this.peerAddress, true);
        }
        if (this.inetAddress != null) {
            if (this.tcpPing) {
                return this.ping(new InetSocketAddress(this.inetAddress, this.port), Number160.ZERO, false);
            }
            return this.ping(new InetSocketAddress(this.inetAddress, this.port), Number160.ZERO, true);
        }
        if (this.peerConnection != null) {
            return this.pingPeerConnection(this.peerConnection);
        }
        throw new IllegalArgumentException("cannot ping, need to know peer address or inet address");
    }

    FutureLateJoin<FutureResponse> pingBroadcast(final int port) {
        final Bindings bindings = this.peer.connectionBean().sender().channelClientConfiguration().externalBindings();
        final int size = bindings.broadcastAddresses().size();
        final FutureLateJoin<FutureResponse> futureLateJoin = new FutureLateJoin<FutureResponse>(size, 1);
        if (size > 0) {
            FutureChannelCreator fcc = this.peer.connectionBean().reservation().create(size, 0);
            fcc.addListener((BaseFutureListener<BaseFuture>)new BaseFutureAdapter<FutureChannelCreator>(){

                @Override
                public void operationComplete(FutureChannelCreator future) throws Exception {
                    if (future.isSuccess()) {
                        Utils.addReleaseListener(future.channelCreator(), futureLateJoin);
                        for (int i = 0; i < size; ++i) {
                            InetAddress broadcastAddress = bindings.broadcastAddresses().get(i);
                            PeerAddress peerAddress = new PeerAddress(Number160.ZERO, broadcastAddress, port, port);
                            FutureResponse validBroadcast = PingBuilder.this.peer.pingRPC().pingBroadcastUDP(peerAddress, future.channelCreator(), PingBuilder.this.connectionConfiguration);
                            if (futureLateJoin.add(validBroadcast)) {
                                continue;
                            }
                            break;
                        }
                    } else {
                        futureLateJoin.failed(future);
                    }
                }
            });
        } else {
            futureLateJoin.failed("No broadcast address found. Cannot ping nothing");
        }
        return futureLateJoin;
    }

    public FutureResponse ping(InetSocketAddress address) {
        return this.ping(address, Number160.ZERO, true);
    }

    public FutureResponse ping(InetSocketAddress address, Number160 peerId, boolean isUDP) {
        return this.ping(new PeerAddress(peerId, address), isUDP);
    }

    public FutureResponse ping(PeerAddress peerAddress, boolean isUDP) {
        final RequestHandler<FutureResponse> request = this.peer.pingRPC().ping(peerAddress, this.connectionConfiguration);
        if (isUDP) {
            FutureChannelCreator fcc = this.peer.connectionBean().reservation().create(1, 0);
            fcc.addListener((BaseFutureListener<BaseFuture>)new BaseFutureAdapter<FutureChannelCreator>(){

                @Override
                public void operationComplete(FutureChannelCreator future) throws Exception {
                    if (future.isSuccess()) {
                        Object futureResponse = request.sendUDP(future.channelCreator());
                        Utils.addReleaseListener(future.channelCreator(), new BaseFuture[]{futureResponse});
                    } else {
                        ((BaseFutureImpl)request.futureResponse()).failed(future);
                    }
                }
            });
        } else {
            FutureChannelCreator fcc = this.peer.connectionBean().reservation().create(0, 1);
            fcc.addListener((BaseFutureListener<BaseFuture>)new BaseFutureAdapter<FutureChannelCreator>(){

                @Override
                public void operationComplete(FutureChannelCreator future) throws Exception {
                    if (future.isSuccess()) {
                        Object futureResponse = request.sendTCP(future.channelCreator());
                        Utils.addReleaseListener(future.channelCreator(), new BaseFuture[]{futureResponse});
                    } else {
                        ((BaseFutureImpl)request.futureResponse()).failed(future);
                    }
                }
            });
        }
        return request.futureResponse();
    }

    public FutureResponse pingPeerConnection(final PeerConnection peerConnection) {
        final RequestHandler<FutureResponse> request = this.peer.pingRPC().ping(peerConnection.remotePeer(), this.connectionConfiguration);
        FutureChannelCreator futureChannelCreator = peerConnection.acquire(request.futureResponse());
        futureChannelCreator.addListener((BaseFutureListener<BaseFuture>)new BaseFutureAdapter<FutureChannelCreator>(){

            @Override
            public void operationComplete(FutureChannelCreator future) throws Exception {
                if (future.isSuccess()) {
                    ((FutureResponse)request.futureResponse()).request().keepAlive(true);
                    request.sendTCP(peerConnection);
                } else {
                    ((BaseFutureImpl)request.futureResponse()).failed(future);
                }
            }
        });
        return request.futureResponse();
    }
}

