/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.message;

import java.util.Iterator;
import java.util.Map;
import net.tomp2p.peers.Number160;
import net.tomp2p.peers.PeerStatatistic;
import net.tomp2p.storage.Data;

public class TrackerData {
    public static final Data EMTPY_DATA = new Data(0, 0);
    private final Map<PeerStatatistic, Data> peerAddresses;
    private final boolean couldProvideMoreData;

    public TrackerData(Map<PeerStatatistic, Data> peerAddresses) {
        this(peerAddresses, false);
    }

    public TrackerData(Map<PeerStatatistic, Data> peerAddresses, boolean couldProvideMoreData) {
        this.peerAddresses = peerAddresses;
        this.couldProvideMoreData = couldProvideMoreData;
    }

    public Map<PeerStatatistic, Data> peerAddresses() {
        return this.peerAddresses;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("p:").append(this.peerAddresses).append(",l:");
        return sb.toString();
    }

    public boolean couldProvideMoreData() {
        return this.couldProvideMoreData;
    }

    public int size() {
        return this.peerAddresses.size();
    }

    public void put(PeerStatatistic remotePeer, Data attachement) {
        this.peerAddresses.put(remotePeer, attachement == null ? EMTPY_DATA : attachement);
    }

    public Map.Entry<PeerStatatistic, Data> remove(Number160 remotePeerId) {
        Iterator<Map.Entry<PeerStatatistic, Data>> iterator = this.peerAddresses.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<PeerStatatistic, Data> entry = iterator.next();
            if (!entry.getKey().peerAddress().peerId().equals(remotePeerId)) continue;
            iterator.remove();
            return entry;
        }
        return null;
    }

    public boolean containsKey(Number160 tmpKey) {
        for (Map.Entry<PeerStatatistic, Data> entry : this.peerAddresses.entrySet()) {
            if (!entry.getKey().peerAddress().peerId().equals(tmpKey)) continue;
            return true;
        }
        return false;
    }
}

