/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.connection;

import io.netty.bootstrap.Bootstrap;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelException;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.FixedRecvByteBufAllocator;
import io.netty.channel.socket.nio.NioDatagramChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.util.concurrent.EventExecutorGroup;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import net.tomp2p.connection.Bindings;
import net.tomp2p.connection.ChannelServerConficuration;
import net.tomp2p.connection.DiscoverNetworks;
import net.tomp2p.connection.Dispatcher;
import net.tomp2p.connection.DropConnectionInboundHandler;
import net.tomp2p.connection.Ports;
import net.tomp2p.connection.TimeoutFactory;
import net.tomp2p.futures.FutureDone;
import net.tomp2p.message.TomP2PCumulationTCP;
import net.tomp2p.message.TomP2POutbound;
import net.tomp2p.message.TomP2PSinglePacketUDP;
import net.tomp2p.peers.PeerStatusListener;
import net.tomp2p.utils.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ChannelServer {
    private static final Logger LOG = LoggerFactory.getLogger(ChannelServer.class);
    private final EventLoopGroup bossGroup;
    private final EventLoopGroup workerGroup;
    private Channel channelUDP;
    private Channel channelTCP;
    private final FutureDone<Void> futureServerDone = new FutureDone();
    private final Bindings interfaceBindings;
    private final Ports ports;
    private final ChannelServerConficuration channelServerConfiguration;
    private final Dispatcher dispatcher;
    private final List<PeerStatusListener> peerStatusListeners;
    private final DropConnectionInboundHandler tcpDropConnectionInboundHandler;
    private final DropConnectionInboundHandler udpDropConnectionInboundHandler;
    private final ChannelHandler udpDecoderHandler;

    public ChannelServer(EventLoopGroup bossGroup, EventLoopGroup workerGroup, ChannelServerConficuration channelServerConfiguration, Dispatcher dispatcher, List<PeerStatusListener> peerStatusListeners) throws IOException {
        this.bossGroup = bossGroup;
        this.workerGroup = workerGroup;
        this.interfaceBindings = channelServerConfiguration.interfaceBindings();
        this.ports = channelServerConfiguration.ports();
        this.channelServerConfiguration = channelServerConfiguration;
        this.dispatcher = dispatcher;
        this.peerStatusListeners = peerStatusListeners;
        String status = DiscoverNetworks.discoverInterfaces(this.interfaceBindings);
        if (LOG.isInfoEnabled()) {
            LOG.info("Status of interface search: " + status);
        }
        this.tcpDropConnectionInboundHandler = new DropConnectionInboundHandler(channelServerConfiguration.maxTCPIncomingConnections());
        this.udpDropConnectionInboundHandler = new DropConnectionInboundHandler(channelServerConfiguration.maxUDPIncomingConnections());
        this.udpDecoderHandler = new TomP2PSinglePacketUDP(channelServerConfiguration.signatureFactory());
    }

    public Ports ports() {
        return this.ports;
    }

    public ChannelServerConficuration channelServerConfiguration() {
        return this.channelServerConfiguration;
    }

    public boolean startup() throws IOException {
        if (!this.channelServerConfiguration.isDisableBind()) {
            boolean listenAll = this.interfaceBindings.isListenAll();
            if (listenAll) {
                if (LOG.isInfoEnabled()) {
                    LOG.info("Listening for broadcasts on port udp: " + this.ports.externalUDPPort() + " and tcp:" + this.ports.externalTCPPort());
                }
                if (!this.startupTCP(new InetSocketAddress(this.ports.externalTCPPort()), this.channelServerConfiguration) || !this.startupUDP(new InetSocketAddress(this.ports.externalUDPPort()), this.channelServerConfiguration)) {
                    LOG.warn("cannot bind TCP or UDP");
                    return false;
                }
            } else {
                for (InetAddress addr : this.interfaceBindings.foundAddresses()) {
                    if (LOG.isInfoEnabled()) {
                        LOG.info("Listening on address: " + addr + " on port udp: " + this.ports.externalUDPPort() + " and tcp:" + this.ports.externalTCPPort());
                    }
                    if (this.startupTCP(new InetSocketAddress(addr, this.ports.externalTCPPort()), this.channelServerConfiguration) && this.startupUDP(new InetSocketAddress(addr, this.ports.externalUDPPort()), this.channelServerConfiguration)) continue;
                    LOG.warn("cannot bind TCP or UDP");
                    return false;
                }
            }
        }
        return true;
    }

    boolean startupUDP(InetSocketAddress listenAddresses, ChannelServerConficuration config) {
        Bootstrap b = new Bootstrap();
        b.group(this.workerGroup);
        b.channel(NioDatagramChannel.class);
        b.option(ChannelOption.SO_BROADCAST, (Object)true);
        b.option(ChannelOption.RCVBUF_ALLOCATOR, (Object)new FixedRecvByteBufAllocator(1400));
        b.handler((ChannelHandler)new ChannelInitializer<Channel>(){

            protected void initChannel(Channel ch) throws Exception {
                for (Map.Entry entry : ChannelServer.this.handlers(false).entrySet()) {
                    if (!((Pair)entry.getValue()).isEmpty()) {
                        ch.pipeline().addLast((EventExecutorGroup)((Pair)entry.getValue()).element0(), (String)entry.getKey(), (ChannelHandler)((Pair)entry.getValue()).element1());
                        continue;
                    }
                    if (((Pair)entry.getValue()).element1() == null) continue;
                    ch.pipeline().addLast((String)entry.getKey(), (ChannelHandler)((Pair)entry.getValue()).element1());
                }
            }
        });
        ChannelFuture future = b.bind((SocketAddress)listenAddresses);
        this.channelUDP = future.channel();
        return this.handleFuture(future);
    }

    boolean startupTCP(InetSocketAddress listenAddresses, ChannelServerConficuration config) {
        ServerBootstrap b = new ServerBootstrap();
        b.group(this.bossGroup, this.workerGroup);
        b.channel(NioServerSocketChannel.class);
        b.childHandler((ChannelHandler)new ChannelInitializer<Channel>(){

            protected void initChannel(Channel ch) throws Exception {
                ChannelServer.bestEffortOptions(ch, ChannelOption.SO_LINGER, 0);
                ChannelServer.bestEffortOptions(ch, ChannelOption.TCP_NODELAY, true);
                for (Map.Entry entry : ChannelServer.this.handlers(true).entrySet()) {
                    if (!((Pair)entry.getValue()).isEmpty()) {
                        ch.pipeline().addLast((EventExecutorGroup)((Pair)entry.getValue()).element0(), (String)entry.getKey(), (ChannelHandler)((Pair)entry.getValue()).element1());
                        continue;
                    }
                    if (((Pair)entry.getValue()).element1() == null) continue;
                    ch.pipeline().addLast((String)entry.getKey(), (ChannelHandler)((Pair)entry.getValue()).element1());
                }
            }
        });
        ChannelFuture future = b.bind((SocketAddress)listenAddresses);
        this.channelTCP = future.channel();
        return this.handleFuture(future);
    }

    private static <T> void bestEffortOptions(Channel ch, ChannelOption<T> option, T value) {
        try {
            ch.config().setOption(option, value);
        }
        catch (ChannelException channelException) {
            // empty catch block
        }
    }

    private Map<String, Pair<EventExecutorGroup, ChannelHandler>> handlers(boolean tcp) {
        LinkedHashMap<String, Pair<EventExecutorGroup, ChannelHandler>> handlers;
        TimeoutFactory timeoutFactory = new TimeoutFactory(null, this.channelServerConfiguration.idleTCPSeconds(), this.peerStatusListeners, "Server");
        if (tcp) {
            int nrTCPHandlers = 8;
            handlers = new LinkedHashMap<String, Pair<EventExecutorGroup, ChannelHandler>>(8);
            handlers.put("dropconnection", new Pair<Object, DropConnectionInboundHandler>(null, this.tcpDropConnectionInboundHandler));
            handlers.put("timeout0", new Pair<Object, ChannelHandler>(null, timeoutFactory.idleStateHandlerTomP2P()));
            handlers.put("timeout1", new Pair<Object, ChannelHandler>(null, timeoutFactory.timeHandler()));
            handlers.put("decoder", new Pair<Object, TomP2PCumulationTCP>(null, new TomP2PCumulationTCP(this.channelServerConfiguration.signatureFactory())));
        } else {
            int nrUDPHandlers = 6;
            handlers = new LinkedHashMap(6);
            handlers.put("dropconnection", new Pair<Object, DropConnectionInboundHandler>(null, this.udpDropConnectionInboundHandler));
            handlers.put("decoder", new Pair<Object, ChannelHandler>(null, this.udpDecoderHandler));
        }
        handlers.put("encoder", new Pair<Object, TomP2POutbound>(null, new TomP2POutbound(false, this.channelServerConfiguration.signatureFactory())));
        handlers.put("dispatcher", new Pair<Object, Dispatcher>(null, this.dispatcher));
        return this.channelServerConfiguration.pipelineFilter().filter(handlers, tcp, false);
    }

    private boolean handleFuture(ChannelFuture future) {
        try {
            future.await();
        }
        catch (InterruptedException e) {
            if (LOG.isWarnEnabled()) {
                LOG.warn("could not start UPD server", (Throwable)e);
            }
            return false;
        }
        boolean success = future.isSuccess();
        if (success) {
            return true;
        }
        future.cause().printStackTrace();
        return false;
    }

    public FutureDone<Void> shutdown() {
        final int maxListeners = this.channelUDP != null && this.channelTCP != null ? 2 : 1;
        final AtomicInteger listenerCounter = new AtomicInteger(0);
        LOG.debug("shutdown servers");
        if (this.channelUDP != null) {
            this.channelUDP.close().addListener((GenericFutureListener)new GenericFutureListener<ChannelFuture>(){

                public void operationComplete(ChannelFuture future) throws Exception {
                    LOG.debug("shutdown TCP server");
                    if (listenerCounter.incrementAndGet() == maxListeners) {
                        ChannelServer.this.futureServerDone.done();
                    }
                }
            });
        }
        if (this.channelTCP != null) {
            this.channelTCP.close().addListener((GenericFutureListener)new GenericFutureListener<ChannelFuture>(){

                public void operationComplete(ChannelFuture future) throws Exception {
                    LOG.debug("shutdown TCP channels");
                    if (listenerCounter.incrementAndGet() == maxListeners) {
                        ChannelServer.this.futureServerDone.done();
                    }
                }
            });
        }
        return this.shutdownFuture();
    }

    public FutureDone<Void> shutdownFuture() {
        return this.futureServerDone;
    }
}

