/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.replication;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.NavigableSet;
import net.tomp2p.dht.ReplicationListener;
import net.tomp2p.dht.StorageLayer;
import net.tomp2p.p2p.ResponsibilityListener;
import net.tomp2p.peers.Number160;
import net.tomp2p.peers.PeerAddress;
import net.tomp2p.peers.PeerMap;
import net.tomp2p.peers.PeerMapChangeListener;
import net.tomp2p.peers.PeerStatatistic;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Replication
implements PeerMapChangeListener,
ReplicationListener {
    private static final Logger LOG = LoggerFactory.getLogger(Replication.class);
    private final List<ResponsibilityListener> listeners = new ArrayList<ResponsibilityListener>();
    private final PeerMap peerMap;
    private final PeerAddress selfAddress;
    private final StorageLayer backend;
    private int replicationFactor;
    private boolean nRootReplication;

    public Replication(StorageLayer backend, PeerAddress selfAddress, PeerMap peerMap, int replicationFactor, boolean nRoot) {
        this.backend = backend;
        this.selfAddress = selfAddress;
        this.peerMap = peerMap;
        this.replicationFactor = replicationFactor;
        this.nRootReplication = nRoot;
        peerMap.addPeerMapChangeListener((PeerMapChangeListener)this);
    }

    public Replication replicationFactor(int replicationFactor) {
        this.replicationFactor = replicationFactor;
        return this;
    }

    public int replicationFactor() {
        return this.replicationFactor;
    }

    public void nRootReplication(boolean nRootReplication) {
        this.nRootReplication = nRootReplication;
    }

    public boolean isNRootReplication() {
        return this.nRootReplication;
    }

    public boolean is0RootReplication() {
        return !this.nRootReplication;
    }

    public boolean isReplication() {
        return this.listeners.size() > 0;
    }

    public void addResponsibilityListener(ResponsibilityListener responsibilityListener) {
        this.listeners.add(responsibilityListener);
    }

    public void removeResponsibilityListener(ResponsibilityListener responsibilityListener) {
        this.listeners.remove(responsibilityListener);
    }

    private void notifyMeResponsible(Number160 locationKey) {
        for (ResponsibilityListener responsibilityListener : this.listeners) {
            responsibilityListener.meResponsible(locationKey);
        }
    }

    private void notifyMeResponsible(Number160 locationKey, PeerAddress newPeer) {
        for (ResponsibilityListener responsibilityListener : this.listeners) {
            responsibilityListener.meResponsible(locationKey, newPeer);
        }
    }

    private void notifyOtherResponsible(Number160 locationKey, PeerAddress other) {
        for (ResponsibilityListener responsibilityListener : this.listeners) {
            responsibilityListener.otherResponsible(locationKey, other);
        }
    }

    public void dataRemoved(Number160 locationKey) {
        if (!this.isReplication()) {
            return;
        }
    }

    public void dataInserted(Number160 locationKey) {
        if (!this.isReplication()) {
            return;
        }
        if (!this.nRootReplication) {
            PeerAddress closest = this.closest(locationKey);
            if (closest.peerId().equals((Object)this.selfAddress.peerId())) {
                if (this.backend.updateResponsibilities(locationKey, closest.peerId())) {
                    this.notifyMeResponsible(locationKey);
                }
            } else if (this.backend.updateResponsibilities(locationKey, closest.peerId())) {
                this.notifyOtherResponsible(locationKey, closest);
            }
        } else if (this.isInReplicationRange(locationKey, this.selfAddress, this.replicationFactor)) {
            if (this.backend.updateResponsibilities(locationKey, this.selfAddress.peerId())) {
                LOG.debug("I {} am now responsible for key {}.", (Object)this.selfAddress, (Object)locationKey);
                this.notifyMeResponsible(locationKey);
            } else {
                LOG.debug("I {} already know that I'm responsible for key {}.", (Object)this.selfAddress, (Object)locationKey);
                Collection peerIds = this.backend.findPeerIDsForResponsibleContent(locationKey);
                peerIds.remove(this.selfAddress.peerId());
                boolean hasToNotifyReplicaSet = false;
                for (Number160 otherReplica : peerIds) {
                    PeerAddress peerAddress = new PeerAddress(otherReplica);
                    if (!this.isInReplicationRange(locationKey, peerAddress, this.replicationFactor)) {
                        LOG.debug("I {} detected that {} is not responsible anymore for key {}.", new Object[]{this.selfAddress, peerAddress, locationKey});
                        this.backend.removeResponsibility(locationKey, otherReplica);
                        hasToNotifyReplicaSet = true;
                        continue;
                    }
                    LOG.debug("I {} checked that {} is still responsible for key {}.", new Object[]{this.selfAddress, peerAddress, locationKey});
                }
                if (hasToNotifyReplicaSet) {
                    this.notifyMeResponsible(locationKey);
                }
            }
        } else {
            LOG.debug("I {} am not responsible for key {}.", (Object)this.selfAddress, (Object)locationKey);
            this.backend.removeResponsibility(locationKey);
        }
    }

    public void peerInserted(PeerAddress peerAddress, boolean verified) {
        if (!this.isReplication() || !verified) {
            return;
        }
        LOG.debug("The peer {} was inserted in my map. I'm {}", (Object)peerAddress, (Object)this.selfAddress);
        Collection myResponsibleLocations = this.backend.findContentForResponsiblePeerID(this.selfAddress.peerId());
        LOG.debug("I {} have to check replication responsibilities for {}.", (Object)this.selfAddress, (Object)myResponsibleLocations);
        for (Number160 myResponsibleLocation : myResponsibleLocations) {
            if (!this.nRootReplication) {
                PeerAddress closest = this.closest(myResponsibleLocation);
                if (!closest.peerId().equals((Object)this.selfAddress.peerId())) {
                    if (this.isInReplicationRange(myResponsibleLocation, this.selfAddress, this.replicationFactor)) {
                        if (this.backend.updateResponsibilities(myResponsibleLocation, closest.peerId())) {
                            LOG.debug("I {} didn't know that {} is responsible for {}.", new Object[]{this.selfAddress, closest, myResponsibleLocation});
                            this.notifyOtherResponsible(myResponsibleLocation, closest);
                            continue;
                        }
                        LOG.debug("I {} know already that {} is responsible for {}.", new Object[]{this.selfAddress, closest, myResponsibleLocation});
                        continue;
                    }
                    this.notifyOtherResponsible(myResponsibleLocation, closest);
                    LOG.debug("I {} am no more in the replica set of {}.", (Object)this.selfAddress, (Object)myResponsibleLocation);
                    this.backend.removeResponsibility(myResponsibleLocation);
                    continue;
                }
                if (!this.isInReplicationRange(myResponsibleLocation, peerAddress, this.replicationFactor)) continue;
                LOG.debug("{} is in the replica set for {}.", (Object)peerAddress, (Object)myResponsibleLocation);
                if (this.backend.updateResponsibilities(myResponsibleLocation, this.selfAddress.peerId())) {
                    LOG.debug("I {} didn't know that I'm responsible for {}.", (Object)this.selfAddress, (Object)myResponsibleLocation);
                    this.notifyMeResponsible(myResponsibleLocation);
                    continue;
                }
                LOG.debug("I {} already know that I'm responsible for {}.", (Object)this.selfAddress, (Object)myResponsibleLocation);
                this.notifyMeResponsible(myResponsibleLocation, peerAddress);
                continue;
            }
            if (this.isInReplicationRange(myResponsibleLocation, peerAddress, this.replicationFactor)) {
                if (this.isInReplicationRange(myResponsibleLocation, this.selfAddress, this.replicationFactor)) {
                    if (this.backend.updateResponsibilities(myResponsibleLocation, this.selfAddress.peerId())) {
                        LOG.debug("I {} didn't know my replication responsibility for {}.", (Object)this.selfAddress, (Object)myResponsibleLocation);
                        this.notifyMeResponsible(myResponsibleLocation);
                    } else {
                        LOG.debug("I {} already know my replication responsibility for {}.", (Object)this.selfAddress, (Object)myResponsibleLocation);
                    }
                    if (this.backend.updateResponsibilities(myResponsibleLocation, peerAddress.peerId())) {
                        LOG.debug("I {} didn't know common replication responsibility with newly joined peer {} for {}.", new Object[]{this.selfAddress, peerAddress, myResponsibleLocation});
                        this.notifyMeResponsible(myResponsibleLocation, peerAddress);
                        continue;
                    }
                    LOG.debug("I {} already know common replication responsibility with newly joined peer {} for {}.", new Object[]{this.selfAddress, peerAddress, myResponsibleLocation});
                    continue;
                }
                LOG.debug("I {} figured out replication responsibility of newly joined peer {} for {}.", new Object[]{this.selfAddress, peerAddress, myResponsibleLocation});
                this.notifyOtherResponsible(myResponsibleLocation, peerAddress);
                LOG.debug("I {} am not responsible anymore for {}.", (Object)this.selfAddress, (Object)myResponsibleLocation);
                this.backend.removeResponsibility(myResponsibleLocation);
                continue;
            }
            if (this.isInReplicationRange(myResponsibleLocation, this.selfAddress, this.replicationFactor)) {
                if (this.backend.updateResponsibilities(myResponsibleLocation, this.selfAddress.peerId())) {
                    LOG.debug("I {} didn't know my replication responsibility. Newly joined peer {} doesn't has to replicate {}.", new Object[]{this.selfAddress, peerAddress, myResponsibleLocation});
                    this.notifyMeResponsible(myResponsibleLocation);
                    continue;
                }
                LOG.debug("I {} already know my replication responsibility. Newly joined peer {} doesn't has to replicate {}.", new Object[]{this.selfAddress, peerAddress, myResponsibleLocation});
                continue;
            }
            LOG.debug("I {} and newly joined peer {} don't have to replicate {}.", new Object[]{this.selfAddress, peerAddress, myResponsibleLocation});
            this.backend.removeResponsibility(myResponsibleLocation);
        }
    }

    public void peerRemoved(PeerAddress peerAddress, PeerStatatistic peerStatatistic) {
        if (!this.isReplication()) {
            return;
        }
        LOG.debug("The peer {} was removed from my map. I'm {}", (Object)peerAddress, (Object)this.selfAddress);
        Collection otherResponsibleLocations = this.backend.findContentForResponsiblePeerID(peerAddress.peerId());
        LOG.debug("I {} know that {} has to replicate {}.", new Object[]{this.selfAddress, peerAddress, otherResponsibleLocations});
        Collection myResponsibleLocations = this.backend.findContentForResponsiblePeerID(this.selfAddress.peerId());
        LOG.debug("I {} have to replicate {}.", (Object)this.selfAddress, (Object)myResponsibleLocations);
        if (!this.nRootReplication) {
            for (Number160 otherResponsibleLocation : otherResponsibleLocations) {
                PeerAddress closest = this.closest(otherResponsibleLocation);
                if (closest.peerId().equals((Object)this.selfAddress.peerId())) {
                    if (this.backend.updateResponsibilities(otherResponsibleLocation, closest.peerId())) {
                        LOG.debug("I {} am responsible for {} after leaving of {}.", new Object[]{this.selfAddress, otherResponsibleLocations, peerAddress});
                        this.notifyMeResponsible(otherResponsibleLocation);
                        myResponsibleLocations.remove(otherResponsibleLocation);
                        continue;
                    }
                    LOG.debug("I {} already know that I'm responsible for {} after leaving of {}.", new Object[]{this.selfAddress, otherResponsibleLocations, peerAddress});
                    continue;
                }
                if (!this.backend.updateResponsibilities(otherResponsibleLocation, closest.peerId())) continue;
                LOG.debug("We should check if the closer peer has the content");
                this.notifyOtherResponsible(otherResponsibleLocation, closest);
                myResponsibleLocations.remove(otherResponsibleLocation);
            }
            for (Number160 myResponsibleLocation : myResponsibleLocations) {
                if (this.isInReplicationRange(myResponsibleLocation, peerAddress, this.replicationFactor)) {
                    LOG.debug("Leaving {} affects my {} replication responsiblity for {}.", new Object[]{this.selfAddress, peerAddress, myResponsibleLocation});
                    this.notifyMeResponsible(myResponsibleLocation);
                    continue;
                }
                LOG.debug("Leaving {} doesn't affect my {} replication responsibility for {}.", new Object[]{peerAddress, this.selfAddress, myResponsibleLocation});
            }
        } else {
            for (Number160 otherResponsibleLocation : otherResponsibleLocations) {
                if (this.isInReplicationRange(otherResponsibleLocation, this.selfAddress, this.replicationFactor)) {
                    if (this.backend.updateResponsibilities(otherResponsibleLocation, this.selfAddress.peerId())) {
                        LOG.debug("I {} didn't know my replication responsiblity for {}, which gets discharged by leaving {}.", new Object[]{this.selfAddress, otherResponsibleLocation, peerAddress});
                        this.notifyMeResponsible(otherResponsibleLocation);
                        myResponsibleLocations.remove(otherResponsibleLocation);
                    } else {
                        LOG.debug("I {} already know my replication responsiblity for {}, which gets discharged by leaving {}.", new Object[]{this.selfAddress, otherResponsibleLocation, peerAddress});
                    }
                } else {
                    LOG.debug("I {} don't have {}'s replication responsiblity for {}.", new Object[]{this.selfAddress, peerAddress, otherResponsibleLocation});
                }
                this.backend.removeResponsibility(otherResponsibleLocation, peerAddress.peerId());
            }
            for (Number160 myResponsibleLocation : myResponsibleLocations) {
                if (this.isInReplicationRange(myResponsibleLocation, peerAddress, this.replicationFactor)) {
                    LOG.debug("I {} realized that leaving {} had also replication responsibility for {}. The replica set has to get notified about the leaving replica node.", new Object[]{this.selfAddress, peerAddress, myResponsibleLocation});
                    this.notifyMeResponsible(myResponsibleLocation);
                    continue;
                }
                LOG.debug("Leaving {} doesn't affect my {} replication responsibility for {}.", new Object[]{peerAddress, this.selfAddress, myResponsibleLocation});
            }
        }
    }

    public void peerUpdated(PeerAddress peerAddress, PeerStatatistic peerStatatistic) {
    }

    private PeerAddress closest(Number160 locationKey) {
        NavigableSet tmp = this.peerMap.closePeers(locationKey, 1);
        tmp.add(this.selfAddress);
        return (PeerAddress)tmp.iterator().next();
    }

    private boolean isInReplicationRange(Number160 locationKey, PeerAddress peerAddress, int replicationFactor) {
        NavigableSet tmp = this.peerMap.closePeers(locationKey, replicationFactor);
        tmp.add(this.selfAddress);
        return tmp.headSet(peerAddress).size() < replicationFactor;
    }
}

