/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.examples;

import io.netty.channel.ChannelHandler;
import io.netty.util.concurrent.EventExecutorGroup;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Random;
import net.tomp2p.connection.ChannelClientConfiguration;
import net.tomp2p.connection.ChannelServerConficuration;
import net.tomp2p.connection.PipelineFilter;
import net.tomp2p.futures.FutureDirect;
import net.tomp2p.futures.FuturePeerConnection;
import net.tomp2p.message.CountConnectionOutboundHandler;
import net.tomp2p.p2p.Peer;
import net.tomp2p.p2p.PeerMaker;
import net.tomp2p.peers.Number160;
import net.tomp2p.peers.PeerAddress;
import net.tomp2p.rpc.ObjectDataReply;
import net.tomp2p.utils.Pair;

public final class ExamplePersistentConnection {
    private static final Random RND = new Random(42L);
    private static final CountConnectionOutboundHandler ccohTCP = new CountConnectionOutboundHandler();
    private static final CountConnectionOutboundHandler ccohUDP = new CountConnectionOutboundHandler();

    private ExamplePersistentConnection() {
    }

    public static void main(String[] args) throws Exception {
        ExamplePersistentConnection.examplePersistentConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void examplePersistentConnection() throws Exception {
        Peer peer1 = null;
        Peer peer2 = null;
        try {
            int port1 = 4001;
            int port2 = 4002;
            int timeout = 20;
            ChannelServerConficuration csc = PeerMaker.createDefaultChannelServerConfiguration();
            ChannelClientConfiguration ccc = PeerMaker.createDefaultChannelClientConfiguration();
            csc.pipelineFilter(ExamplePersistentConnection.createFilter());
            ccc.pipelineFilter(ExamplePersistentConnection.createFilter());
            peer1 = new PeerMaker(new Number160(RND)).ports(4001).channelClientConfiguration(ccc).channelServerConfiguration(csc).makeAndListen();
            peer2 = new PeerMaker(new Number160(RND)).ports(4002).makeAndListen();
            peer2.setObjectDataReply(new ObjectDataReply(){

                public Object reply(PeerAddress sender, Object request) throws Exception {
                    return "world!";
                }
            });
            String sentObject = "Hello";
            FutureDirect fd = peer1.sendDirect(peer2.getPeerAddress()).setObject((Object)sentObject).start();
            System.out.println("send " + sentObject);
            fd.awaitUninterruptibly();
            System.out.println("received " + fd.object() + " connections: " + ccohTCP.total() + "/" + ccohUDP.total());
            FuturePeerConnection futurePeerConnection = peer1.createPeerConnection(peer2.getPeerAddress(), 20);
            fd = peer1.sendDirect(futurePeerConnection).setObject((Object)sentObject).start();
            System.out.println("send " + sentObject);
            fd.awaitUninterruptibly();
            System.out.println("received " + fd.object() + " connections: " + ccohTCP.total() + "/" + ccohUDP.total());
            fd = peer1.sendDirect(futurePeerConnection).setObject((Object)sentObject).start();
            System.out.println("send " + sentObject);
            fd.awaitUninterruptibly();
            System.out.println("received " + fd.object() + " connections: " + ccohTCP.total() + "/" + ccohUDP.total());
            futurePeerConnection.close();
        }
        finally {
            if (peer1 != null) {
                peer1.shutdown();
            }
            if (peer2 != null) {
                peer2.shutdown();
            }
        }
    }

    private static PipelineFilter createFilter() {
        PipelineFilter pf = new PipelineFilter(){

            public Map<String, Pair<EventExecutorGroup, ChannelHandler>> filter(Map<String, Pair<EventExecutorGroup, ChannelHandler>> channelHandlers, boolean tcp, boolean client) {
                LinkedHashMap<String, Pair<EventExecutorGroup, ChannelHandler>> retVal = new LinkedHashMap<String, Pair<EventExecutorGroup, ChannelHandler>>();
                retVal.put("counter", new Pair(null, (Object)(tcp ? ccohTCP : ccohUDP)));
                retVal.putAll(channelHandlers);
                return retVal;
            }
        };
        return pf;
    }
}

