/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.examples;

import java.io.IOException;
import java.util.HashMap;
import java.util.Random;
import net.tomp2p.examples.ExampleUtils;
import net.tomp2p.futures.FutureDigest;
import net.tomp2p.futures.FutureGet;
import net.tomp2p.futures.FuturePut;
import net.tomp2p.p2p.Peer;
import net.tomp2p.p2p.builder.DigestBuilder;
import net.tomp2p.p2p.builder.GetBuilder;
import net.tomp2p.peers.Number160;
import net.tomp2p.rpc.SimpleBloomFilter;
import net.tomp2p.storage.Data;

public final class ExampleBloomFilter {
    private static final Random RND = new Random(42L);

    private ExampleBloomFilter() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        int peerNr = 100;
        int port = 4001;
        ExampleBloomFilter.bloomFilterBasics();
        Peer[] peers = null;
        try {
            peers = ExampleUtils.createAndAttachNodes(100, 4001);
            ExampleUtils.bootstrap(peers);
            ExampleBloomFilter.exampleBloomFilter(peers);
        }
        finally {
            if (peers != null && peers[0] != null) {
                peers[0].shutdown();
            }
        }
    }

    private static void bloomFilterBasics() {
        int nrElements = 20;
        System.out.println("bloomfilter basics:");
        SimpleBloomFilter sbf = new SimpleBloomFilter(0.05, 20);
        System.out.println("false-prob. rate: " + sbf.expectedFalsePositiveProbability());
        System.out.println("init: " + sbf.getBitSet().size());
        for (int i = 0; i < 20; ++i) {
            sbf.add((Object)new Number160(i));
            System.out.printf("after %2d insert %s\n", i + 1, sbf);
        }
    }

    private static void exampleBloomFilter(Peer[] peers) throws IOException {
        int nrPeers = 1000;
        int range1 = 800;
        int range2 = 1800;
        int peer10 = 10;
        int peer20 = 20;
        int peer30 = 30;
        int peer60 = 60;
        Number160 nr1 = new Number160(RND);
        HashMap<Number160, Data> contentMap = new HashMap<Number160, Data>();
        System.out.println("first we store 1000 items from 0-999 under key " + nr1);
        for (int i = 0; i < 1000; ++i) {
            contentMap.put(new Number160(i), new Data((Object)("data " + i)));
        }
        FuturePut futurePut = peers[30].put(nr1).setDataMapContent(contentMap).setDomainKey(Number160.createHash((String)"my_domain")).start();
        futurePut.awaitUninterruptibly();
        Number160 nr2 = new Number160(RND);
        contentMap = new HashMap();
        System.out.println("then we store 1000 items from 800-1799 under key " + nr2);
        for (int i = 800; i < 1800; ++i) {
            contentMap.put(new Number160(i), new Data((Object)("data " + i)));
        }
        futurePut = peers[60].put(nr2).setDataMapContent(contentMap).setDomainKey(Number160.createHash((String)"my_domain")).start();
        futurePut.awaitUninterruptibly();
        FutureDigest futureDigest = ((DigestBuilder)peers[20].digest(nr1).setAll().returnBloomFilter().setDomainKey(Number160.createHash((String)"my_domain"))).start();
        futureDigest.awaitUninterruptibly();
        SimpleBloomFilter contentBF = futureDigest.getDigest().contentBloomFilter();
        System.out.println("We got bloomfilter for the first key: " + contentBF);
        FutureGet futureGet1 = ((GetBuilder)peers[10].get(nr2).setAll().setKeyBloomFilter(contentBF).setDomainKey(Number160.createHash((String)"my_domain"))).start();
        futureGet1.awaitUninterruptibly();
        System.out.println("For the 2nd key we requested with this Bloom filer and we got " + futureGet1.getDataMap().size() + " items.");
        FutureGet futureGet2 = ((GetBuilder)peers[10].get(nr2).setAll().bloomFilterIntersect().setKeyBloomFilter(contentBF).setDomainKey(Number160.createHash((String)"my_domain"))).start();
        futureGet2.awaitUninterruptibly();
        System.out.println("For the 2nd key we requested with this Bloom filer and we got " + futureGet2.getDataMap().size() + " items.");
    }
}

