/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.upnp;

import net.tomp2p.upnp.Action;
import net.tomp2p.upnp.ActionResponse;
import net.tomp2p.upnp.Argument;
import net.tomp2p.upnp.UPNPResponseException;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

class ActionMessageResponseParser
extends DefaultHandler {
    private static final String SOAP_FAULT_EL = "Fault";
    private final Action serviceAction;
    private final String bodyElementName;
    private boolean faultResponse = false;
    private UPNPResponseException msgEx;
    private boolean readFaultCode = false;
    private boolean readFaultString = false;
    private boolean readErrorCode = false;
    private boolean readErrorDescription = false;
    private boolean parseOutputParams = false;
    private ActionResponse result;
    private Argument parsedResultOutArg;

    ActionMessageResponseParser(Action serviceAction) {
        this.serviceAction = serviceAction;
        this.bodyElementName = serviceAction.getName() + "Response";
    }

    UPNPResponseException getUPNPResponseException() {
        return this.msgEx;
    }

    ActionResponse getActionResponse() {
        return this.result;
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        if (this.parseOutputParams) {
            if (this.parsedResultOutArg != null) {
                String origChars = this.result.getOutActionArgumentValue(this.parsedResultOutArg.name);
                String newChars = new String(ch, start, length);
                if (origChars == null) {
                    this.result.addResult(this.parsedResultOutArg, newChars);
                } else {
                    this.result.addResult(this.parsedResultOutArg, origChars + newChars);
                }
            }
        } else if (this.readFaultCode) {
            this.msgEx.faultCode = new String(ch, start, length);
            this.readFaultCode = false;
        } else if (this.readFaultString) {
            this.msgEx.faultString = new String(ch, start, length);
            this.readFaultString = false;
        } else if (this.readErrorCode) {
            String code = new String(ch, start, length);
            try {
                this.msgEx.detailErrorCode = Integer.parseInt(code);
            }
            catch (Throwable ex) {
                ex.printStackTrace();
            }
            this.readErrorCode = false;
        } else if (this.readErrorDescription) {
            this.msgEx.detailErrorDescription = new String(ch, start, length);
            this.readErrorDescription = false;
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) {
        if (this.parseOutputParams) {
            Argument arg = this.serviceAction.getActionArgument(localName);
            if (arg != null && arg.direction == Argument.Direction.out) {
                this.parsedResultOutArg = arg;
                this.result.addResult(this.parsedResultOutArg, null);
            } else {
                this.parsedResultOutArg = null;
            }
        } else if (this.faultResponse) {
            if (localName.equals("faultcode")) {
                this.readFaultCode = true;
            } else if (localName.equals("faultstring")) {
                this.readFaultString = true;
            } else if (localName.equals("errorCode")) {
                this.readErrorCode = true;
            } else if (localName.equals("errorDescription")) {
                this.readErrorDescription = true;
            }
        } else if (localName.equals(SOAP_FAULT_EL)) {
            this.msgEx = new UPNPResponseException();
            this.faultResponse = true;
        } else if (localName.equals(this.bodyElementName)) {
            this.parseOutputParams = true;
            this.result = new ActionResponse();
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) {
        if (this.parsedResultOutArg != null && this.parsedResultOutArg.name.equals(localName)) {
            this.parsedResultOutArg = null;
        } else if (localName.equals(this.bodyElementName)) {
            this.parseOutputParams = false;
        }
    }
}

