/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.message;

import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.PublicKey;
import java.security.SignatureException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.tomp2p.connection.SignatureFactory;
import net.tomp2p.message.Buffer;
import net.tomp2p.message.DataMap;
import net.tomp2p.message.KeyCollection;
import net.tomp2p.message.KeyMap640Keys;
import net.tomp2p.message.KeyMapByte;
import net.tomp2p.message.Message;
import net.tomp2p.message.MessageHeaderCodec;
import net.tomp2p.message.NeighborSet;
import net.tomp2p.message.NumberType;
import net.tomp2p.message.SignatureCodec;
import net.tomp2p.message.TrackerData;
import net.tomp2p.peers.Number160;
import net.tomp2p.peers.Number640;
import net.tomp2p.peers.PeerAddress;
import net.tomp2p.peers.PeerSocketAddress;
import net.tomp2p.rpc.SimpleBloomFilter;
import net.tomp2p.storage.AlternativeCompositeByteBuf;
import net.tomp2p.storage.Data;
import net.tomp2p.utils.Timings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Encoder {
    private static final Logger LOG = LoggerFactory.getLogger(Encoder.class);
    private boolean header = false;
    private boolean resume = false;
    private Message message;
    private SignatureFactory signatureFactory;

    public Encoder(SignatureFactory signatureFactory) {
        this.signatureFactory = signatureFactory;
    }

    public boolean write(AlternativeCompositeByteBuf buf, Message message) throws InvalidKeyException, SignatureException, IOException {
        this.message = message;
        LOG.debug("message for outbound {}", (Object)message);
        if (!this.header) {
            MessageHeaderCodec.encodeHeader(buf, message);
            this.header = true;
        } else {
            LOG.debug("send a follow up message {}", (Object)message);
            this.resume = true;
        }
        LOG.debug("entering loop");
        boolean done = this.loop(buf);
        LOG.debug("exiting loop");
        if (buf.isReadable() && done && message.isSign()) {
            SignatureCodec decodedSignature = this.signatureFactory.sign(message.getPrivateKey(), buf);
            decodedSignature.write(buf);
        }
        return done;
    }

    private boolean loop(AlternativeCompositeByteBuf buf) throws InvalidKeyException, SignatureException, IOException {
        NumberType next;
        block16: while ((next = this.message.contentRefencencs().peek()) != null) {
            switch (next.content()) {
                case KEY: {
                    buf.writeBytes(this.message.getKey(next.number()).toByteArray());
                    this.message.contentRefencencs().poll();
                    continue block16;
                }
                case INTEGER: {
                    buf.writeInt(this.message.getInteger(next.number()));
                    this.message.contentRefencencs().poll();
                    continue block16;
                }
                case LONG: {
                    buf.writeLong(this.message.getLong(next.number()));
                    this.message.contentRefencencs().poll();
                    continue block16;
                }
                case SET_NEIGHBORS: {
                    NeighborSet neighborSet = this.message.getNeighborsSet(next.number());
                    buf.writeByte(neighborSet.size());
                    for (PeerAddress neighbor : neighborSet.neighbors()) {
                        buf.writeBytes(neighbor.toByteArray());
                    }
                    this.message.contentRefencencs().poll();
                    continue block16;
                }
                case SET_PEER_SOCKET: {
                    List<PeerSocketAddress> list = this.message.getPeerSocketAddresses();
                    buf.writeByte(list.size());
                    for (PeerSocketAddress addr : list) {
                        buf.writeByte(addr.isIPv4() ? 0 : 1);
                        buf.writeBytes(addr.toByteArray());
                    }
                    this.message.contentRefencencs().poll();
                    continue block16;
                }
                case BLOOM_FILTER: {
                    SimpleBloomFilter<Number160> simpleBloomFilter = this.message.getBloomFilter(next.number());
                    simpleBloomFilter.toByteBuf(buf);
                    this.message.contentRefencencs().poll();
                    continue block16;
                }
                case SET_KEY640: {
                    KeyCollection keys = this.message.getKeyCollection(next.number());
                    buf.writeInt(keys.size());
                    if (keys.isConvert()) {
                        for (Number160 number160 : keys.keysConvert()) {
                            buf.writeBytes(keys.locationKey().toByteArray());
                            buf.writeBytes(keys.domainKey().toByteArray());
                            buf.writeBytes(number160.toByteArray());
                            buf.writeBytes(keys.versionKey().toByteArray());
                        }
                    } else {
                        for (Number640 number640 : keys.keys()) {
                            buf.writeBytes(number640.getLocationKey().toByteArray());
                            buf.writeBytes(number640.getDomainKey().toByteArray());
                            buf.writeBytes(number640.getContentKey().toByteArray());
                            buf.writeBytes(number640.getVersionKey().toByteArray());
                        }
                    }
                    this.message.contentRefencencs().poll();
                    continue block16;
                }
                case MAP_KEY640_DATA: {
                    DataMap dataMap = this.message.getDataMap(next.number());
                    buf.writeInt(dataMap.size());
                    if (dataMap.isConvert()) {
                        for (Map.Entry<Number160, Data> entry : dataMap.dataMapConvert().entrySet()) {
                            buf.writeBytes(dataMap.locationKey().toByteArray());
                            buf.writeBytes(dataMap.domainKey().toByteArray());
                            buf.writeBytes(entry.getKey().toByteArray());
                            buf.writeBytes(dataMap.versionKey().toByteArray());
                            this.encodeData(buf, entry.getValue(), dataMap.isConvertMeta(), !this.message.isRequest());
                        }
                    } else {
                        for (Map.Entry<Number640, Data> entry : dataMap.dataMap().entrySet()) {
                            buf.writeBytes(entry.getKey().getLocationKey().toByteArray());
                            buf.writeBytes(entry.getKey().getDomainKey().toByteArray());
                            buf.writeBytes(entry.getKey().getContentKey().toByteArray());
                            buf.writeBytes(entry.getKey().getVersionKey().toByteArray());
                            this.encodeData(buf, entry.getValue(), dataMap.isConvertMeta(), !this.message.isRequest());
                        }
                    }
                    this.message.contentRefencencs().poll();
                    continue block16;
                }
                case MAP_KEY640_KEYS: {
                    KeyMap640Keys keyMap640Keys = this.message.getKeyMap640Keys(next.number());
                    buf.writeInt(keyMap640Keys.size());
                    for (Map.Entry entry : keyMap640Keys.keysMap().entrySet()) {
                        buf.writeBytes(((Number640)entry.getKey()).getLocationKey().toByteArray());
                        buf.writeBytes(((Number640)entry.getKey()).getDomainKey().toByteArray());
                        buf.writeBytes(((Number640)entry.getKey()).getContentKey().toByteArray());
                        buf.writeBytes(((Number640)entry.getKey()).getVersionKey().toByteArray());
                        buf.writeByte(((Set)entry.getValue()).size());
                        for (Number160 basedOnKey : (Set)entry.getValue()) {
                            buf.writeBytes(basedOnKey.toByteArray());
                        }
                    }
                    this.message.contentRefencencs().poll();
                    continue block16;
                }
                case MAP_KEY640_BYTE: {
                    KeyMapByte keyMapByte = this.message.getKeyMapByte(next.number());
                    buf.writeInt(keyMapByte.size());
                    for (Map.Entry<Number640, Byte> entry : keyMapByte.keysMap().entrySet()) {
                        buf.writeBytes(entry.getKey().getLocationKey().toByteArray());
                        buf.writeBytes(entry.getKey().getDomainKey().toByteArray());
                        buf.writeBytes(entry.getKey().getContentKey().toByteArray());
                        buf.writeBytes(entry.getKey().getVersionKey().toByteArray());
                        buf.writeByte(entry.getValue().byteValue());
                    }
                    this.message.contentRefencencs().poll();
                    continue block16;
                }
                case BYTE_BUFFER: {
                    Buffer buffer = this.message.getBuffer(next.number());
                    if (!this.resume) {
                        buf.writeInt(buffer.length());
                    }
                    int readable = buffer.readable();
                    buf.writeBytes(buffer.buffer(), readable);
                    if (buffer.incRead(readable) == buffer.length()) {
                        this.message.contentRefencencs().poll();
                        continue block16;
                    }
                    if (this.message.isStreaming()) {
                        LOG.debug("we sent a partial message of length {}", (Object)readable);
                        return false;
                    }
                    LOG.debug("Announced a larger buffer, but not in streaming mode. This is wrong.");
                    throw new RuntimeException("Announced a larger buffer, but not in streaming mode. This is wrong.");
                }
                case SET_TRACKER_DATA: {
                    TrackerData trackerData = this.message.getTrackerData(next.number());
                    buf.writeByte(trackerData.getPeerAddresses().size());
                    for (Map.Entry<PeerAddress, Data> entry : trackerData.getPeerAddresses().entrySet()) {
                        buf.writeBytes(entry.getKey().toByteArray());
                        Data data = entry.getValue().duplicate();
                        this.encodeData(buf, data, false, !this.message.isRequest());
                    }
                    this.message.contentRefencencs().poll();
                    continue block16;
                }
                case PUBLIC_KEY_SIGNATURE: {
                    this.message.setHintSign();
                }
                case PUBLIC_KEY: {
                    PublicKey publicKey = this.message.getPublicKey(next.number());
                    this.signatureFactory.encodePublicKey(publicKey, buf);
                    this.message.contentRefencencs().poll();
                    continue block16;
                }
            }
            throw new RuntimeException("Unknown type: " + (Object)((Object)next.content()));
        }
        return true;
    }

    private void encodeData(AlternativeCompositeByteBuf buf, Data data, boolean isConvertMeta, boolean isReply) throws InvalidKeyException, SignatureException, IOException {
        data = isConvertMeta ? data.duplicateMeta() : data.duplicate();
        if (isReply) {
            int ttl = (int)((data.expirationMillis() - Timings.currentTimeMillis()) / 1000L);
            data.ttlSeconds(ttl < 0 ? 0 : ttl);
        }
        data.encodeHeader(buf, this.signatureFactory);
        data.encodeDone(buf, this.signatureFactory);
    }

    public Message message() {
        return this.message;
    }

    public void reset() {
        this.header = false;
        this.resume = false;
    }
}

