/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.natpmp;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Gateway {
    private static final Logger logger = LoggerFactory.getLogger(Gateway.class);
    private static final Pattern IP_PATTERN = Pattern.compile("(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)");

    public static InetAddress getIP() {
        try {
            Process proc = Runtime.getRuntime().exec("netstat -rn");
            InputStream inputstream = proc.getInputStream();
            InputStreamReader inputstreamreader = new InputStreamReader(inputstream);
            BufferedReader bufferedreader = new BufferedReader(inputstreamreader);
            InetAddress inet = Gateway.parse(bufferedreader);
            bufferedreader.close();
            return inet;
        }
        catch (IOException ex) {
            logger.error("Unable to determine gateway.", (Throwable)ex);
            return null;
        }
    }

    static InetAddress parse(BufferedReader bufferedreader) throws IOException, UnknownHostException {
        String line;
        while ((line = bufferedreader.readLine()) != null) {
            boolean gatewayLine = false;
            if (line.indexOf("default") != 0 && line.indexOf("0.0.0.0") < 0) continue;
            if (line.indexOf("default") == 0) {
                gatewayLine = true;
            }
            Matcher m = IP_PATTERN.matcher(line);
            int start = 0;
            while (m.find(start)) {
                String tmp = m.group();
                if (start == 0 && tmp.equals("0.0.0.0")) {
                    gatewayLine = true;
                } else if (!tmp.equals("0.0.0.0") && gatewayLine) {
                    return InetAddress.getByName(tmp);
                }
                start = m.end() + 1;
            }
        }
        return null;
    }
}

