/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.p2p.builder;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Random;
import net.tomp2p.futures.FuturePut;
import net.tomp2p.p2p.Peer;
import net.tomp2p.p2p.builder.DHTBuilder;
import net.tomp2p.peers.Number160;
import net.tomp2p.storage.Data;

public class AddBuilder
extends DHTBuilder<AddBuilder> {
    private static final FuturePut FUTURE_SHUTDOWN = (FuturePut)new FuturePut(null, 0, 0).setFailed("add builder - peer is shutting down");
    private Collection<Data> dataSet;
    private Data data;
    private boolean list = false;
    private Random rnd;

    public AddBuilder(Peer peer, Number160 locationKey) {
        super(peer, locationKey);
        this.self(this);
    }

    public Collection<Data> getDataSet() {
        return this.dataSet;
    }

    public AddBuilder setDataSet(Collection<Data> dataSet) {
        this.dataSet = dataSet;
        return this;
    }

    public Data getData() {
        return this.data;
    }

    public AddBuilder setData(Data data) {
        this.data = data;
        return this;
    }

    public AddBuilder setObject(Object object) throws IOException {
        return this.setData(new Data(object));
    }

    public boolean isList() {
        return this.list;
    }

    public AddBuilder setList(boolean list) {
        this.list = list;
        return this;
    }

    public AddBuilder setList() {
        this.list = true;
        return this;
    }

    public AddBuilder random(Random rnd) {
        this.rnd = rnd;
        return this;
    }

    public Random random() {
        return this.rnd;
    }

    @Override
    public FuturePut start() {
        if (this.peer.isShutdown()) {
            return FUTURE_SHUTDOWN;
        }
        this.preBuild("add-builder");
        if (this.dataSet == null) {
            this.dataSet = new ArrayList<Data>(1);
        }
        if (this.data != null) {
            this.dataSet.add(this.data);
        }
        if (this.dataSet.size() == 0) {
            throw new IllegalArgumentException("You must either set data via setDataMap() or setData(). Cannot add nothing.");
        }
        if (this.rnd == null) {
            this.rnd = new Random();
        }
        return this.peer.getDistributedHashMap().add(this);
    }
}

