/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.p2p;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.Random;
import java.util.TimerTask;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import net.tomp2p.futures.BaseFuture;
import net.tomp2p.futures.BaseFutureAdapter;
import net.tomp2p.futures.BaseFutureListener;
import net.tomp2p.futures.FutureChannelCreator;
import net.tomp2p.futures.FutureResponse;
import net.tomp2p.p2p.Peer;
import net.tomp2p.p2p.Replication;
import net.tomp2p.p2p.ReplicationFactor;
import net.tomp2p.p2p.ReplicationSender;
import net.tomp2p.p2p.ResponsibilityListener;
import net.tomp2p.p2p.builder.PutBuilder;
import net.tomp2p.peers.Number160;
import net.tomp2p.peers.Number640;
import net.tomp2p.peers.PeerAddress;
import net.tomp2p.rpc.StorageRPC;
import net.tomp2p.storage.Data;
import net.tomp2p.storage.StorageLayer;
import net.tomp2p.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReplicationExecutor
implements ResponsibilityListener,
Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(ReplicationExecutor.class);
    private final StorageLayer storage;
    private final StorageRPC storageRPC;
    private final Peer peer;
    private final Replication replicationStorage;
    private static final int REPLICATION = 6;
    private final ScheduledExecutorService timer;
    private final Random random;
    private final int delayMillis;
    private final ReplicationFactor replicationFactor;
    private final ReplicationSender replicationSender;
    private final boolean allPeersReplicate;
    private ScheduledFuture<?> scheduledFuture;

    public ReplicationExecutor(Peer peer, ReplicationFactor replicationFactor, ReplicationSender replicationSender, Random random, ScheduledExecutorService timer, int delayMillis, boolean allPeersReplicate) {
        this.peer = peer;
        this.storage = peer.getPeerBean().storage();
        this.storageRPC = peer.getStoreRPC();
        this.replicationStorage = peer.getPeerBean().replicationStorage();
        this.replicationStorage.addResponsibilityListener(this);
        this.replicationStorage.setReplicationFactor(6);
        this.random = random;
        this.timer = timer;
        this.delayMillis = delayMillis;
        this.replicationFactor = replicationFactor;
        this.replicationSender = replicationSender;
        this.allPeersReplicate = allPeersReplicate;
    }

    public void init(int intervalMillis) {
        this.scheduledFuture = this.timer.scheduleAtFixedRate(this, intervalMillis, intervalMillis, TimeUnit.MILLISECONDS);
    }

    @Override
    public void otherResponsible(final Number160 locationKey, final PeerAddress other, boolean delayed) {
        if (!this.allPeersReplicate) {
            return;
        }
        LOG.debug("Other peer {} is responsible for {}. I'm {}", new Object[]{other, locationKey, this.storageRPC.peerBean().serverPeerAddress()});
        if (!delayed) {
            Number640 min = new Number640(locationKey, Number160.ZERO, Number160.ZERO, Number160.ZERO);
            Number640 max = new Number640(locationKey, Number160.MAX_VALUE, Number160.MAX_VALUE, Number160.MAX_VALUE);
            NavigableMap<Number640, Data> dataMap = this.storage.get(min, max, -1, true);
            this.replicationSender.sendDirect(other, locationKey, dataMap);
            LOG.debug("transfer from {} to {} for key {}", new Object[]{this.storageRPC.peerBean().serverPeerAddress(), other, locationKey});
        } else {
            this.timer.schedule(new TimerTask(){

                @Override
                public void run() {
                    ReplicationExecutor.this.otherResponsible(locationKey, other, false);
                }
            }, (long)this.random.nextInt(this.delayMillis), TimeUnit.MILLISECONDS);
        }
    }

    @Override
    public void meResponsible(Number160 locationKey) {
        LOG.debug("I ({}) now responsible for {}", (Object)this.storageRPC.peerBean().serverPeerAddress(), (Object)locationKey);
        this.synchronizeData(locationKey);
    }

    @Override
    public void meResponsible(Number160 locationKey, PeerAddress newPeer) {
        LOG.debug("I ({}) sync {} to {}", new Object[]{this.storageRPC.peerBean().serverPeerAddress(), locationKey, newPeer});
        Number640 min = new Number640(locationKey, Number160.ZERO, Number160.ZERO, Number160.ZERO);
        Number640 max = new Number640(locationKey, Number160.MAX_VALUE, Number160.MAX_VALUE, Number160.MAX_VALUE);
        NavigableMap<Number640, Data> dataMap = this.storage.get(min, max, -1, true);
        this.replicationSender.sendDirect(newPeer, locationKey, dataMap);
    }

    @Override
    public void run() {
        Collection<Number160> locationKeys = this.storage.findContentForResponsiblePeerID(this.peer.getPeerID());
        for (Number160 locationKey : locationKeys) {
            this.synchronizeData(locationKey);
        }
        int replicationFactor = this.replicationFactor.replicationFactor();
        this.peer.getPeerBean().replicationStorage().setReplicationFactor(replicationFactor);
    }

    private void synchronizeData(Number160 locationKey) {
        Number640 min = new Number640(locationKey, Number160.ZERO, Number160.ZERO, Number160.ZERO);
        Number640 max = new Number640(locationKey, Number160.MAX_VALUE, Number160.MAX_VALUE, Number160.MAX_VALUE);
        NavigableMap<Number640, Data> dataMap = this.storage.get(min, max, -1, true);
        List<PeerAddress> closePeers = this.send(locationKey, dataMap);
        LOG.debug("[storage refresh] I ({}) restore {} to {}", new Object[]{this.storageRPC.peerBean().serverPeerAddress(), locationKey, closePeers});
    }

    protected List<PeerAddress> send(Number160 locationKey, Map<Number640, Data> dataMapConverted) {
        int replicationFactor = this.replicationStorage.getReplicationFactor() - 1;
        ArrayList<PeerAddress> closePeers = new ArrayList<PeerAddress>();
        NavigableSet<PeerAddress> sortedSet = this.peer.getPeerBean().peerMap().closePeers(locationKey, replicationFactor);
        int count = 0;
        for (PeerAddress peerAddress : sortedSet) {
            closePeers.add(peerAddress);
            this.replicationSender.sendDirect(peerAddress, locationKey, dataMapConverted);
            if (++count != replicationFactor) continue;
            break;
        }
        return closePeers;
    }

    public void shutdown() {
        if (this.scheduledFuture != null) {
            this.scheduledFuture.cancel(false);
        }
    }

    public static class DefaultReplicationSender
    implements ReplicationSender {
        private StorageRPC storageRPC;
        private Peer peer;

        @Override
        public void init(Peer peer) {
            this.peer = peer;
            this.storageRPC = peer.getStoreRPC();
        }

        @Override
        public void sendDirect(final PeerAddress other, final Number160 locationKey, final Map<Number640, Data> dataMap) {
            FutureChannelCreator futureChannelCreator = this.peer.getConnectionBean().reservation().create(0, 1);
            futureChannelCreator.addListener((BaseFutureListener<BaseFuture>)new BaseFutureAdapter<FutureChannelCreator>(){

                @Override
                public void operationComplete(FutureChannelCreator future) throws Exception {
                    if (future.isSuccess()) {
                        PutBuilder putBuilder = new PutBuilder(DefaultReplicationSender.this.peer, locationKey);
                        putBuilder.setDataMap(dataMap);
                        FutureResponse futureResponse = DefaultReplicationSender.this.storageRPC.put(other, putBuilder, future.channelCreator());
                        Utils.addReleaseListener(future.channelCreator(), futureResponse);
                        DefaultReplicationSender.this.peer.notifyAutomaticFutures(futureResponse);
                    } else if (LOG.isErrorEnabled()) {
                        LOG.error("otherResponsible failed " + future.getFailedReason());
                    }
                }
            });
        }
    }
}

