/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.p2p.builder;

import java.security.KeyPair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import net.tomp2p.connection.DefaultConnectionConfiguration;
import net.tomp2p.futures.FutureChannelCreator;
import net.tomp2p.futures.FutureTracker;
import net.tomp2p.p2p.Peer;
import net.tomp2p.p2p.RoutingConfiguration;
import net.tomp2p.p2p.TrackerConfiguration;
import net.tomp2p.p2p.builder.Builder;
import net.tomp2p.p2p.builder.RoutingBuilder;
import net.tomp2p.p2p.builder.SignatureBuilder;
import net.tomp2p.peers.Number160;
import net.tomp2p.peers.PeerFilter;

public abstract class TrackerBuilder<K extends TrackerBuilder<K>>
extends DefaultConnectionConfiguration
implements SignatureBuilder<K>,
Builder {
    public static final Number160 DEFAULT_DOMAIN = Number160.createHash("default-tracker");
    protected static final FutureTracker FUTURE_TRACKER_SHUTDOWN = (FutureTracker)new FutureTracker().setFailed("Peer is shutting down");
    protected final Peer peer;
    protected final Number160 locationKey;
    protected Number160 domainKey;
    protected RoutingConfiguration routingConfiguration;
    protected TrackerConfiguration trackerConfiguration;
    protected FutureChannelCreator futureChannelCreator;
    private Set<Number160> knownPeers;
    private K self;
    private KeyPair keyPair = null;
    private Collection<PeerFilter> peerFilters;

    public TrackerBuilder(Peer peer, Number160 locationKey) {
        this.peer = peer;
        this.locationKey = locationKey;
    }

    public void self(K self) {
        this.self = self;
    }

    public Number160 getDomainKey() {
        return this.domainKey;
    }

    public Number160 getLocationKey() {
        return this.locationKey;
    }

    public K setDomainKey(Number160 domainKey) {
        this.domainKey = domainKey;
        return this.self;
    }

    public RoutingConfiguration getRoutingConfiguration() {
        return this.routingConfiguration;
    }

    public K setRoutingConfiguration(RoutingConfiguration routingConfiguration) {
        this.routingConfiguration = routingConfiguration;
        return this.self;
    }

    public TrackerConfiguration getTrackerConfiguration() {
        return this.trackerConfiguration;
    }

    public K setTrackerConfiguration(TrackerConfiguration trackerConfiguration) {
        this.trackerConfiguration = trackerConfiguration;
        return this.self;
    }

    public FutureChannelCreator getFutureChannelCreator() {
        return this.futureChannelCreator;
    }

    public K setFutureChannelCreator(FutureChannelCreator futureChannelCreator) {
        this.futureChannelCreator = futureChannelCreator;
        return this.self;
    }

    public Set<Number160> getKnownPeers() {
        return this.knownPeers;
    }

    public K setKnownPeers(Set<Number160> knownPeers) {
        this.knownPeers = knownPeers;
        return this.self;
    }

    public void preBuild(String name) {
        if (this.domainKey == null) {
            this.domainKey = DEFAULT_DOMAIN;
        }
        if (this.routingConfiguration == null) {
            this.routingConfiguration = new RoutingConfiguration(5, 10, 2);
        }
        if (this.trackerConfiguration == null) {
            int size = this.peer.getPeerBean().peerMap().size() + 1;
            this.trackerConfiguration = new TrackerConfiguration(Math.min(size, 3), 5, 3, 30);
        }
        if (this.futureChannelCreator == null) {
            int conn = Math.max(this.routingConfiguration.getParallel(), this.trackerConfiguration.getParallel());
            this.futureChannelCreator = this.peer.getConnectionBean().reservation().create(conn, 0);
        }
    }

    @Override
    public abstract FutureTracker start();

    public RoutingBuilder createBuilder(RoutingConfiguration routingConfiguration2) {
        RoutingBuilder routingBuilder = new RoutingBuilder();
        routingBuilder.setParallel(this.routingConfiguration.getParallel());
        routingBuilder.setMaxNoNewInfo(this.routingConfiguration.getMaxNoNewInfo(0));
        routingBuilder.setMaxDirectHits(this.routingConfiguration.getMaxDirectHits());
        routingBuilder.setMaxFailures(this.routingConfiguration.getMaxFailures());
        routingBuilder.setMaxSuccess(this.routingConfiguration.getMaxSuccess());
        return routingBuilder;
    }

    @Override
    public boolean isSign() {
        return this.keyPair != null;
    }

    @Override
    public K sign(boolean signMessage) {
        if (signMessage) {
            this.setSign();
        } else {
            this.keyPair = null;
        }
        return this.self;
    }

    @Override
    public K setSign() {
        this.keyPair = this.peer.getPeerBean().keyPair();
        return this.self;
    }

    @Override
    public K keyPair(KeyPair keyPair) {
        this.keyPair = keyPair;
        return this.self;
    }

    @Override
    public KeyPair keyPair() {
        return this.keyPair;
    }

    public K addPeerFilter(PeerFilter peerFilter) {
        if (this.peerFilters == null) {
            this.peerFilters = new ArrayList<PeerFilter>(2);
        }
        this.peerFilters.add(peerFilter);
        return this.self;
    }

    public Collection<PeerFilter> peerFilters() {
        return this.peerFilters;
    }
}

