/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.futures;

import java.util.Map;
import net.tomp2p.futures.BaseFuture;
import net.tomp2p.futures.FutureDHT;
import net.tomp2p.p2p.EvaluatingSchemeDHT;
import net.tomp2p.p2p.VotingSchemeDHT;
import net.tomp2p.p2p.builder.DHTBuilder;
import net.tomp2p.peers.Number640;
import net.tomp2p.peers.PeerAddress;
import net.tomp2p.storage.Data;

public class FutureGet
extends FutureDHT<FutureGet> {
    private final int min;
    private final EvaluatingSchemeDHT evaluationScheme;
    private Map<PeerAddress, Map<Number640, Data>> rawData;
    private boolean minReached;

    public FutureGet(DHTBuilder<?> builder) {
        this(builder, 0, new VotingSchemeDHT());
    }

    public FutureGet(DHTBuilder<?> builder, int min, EvaluatingSchemeDHT evaluationScheme) {
        super(builder);
        this.min = min;
        this.evaluationScheme = evaluationScheme;
        this.self(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setReceivedData(Map<PeerAddress, Map<Number640, Data>> rawData) {
        Object object = this.lock;
        synchronized (object) {
            if (!this.setCompletedAndNotify()) {
                return;
            }
            this.rawData = rawData;
            int size = rawData.size();
            this.minReached = size >= this.min;
            this.type = size > 0 ? BaseFuture.FutureType.OK : BaseFuture.FutureType.FAILED;
            this.reason = size > 0 ? "Minimun number of results reached" : "Expected >0 result, but got " + size;
        }
        this.notifyListeners();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<PeerAddress, Map<Number640, Data>> getRawData() {
        Object object = this.lock;
        synchronized (object) {
            return this.rawData;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Number640, Data> getDataMap() {
        Object object = this.lock;
        synchronized (object) {
            return this.evaluationScheme.evaluate2(this.rawData);
        }
    }

    public Data getData() {
        Map<Number640, Data> dataMap = this.getDataMap();
        if (dataMap.size() == 0) {
            return null;
        }
        return dataMap.values().iterator().next();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isMinReached() {
        Object object = this.lock;
        synchronized (object) {
            return this.minReached;
        }
    }
}

