/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.simgrid;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashSet;
import java.util.Random;
import net.tomp2p.peers.Number160;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.apache.commons.io.FileUtils;

public class Utils {
    private static final Options options = new Options();
    private static Random rnd;

    public static void main(String[] args) throws ParseException, IOException {
        String trailer;
        String header;
        File fileNameDep;
        PosixParser parser = new PosixParser();
        CommandLine cmd = parser.parse(options, args);
        boolean work = false;
        if (cmd.hasOption("s")) {
            try {
                rnd = new Random(Long.parseLong(cmd.getOptionValue("s")));
            }
            catch (NumberFormatException nfe) {
                Utils.printHelpAndExit("Could not parse -s [" + cmd.getOptionValue("s") + "]");
            }
        } else {
            rnd = new Random();
        }
        if (cmd.hasOption("n") && cmd.hasOption("o")) {
            String search;
            work = true;
            File fileNameOld = new File(cmd.getOptionValue("o"));
            File fileNameNew = new File(cmd.getOptionValue("n"));
            String old = FileUtils.readFileToString((File)fileNameOld);
            int i = 0;
            while (old.indexOf(search = "\"Host " + i + "\"") >= 0) {
                int start;
                Number160 number160 = new Number160(rnd);
                int index = 0;
                while ((start = old.indexOf(search, index)) >= 0) {
                    index = start + 1;
                    old = old.substring(0, start) + "\"" + number160.toString() + "\"" + old.substring(start + search.length());
                }
                System.out.println(search);
                ++i;
            }
            FileUtils.write((File)fileNameNew, (CharSequence)old);
        }
        if (cmd.hasOption("d") && cmd.hasOption("r")) {
            work = true;
            fileNameDep = new File(cmd.getOptionValue("d"));
            header = "<?xml version='1.0'?>\n<!DOCTYPE platform SYSTEM \"http://simgrid.gforge.inria.fr/simgrid.dtd\">\n<platform version=\"3\">\n";
            trailer = "</platform>";
            StringBuilder sb = new StringBuilder(header);
            int nr = 0;
            if (cmd.hasOption("r")) {
                try {
                    nr = Integer.parseInt(cmd.getOptionValue("r"));
                }
                catch (NumberFormatException nfe) {
                    Utils.printHelpAndExit("Could not parse -r [" + cmd.getOptionValue("r") + "]");
                }
            }
            Number160 first = null;
            for (int i = 0; i < nr; ++i) {
                Number160 number160 = new Number160(rnd);
                if (first == null) {
                    first = number160;
                }
                sb.append(" <process host=\"" + number160.toString() + "\" function=\"net.tomp2p.simgrid.SimulationLoop\">\n" + "  <argument value=\"" + first + "\"/> <!-- boostrap to -->\n" + " </process>\n");
                sb.append(" <process host=\"" + number160.toString() + "\" function=\"net.tomp2p.simgrid.TomP2PReceiver\"/>\n");
                sb.append(" <process host=\"" + number160.toString() + "\" function=\"net.tomp2p.simgrid.TomP2PSender\"/>\n");
                sb.append(" <!-- next -->\n");
            }
            FileUtils.write((File)fileNameDep, (CharSequence)sb.append(trailer).toString());
        }
        if (cmd.hasOption("d1") && cmd.hasOption("r")) {
            work = true;
            fileNameDep = new File(cmd.getOptionValue("d1"));
            header = "<?xml version='1.0'?>\n<!DOCTYPE platform SYSTEM \"http://simgrid.gforge.inria.fr/simgrid.dtd\">\n<platform version=\"3\">\n";
            trailer = "</platform>";
            StringBuilder sb = new StringBuilder(header);
            int nr = 0;
            if (cmd.hasOption("r")) {
                try {
                    nr = Integer.parseInt(cmd.getOptionValue("r"));
                }
                catch (NumberFormatException nfe) {
                    Utils.printHelpAndExit("Could not parse -r [" + cmd.getOptionValue("r") + "]");
                }
            }
            for (int i = 0; i < nr; ++i) {
                sb.append(" <process host=\"" + i + "\" function=\"net.tomp2p.simgrid.SimulationLoop\">\n" + "  <argument value=\"0\"/> <!-- boostrap to -->\n" + " </process>\n");
                sb.append(" <process host=\"" + i + "\" function=\"net.tomp2p.simgrid.TomP2PReceiver\"/>\n");
                sb.append(" <process host=\"" + i + "\" function=\"net.tomp2p.simgrid.TomP2PSender\"/>\n");
                sb.append(" <!-- next -->\n");
            }
            FileUtils.write((File)fileNameDep, (CharSequence)sb.append(trailer).toString());
        }
        if (!work) {
            Utils.printHelpAndExit("nothing to do");
        }
    }

    private static void printHelpAndExit(String msg) {
        System.out.println(msg);
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("Utils", options);
    }

    public static int countHosts(String string) throws IOException {
        File file = new File(string);
        BufferedReader br = new BufferedReader(new FileReader(file));
        String line = null;
        HashSet<String> hosts = new HashSet<String>();
        while ((line = br.readLine()) != null) {
            int end;
            String markerStr = "host=\"";
            String markerEnd = "\"";
            int start = line.indexOf(markerStr);
            if (!(start > 0 & (end = line.indexOf(markerEnd, start + markerStr.length() + 1)) > 0)) continue;
            hosts.add(line.substring(start + markerStr.length(), end));
        }
        br.close();
        return hosts.size();
    }

    static {
        options.addOption("o", "old", true, "path name of the old platform.xml file");
        options.addOption("n", "new", true, "path name of the new (transformed) platform.xml file");
        options.addOption("s", "seed", true, "seed for the random generator");
        options.addOption("d", "deployment", true, "path name of the deployment.xml file");
        options.addOption("d1", "deployment1", true, "path name of the deployment.xml file");
        options.addOption("r", "nrpeers", true, "number of peers to create");
    }
}

