/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.simgrid;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.Semaphore;
import net.tomp2p.connection.ChannelCreator;
import net.tomp2p.connection.Reservation;
import net.tomp2p.connection.Scheduler;
import net.tomp2p.connection.Sender;
import net.tomp2p.futures.BaseFuture;
import net.tomp2p.futures.FutureResponse;
import net.tomp2p.futures.FutureRunnable;
import net.tomp2p.message.Message;
import net.tomp2p.message.MessageID;
import net.tomp2p.p2p.Peer;
import net.tomp2p.peers.Number160;
import net.tomp2p.peers.PeerAddress;
import net.tomp2p.rpc.RequestHandlerTCP;
import net.tomp2p.rpc.RequestHandlerUDP;
import net.tomp2p.simgrid.OSTester;
import net.tomp2p.simgrid.SendingMessage;
import net.tomp2p.simgrid.SimGridMessage;
import net.tomp2p.simgrid.Simulation;
import net.tomp2p.simgrid.Utils;
import net.tomp2p.utils.Timing;
import net.tomp2p.utils.Timings;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.simgrid.msg.HostFailureException;
import org.simgrid.msg.Msg;
import org.simgrid.msg.NativeException;
import org.simgrid.msg.Process;
import org.simgrid.msg.TimeoutException;
import org.simgrid.msg.TransferFailureException;

public class SimGridTomP2P {
    private static final Map<Number160, Peer> peers = new HashMap<Number160, Peer>();
    private static final Map<MessageID, FutureResponse> futures = new HashMap<MessageID, FutureResponse>();
    private static final Map<Number160, BlockingQueue<SendingMessage>> pendingMessages = new HashMap<Number160, BlockingQueue<SendingMessage>>();
    private static final Map<Number160, Process> paused = new ConcurrentHashMap<Number160, Process>();
    private static final Map<Number160, String> mailboxMapping = new HashMap<Number160, String>();
    private static Simulation simulation;

    private static void createPeers(int nr) {
        for (int i = 0; i < nr; ++i) {
            Number160 peerID = Number160.createHash((String)("" + i));
            mailboxMapping.put(peerID, "" + i);
            Peer peer = new Peer(peerID);
            peer.getP2PConfiguration().setDisableBind(true);
            peer.getP2PConfiguration().setStartMaintenance(false);
            try {
                peer.listen();
                peer.getConnectionBean().getConnectionReservation().setReservation(new Reservation(){
                    private volatile boolean shutdown = false;

                    public void shutdown() {
                        this.shutdown = true;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public boolean acquire(Semaphore semaphore, int permits) {
                        boolean acquired = false;
                        while (!acquired && !this.shutdown) {
                            try {
                                acquired = semaphore.tryAcquire(permits);
                                if (acquired) continue;
                                Semaphore semaphore2 = semaphore;
                                synchronized (semaphore2) {
                                    Process.sleep((long)0L);
                                }
                            }
                            catch (HostFailureException e) {
                                e.printStackTrace();
                            }
                        }
                        return acquired;
                    }

                    public void runDeadLockProof(Scheduler scheduler, FutureRunnable futureRunnable) {
                        futureRunnable.run();
                    }

                    public void prepareDeadLockCheck() {
                    }

                    public void removeDeadLockCheck(long creatorThread) {
                    }
                });
                SimGridTomP2P.emulateSender(peer);
                peers.put(peerID, peer);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            Msg.info((String)("created peer with peerID " + peerID));
        }
        Msg.info((String)"peers created");
    }

    private static void loadFromJar(String lib) {
        try {
            SimGridTomP2P.loadLib(lib);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void loadLib(String name) throws IOException {
        String pathJar = null;
        String pathEclipse = null;
        if (OSTester.is64bit() && OSTester.isUnix()) {
            name = "lib" + name + ".so";
            pathJar = "libs" + File.separator + "x64" + File.separator + name;
            pathEclipse = File.separator + "libs" + File.separator + "x64" + File.separator + name;
        }
        if (pathJar == null || pathEclipse == null) {
            throw new IOException("Platform not supported");
        }
        InputStream in = SimGridTomP2P.class.getResourceAsStream(pathJar);
        if (in == null) {
            in = SimGridTomP2P.class.getResourceAsStream(pathEclipse);
        }
        File fileOut = new File(System.getProperty("java.io.tmpdir") + "/" + name);
        fileOut.deleteOnExit();
        FileOutputStream out = FileUtils.openOutputStream((File)fileOut);
        IOUtils.copy((InputStream)in, (OutputStream)out);
        in.close();
        ((OutputStream)out).close();
        System.load(fileOut.toString());
    }

    public static Peer getPeer(Number160 peerID) {
        return peers.get(peerID);
    }

    public static PeerAddress createPeer(String peerID) {
        return new PeerAddress(new Number160(peerID));
    }

    public static void send(String type, Message message, FutureResponse futureResponse) throws NativeException, TransferFailureException, HostFailureException, TimeoutException {
        SimGridMessage msgSG = new SimGridMessage("msg-" + type, 0.0, message.getLength() + 56L);
        msgSG.setMessage(message);
        Msg.info((String)("send [" + type + "] " + message));
        if (futureResponse != null) {
            futures.put(new MessageID(message), futureResponse);
        }
        String mailbox = mailboxMapping.get(message.getRecipient().getID());
        msgSG.send(mailbox);
    }

    public static FutureResponse getAndRemoveFuture(MessageID messageID) {
        return futures.remove(messageID);
    }

    public static void addQueue(Number160 senderID, SendingMessage sendingMessage) {
        BlockingQueue<SendingMessage> queue = pendingMessages.get(senderID);
        if (queue == null) {
            queue = new LinkedBlockingQueue<SendingMessage>();
            pendingMessages.put(senderID, queue);
        }
        queue.offer(sendingMessage);
        SimGridTomP2P.notify(senderID);
    }

    public static SendingMessage getPendingMessag(Number160 senderID) throws InterruptedException {
        BlockingQueue<SendingMessage> queue = pendingMessages.get(senderID);
        if (queue == null) {
            queue = new LinkedBlockingQueue<SendingMessage>();
            pendingMessages.put(senderID, queue);
        }
        return (SendingMessage)queue.poll();
    }

    private static void emulateSender(Peer peer) {
        peer.getConnectionBean().setSender(new Sender(){

            public void sendUDP(RequestHandlerUDP<? extends BaseFuture> handler, FutureResponse futureResponse, Message message, ChannelCreator channelCreator) {
                SimGridTomP2P.addQueue(message.getSender().getID(), new SendingMessage("snd-udp", message, futureResponse));
            }

            public void sendTCP(RequestHandlerTCP<? extends BaseFuture> handler, FutureResponse futureResponse, Message message, ChannelCreator channelCreator, int idleTCPMillis) {
                SimGridTomP2P.addQueue(message.getSender().getID(), new SendingMessage("snd-tcp", message, futureResponse));
            }

            public void sendBroadcastUDP(RequestHandlerUDP<? extends BaseFuture> handler, FutureResponse futureResponse, Message message, ChannelCreator channelCreator) {
                throw new RuntimeException("broadcasting in SimGrid-TomP2P not support");
            }

            public void shutdown() {
            }
        });
    }

    public static void wait(Number160 host, Process process) {
        if (!process.isSuspended()) {
            Process old = paused.put(host, process);
            if (old != null && !old.equals(process)) {
                throw new RuntimeException("This needs to be the same process");
            }
            process.pause();
        }
    }

    public static void notify(Number160 host) {
        Process p = paused.remove(host);
        if (p != null) {
            p.restart();
        }
    }

    public static void setSimulation(Simulation simulation2) {
        simulation = simulation2;
    }

    public static Simulation getSimulation() {
        return simulation;
    }

    public static void checkArgs(String[] args) {
        if (args.length < 2) {
            System.err.println("Usage: java -jar TomP2P-SimGrid platform_file deployment_file ");
            System.exit(1);
        }
    }

    public static void main(String[] args) throws IOException {
        Msg.init((String[])args);
        SimGridTomP2P.checkArgs(args);
        int nr = Utils.countHosts(args[1]);
        SimGridTomP2P.createPeers(nr);
        Msg.createEnvironment((String)args[0]);
        Msg.deployApplication((String)args[1]);
        Msg.run();
        Msg.info((String)"EXIT.");
    }

    static {
        try {
            System.loadLibrary("simgrid");
        }
        catch (UnsatisfiedLinkError e) {
            SimGridTomP2P.loadFromJar("simgrid");
        }
        try {
            System.loadLibrary("SG_java");
        }
        catch (UnsatisfiedLinkError e) {
            SimGridTomP2P.loadFromJar("SG_java");
        }
        Timings.setImpl((Timing)new Timing(){

            public void sleepUninterruptibly(int millis) {
                try {
                    Process.sleep((long)millis);
                }
                catch (HostFailureException e) {
                    e.printStackTrace();
                }
            }

            public void sleep(int millis) throws InterruptedException {
                try {
                    Process.sleep((long)millis);
                }
                catch (HostFailureException e) {
                    e.printStackTrace();
                }
            }

            public long currentTimeMillis() {
                return (long)(Msg.getClock() * 1000.0);
            }
        });
    }
}

