/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.audiovideowrapper;

import com.github.sarxos.webcam.Webcam;
import java.awt.image.BufferedImage;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicInteger;
import javafx.application.Platform;
import javafx.embed.swing.SwingFXUtils;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.image.WritableImage;
import javax.sound.sampled.LineUnavailableException;
import net.tomp2p.audiovideowrapper.VideoData;
import org.jcodec.codecs.h264.H264Decoder;
import org.jcodec.codecs.h264.H264Encoder;
import org.jcodec.codecs.h264.io.model.Frame;
import org.jcodec.common.model.ColorSpace;
import org.jcodec.common.model.Picture;
import org.jcodec.scale.AWTUtil;
import org.jcodec.scale.RgbToYuv420j;
import org.jcodec.scale.Transform;
import org.jcodec.scale.Yuv420jToRgb;

public class H264Wrapper {
    private static final int FPS = 10;
    private static int w = 0;
    private static int h = 0;
    private static boolean running = true;
    private static Webcam webcam;

    public static int getW() {
        return w;
    }

    public static int getH() {
        return h;
    }

    public static VideoData decodeAndPlay(ImageView imageView) throws LineUnavailableException {
        Yuv420jToRgb transform2 = new Yuv420jToRgb();
        final H264Decoder decoder = new H264Decoder();
        return new VideoData((Transform)transform2, imageView){
            private long baseline = 0L;
            private Picture target1 = null;
            private Picture rgb = null;
            private BufferedImage bi = null;
            final /* synthetic */ Transform val$transform2;
            final /* synthetic */ ImageView val$imageView;
            {
                this.val$transform2 = transform;
                this.val$imageView = imageView;
            }

            @Override
            public void created(ByteBuffer bb, long time, int w0, int h0) {
                try {
                    w = w0;
                    h = h0;
                    if (bb.limit() == 0) {
                        return;
                    }
                    if (this.target1 == null && this.rgb == null && this.bi == null) {
                        this.target1 = Picture.create((int)(w + 15 & 0xFFFFFFF0), (int)(h + 15 & 0xFFFFFFF0), (ColorSpace)ColorSpace.YUV420J);
                        this.rgb = Picture.create((int)w, (int)h, (ColorSpace)ColorSpace.RGB);
                        this.bi = new BufferedImage(w, h, 5);
                    }
                    Frame dec = decoder.decodeFrame(bb, this.target1.getData());
                    this.val$transform2.transform((Picture)dec, this.rgb);
                    AWTUtil.toBufferedImage((Picture)this.rgb, (BufferedImage)this.bi);
                    WritableImage newImg = SwingFXUtils.toFXImage((BufferedImage)this.bi, null);
                    long now = System.currentTimeMillis();
                    if (this.baseline == 0L) {
                        this.baseline = now - time;
                    } else {
                        long wait = this.baseline + time - now;
                        if (wait > 0L) {
                            Thread.sleep(wait);
                        }
                    }
                    this.val$imageView.setImage((Image)newImg);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
    }

    public static void stopRecordeAndEncode() {
        running = false;
        webcam.close();
    }

    public static void recordAndEncode(Webcam webcam0, VideoData onFrame) {
        webcam = webcam0;
        webcam.open();
        H264Encoder encoder = new H264Encoder();
        RgbToYuv420j transform = new RgbToYuv420j();
        AtomicInteger counter = new AtomicInteger(0);
        new Thread(new Runnable((Transform)transform, encoder, counter, onFrame){
            final /* synthetic */ Transform val$transform;
            final /* synthetic */ H264Encoder val$encoder;
            final /* synthetic */ AtomicInteger val$counter;
            final /* synthetic */ VideoData val$onFrame;
            {
                this.val$transform = transform;
                this.val$encoder = h264Encoder;
                this.val$counter = atomicInteger;
                this.val$onFrame = videoData;
            }

            @Override
            public void run() {
                try {
                    Picture yuv = null;
                    while (running) {
                        long wait;
                        long start = System.currentTimeMillis();
                        BufferedImage rgb = webcam.getImage();
                        if (yuv == null) {
                            w = rgb.getWidth();
                            h = rgb.getHeight();
                            yuv = Picture.create((int)w, (int)h, (ColorSpace)ColorSpace.YUV420);
                        }
                        this.val$transform.transform(AWTUtil.fromBufferedImage((BufferedImage)rgb), yuv);
                        final ByteBuffer ff = this.val$encoder.encodeFrame(yuv, ByteBuffer.allocate(w * h * 3));
                        if (this.val$counter.get() == 0) {
                            Platform.runLater((Runnable)new Runnable(){

                                @Override
                                public void run() {
                                    try {
                                        val$counter.incrementAndGet();
                                        val$onFrame.created(ff, System.currentTimeMillis(), w, h);
                                        val$counter.decrementAndGet();
                                    }
                                    catch (Exception e) {
                                        e.printStackTrace();
                                    }
                                }
                            });
                        }
                        if ((wait = start + 100L - System.currentTimeMillis()) <= 0L) continue;
                        Thread.sleep(wait);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }).start();
    }
}

