/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.audiovideowrapper;

import com.github.sarxos.webcam.Webcam;
import java.awt.Dimension;
import javafx.application.Application;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.image.ImageView;
import javafx.scene.layout.StackPane;
import javafx.stage.Stage;
import net.tomp2p.audiovideowrapper.AudioData;
import net.tomp2p.audiovideowrapper.H264Wrapper;
import net.tomp2p.audiovideowrapper.OpusWrapper;
import net.tomp2p.audiovideowrapper.VideoData;

public class AudioVideoExample
extends Application {
    private static final ImageView IMG = new ImageView();

    public static void main(String[] args) throws Exception {
        Webcam webcam = Webcam.getDefault();
        Dimension[] d = webcam.getViewSizes();
        webcam.setViewSize(d[d.length - 1]);
        AudioData frameAudio = OpusWrapper.decodeAndPlay(OpusWrapper.FORMAT);
        OpusWrapper.recordAndEncode(OpusWrapper.FORMAT, frameAudio);
        VideoData frameVideo = H264Wrapper.decodeAndPlay(IMG);
        H264Wrapper.recordAndEncode(webcam, frameVideo);
        AudioVideoExample.launch((String[])args);
    }

    public void start(Stage primaryStage) {
        primaryStage.setTitle("Audio Video Test");
        StackPane root = new StackPane();
        root.getChildren().add((Object)IMG);
        while (H264Wrapper.getH() == 0) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
        }
        primaryStage.setScene(new Scene((Parent)root, (double)H264Wrapper.getW(), (double)H264Wrapper.getH()));
        primaryStage.show();
    }

    public void stop() {
        OpusWrapper.stopDecodeAndPlay();
        OpusWrapper.stopRecordeAndEncode();
        H264Wrapper.stopRecordeAndEncode();
    }
}

