package net.tomp2p.audiovideowrapper;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;

import com.sun.jna.Library;
import com.sun.jna.Native;
import com.sun.jna.NativeLibrary;
import com.sun.jna.Pointer;
import com.sun.jna.PointerType;
import com.sun.jna.ptr.FloatByReference;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.PointerByReference;
import com.sun.jna.ptr.ShortByReference;
/**
 * JNA Wrapper for library <b>opus</b><br>
 * This file was autogenerated by <a href="http://jnaerator.googlecode.com/">JNAerator</a>,<br>
 * a tool written by <a href="http://ochafik.com/">Olivier Chafik</a> that <a href="http://code.google.com/p/jnaerator/wiki/CreditsAndLicense">uses a few opensource projects.</a>.<br>
 * For help, please visit <a href="http://nativelibs4java.googlecode.com/">NativeLibs4Java</a> , <a href="http://rococoa.dev.java.net/">Rococoa</a>, or <a href="http://jna.dev.java.net/">JNA</a>.
 */
public interface Opus extends Library {
    
	public static final String JNA_LIBRARY_NAME = "opus";
	public static final NativeLibrary JNA_NATIVE_LIB = NativeLibrary.getInstance(Opus.JNA_LIBRARY_NAME);
	public static final Opus INSTANCE = (Opus)Native.loadLibrary(Opus.JNA_LIBRARY_NAME, Opus.class);
	
	//  ****** Constants
	
	/** <i>native declaration : /tmp/opus_defines.h</i> */
	public static final int OPUS_GET_LSB_DEPTH_REQUEST = (int)4037;
	/** <i>native declaration : /tmp/opus_defines.h</i> */
	public static final int OPUS_GET_APPLICATION_REQUEST = (int)4001;
	/** <i>native declaration : /tmp/opus_defines.h</i> */
	public static final int OPUS_GET_FORCE_CHANNELS_REQUEST = (int)4023;
	/** <i>native declaration : /tmp/opus_defines.h</i> */
	public static final int OPUS_GET_VBR_REQUEST = (int)4007;
	/** <i>native declaration : /tmp/opus_defines.h</i> */
	public static final int OPUS_GET_BANDWIDTH_REQUEST = (int)4009;
	/** <i>native declaration : /tmp/opus_defines.h</i> */
	public static final int OPUS_SET_BITRATE_REQUEST = (int)4002;
	/** <i>native declaration : /tmp/opus_defines.h</i> */
	public static final int OPUS_SET_BANDWIDTH_REQUEST = (int)4008;
	/** <i>native declaration : /tmp/opus_defines.h</i> */
	public static final int OPUS_SIGNAL_MUSIC = (int)3002;
	/** <i>native declaration : /tmp/opus_defines.h</i> */
	public static final int OPUS_RESET_STATE = (int)4028;
	/** <i>native declaration : /tmp/opus_defines.h</i> */
	public static final int OPUS_FRAMESIZE_2_5_MS = (int)5001;
	/** <i>native declaration : /tmp/opus_defines.h</i> */
	public static final int OPUS_GET_COMPLEXITY_REQUEST = (int)4011;
	/** <i>native declaration : /tmp/opus_defines.h</i> */
	public static final int OPUS_FRAMESIZE_40_MS = (int)5005;
	/** <i>native declaration : /tmp/opus_defines.h</i> */
	public static final int OPUS_SET_PACKET_LOSS_PERC_REQUEST = (int)4014;
	/** <i>native declaration : /tmp/opus_defines.h</i> */
	public static final int OPUS_GET_VBR_CONSTRAINT_REQUEST = (int)4021;
	/** <i>native declaration : /tmp/opus_defines.h</i> */
	public static final int OPUS_SET_INBAND_FEC_REQUEST = (int)4012;
	/** <i>native declaration : /tmp/opus_defines.h</i> */
	public static final int OPUS_APPLICATION_RESTRICTED_LOWDELAY = (int)2051;
	/** <i>native declaration : /tmp/opus_defines.h</i> */
	public static final int OPUS_BANDWIDTH_FULLBAND = (int)1105;
	/** <i>native declaration : /tmp/opus_defines.h</i> */
	public static final int OPUS_SET_VBR_REQUEST = (int)4006;
	/** <i>native declaration : /tmp/opus_defines.h</i> */
	public static final int OPUS_BANDWIDTH_SUPERWIDEBAND = (int)1104;
	/** <i>native declaration : /tmp/opus_defines.h</i> */
	public static final int OPUS_SET_FORCE_CHANNELS_REQUEST = (int)4022;
	/** <i>native declaration : /tmp/opus_defines.h</i> */
	public static final int OPUS_APPLICATION_VOIP = (int)2048;
	/** <i>native declaration : /tmp/opus_defines.h</i> */
	public static final int OPUS_SIGNAL_VOICE = (int)3001;
	/** <i>native declaration : /tmp/opus_defines.h</i> */
	public static final int OPUS_GET_FINAL_RANGE_REQUEST = (int)4031;
	/** <i>native declaration : /tmp/opus_defines.h</i> */
	public static final int OPUS_BUFFER_TOO_SMALL = (int)-2;
	/** <i>native declaration : /tmp/opus_defines.h</i> */
	public static final int OPUS_SET_COMPLEXITY_REQUEST = (int)4010;
	/** <i>native declaration : /tmp/opus_defines.h</i> */
	public static final int OPUS_FRAMESIZE_ARG = (int)5000;
	/** <i>native declaration : /tmp/opus_defines.h</i> */
	public static final int OPUS_GET_LOOKAHEAD_REQUEST = (int)4027;
	/** <i>native declaration : /tmp/opus_defines.h</i> */
	public static final int OPUS_GET_INBAND_FEC_REQUEST = (int)4013;
	/** <i>native declaration : /tmp/opus_defines.h</i> */
	public static final int OPUS_BITRATE_MAX = (int)-1;
	/** <i>native declaration : /tmp/opus_defines.h</i> */
	public static final int OPUS_FRAMESIZE_5_MS = (int)5002;
	/** <i>native declaration : /tmp/opus_defines.h</i> */
	public static final int OPUS_BAD_ARG = (int)-1;
	/** <i>native declaration : /tmp/opus_defines.h</i> */
	public static final int OPUS_GET_PITCH_REQUEST = (int)4033;
	/** <i>native declaration : /tmp/opus_defines.h</i> */
	public static final int OPUS_SET_SIGNAL_REQUEST = (int)4024;
	/** <i>native declaration : /tmp/opus_defines.h</i> */
	public static final int OPUS_FRAMESIZE_20_MS = (int)5004;
	/** <i>native declaration : /tmp/opus_defines.h</i> */
	public static final int OPUS_APPLICATION_AUDIO = (int)2049;
	/** <i>native declaration : /tmp/opus_defines.h</i> */
	public static final int OPUS_GET_DTX_REQUEST = (int)4017;
	/** <i>native declaration : /tmp/opus_defines.h</i> */
	public static final int OPUS_FRAMESIZE_10_MS = (int)5003;
	/** <i>native declaration : /tmp/opus_defines.h</i> */
	public static final int OPUS_SET_LSB_DEPTH_REQUEST = (int)4036;
	/** <i>native declaration : /tmp/opus_defines.h</i> */
	public static final int OPUS_UNIMPLEMENTED = (int)-5;
	/** <i>native declaration : /tmp/opus_defines.h</i> */
	public static final int OPUS_GET_PACKET_LOSS_PERC_REQUEST = (int)4015;
	/** <i>native declaration : /tmp/opus_defines.h</i> */
	public static final int OPUS_INVALID_STATE = (int)-6;
	/** <i>native declaration : /tmp/opus_defines.h</i> */
	public static final int OPUS_SET_EXPERT_FRAME_DURATION_REQUEST = (int)4040;
	/** <i>native declaration : /tmp/opus_defines.h</i> */
	public static final int OPUS_FRAMESIZE_60_MS = (int)5006;
	/** <i>native declaration : /tmp/opus_defines.h</i> */
	public static final int OPUS_GET_BITRATE_REQUEST = (int)4003;
	/** <i>native declaration : /tmp/opus_defines.h</i> */
	public static final int OPUS_INTERNAL_ERROR = (int)-3;
	/** <i>native declaration : /tmp/opus_defines.h</i> */
	public static final int OPUS_SET_MAX_BANDWIDTH_REQUEST = (int)4004;
	/** <i>native declaration : /tmp/opus_defines.h</i> */
	public static final int OPUS_SET_VBR_CONSTRAINT_REQUEST = (int)4020;
	/** <i>native declaration : /tmp/opus_defines.h</i> */
	public static final int OPUS_GET_MAX_BANDWIDTH_REQUEST = (int)4005;
	/** <i>native declaration : /tmp/opus_defines.h</i> */
	public static final int OPUS_BANDWIDTH_NARROWBAND = (int)1101;
	/** <i>native declaration : /tmp/opus_defines.h</i> */
	public static final int OPUS_SET_GAIN_REQUEST = (int)4034;
	/** <i>native declaration : /tmp/opus_defines.h</i> */
	public static final int OPUS_SET_PREDICTION_DISABLED_REQUEST = (int)4042;
	/** <i>native declaration : /tmp/opus_defines.h</i> */
	public static final int OPUS_SET_APPLICATION_REQUEST = (int)4000;
	/** <i>native declaration : /tmp/opus_defines.h</i> */
	public static final int OPUS_SET_DTX_REQUEST = (int)4016;
	/** <i>native declaration : /tmp/opus_defines.h</i> */
	public static final int OPUS_BANDWIDTH_MEDIUMBAND = (int)1102;
	/** <i>native declaration : /tmp/opus_defines.h</i> */
	public static final int OPUS_GET_SAMPLE_RATE_REQUEST = (int)4029;
	/** <i>native declaration : /tmp/opus_defines.h</i> */
	public static final int OPUS_GET_EXPERT_FRAME_DURATION_REQUEST = (int)4041;
	/** <i>native declaration : /tmp/opus_defines.h</i> */
	public static final int OPUS_AUTO = (int)-1000;
	/** <i>native declaration : /tmp/opus_defines.h</i> */
	public static final int OPUS_GET_SIGNAL_REQUEST = (int)4025;
	/** <i>native declaration : /tmp/opus_defines.h</i> */
	public static final int OPUS_GET_LAST_PACKET_DURATION_REQUEST = (int)4039;
	/** <i>native declaration : /tmp/opus_defines.h</i> */
	public static final int OPUS_GET_PREDICTION_DISABLED_REQUEST = (int)4043;
	/** <i>native declaration : /tmp/opus_defines.h</i> */
	public static final int OPUS_GET_GAIN_REQUEST = (int)4045;
	/** <i>native declaration : /tmp/opus_defines.h</i> */
	public static final int OPUS_BANDWIDTH_WIDEBAND = (int)1103;
	/** <i>native declaration : /tmp/opus_defines.h</i> */
	public static final int OPUS_INVALID_PACKET = (int)-4;
	/** <i>native declaration : /tmp/opus_defines.h</i> */
	public static final int OPUS_ALLOC_FAIL = (int)-7;
	/** <i>native declaration : /tmp/opus_defines.h</i> */
	public static final int OPUS_OK = (int)0;
	
	/** <i>native declaration : /tmp/opus_multistream.h</i> */
	public static final int OPUS_MULTISTREAM_GET_DECODER_STATE_REQUEST = (int)5122;
	/** <i>native declaration : /tmp/opus_multistream.h</i> */
	public static final int OPUS_MULTISTREAM_GET_ENCODER_STATE_REQUEST = (int)5120;
	
	/**
	 * Gets the size of an <code>OpusEncoder</code> structure.<br>
	 * @param[in] channels <tt>int</tt>: Number of channels.<br>
	 *                                   This must be 1 or 2.<br>
	 * @returns The size in bytes.<br>
	 * Original signature : <code>int opus_encoder_get_size(int)</code><br>
	 * <i>native declaration : /tmp/opus.h:134</i>
	 */
	int opus_encoder_get_size(int channels);
	/**
	 * Allocates and initializes an encoder state.<br>
	 * There are three coding modes:<br>
	 * * @ref OPUS_APPLICATION_VOIP gives best quality at a given bitrate for voice<br>
	 *    signals. It enhances the  input signal by high-pass filtering and<br>
	 *    emphasizing formants and harmonics. Optionally  it includes in-band<br>
	 *    forward error correction to protect against packet loss. Use this<br>
	 *    mode for typical VoIP applications. Because of the enhancement,<br>
	 *    even at high bitrates the output may sound different from the input.<br>
	 * * @ref OPUS_APPLICATION_AUDIO gives best quality at a given bitrate for most<br>
	 *    non-voice signals like music. Use this mode for music and mixed<br>
	 *    (music/voice) content, broadcast, and applications requiring less<br>
	 *    than 15 ms of coding delay.<br>
	 * * @ref OPUS_APPLICATION_RESTRICTED_LOWDELAY configures low-delay mode that<br>
	 *    disables the speech-optimized mode in exchange for slightly reduced delay.<br>
	 *    This mode can only be set on an newly initialized or freshly reset encoder<br>
	 *    because it changes the codec delay.<br>
	 * * This is useful when the caller knows that the speech-optimized modes will not be needed (use with caution).<br>
	 * @param [in] Fs <tt>opus_int32</tt>: Sampling rate of input signal (Hz)<br>
	 *                                     This must be one of 8000, 12000, 16000,<br>
	 *                                     24000, or 48000.<br>
	 * @param [in] channels <tt>int</tt>: Number of channels (1 or 2) in input signal<br>
	 * @param [in] application <tt>int</tt>: Coding mode (@ref OPUS_APPLICATION_VOIP/@ref OPUS_APPLICATION_AUDIO/@ref OPUS_APPLICATION_RESTRICTED_LOWDELAY)<br>
	 * @param [out] error <tt>int*</tt>: @ref opus_errorcodes<br>
	 * @note Regardless of the sampling rate and number channels selected, the Opus encoder<br>
	 * can switch to a lower audio bandwidth or number of channels if the bitrate<br>
	 * selected is too low. This also means that it is safe to always use 48 kHz stereo input<br>
	 * and let the encoder optimize the encoding.<br>
	 * Original signature : <code>OpusEncoder* opus_encoder_create(opus_int32, int, int, int*)</code><br>
	 * <i>native declaration : /tmp/opus.h:171</i>
	 */
	PointerByReference opus_encoder_create(int Fs, int channels, int application, IntBuffer error);
	/**
	 * Initializes a previously allocated encoder state<br>
	 * The memory pointed to by st must be at least the size returned by opus_encoder_get_size().<br>
	 * This is intended for applications which use their own allocator instead of malloc.<br>
	 * @see opus_encoder_create(),opus_encoder_get_size()<br>
	 * To reset a previously initialized state, use the #OPUS_RESET_STATE CTL.<br>
	 * @param [in] st <tt>OpusEncoder*</tt>: Encoder state<br>
	 * @param [in] Fs <tt>opus_int32</tt>: Sampling rate of input signal (Hz)<br>
	 *                                      This must be one of 8000, 12000, 16000,<br>
	 *                                      24000, or 48000.<br>
	 * @param [in] channels <tt>int</tt>: Number of channels (1 or 2) in input signal<br>
	 * @param [in] application <tt>int</tt>: Coding mode (OPUS_APPLICATION_VOIP/OPUS_APPLICATION_AUDIO/OPUS_APPLICATION_RESTRICTED_LOWDELAY)<br>
	 * @retval #OPUS_OK Success or @ref opus_errorcodes<br>
	 * Original signature : <code>int opus_encoder_init(OpusEncoder*, opus_int32, int, int)</code><br>
	 * <i>native declaration : /tmp/opus.h:191</i>
	 */
	int opus_encoder_init(PointerByReference st, int Fs, int channels, int application);
	/**
	 * Encodes an Opus frame.<br>
	 * @param [in] st <tt>OpusEncoder*</tt>: Encoder state<br>
	 * @param [in] pcm <tt>opus_int16*</tt>: Input signal (interleaved if 2 channels). length is frame_size*channels*sizeof(opus_int16)<br>
	 * @param [in] frame_size <tt>int</tt>: Number of samples per channel in the<br>
	 *                                      input signal.<br>
	 *                                      This must be an Opus frame size for<br>
	 *                                      the encoder's sampling rate.<br>
	 *                                      For example, at 48 kHz the permitted<br>
	 *                                      values are 120, 240, 480, 960, 1920,<br>
	 *                                      and 2880.<br>
	 *                                      Passing in a duration of less than<br>
	 *                                      10 ms (480 samples at 48 kHz) will<br>
	 *                                      prevent the encoder from using the LPC<br>
	 *                                      or hybrid modes.<br>
	 * @param [out] data <tt>unsigned char*</tt>: Output payload.<br>
	 *                                            This must contain storage for at<br>
	 *                                            least \a max_data_bytes.<br>
	 * @param [in] max_data_bytes <tt>opus_int32</tt>: Size of the allocated<br>
	 *                                                 memory for the output<br>
	 *                                                 payload. This may be<br>
	 *                                                 used to impose an upper limit on<br>
	 *                                                 the instant bitrate, but should<br>
	 *                                                 not be used as the only bitrate<br>
	 *                                                 control. Use #OPUS_SET_BITRATE to<br>
	 *                                                 control the bitrate.<br>
	 * @returns The length of the encoded packet (in bytes) on success or a<br>
	 *          negative error code (see @ref opus_errorcodes) on failure.<br>
	 * Original signature : <code>opus_int32 opus_encode(OpusEncoder*, const opus_int16*, int, unsigned char*, opus_int32)</code><br>
	 * <i>native declaration : /tmp/opus.h:226</i>
	 */
	int opus_encode(PointerByReference st, ShortBuffer pcm, int frame_size, ByteBuffer data, int max_data_bytes);
	/**
	 * Encodes an Opus frame.<br>
	 * @param [in] st <tt>OpusEncoder*</tt>: Encoder state<br>
	 * @param [in] pcm <tt>opus_int16*</tt>: Input signal (interleaved if 2 channels). length is frame_size*channels*sizeof(opus_int16)<br>
	 * @param [in] frame_size <tt>int</tt>: Number of samples per channel in the<br>
	 *                                      input signal.<br>
	 *                                      This must be an Opus frame size for<br>
	 *                                      the encoder's sampling rate.<br>
	 *                                      For example, at 48 kHz the permitted<br>
	 *                                      values are 120, 240, 480, 960, 1920,<br>
	 *                                      and 2880.<br>
	 *                                      Passing in a duration of less than<br>
	 *                                      10 ms (480 samples at 48 kHz) will<br>
	 *                                      prevent the encoder from using the LPC<br>
	 *                                      or hybrid modes.<br>
	 * @param [out] data <tt>unsigned char*</tt>: Output payload.<br>
	 *                                            This must contain storage for at<br>
	 *                                            least \a max_data_bytes.<br>
	 * @param [in] max_data_bytes <tt>opus_int32</tt>: Size of the allocated<br>
	 *                                                 memory for the output<br>
	 *                                                 payload. This may be<br>
	 *                                                 used to impose an upper limit on<br>
	 *                                                 the instant bitrate, but should<br>
	 *                                                 not be used as the only bitrate<br>
	 *                                                 control. Use #OPUS_SET_BITRATE to<br>
	 *                                                 control the bitrate.<br>
	 * @returns The length of the encoded packet (in bytes) on success or a<br>
	 *          negative error code (see @ref opus_errorcodes) on failure.<br>
	 * Original signature : <code>opus_int32 opus_encode(OpusEncoder*, const opus_int16*, int, unsigned char*, opus_int32)</code><br>
	 * <i>native declaration : /tmp/opus.h:226</i>
	 */
	int opus_encode(PointerByReference st, ShortByReference pcm, int frame_size, Pointer data, int max_data_bytes);
	/**
	 * Encodes an Opus frame from floating point input.<br>
	 * @param [in] st <tt>OpusEncoder*</tt>: Encoder state<br>
	 * @param [in] pcm <tt>float*</tt>: Input in float format (interleaved if 2 channels), with a normal range of +/-1.0.<br>
	 *          Samples with a range beyond +/-1.0 are supported but will<br>
	 *          be clipped by decoders using the integer API and should<br>
	 *          only be used if it is known that the far end supports<br>
	 *          extended dynamic range.<br>
	 *          length is frame_size*channels*sizeof(float)<br>
	 * @param [in] frame_size <tt>int</tt>: Number of samples per channel in the<br>
	 *                                      input signal.<br>
	 *                                      This must be an Opus frame size for<br>
	 *                                      the encoder's sampling rate.<br>
	 *                                      For example, at 48 kHz the permitted<br>
	 *                                      values are 120, 240, 480, 960, 1920,<br>
	 *                                      and 2880.<br>
	 *                                      Passing in a duration of less than<br>
	 *                                      10 ms (480 samples at 48 kHz) will<br>
	 *                                      prevent the encoder from using the LPC<br>
	 *                                      or hybrid modes.<br>
	 * @param [out] data <tt>unsigned char*</tt>: Output payload.<br>
	 *                                            This must contain storage for at<br>
	 *                                            least \a max_data_bytes.<br>
	 * @param [in] max_data_bytes <tt>opus_int32</tt>: Size of the allocated<br>
	 *                                                 memory for the output<br>
	 *                                                 payload. This may be<br>
	 *                                                 used to impose an upper limit on<br>
	 *                                                 the instant bitrate, but should<br>
	 *                                                 not be used as the only bitrate<br>
	 *                                                 control. Use #OPUS_SET_BITRATE to<br>
	 *                                                 control the bitrate.<br>
	 * @returns The length of the encoded packet (in bytes) on success or a<br>
	 *          negative error code (see @ref opus_errorcodes) on failure.<br>
	 * Original signature : <code>opus_int32 opus_encode_float(OpusEncoder*, const float*, int, unsigned char*, opus_int32)</code><br>
	 * <i>native declaration : /tmp/opus.h:267</i>
	 */
	int opus_encode_float(PointerByReference st, float pcm[], int frame_size, ByteBuffer data, int max_data_bytes);
	/**
	 * Encodes an Opus frame from floating point input.<br>
	 * @param [in] st <tt>OpusEncoder*</tt>: Encoder state<br>
	 * @param [in] pcm <tt>float*</tt>: Input in float format (interleaved if 2 channels), with a normal range of +/-1.0.<br>
	 *          Samples with a range beyond +/-1.0 are supported but will<br>
	 *          be clipped by decoders using the integer API and should<br>
	 *          only be used if it is known that the far end supports<br>
	 *          extended dynamic range.<br>
	 *          length is frame_size*channels*sizeof(float)<br>
	 * @param [in] frame_size <tt>int</tt>: Number of samples per channel in the<br>
	 *                                      input signal.<br>
	 *                                      This must be an Opus frame size for<br>
	 *                                      the encoder's sampling rate.<br>
	 *                                      For example, at 48 kHz the permitted<br>
	 *                                      values are 120, 240, 480, 960, 1920,<br>
	 *                                      and 2880.<br>
	 *                                      Passing in a duration of less than<br>
	 *                                      10 ms (480 samples at 48 kHz) will<br>
	 *                                      prevent the encoder from using the LPC<br>
	 *                                      or hybrid modes.<br>
	 * @param [out] data <tt>unsigned char*</tt>: Output payload.<br>
	 *                                            This must contain storage for at<br>
	 *                                            least \a max_data_bytes.<br>
	 * @param [in] max_data_bytes <tt>opus_int32</tt>: Size of the allocated<br>
	 *                                                 memory for the output<br>
	 *                                                 payload. This may be<br>
	 *                                                 used to impose an upper limit on<br>
	 *                                                 the instant bitrate, but should<br>
	 *                                                 not be used as the only bitrate<br>
	 *                                                 control. Use #OPUS_SET_BITRATE to<br>
	 *                                                 control the bitrate.<br>
	 * @returns The length of the encoded packet (in bytes) on success or a<br>
	 *          negative error code (see @ref opus_errorcodes) on failure.<br>
	 * Original signature : <code>opus_int32 opus_encode_float(OpusEncoder*, const float*, int, unsigned char*, opus_int32)</code><br>
	 * <i>native declaration : /tmp/opus.h:267</i>
	 */
	int opus_encode_float(PointerByReference st, FloatByReference pcm, int frame_size, Pointer data, int max_data_bytes);
	/**
	 * Frees an <code>OpusEncoder</code> allocated by opus_encoder_create().<br>
	 * @param[in] st <tt>OpusEncoder*</tt>: State to be freed.<br>
	 * Original signature : <code>void opus_encoder_destroy(OpusEncoder*)</code><br>
	 * <i>native declaration : /tmp/opus.h:278</i>
	 */
	void opus_encoder_destroy(PointerByReference st);
	/**
	 * Perform a CTL function on an Opus encoder.<br>
	 * * Generally the request and subsequent arguments are generated<br>
	 * by a convenience macro.<br>
	 * @param st <tt>OpusEncoder*</tt>: Encoder state.<br>
	 * @param request This and all remaining parameters should be replaced by one<br>
	 *                of the convenience macros in @ref opus_genericctls or<br>
	 *                @ref opus_encoderctls.<br>
	 * @see opus_genericctls<br>
	 * @see opus_encoderctls<br>
	 * Original signature : <code>int opus_encoder_ctl(OpusEncoder*, int, null)</code><br>
	 * <i>native declaration : /tmp/opus.h:291</i>
	 */
	int opus_encoder_ctl(PointerByReference st, int request, Object... varargs);
	/**
	 * Gets the size of an <code>OpusDecoder</code> structure.<br>
	 * @param [in] channels <tt>int</tt>: Number of channels.<br>
	 *                                    This must be 1 or 2.<br>
	 * @returns The size in bytes.<br>
	 * Original signature : <code>int opus_decoder_get_size(int)</code><br>
	 * <i>native declaration : /tmp/opus.h:369</i>
	 */
	int opus_decoder_get_size(int channels);
	/**
	 * Allocates and initializes a decoder state.<br>
	 * @param [in] Fs <tt>opus_int32</tt>: Sample rate to decode at (Hz).<br>
	 *                                     This must be one of 8000, 12000, 16000,<br>
	 *                                     24000, or 48000.<br>
	 * @param [in] channels <tt>int</tt>: Number of channels (1 or 2) to decode<br>
	 * @param [out] error <tt>int*</tt>: #OPUS_OK Success or @ref opus_errorcodes<br>
	 * * Internally Opus stores data at 48000 Hz, so that should be the default<br>
	 * value for Fs. However, the decoder can efficiently decode to buffers<br>
	 * at 8, 12, 16, and 24 kHz so if for some reason the caller cannot use<br>
	 * data at the full sample rate, or knows the compressed data doesn't<br>
	 * use the full frequency range, it can request decoding at a reduced<br>
	 * rate. Likewise, the decoder is capable of filling in either mono or<br>
	 * interleaved stereo pcm buffers, at the caller's request.<br>
	 * Original signature : <code>OpusDecoder* opus_decoder_create(opus_int32, int, int*)</code><br>
	 * <i>native declaration : /tmp/opus.h:386</i>
	 */
	PointerByReference opus_decoder_create(int Fs, int channels, IntBuffer error);
	/**
	 * Initializes a previously allocated decoder state.<br>
	 * The state must be at least the size returned by opus_decoder_get_size().<br>
	 * This is intended for applications which use their own allocator instead of malloc. @see opus_decoder_create,opus_decoder_get_size<br>
	 * To reset a previously initialized state, use the #OPUS_RESET_STATE CTL.<br>
	 * @param [in] st <tt>OpusDecoder*</tt>: Decoder state.<br>
	 * @param [in] Fs <tt>opus_int32</tt>: Sampling rate to decode to (Hz).<br>
	 *                                     This must be one of 8000, 12000, 16000,<br>
	 *                                     24000, or 48000.<br>
	 * @param [in] channels <tt>int</tt>: Number of channels (1 or 2) to decode<br>
	 * @retval #OPUS_OK Success or @ref opus_errorcodes<br>
	 * Original signature : <code>int opus_decoder_init(OpusDecoder*, opus_int32, int)</code><br>
	 * <i>native declaration : /tmp/opus.h:403</i>
	 */
	int opus_decoder_init(PointerByReference st, int Fs, int channels);
	/**
	 * Decode an Opus packet.<br>
	 * @param [in] st <tt>OpusDecoder*</tt>: Decoder state<br>
	 * @param [in] data <tt>char*</tt>: Input payload. Use a NULL pointer to indicate packet loss<br>
	 * @param [in] len <tt>opus_int32</tt>: Number of bytes in payload*<br>
	 * @param [out] pcm <tt>opus_int16*</tt>: Output signal (interleaved if 2 channels). length<br>
	 *  is frame_size*channels*sizeof(opus_int16)<br>
	 * @param [in] frame_size Number of samples per channel of available space in \a pcm.<br>
	 *  If this is less than the maximum packet duration (120ms; 5760 for 48kHz), this function will<br>
	 *  not be capable of decoding some packets. In the case of PLC (data==NULL) or FEC (decode_fec=1),<br>
	 *  then frame_size needs to be exactly the duration of audio that is missing, otherwise the<br>
	 *  decoder will not be in the optimal state to decode the next incoming packet. For the PLC and<br>
	 *  FEC cases, frame_size <b>must</b> be a multiple of 2.5 ms.<br>
	 * @param [in] decode_fec <tt>int</tt>: Flag (0 or 1) to request that any in-band forward error correction data be<br>
	 *  decoded. If no such data is available, the frame is decoded as if it were lost.<br>
	 * @returns Number of decoded samples or @ref opus_errorcodes<br>
	 * Original signature : <code>int opus_decode(OpusDecoder*, const unsigned char*, opus_int32, opus_int16*, int, int)</code><br>
	 * <i>native declaration : /tmp/opus.h:425</i>
	 */
	int opus_decode(PointerByReference st, byte data[], int len, ShortBuffer pcm, int frame_size, int decode_fec);
	/**
	 * Decode an Opus packet.<br>
	 * @param [in] st <tt>OpusDecoder*</tt>: Decoder state<br>
	 * @param [in] data <tt>char*</tt>: Input payload. Use a NULL pointer to indicate packet loss<br>
	 * @param [in] len <tt>opus_int32</tt>: Number of bytes in payload*<br>
	 * @param [out] pcm <tt>opus_int16*</tt>: Output signal (interleaved if 2 channels). length<br>
	 *  is frame_size*channels*sizeof(opus_int16)<br>
	 * @param [in] frame_size Number of samples per channel of available space in \a pcm.<br>
	 *  If this is less than the maximum packet duration (120ms; 5760 for 48kHz), this function will<br>
	 *  not be capable of decoding some packets. In the case of PLC (data==NULL) or FEC (decode_fec=1),<br>
	 *  then frame_size needs to be exactly the duration of audio that is missing, otherwise the<br>
	 *  decoder will not be in the optimal state to decode the next incoming packet. For the PLC and<br>
	 *  FEC cases, frame_size <b>must</b> be a multiple of 2.5 ms.<br>
	 * @param [in] decode_fec <tt>int</tt>: Flag (0 or 1) to request that any in-band forward error correction data be<br>
	 *  decoded. If no such data is available, the frame is decoded as if it were lost.<br>
	 * @returns Number of decoded samples or @ref opus_errorcodes<br>
	 * Original signature : <code>int opus_decode(OpusDecoder*, const unsigned char*, opus_int32, opus_int16*, int, int)</code><br>
	 * <i>native declaration : /tmp/opus.h:425</i>
	 */
	int opus_decode(PointerByReference st, Pointer data, int len, ShortByReference pcm, int frame_size, int decode_fec);
	/**
	 * Decode an Opus packet with floating point output.<br>
	 * @param [in] st <tt>OpusDecoder*</tt>: Decoder state<br>
	 * @param [in] data <tt>char*</tt>: Input payload. Use a NULL pointer to indicate packet loss<br>
	 * @param [in] len <tt>opus_int32</tt>: Number of bytes in payload<br>
	 * @param [out] pcm <tt>float*</tt>: Output signal (interleaved if 2 channels). length<br>
	 *  is frame_size*channels*sizeof(float)<br>
	 * @param [in] frame_size Number of samples per channel of available space in \a pcm.<br>
	 *  If this is less than the maximum packet duration (120ms; 5760 for 48kHz), this function will<br>
	 *  not be capable of decoding some packets. In the case of PLC (data==NULL) or FEC (decode_fec=1),<br>
	 *  then frame_size needs to be exactly the duration of audio that is missing, otherwise the<br>
	 *  decoder will not be in the optimal state to decode the next incoming packet. For the PLC and<br>
	 *  FEC cases, frame_size <b>must</b> be a multiple of 2.5 ms.<br>
	 * @param [in] decode_fec <tt>int</tt>: Flag (0 or 1) to request that any in-band forward error correction data be<br>
	 *  decoded. If no such data is available the frame is decoded as if it were lost.<br>
	 * @returns Number of decoded samples or @ref opus_errorcodes<br>
	 * Original signature : <code>int opus_decode_float(OpusDecoder*, const unsigned char*, opus_int32, float*, int, int)</code><br>
	 * <i>native declaration : /tmp/opus.h:450</i>
	 */
	int opus_decode_float(PointerByReference st, byte data[], int len, FloatBuffer pcm, int frame_size, int decode_fec);
	/**
	 * Decode an Opus packet with floating point output.<br>
	 * @param [in] st <tt>OpusDecoder*</tt>: Decoder state<br>
	 * @param [in] data <tt>char*</tt>: Input payload. Use a NULL pointer to indicate packet loss<br>
	 * @param [in] len <tt>opus_int32</tt>: Number of bytes in payload<br>
	 * @param [out] pcm <tt>float*</tt>: Output signal (interleaved if 2 channels). length<br>
	 *  is frame_size*channels*sizeof(float)<br>
	 * @param [in] frame_size Number of samples per channel of available space in \a pcm.<br>
	 *  If this is less than the maximum packet duration (120ms; 5760 for 48kHz), this function will<br>
	 *  not be capable of decoding some packets. In the case of PLC (data==NULL) or FEC (decode_fec=1),<br>
	 *  then frame_size needs to be exactly the duration of audio that is missing, otherwise the<br>
	 *  decoder will not be in the optimal state to decode the next incoming packet. For the PLC and<br>
	 *  FEC cases, frame_size <b>must</b> be a multiple of 2.5 ms.<br>
	 * @param [in] decode_fec <tt>int</tt>: Flag (0 or 1) to request that any in-band forward error correction data be<br>
	 *  decoded. If no such data is available the frame is decoded as if it were lost.<br>
	 * @returns Number of decoded samples or @ref opus_errorcodes<br>
	 * Original signature : <code>int opus_decode_float(OpusDecoder*, const unsigned char*, opus_int32, float*, int, int)</code><br>
	 * <i>native declaration : /tmp/opus.h:450</i>
	 */
	int opus_decode_float(PointerByReference st, Pointer data, int len, FloatByReference pcm, int frame_size, int decode_fec);
	/**
	 * Perform a CTL function on an Opus decoder.<br>
	 * * Generally the request and subsequent arguments are generated<br>
	 * by a convenience macro.<br>
	 * @param st <tt>OpusDecoder*</tt>: Decoder state.<br>
	 * @param request This and all remaining parameters should be replaced by one<br>
	 *                of the convenience macros in @ref opus_genericctls or<br>
	 *                @ref opus_decoderctls.<br>
	 * @see opus_genericctls<br>
	 * @see opus_decoderctls<br>
	 * Original signature : <code>int opus_decoder_ctl(OpusDecoder*, int, null)</code><br>
	 * <i>native declaration : /tmp/opus.h:470</i>
	 */
	int opus_decoder_ctl(PointerByReference st, int request, Object... varargs);
	/**
	 * Frees an <code>OpusDecoder</code> allocated by opus_decoder_create().<br>
	 * @param[in] st <tt>OpusDecoder*</tt>: State to be freed.<br>
	 * Original signature : <code>void opus_decoder_destroy(OpusDecoder*)</code><br>
	 * <i>native declaration : /tmp/opus.h:475</i>
	 */
	void opus_decoder_destroy(PointerByReference st);
	/**
	 * Parse an opus packet into one or more frames.<br>
	 * Opus_decode will perform this operation internally so most applications do<br>
	 * not need to use this function.<br>
	 * This function does not copy the frames, the returned pointers are pointers into<br>
	 * the input packet.<br>
	 * @param [in] data <tt>char*</tt>: Opus packet to be parsed<br>
	 * @param [in] len <tt>opus_int32</tt>: size of data<br>
	 * @param [out] out_toc <tt>char*</tt>: TOC pointer<br>
	 * @param [out] frames <tt>char*[48]</tt> encapsulated frames<br>
	 * @param [out] size <tt>opus_int16[48]</tt> sizes of the encapsulated frames<br>
	 * @param [out] payload_offset <tt>int*</tt>: returns the position of the payload within the packet (in bytes)<br>
	 * @returns number of frames<br>
	 * Original signature : <code>int opus_packet_parse(const unsigned char*, opus_int32, unsigned char*, const unsigned char*[48], opus_int16[48], int*)</code><br>
	 * <i>native declaration : /tmp/opus.h:490</i>
	 */
	int opus_packet_parse(byte data[], int len, ByteBuffer out_toc, byte frames[], ShortBuffer size, IntBuffer payload_offset);
	/**
	 * Gets the bandwidth of an Opus packet.<br>
	 * @param [in] data <tt>char*</tt>: Opus packet<br>
	 * @retval OPUS_BANDWIDTH_NARROWBAND Narrowband (4kHz bandpass)<br>
	 * @retval OPUS_BANDWIDTH_MEDIUMBAND Mediumband (6kHz bandpass)<br>
	 * @retval OPUS_BANDWIDTH_WIDEBAND Wideband (8kHz bandpass)<br>
	 * @retval OPUS_BANDWIDTH_SUPERWIDEBAND Superwideband (12kHz bandpass)<br>
	 * @retval OPUS_BANDWIDTH_FULLBAND Fullband (20kHz bandpass)<br>
	 * @retval OPUS_INVALID_PACKET The compressed data passed is corrupted or of an unsupported type<br>
	 * Original signature : <code>int opus_packet_get_bandwidth(const unsigned char*)</code><br>
	 * <i>native declaration : /tmp/opus.h:508</i>
	 */
	int opus_packet_get_bandwidth(byte data[]);
	/**
	 * Gets the number of samples per frame from an Opus packet.<br>
	 * @param [in] data <tt>char*</tt>: Opus packet.<br>
	 *                                  This must contain at least one byte of<br>
	 *                                  data.<br>
	 * @param [in] Fs <tt>opus_int32</tt>: Sampling rate in Hz.<br>
	 *                                     This must be a multiple of 400, or<br>
	 *                                     inaccurate results will be returned.<br>
	 * @returns Number of samples per frame.<br>
	 * Original signature : <code>int opus_packet_get_samples_per_frame(const unsigned char*, opus_int32)</code><br>
	 * <i>native declaration : /tmp/opus.h:519</i>
	 */
	int opus_packet_get_samples_per_frame(byte data[], int Fs);
	/**
	 * Gets the number of channels from an Opus packet.<br>
	 * @param [in] data <tt>char*</tt>: Opus packet<br>
	 * @returns Number of channels<br>
	 * @retval OPUS_INVALID_PACKET The compressed data passed is corrupted or of an unsupported type<br>
	 * Original signature : <code>int opus_packet_get_nb_channels(const unsigned char*)</code><br>
	 * <i>native declaration : /tmp/opus.h:526</i>
	 */
	int opus_packet_get_nb_channels(byte data[]);
	/**
	 * Gets the number of frames in an Opus packet.<br>
	 * @param [in] packet <tt>char*</tt>: Opus packet<br>
	 * @param [in] len <tt>opus_int32</tt>: Length of packet<br>
	 * @returns Number of frames<br>
	 * @retval OPUS_BAD_ARG Insufficient data was passed to the function<br>
	 * @retval OPUS_INVALID_PACKET The compressed data passed is corrupted or of an unsupported type<br>
	 * Original signature : <code>int opus_packet_get_nb_frames(const unsigned char[], opus_int32)</code><br>
	 * <i>native declaration : /tmp/opus.h:535</i>
	 */
	int opus_packet_get_nb_frames(byte packet[], int len);
	/**
	 * Gets the number of samples of an Opus packet.<br>
	 * @param [in] packet <tt>char*</tt>: Opus packet<br>
	 * @param [in] len <tt>opus_int32</tt>: Length of packet<br>
	 * @param [in] Fs <tt>opus_int32</tt>: Sampling rate in Hz.<br>
	 *                                     This must be a multiple of 400, or<br>
	 *                                     inaccurate results will be returned.<br>
	 * @returns Number of samples<br>
	 * @retval OPUS_BAD_ARG Insufficient data was passed to the function<br>
	 * @retval OPUS_INVALID_PACKET The compressed data passed is corrupted or of an unsupported type<br>
	 * Original signature : <code>int opus_packet_get_nb_samples(const unsigned char[], opus_int32, opus_int32)</code><br>
	 * <i>native declaration : /tmp/opus.h:547</i>
	 */
	int opus_packet_get_nb_samples(byte packet[], int len, int Fs);
	/**
	 * Gets the number of samples of an Opus packet.<br>
	 * @param [in] dec <tt>OpusDecoder*</tt>: Decoder state<br>
	 * @param [in] packet <tt>char*</tt>: Opus packet<br>
	 * @param [in] len <tt>opus_int32</tt>: Length of packet<br>
	 * @returns Number of samples<br>
	 * @retval OPUS_BAD_ARG Insufficient data was passed to the function<br>
	 * @retval OPUS_INVALID_PACKET The compressed data passed is corrupted or of an unsupported type<br>
	 * Original signature : <code>int opus_decoder_get_nb_samples(const OpusDecoder*, const unsigned char[], opus_int32)</code><br>
	 * <i>native declaration : /tmp/opus.h:557</i>
	 */
	int opus_decoder_get_nb_samples(PointerByReference dec, byte packet[], int len);
	/**
	 * Gets the number of samples of an Opus packet.<br>
	 * @param [in] dec <tt>OpusDecoder*</tt>: Decoder state<br>
	 * @param [in] packet <tt>char*</tt>: Opus packet<br>
	 * @param [in] len <tt>opus_int32</tt>: Length of packet<br>
	 * @returns Number of samples<br>
	 * @retval OPUS_BAD_ARG Insufficient data was passed to the function<br>
	 * @retval OPUS_INVALID_PACKET The compressed data passed is corrupted or of an unsupported type<br>
	 * Original signature : <code>int opus_decoder_get_nb_samples(const OpusDecoder*, const unsigned char[], opus_int32)</code><br>
	 * <i>native declaration : /tmp/opus.h:557</i>
	 */
	int opus_decoder_get_nb_samples(PointerByReference dec, Pointer packet, int len);
	/**
	 * Applies soft-clipping to bring a float signal within the [-1,1] range. If<br>
	 * the signal is already in that range, nothing is done. If there are values<br>
	 * outside of [-1,1], then the signal is clipped as smoothly as possible to<br>
	 * both fit in the range and avoid creating excessive distortion in the<br>
	 * process.<br>
	 * @param [in,out] pcm <tt>float*</tt>: Input PCM and modified PCM<br>
	 * @param [in] frame_size <tt>int</tt> Number of samples per channel to process<br>
	 * @param [in] channels <tt>int</tt>: Number of channels<br>
	 * @param [in,out] softclip_mem <tt>float*</tt>: State memory for the soft clipping process (one float per channel, initialized to zero)<br>
	 * Original signature : <code>void opus_pcm_soft_clip(float*, int, int, float*)</code><br>
	 * <i>native declaration : /tmp/opus.h:569</i>
	 */
	void opus_pcm_soft_clip(FloatBuffer pcm, int frame_size, int channels, FloatBuffer softclip_mem);
	/**
	 * Gets the size of an <code>OpusRepacketizer</code> structure.<br>
	 * @returns The size in bytes.<br>
	 * Original signature : <code>int opus_repacketizer_get_size()</code><br>
	 * <i>native declaration : /tmp/opus.h:719</i>
	 */
	int opus_repacketizer_get_size();
	/**
	 * (Re)initializes a previously allocated repacketizer state.<br>
	 * The state must be at least the size returned by opus_repacketizer_get_size().<br>
	 * This can be used for applications which use their own allocator instead of<br>
	 * malloc().<br>
	 * It must also be called to reset the queue of packets waiting to be<br>
	 * repacketized, which is necessary if the maximum packet duration of 120 ms<br>
	 * is reached or if you wish to submit packets with a different Opus<br>
	 * configuration (coding mode, audio bandwidth, frame size, or channel count).<br>
	 * Failure to do so will prevent a new packet from being added with<br>
	 * opus_repacketizer_cat().<br>
	 * @see opus_repacketizer_create<br>
	 * @see opus_repacketizer_get_size<br>
	 * @see opus_repacketizer_cat<br>
	 * @param rp <tt>OpusRepacketizer*</tt>: The repacketizer state to<br>
	 *                                       (re)initialize.<br>
	 * @returns A pointer to the same repacketizer state that was passed in.<br>
	 * Original signature : <code>OpusRepacketizer* opus_repacketizer_init(OpusRepacketizer*)</code><br>
	 * <i>native declaration : /tmp/opus.h:738</i>
	 */
	PointerByReference opus_repacketizer_init(PointerByReference rp);
	/**
	 * Allocates memory and initializes the new repacketizer with<br>
	 * opus_repacketizer_init().<br>
	 * Original signature : <code>OpusRepacketizer* opus_repacketizer_create()</code><br>
	 * <i>native declaration : /tmp/opus.h:743</i>
	 */
	PointerByReference opus_repacketizer_create();
	/**
	 * Frees an <code>OpusRepacketizer</code> allocated by<br>
	 * opus_repacketizer_create().<br>
	 * @param[in] rp <tt>OpusRepacketizer*</tt>: State to be freed.<br>
	 * Original signature : <code>void opus_repacketizer_destroy(OpusRepacketizer*)</code><br>
	 * <i>native declaration : /tmp/opus.h:749</i>
	 */
	void opus_repacketizer_destroy(PointerByReference rp);
	/**
	 * Add a packet to the current repacketizer state.<br>
	 * This packet must match the configuration of any packets already submitted<br>
	 * for repacketization since the last call to opus_repacketizer_init().<br>
	 * This means that it must have the same coding mode, audio bandwidth, frame<br>
	 * size, and channel count.<br>
	 * This can be checked in advance by examining the top 6 bits of the first<br>
	 * byte of the packet, and ensuring they match the top 6 bits of the first<br>
	 * byte of any previously submitted packet.<br>
	 * The total duration of audio in the repacketizer state also must not exceed<br>
	 * 120 ms, the maximum duration of a single packet, after adding this packet.<br>
	 * * The contents of the current repacketizer state can be extracted into new<br>
	 * packets using opus_repacketizer_out() or opus_repacketizer_out_range().<br>
	 * * In order to add a packet with a different configuration or to add more<br>
	 * audio beyond 120 ms, you must clear the repacketizer state by calling<br>
	 * opus_repacketizer_init().<br>
	 * If a packet is too large to add to the current repacketizer state, no part<br>
	 * of it is added, even if it contains multiple frames, some of which might<br>
	 * fit.<br>
	 * If you wish to be able to add parts of such packets, you should first use<br>
	 * another repacketizer to split the packet into pieces and add them<br>
	 * individually.<br>
	 * @see opus_repacketizer_out_range<br>
	 * @see opus_repacketizer_out<br>
	 * @see opus_repacketizer_init<br>
	 * @param rp <tt>OpusRepacketizer*</tt>: The repacketizer state to which to<br>
	 *                                       add the packet.<br>
	 * @param[in] data <tt>const unsigned char*</tt>: The packet data.<br>
	 *                                                The application must ensure<br>
	 *                                                this pointer remains valid<br>
	 *                                                until the next call to<br>
	 *                                                opus_repacketizer_init() or<br>
	 *                                                opus_repacketizer_destroy().<br>
	 * @param len <tt>opus_int32</tt>: The number of bytes in the packet data.<br>
	 * @returns An error code indicating whether or not the operation succeeded.<br>
	 * @retval #OPUS_OK The packet's contents have been added to the repacketizer<br>
	 *                  state.<br>
	 * @retval #OPUS_INVALID_PACKET The packet did not have a valid TOC sequence,<br>
	 *                              the packet's TOC sequence was not compatible<br>
	 *                              with previously submitted packets (because<br>
	 *                              the coding mode, audio bandwidth, frame size,<br>
	 *                              or channel count did not match), or adding<br>
	 *                              this packet would increase the total amount of<br>
	 *                              audio stored in the repacketizer state to more<br>
	 *                              than 120 ms.<br>
	 * Original signature : <code>int opus_repacketizer_cat(OpusRepacketizer*, const unsigned char*, opus_int32)</code><br>
	 * <i>native declaration : /tmp/opus.h:798</i>
	 */
	int opus_repacketizer_cat(PointerByReference rp, byte data[], int len);
	/**
	 * Add a packet to the current repacketizer state.<br>
	 * This packet must match the configuration of any packets already submitted<br>
	 * for repacketization since the last call to opus_repacketizer_init().<br>
	 * This means that it must have the same coding mode, audio bandwidth, frame<br>
	 * size, and channel count.<br>
	 * This can be checked in advance by examining the top 6 bits of the first<br>
	 * byte of the packet, and ensuring they match the top 6 bits of the first<br>
	 * byte of any previously submitted packet.<br>
	 * The total duration of audio in the repacketizer state also must not exceed<br>
	 * 120 ms, the maximum duration of a single packet, after adding this packet.<br>
	 * * The contents of the current repacketizer state can be extracted into new<br>
	 * packets using opus_repacketizer_out() or opus_repacketizer_out_range().<br>
	 * * In order to add a packet with a different configuration or to add more<br>
	 * audio beyond 120 ms, you must clear the repacketizer state by calling<br>
	 * opus_repacketizer_init().<br>
	 * If a packet is too large to add to the current repacketizer state, no part<br>
	 * of it is added, even if it contains multiple frames, some of which might<br>
	 * fit.<br>
	 * If you wish to be able to add parts of such packets, you should first use<br>
	 * another repacketizer to split the packet into pieces and add them<br>
	 * individually.<br>
	 * @see opus_repacketizer_out_range<br>
	 * @see opus_repacketizer_out<br>
	 * @see opus_repacketizer_init<br>
	 * @param rp <tt>OpusRepacketizer*</tt>: The repacketizer state to which to<br>
	 *                                       add the packet.<br>
	 * @param[in] data <tt>const unsigned char*</tt>: The packet data.<br>
	 *                                                The application must ensure<br>
	 *                                                this pointer remains valid<br>
	 *                                                until the next call to<br>
	 *                                                opus_repacketizer_init() or<br>
	 *                                                opus_repacketizer_destroy().<br>
	 * @param len <tt>opus_int32</tt>: The number of bytes in the packet data.<br>
	 * @returns An error code indicating whether or not the operation succeeded.<br>
	 * @retval #OPUS_OK The packet's contents have been added to the repacketizer<br>
	 *                  state.<br>
	 * @retval #OPUS_INVALID_PACKET The packet did not have a valid TOC sequence,<br>
	 *                              the packet's TOC sequence was not compatible<br>
	 *                              with previously submitted packets (because<br>
	 *                              the coding mode, audio bandwidth, frame size,<br>
	 *                              or channel count did not match), or adding<br>
	 *                              this packet would increase the total amount of<br>
	 *                              audio stored in the repacketizer state to more<br>
	 *                              than 120 ms.<br>
	 * Original signature : <code>int opus_repacketizer_cat(OpusRepacketizer*, const unsigned char*, opus_int32)</code><br>
	 * <i>native declaration : /tmp/opus.h:798</i>
	 */
	int opus_repacketizer_cat(PointerByReference rp, Pointer data, int len);
	/**
	 * Construct a new packet from data previously submitted to the repacketizer<br>
	 * state via opus_repacketizer_cat().<br>
	 * @param rp <tt>OpusRepacketizer*</tt>: The repacketizer state from which to<br>
	 *                                       construct the new packet.<br>
	 * @param begin <tt>int</tt>: The index of the first frame in the current<br>
	 *                            repacketizer state to include in the output.<br>
	 * @param end <tt>int</tt>: One past the index of the last frame in the<br>
	 *                          current repacketizer state to include in the<br>
	 *                          output.<br>
	 * @param[out] data <tt>const unsigned char*</tt>: The buffer in which to<br>
	 *                                                 store the output packet.<br>
	 * @param maxlen <tt>opus_int32</tt>: The maximum number of bytes to store in<br>
	 *                                    the output buffer. In order to guarantee<br>
	 *                                    success, this should be at least<br>
	 *                                    <code>1276</code> for a single frame,<br>
	 *                                    or for multiple frames,<br>
	 *                                    <code>1277*(end-begin)</code>.<br>
	 *                                    However, <code>1*(end-begin)</code> plus<br>
	 *                                    the size of all packet data submitted to<br>
	 *                                    the repacketizer since the last call to<br>
	 *                                    opus_repacketizer_init() or<br>
	 *                                    opus_repacketizer_create() is also<br>
	 *                                    sufficient, and possibly much smaller.<br>
	 * @returns The total size of the output packet on success, or an error code<br>
	 *          on failure.<br>
	 * @retval #OPUS_BAD_ARG <code>[begin,end)</code> was an invalid range of<br>
	 *                       frames (begin < 0, begin >= end, or end ><br>
	 *                       opus_repacketizer_get_nb_frames()).<br>
	 * @retval #OPUS_BUFFER_TOO_SMALL \a maxlen was insufficient to contain the<br>
	 *                                complete output packet.<br>
	 * Original signature : <code>opus_int32 opus_repacketizer_out_range(OpusRepacketizer*, int, int, unsigned char*, opus_int32)</code><br>
	 * <i>native declaration : /tmp/opus.h:832</i>
	 */
	int opus_repacketizer_out_range(PointerByReference rp, int begin, int end, ByteBuffer data, int maxlen);
	/**
	 * Construct a new packet from data previously submitted to the repacketizer<br>
	 * state via opus_repacketizer_cat().<br>
	 * @param rp <tt>OpusRepacketizer*</tt>: The repacketizer state from which to<br>
	 *                                       construct the new packet.<br>
	 * @param begin <tt>int</tt>: The index of the first frame in the current<br>
	 *                            repacketizer state to include in the output.<br>
	 * @param end <tt>int</tt>: One past the index of the last frame in the<br>
	 *                          current repacketizer state to include in the<br>
	 *                          output.<br>
	 * @param[out] data <tt>const unsigned char*</tt>: The buffer in which to<br>
	 *                                                 store the output packet.<br>
	 * @param maxlen <tt>opus_int32</tt>: The maximum number of bytes to store in<br>
	 *                                    the output buffer. In order to guarantee<br>
	 *                                    success, this should be at least<br>
	 *                                    <code>1276</code> for a single frame,<br>
	 *                                    or for multiple frames,<br>
	 *                                    <code>1277*(end-begin)</code>.<br>
	 *                                    However, <code>1*(end-begin)</code> plus<br>
	 *                                    the size of all packet data submitted to<br>
	 *                                    the repacketizer since the last call to<br>
	 *                                    opus_repacketizer_init() or<br>
	 *                                    opus_repacketizer_create() is also<br>
	 *                                    sufficient, and possibly much smaller.<br>
	 * @returns The total size of the output packet on success, or an error code<br>
	 *          on failure.<br>
	 * @retval #OPUS_BAD_ARG <code>[begin,end)</code> was an invalid range of<br>
	 *                       frames (begin < 0, begin >= end, or end ><br>
	 *                       opus_repacketizer_get_nb_frames()).<br>
	 * @retval #OPUS_BUFFER_TOO_SMALL \a maxlen was insufficient to contain the<br>
	 *                                complete output packet.<br>
	 * Original signature : <code>opus_int32 opus_repacketizer_out_range(OpusRepacketizer*, int, int, unsigned char*, opus_int32)</code><br>
	 * <i>native declaration : /tmp/opus.h:832</i>
	 */
	int opus_repacketizer_out_range(PointerByReference rp, int begin, int end, Pointer data, int maxlen);
	/**
	 * Return the total number of frames contained in packet data submitted to<br>
	 * the repacketizer state so far via opus_repacketizer_cat() since the last<br>
	 * call to opus_repacketizer_init() or opus_repacketizer_create().<br>
	 * This defines the valid range of packets that can be extracted with<br>
	 * opus_repacketizer_out_range() or opus_repacketizer_out().<br>
	 * @param rp <tt>OpusRepacketizer*</tt>: The repacketizer state containing the<br>
	 *                                       frames.<br>
	 * @returns The total number of frames contained in the packet data submitted<br>
	 *          to the repacketizer state.<br>
	 * Original signature : <code>int opus_repacketizer_get_nb_frames(OpusRepacketizer*)</code><br>
	 * <i>native declaration : /tmp/opus.h:844</i>
	 */
	int opus_repacketizer_get_nb_frames(PointerByReference rp);
	/**
	 * Construct a new packet from data previously submitted to the repacketizer<br>
	 * state via opus_repacketizer_cat().<br>
	 * This is a convenience routine that returns all the data submitted so far<br>
	 * in a single packet.<br>
	 * It is equivalent to calling<br>
	 * @code<br>
	 * opus_repacketizer_out_range(rp, 0, opus_repacketizer_get_nb_frames(rp),<br>
	 *                             data, maxlen)<br>
	 * @endcode<br>
	 * @param rp <tt>OpusRepacketizer*</tt>: The repacketizer state from which to<br>
	 *                                       construct the new packet.<br>
	 * @param[out] data <tt>const unsigned char*</tt>: The buffer in which to<br>
	 *                                                 store the output packet.<br>
	 * @param maxlen <tt>opus_int32</tt>: The maximum number of bytes to store in<br>
	 *                                    the output buffer. In order to guarantee<br>
	 *                                    success, this should be at least<br>
	 *                                    <code>1277*opus_repacketizer_get_nb_frames(rp)</code>.<br>
	 *                                    However,<br>
	 *                                    <code>1*opus_repacketizer_get_nb_frames(rp)</code><br>
	 *                                    plus the size of all packet data<br>
	 *                                    submitted to the repacketizer since the<br>
	 *                                    last call to opus_repacketizer_init() or<br>
	 *                                    opus_repacketizer_create() is also<br>
	 *                                    sufficient, and possibly much smaller.<br>
	 * @returns The total size of the output packet on success, or an error code<br>
	 *          on failure.<br>
	 * @retval #OPUS_BUFFER_TOO_SMALL \a maxlen was insufficient to contain the<br>
	 *                                complete output packet.<br>
	 * Original signature : <code>opus_int32 opus_repacketizer_out(OpusRepacketizer*, unsigned char*, opus_int32)</code><br>
	 * <i>native declaration : /tmp/opus.h:875</i>
	 */
	int opus_repacketizer_out(PointerByReference rp, ByteBuffer data, int maxlen);
	/**
	 * Construct a new packet from data previously submitted to the repacketizer<br>
	 * state via opus_repacketizer_cat().<br>
	 * This is a convenience routine that returns all the data submitted so far<br>
	 * in a single packet.<br>
	 * It is equivalent to calling<br>
	 * @code<br>
	 * opus_repacketizer_out_range(rp, 0, opus_repacketizer_get_nb_frames(rp),<br>
	 *                             data, maxlen)<br>
	 * @endcode<br>
	 * @param rp <tt>OpusRepacketizer*</tt>: The repacketizer state from which to<br>
	 *                                       construct the new packet.<br>
	 * @param[out] data <tt>const unsigned char*</tt>: The buffer in which to<br>
	 *                                                 store the output packet.<br>
	 * @param maxlen <tt>opus_int32</tt>: The maximum number of bytes to store in<br>
	 *                                    the output buffer. In order to guarantee<br>
	 *                                    success, this should be at least<br>
	 *                                    <code>1277*opus_repacketizer_get_nb_frames(rp)</code>.<br>
	 *                                    However,<br>
	 *                                    <code>1*opus_repacketizer_get_nb_frames(rp)</code><br>
	 *                                    plus the size of all packet data<br>
	 *                                    submitted to the repacketizer since the<br>
	 *                                    last call to opus_repacketizer_init() or<br>
	 *                                    opus_repacketizer_create() is also<br>
	 *                                    sufficient, and possibly much smaller.<br>
	 * @returns The total size of the output packet on success, or an error code<br>
	 *          on failure.<br>
	 * @retval #OPUS_BUFFER_TOO_SMALL \a maxlen was insufficient to contain the<br>
	 *                                complete output packet.<br>
	 * Original signature : <code>opus_int32 opus_repacketizer_out(OpusRepacketizer*, unsigned char*, opus_int32)</code><br>
	 * <i>native declaration : /tmp/opus.h:875</i>
	 */
	int opus_repacketizer_out(PointerByReference rp, Pointer data, int maxlen);
	/**
	 * Pads a given Opus packet to a larger size (possibly changing the TOC sequence).<br>
	 * @param[in,out] data <tt>const unsigned char*</tt>: The buffer containing the<br>
	 *                                                   packet to pad.<br>
	 * @param len <tt>opus_int32</tt>: The size of the packet.<br>
	 *                                 This must be at least 1.<br>
	 * @param new_len <tt>opus_int32</tt>: The desired size of the packet after padding.<br>
	 *                                 This must be at least as large as len.<br>
	 * @returns an error code<br>
	 * @retval #OPUS_OK \a on success.<br>
	 * @retval #OPUS_BAD_ARG \a len was less than 1 or new_len was less than len.<br>
	 * @retval #OPUS_INVALID_PACKET \a data did not contain a valid Opus packet.<br>
	 * Original signature : <code>int opus_packet_pad(unsigned char*, opus_int32, opus_int32)</code><br>
	 * <i>native declaration : /tmp/opus.h:889</i>
	 */
	int opus_packet_pad(ByteBuffer data, int len, int new_len);
	/**
	 * Remove all padding from a given Opus packet and rewrite the TOC sequence to<br>
	 * minimize space usage.<br>
	 * @param[in,out] data <tt>const unsigned char*</tt>: The buffer containing the<br>
	 *                                                   packet to strip.<br>
	 * @param len <tt>opus_int32</tt>: The size of the packet.<br>
	 *                                 This must be at least 1.<br>
	 * @returns The new size of the output packet on success, or an error code<br>
	 *          on failure.<br>
	 * @retval #OPUS_BAD_ARG \a len was less than 1.<br>
	 * @retval #OPUS_INVALID_PACKET \a data did not contain a valid Opus packet.<br>
	 * Original signature : <code>opus_int32 opus_packet_unpad(unsigned char*, opus_int32)</code><br>
	 * <i>native declaration : /tmp/opus.h:902</i>
	 */
	int opus_packet_unpad(ByteBuffer data, int len);
	/**
	 * Pads a given Opus multi-stream packet to a larger size (possibly changing the TOC sequence).<br>
	 * @param[in,out] data <tt>const unsigned char*</tt>: The buffer containing the<br>
	 *                                                   packet to pad.<br>
	 * @param len <tt>opus_int32</tt>: The size of the packet.<br>
	 *                                 This must be at least 1.<br>
	 * @param new_len <tt>opus_int32</tt>: The desired size of the packet after padding.<br>
	 *                                 This must be at least 1.<br>
	 * @param nb_streams <tt>opus_int32</tt>: The number of streams (not channels) in the packet.<br>
	 *                                 This must be at least as large as len.<br>
	 * @returns an error code<br>
	 * @retval #OPUS_OK \a on success.<br>
	 * @retval #OPUS_BAD_ARG \a len was less than 1.<br>
	 * @retval #OPUS_INVALID_PACKET \a data did not contain a valid Opus packet.<br>
	 * Original signature : <code>int opus_multistream_packet_pad(unsigned char*, opus_int32, opus_int32, int)</code><br>
	 * <i>native declaration : /tmp/opus.h:918</i>
	 */
	int opus_multistream_packet_pad(ByteBuffer data, int len, int new_len, int nb_streams);
	/**
	 * Remove all padding from a given Opus multi-stream packet and rewrite the TOC sequence to<br>
	 * minimize space usage.<br>
	 * @param[in,out] data <tt>const unsigned char*</tt>: The buffer containing the<br>
	 *                                                   packet to strip.<br>
	 * @param len <tt>opus_int32</tt>: The size of the packet.<br>
	 *                                 This must be at least 1.<br>
	 * @param nb_streams <tt>opus_int32</tt>: The number of streams (not channels) in the packet.<br>
	 *                                 This must be at least 1.<br>
	 * @returns The new size of the output packet on success, or an error code<br>
	 *          on failure.<br>
	 * @retval #OPUS_BAD_ARG \a len was less than 1 or new_len was less than len.<br>
	 * @retval #OPUS_INVALID_PACKET \a data did not contain a valid Opus packet.<br>
	 * Original signature : <code>opus_int32 opus_multistream_packet_unpad(unsigned char*, opus_int32, int)</code><br>
	 * <i>native declaration : /tmp/opus.h:933</i>
	 */
	int opus_multistream_packet_unpad(ByteBuffer data, int len, int nb_streams);
	public static class OpusDecoder extends PointerType {
		public OpusDecoder(Pointer address) {
			super(address);
		}
		public OpusDecoder() {
			super();
		}
	};
	public static class OpusEncoder extends PointerType {
		public OpusEncoder(Pointer address) {
			super(address);
		}
		public OpusEncoder() {
			super();
		}
	};
	public static class OpusRepacketizer extends PointerType {
		public OpusRepacketizer(Pointer address) {
			super(address);
		}
		public OpusRepacketizer() {
			super();
		}
	};
	
	/**
	 * Converts an opus error code into a human readable string.<br>
	 * * @param[in] error <tt>int</tt>: Error number<br>
	 * @returns Error string<br>
	 * Original signature : <code>char* opus_strerror(int)</code><br>
	 * <i>native declaration : /tmp/opus_defines.h:712</i>
	 */
	String opus_strerror(int error);
	/**
	 * Gets the libopus version string.<br>
	 * * @returns Version string<br>
	 * Original signature : <code>char* opus_get_version_string()</code><br>
	 * <i>native declaration : /tmp/opus_defines.h:718</i>
	 */
	String opus_get_version_string();
	
	//******************** Multi Stream Support
	
	/**
	 * Gets the size of an OpusMSEncoder structure.<br>
	 * @param streams <tt>int</tt>: The total number of streams to encode from the<br>
	 *                              input.<br>
	 *                              This must be no more than 255.<br>
	 * @param coupled_streams <tt>int</tt>: Number of coupled (2 channel) streams<br>
	 *                                      to encode.<br>
	 *                                      This must be no larger than the total<br>
	 *                                      number of streams.<br>
	 *                                      Additionally, The total number of<br>
	 *                                      encoded channels (<code>streams +<br>
	 *                                      coupled_streams</code>) must be no<br>
	 *                                      more than 255.<br>
	 * @returns The size in bytes on success, or a negative error code<br>
	 *          (see @ref opus_errorcodes) on error.<br>
	 * Original signature : <code>opus_int32 opus_multistream_encoder_get_size(int, int)</code><br>
	 * <i>native declaration : /tmp/opus_multistream.h:202</i>
	 */
	int opus_multistream_encoder_get_size(int streams, int coupled_streams);
	/**
	 * Original signature : <code>opus_int32 opus_multistream_surround_encoder_get_size(int, int)</code><br>
	 * <i>native declaration : /tmp/opus_multistream.h:207</i>
	 */
	int opus_multistream_surround_encoder_get_size(int channels, int mapping_family);
	/**
	 * Allocates and initializes a multistream encoder state.<br>
	 * Call opus_multistream_encoder_destroy() to release<br>
	 * this object when finished.<br>
	 * @param Fs <tt>opus_int32</tt>: Sampling rate of the input signal (in Hz).<br>
	 *                                This must be one of 8000, 12000, 16000,<br>
	 *                                24000, or 48000.<br>
	 * @param channels <tt>int</tt>: Number of channels in the input signal.<br>
	 *                               This must be at most 255.<br>
	 *                               It may be greater than the number of<br>
	 *                               coded channels (<code>streams +<br>
	 *                               coupled_streams</code>).<br>
	 * @param streams <tt>int</tt>: The total number of streams to encode from the<br>
	 *                              input.<br>
	 *                              This must be no more than the number of channels.<br>
	 * @param coupled_streams <tt>int</tt>: Number of coupled (2 channel) streams<br>
	 *                                      to encode.<br>
	 *                                      This must be no larger than the total<br>
	 *                                      number of streams.<br>
	 *                                      Additionally, The total number of<br>
	 *                                      encoded channels (<code>streams +<br>
	 *                                      coupled_streams</code>) must be no<br>
	 *                                      more than the number of input channels.<br>
	 * @param[in] mapping <code>const unsigned char[channels]</code>: Mapping from<br>
	 *                    encoded channels to input channels, as described in<br>
	 *                    @ref opus_multistream. As an extra constraint, the<br>
	 *                    multistream encoder does not allow encoding coupled<br>
	 *                    streams for which one channel is unused since this<br>
	 *                    is never a good idea.<br>
	 * @param application <tt>int</tt>: The target encoder application.<br>
	 *                                  This must be one of the following:<br>
	 * <dl><br>
	 * <dt>#OPUS_APPLICATION_VOIP</dt><br>
	 * <dd>Process signal for improved speech intelligibility.</dd><br>
	 * <dt>#OPUS_APPLICATION_AUDIO</dt><br>
	 * <dd>Favor faithfulness to the original input.</dd><br>
	 * <dt>#OPUS_APPLICATION_RESTRICTED_LOWDELAY</dt><br>
	 * <dd>Configure the minimum possible coding delay by disabling certain modes<br>
	 * of operation.</dd><br>
	 * </dl><br>
	 * @param[out] error <tt>int *</tt>: Returns #OPUS_OK on success, or an error<br>
	 *                                   code (see @ref opus_errorcodes) on<br>
	 *                                   failure.<br>
	 * Original signature : <code>OpusMSEncoder* opus_multistream_encoder_create(opus_int32, int, int, int, const unsigned char*, int, int*)</code><br>
	 * <i>native declaration : /tmp/opus_multistream.h:256</i>
	 */
	PointerByReference opus_multistream_encoder_create(int Fs, int channels, int streams, int coupled_streams, byte mapping[], int application, IntBuffer error);
	/**
	 * Original signature : <code>OpusMSEncoder* opus_multistream_surround_encoder_create(opus_int32, int, int, int*, int*, unsigned char*, int, int*)</code><br>
	 * <i>native declaration : /tmp/opus_multistream.h:266</i>
	 */
	PointerByReference opus_multistream_surround_encoder_create(int Fs, int channels, int mapping_family, IntBuffer streams, IntBuffer coupled_streams, ByteBuffer mapping, int application, IntBuffer error);
	/**
	 * Initialize a previously allocated multistream encoder state.<br>
	 * The memory pointed to by \a st must be at least the size returned by<br>
	 * opus_multistream_encoder_get_size().<br>
	 * This is intended for applications which use their own allocator instead of<br>
	 * malloc.<br>
	 * To reset a previously initialized state, use the #OPUS_RESET_STATE CTL.<br>
	 * @see opus_multistream_encoder_create<br>
	 * @see opus_multistream_encoder_get_size<br>
	 * @param st <tt>OpusMSEncoder*</tt>: Multistream encoder state to initialize.<br>
	 * @param Fs <tt>opus_int32</tt>: Sampling rate of the input signal (in Hz).<br>
	 *                                This must be one of 8000, 12000, 16000,<br>
	 *                                24000, or 48000.<br>
	 * @param channels <tt>int</tt>: Number of channels in the input signal.<br>
	 *                               This must be at most 255.<br>
	 *                               It may be greater than the number of<br>
	 *                               coded channels (<code>streams +<br>
	 *                               coupled_streams</code>).<br>
	 * @param streams <tt>int</tt>: The total number of streams to encode from the<br>
	 *                              input.<br>
	 *                              This must be no more than the number of channels.<br>
	 * @param coupled_streams <tt>int</tt>: Number of coupled (2 channel) streams<br>
	 *                                      to encode.<br>
	 *                                      This must be no larger than the total<br>
	 *                                      number of streams.<br>
	 *                                      Additionally, The total number of<br>
	 *                                      encoded channels (<code>streams +<br>
	 *                                      coupled_streams</code>) must be no<br>
	 *                                      more than the number of input channels.<br>
	 * @param[in] mapping <code>const unsigned char[channels]</code>: Mapping from<br>
	 *                    encoded channels to input channels, as described in<br>
	 *                    @ref opus_multistream. As an extra constraint, the<br>
	 *                    multistream encoder does not allow encoding coupled<br>
	 *                    streams for which one channel is unused since this<br>
	 *                    is never a good idea.<br>
	 * @param application <tt>int</tt>: The target encoder application.<br>
	 *                                  This must be one of the following:<br>
	 * <dl><br>
	 * <dt>#OPUS_APPLICATION_VOIP</dt><br>
	 * <dd>Process signal for improved speech intelligibility.</dd><br>
	 * <dt>#OPUS_APPLICATION_AUDIO</dt><br>
	 * <dd>Favor faithfulness to the original input.</dd><br>
	 * <dt>#OPUS_APPLICATION_RESTRICTED_LOWDELAY</dt><br>
	 * <dd>Configure the minimum possible coding delay by disabling certain modes<br>
	 * of operation.</dd><br>
	 * </dl><br>
	 * @returns #OPUS_OK on success, or an error code (see @ref opus_errorcodes)<br>
	 *          on failure.<br>
	 * Original signature : <code>int opus_multistream_encoder_init(OpusMSEncoder*, opus_int32, int, int, int, const unsigned char*, int)</code><br>
	 * <i>native declaration : /tmp/opus_multistream.h:325</i>
	 */
	int opus_multistream_encoder_init(PointerByReference st, int Fs, int channels, int streams, int coupled_streams, byte mapping[], int application);
	/**
	 * Initialize a previously allocated multistream encoder state.<br>
	 * The memory pointed to by \a st must be at least the size returned by<br>
	 * opus_multistream_encoder_get_size().<br>
	 * This is intended for applications which use their own allocator instead of<br>
	 * malloc.<br>
	 * To reset a previously initialized state, use the #OPUS_RESET_STATE CTL.<br>
	 * @see opus_multistream_encoder_create<br>
	 * @see opus_multistream_encoder_get_size<br>
	 * @param st <tt>OpusMSEncoder*</tt>: Multistream encoder state to initialize.<br>
	 * @param Fs <tt>opus_int32</tt>: Sampling rate of the input signal (in Hz).<br>
	 *                                This must be one of 8000, 12000, 16000,<br>
	 *                                24000, or 48000.<br>
	 * @param channels <tt>int</tt>: Number of channels in the input signal.<br>
	 *                               This must be at most 255.<br>
	 *                               It may be greater than the number of<br>
	 *                               coded channels (<code>streams +<br>
	 *                               coupled_streams</code>).<br>
	 * @param streams <tt>int</tt>: The total number of streams to encode from the<br>
	 *                              input.<br>
	 *                              This must be no more than the number of channels.<br>
	 * @param coupled_streams <tt>int</tt>: Number of coupled (2 channel) streams<br>
	 *                                      to encode.<br>
	 *                                      This must be no larger than the total<br>
	 *                                      number of streams.<br>
	 *                                      Additionally, The total number of<br>
	 *                                      encoded channels (<code>streams +<br>
	 *                                      coupled_streams</code>) must be no<br>
	 *                                      more than the number of input channels.<br>
	 * @param[in] mapping <code>const unsigned char[channels]</code>: Mapping from<br>
	 *                    encoded channels to input channels, as described in<br>
	 *                    @ref opus_multistream. As an extra constraint, the<br>
	 *                    multistream encoder does not allow encoding coupled<br>
	 *                    streams for which one channel is unused since this<br>
	 *                    is never a good idea.<br>
	 * @param application <tt>int</tt>: The target encoder application.<br>
	 *                                  This must be one of the following:<br>
	 * <dl><br>
	 * <dt>#OPUS_APPLICATION_VOIP</dt><br>
	 * <dd>Process signal for improved speech intelligibility.</dd><br>
	 * <dt>#OPUS_APPLICATION_AUDIO</dt><br>
	 * <dd>Favor faithfulness to the original input.</dd><br>
	 * <dt>#OPUS_APPLICATION_RESTRICTED_LOWDELAY</dt><br>
	 * <dd>Configure the minimum possible coding delay by disabling certain modes<br>
	 * of operation.</dd><br>
	 * </dl><br>
	 * @returns #OPUS_OK on success, or an error code (see @ref opus_errorcodes)<br>
	 *          on failure.<br>
	 * Original signature : <code>int opus_multistream_encoder_init(OpusMSEncoder*, opus_int32, int, int, int, const unsigned char*, int)</code><br>
	 * <i>native declaration : /tmp/opus_multistream.h:325</i>
	 */
	int opus_multistream_encoder_init(PointerByReference st, int Fs, int channels, int streams, int coupled_streams, Pointer mapping, int application);
	/**
	 * Original signature : <code>int opus_multistream_surround_encoder_init(OpusMSEncoder*, opus_int32, int, int, int*, int*, unsigned char*, int)</code><br>
	 * <i>native declaration : /tmp/opus_multistream.h:335</i>
	 */
	int opus_multistream_surround_encoder_init(PointerByReference st, int Fs, int channels, int mapping_family, IntBuffer streams, IntBuffer coupled_streams, ByteBuffer mapping, int application);
	/**
	 * Original signature : <code>int opus_multistream_surround_encoder_init(OpusMSEncoder*, opus_int32, int, int, int*, int*, unsigned char*, int)</code><br>
	 * <i>native declaration : /tmp/opus_multistream.h:335</i>
	 */
	int opus_multistream_surround_encoder_init(PointerByReference st, int Fs, int channels, int mapping_family, IntByReference streams, IntByReference coupled_streams, Pointer mapping, int application);
	/**
	 * Encodes a multistream Opus frame.<br>
	 * @param st <tt>OpusMSEncoder*</tt>: Multistream encoder state.<br>
	 * @param[in] pcm <tt>const opus_int16*</tt>: The input signal as interleaved<br>
	 *                                            samples.<br>
	 *                                            This must contain<br>
	 *                                            <code>frame_size*channels</code><br>
	 *                                            samples.<br>
	 * @param frame_size <tt>int</tt>: Number of samples per channel in the input<br>
	 *                                 signal.<br>
	 *                                 This must be an Opus frame size for the<br>
	 *                                 encoder's sampling rate.<br>
	 *                                 For example, at 48 kHz the permitted values<br>
	 *                                 are 120, 240, 480, 960, 1920, and 2880.<br>
	 *                                 Passing in a duration of less than 10 ms<br>
	 *                                 (480 samples at 48 kHz) will prevent the<br>
	 *                                 encoder from using the LPC or hybrid modes.<br>
	 * @param[out] data <tt>unsigned char*</tt>: Output payload.<br>
	 *                                           This must contain storage for at<br>
	 *                                           least \a max_data_bytes.<br>
	 * @param [in] max_data_bytes <tt>opus_int32</tt>: Size of the allocated<br>
	 *                                                 memory for the output<br>
	 *                                                 payload. This may be<br>
	 *                                                 used to impose an upper limit on<br>
	 *                                                 the instant bitrate, but should<br>
	 *                                                 not be used as the only bitrate<br>
	 *                                                 control. Use #OPUS_SET_BITRATE to<br>
	 *                                                 control the bitrate.<br>
	 * @returns The length of the encoded packet (in bytes) on success or a<br>
	 *          negative error code (see @ref opus_errorcodes) on failure.<br>
	 * Original signature : <code>int opus_multistream_encode(OpusMSEncoder*, const opus_int16*, int, unsigned char*, opus_int32)</code><br>
	 * <i>native declaration : /tmp/opus_multistream.h:376</i>
	 */
	int opus_multistream_encode(PointerByReference st, ShortBuffer pcm, int frame_size, ByteBuffer data, int max_data_bytes);
	/**
	 * Encodes a multistream Opus frame.<br>
	 * @param st <tt>OpusMSEncoder*</tt>: Multistream encoder state.<br>
	 * @param[in] pcm <tt>const opus_int16*</tt>: The input signal as interleaved<br>
	 *                                            samples.<br>
	 *                                            This must contain<br>
	 *                                            <code>frame_size*channels</code><br>
	 *                                            samples.<br>
	 * @param frame_size <tt>int</tt>: Number of samples per channel in the input<br>
	 *                                 signal.<br>
	 *                                 This must be an Opus frame size for the<br>
	 *                                 encoder's sampling rate.<br>
	 *                                 For example, at 48 kHz the permitted values<br>
	 *                                 are 120, 240, 480, 960, 1920, and 2880.<br>
	 *                                 Passing in a duration of less than 10 ms<br>
	 *                                 (480 samples at 48 kHz) will prevent the<br>
	 *                                 encoder from using the LPC or hybrid modes.<br>
	 * @param[out] data <tt>unsigned char*</tt>: Output payload.<br>
	 *                                           This must contain storage for at<br>
	 *                                           least \a max_data_bytes.<br>
	 * @param [in] max_data_bytes <tt>opus_int32</tt>: Size of the allocated<br>
	 *                                                 memory for the output<br>
	 *                                                 payload. This may be<br>
	 *                                                 used to impose an upper limit on<br>
	 *                                                 the instant bitrate, but should<br>
	 *                                                 not be used as the only bitrate<br>
	 *                                                 control. Use #OPUS_SET_BITRATE to<br>
	 *                                                 control the bitrate.<br>
	 * @returns The length of the encoded packet (in bytes) on success or a<br>
	 *          negative error code (see @ref opus_errorcodes) on failure.<br>
	 * Original signature : <code>int opus_multistream_encode(OpusMSEncoder*, const opus_int16*, int, unsigned char*, opus_int32)</code><br>
	 * <i>native declaration : /tmp/opus_multistream.h:376</i>
	 */
	int opus_multistream_encode(PointerByReference st, ShortByReference pcm, int frame_size, Pointer data, int max_data_bytes);
	/**
	 * Encodes a multistream Opus frame from floating point input.<br>
	 * @param st <tt>OpusMSEncoder*</tt>: Multistream encoder state.<br>
	 * @param[in] pcm <tt>const float*</tt>: The input signal as interleaved<br>
	 *                                       samples with a normal range of<br>
	 *                                       +/-1.0.<br>
	 *                                       Samples with a range beyond +/-1.0<br>
	 *                                       are supported but will be clipped by<br>
	 *                                       decoders using the integer API and<br>
	 *                                       should only be used if it is known<br>
	 *                                       that the far end supports extended<br>
	 *                                       dynamic range.<br>
	 *                                       This must contain<br>
	 *                                       <code>frame_size*channels</code><br>
	 *                                       samples.<br>
	 * @param frame_size <tt>int</tt>: Number of samples per channel in the input<br>
	 *                                 signal.<br>
	 *                                 This must be an Opus frame size for the<br>
	 *                                 encoder's sampling rate.<br>
	 *                                 For example, at 48 kHz the permitted values<br>
	 *                                 are 120, 240, 480, 960, 1920, and 2880.<br>
	 *                                 Passing in a duration of less than 10 ms<br>
	 *                                 (480 samples at 48 kHz) will prevent the<br>
	 *                                 encoder from using the LPC or hybrid modes.<br>
	 * @param[out] data <tt>unsigned char*</tt>: Output payload.<br>
	 *                                           This must contain storage for at<br>
	 *                                           least \a max_data_bytes.<br>
	 * @param [in] max_data_bytes <tt>opus_int32</tt>: Size of the allocated<br>
	 *                                                 memory for the output<br>
	 *                                                 payload. This may be<br>
	 *                                                 used to impose an upper limit on<br>
	 *                                                 the instant bitrate, but should<br>
	 *                                                 not be used as the only bitrate<br>
	 *                                                 control. Use #OPUS_SET_BITRATE to<br>
	 *                                                 control the bitrate.<br>
	 * @returns The length of the encoded packet (in bytes) on success or a<br>
	 *          negative error code (see @ref opus_errorcodes) on failure.<br>
	 * Original signature : <code>int opus_multistream_encode_float(OpusMSEncoder*, const float*, int, unsigned char*, opus_int32)</code><br>
	 * <i>native declaration : /tmp/opus_multistream.h:421</i>
	 */
	int opus_multistream_encode_float(PointerByReference st, float pcm[], int frame_size, ByteBuffer data, int max_data_bytes);
	/**
	 * Encodes a multistream Opus frame from floating point input.<br>
	 * @param st <tt>OpusMSEncoder*</tt>: Multistream encoder state.<br>
	 * @param[in] pcm <tt>const float*</tt>: The input signal as interleaved<br>
	 *                                       samples with a normal range of<br>
	 *                                       +/-1.0.<br>
	 *                                       Samples with a range beyond +/-1.0<br>
	 *                                       are supported but will be clipped by<br>
	 *                                       decoders using the integer API and<br>
	 *                                       should only be used if it is known<br>
	 *                                       that the far end supports extended<br>
	 *                                       dynamic range.<br>
	 *                                       This must contain<br>
	 *                                       <code>frame_size*channels</code><br>
	 *                                       samples.<br>
	 * @param frame_size <tt>int</tt>: Number of samples per channel in the input<br>
	 *                                 signal.<br>
	 *                                 This must be an Opus frame size for the<br>
	 *                                 encoder's sampling rate.<br>
	 *                                 For example, at 48 kHz the permitted values<br>
	 *                                 are 120, 240, 480, 960, 1920, and 2880.<br>
	 *                                 Passing in a duration of less than 10 ms<br>
	 *                                 (480 samples at 48 kHz) will prevent the<br>
	 *                                 encoder from using the LPC or hybrid modes.<br>
	 * @param[out] data <tt>unsigned char*</tt>: Output payload.<br>
	 *                                           This must contain storage for at<br>
	 *                                           least \a max_data_bytes.<br>
	 * @param [in] max_data_bytes <tt>opus_int32</tt>: Size of the allocated<br>
	 *                                                 memory for the output<br>
	 *                                                 payload. This may be<br>
	 *                                                 used to impose an upper limit on<br>
	 *                                                 the instant bitrate, but should<br>
	 *                                                 not be used as the only bitrate<br>
	 *                                                 control. Use #OPUS_SET_BITRATE to<br>
	 *                                                 control the bitrate.<br>
	 * @returns The length of the encoded packet (in bytes) on success or a<br>
	 *          negative error code (see @ref opus_errorcodes) on failure.<br>
	 * Original signature : <code>int opus_multistream_encode_float(OpusMSEncoder*, const float*, int, unsigned char*, opus_int32)</code><br>
	 * <i>native declaration : /tmp/opus_multistream.h:421</i>
	 */
	int opus_multistream_encode_float(PointerByReference st, FloatByReference pcm, int frame_size, Pointer data, int max_data_bytes);
	/**
	 * Frees an <code>OpusMSEncoder</code> allocated by<br>
	 * opus_multistream_encoder_create().<br>
	 * @param st <tt>OpusMSEncoder*</tt>: Multistream encoder state to be freed.<br>
	 * Original signature : <code>void opus_multistream_encoder_destroy(OpusMSEncoder*)</code><br>
	 * <i>native declaration : /tmp/opus_multistream.h:433</i>
	 */
	void opus_multistream_encoder_destroy(PointerByReference st);
	/**
	 * Perform a CTL function on a multistream Opus encoder.<br>
	 * * Generally the request and subsequent arguments are generated by a<br>
	 * convenience macro.<br>
	 * @param st <tt>OpusMSEncoder*</tt>: Multistream encoder state.<br>
	 * @param request This and all remaining parameters should be replaced by one<br>
	 *                of the convenience macros in @ref opus_genericctls,<br>
	 *                @ref opus_encoderctls, or @ref opus_multistream_ctls.<br>
	 * @see opus_genericctls<br>
	 * @see opus_encoderctls<br>
	 * @see opus_multistream_ctls<br>
	 * Original signature : <code>int opus_multistream_encoder_ctl(OpusMSEncoder*, int, null)</code><br>
	 * <i>native declaration : /tmp/opus_multistream.h:447</i>
	 */
	int opus_multistream_encoder_ctl(PointerByReference st, int request, Object... varargs);
	/**
	 * Gets the size of an <code>OpusMSDecoder</code> structure.<br>
	 * @param streams <tt>int</tt>: The total number of streams coded in the<br>
	 *                              input.<br>
	 *                              This must be no more than 255.<br>
	 * @param coupled_streams <tt>int</tt>: Number streams to decode as coupled<br>
	 *                                      (2 channel) streams.<br>
	 *                                      This must be no larger than the total<br>
	 *                                      number of streams.<br>
	 *                                      Additionally, The total number of<br>
	 *                                      coded channels (<code>streams +<br>
	 *                                      coupled_streams</code>) must be no<br>
	 *                                      more than 255.<br>
	 * @returns The size in bytes on success, or a negative error code<br>
	 *          (see @ref opus_errorcodes) on error.<br>
	 * Original signature : <code>opus_int32 opus_multistream_decoder_get_size(int, int)</code><br>
	 * <i>native declaration : /tmp/opus_multistream.h:469</i>
	 */
	int opus_multistream_decoder_get_size(int streams, int coupled_streams);
	/**
	 * Allocates and initializes a multistream decoder state.<br>
	 * Call opus_multistream_decoder_destroy() to release<br>
	 * this object when finished.<br>
	 * @param Fs <tt>opus_int32</tt>: Sampling rate to decode at (in Hz).<br>
	 *                                This must be one of 8000, 12000, 16000,<br>
	 *                                24000, or 48000.<br>
	 * @param channels <tt>int</tt>: Number of channels to output.<br>
	 *                               This must be at most 255.<br>
	 *                               It may be different from the number of coded<br>
	 *                               channels (<code>streams +<br>
	 *                               coupled_streams</code>).<br>
	 * @param streams <tt>int</tt>: The total number of streams coded in the<br>
	 *                              input.<br>
	 *                              This must be no more than 255.<br>
	 * @param coupled_streams <tt>int</tt>: Number of streams to decode as coupled<br>
	 *                                      (2 channel) streams.<br>
	 *                                      This must be no larger than the total<br>
	 *                                      number of streams.<br>
	 *                                      Additionally, The total number of<br>
	 *                                      coded channels (<code>streams +<br>
	 *                                      coupled_streams</code>) must be no<br>
	 *                                      more than 255.<br>
	 * @param[in] mapping <code>const unsigned char[channels]</code>: Mapping from<br>
	 *                    coded channels to output channels, as described in<br>
	 *                    @ref opus_multistream.<br>
	 * @param[out] error <tt>int *</tt>: Returns #OPUS_OK on success, or an error<br>
	 *                                   code (see @ref opus_errorcodes) on<br>
	 *                                   failure.<br>
	 * Original signature : <code>OpusMSDecoder* opus_multistream_decoder_create(opus_int32, int, int, int, const unsigned char*, int*)</code><br>
	 * <i>native declaration : /tmp/opus_multistream.h:503</i>
	 */
	PointerByReference opus_multistream_decoder_create(int Fs, int channels, int streams, int coupled_streams, byte mapping[], IntBuffer error);
	/**
	 * Intialize a previously allocated decoder state object.<br>
	 * The memory pointed to by \a st must be at least the size returned by<br>
	 * opus_multistream_encoder_get_size().<br>
	 * This is intended for applications which use their own allocator instead of<br>
	 * malloc.<br>
	 * To reset a previously initialized state, use the #OPUS_RESET_STATE CTL.<br>
	 * @see opus_multistream_decoder_create<br>
	 * @see opus_multistream_deocder_get_size<br>
	 * @param st <tt>OpusMSEncoder*</tt>: Multistream encoder state to initialize.<br>
	 * @param Fs <tt>opus_int32</tt>: Sampling rate to decode at (in Hz).<br>
	 *                                This must be one of 8000, 12000, 16000,<br>
	 *                                24000, or 48000.<br>
	 * @param channels <tt>int</tt>: Number of channels to output.<br>
	 *                               This must be at most 255.<br>
	 *                               It may be different from the number of coded<br>
	 *                               channels (<code>streams +<br>
	 *                               coupled_streams</code>).<br>
	 * @param streams <tt>int</tt>: The total number of streams coded in the<br>
	 *                              input.<br>
	 *                              This must be no more than 255.<br>
	 * @param coupled_streams <tt>int</tt>: Number of streams to decode as coupled<br>
	 *                                      (2 channel) streams.<br>
	 *                                      This must be no larger than the total<br>
	 *                                      number of streams.<br>
	 *                                      Additionally, The total number of<br>
	 *                                      coded channels (<code>streams +<br>
	 *                                      coupled_streams</code>) must be no<br>
	 *                                      more than 255.<br>
	 * @param[in] mapping <code>const unsigned char[channels]</code>: Mapping from<br>
	 *                    coded channels to output channels, as described in<br>
	 *                    @ref opus_multistream.<br>
	 * @returns #OPUS_OK on success, or an error code (see @ref opus_errorcodes)<br>
	 *          on failure.<br>
	 * Original signature : <code>int opus_multistream_decoder_init(OpusMSDecoder*, opus_int32, int, int, int, const unsigned char*)</code><br>
	 * <i>native declaration : /tmp/opus_multistream.h:546</i>
	 */
	int opus_multistream_decoder_init(PointerByReference st, int Fs, int channels, int streams, int coupled_streams, byte mapping[]);
	/**
	 * Intialize a previously allocated decoder state object.<br>
	 * The memory pointed to by \a st must be at least the size returned by<br>
	 * opus_multistream_encoder_get_size().<br>
	 * This is intended for applications which use their own allocator instead of<br>
	 * malloc.<br>
	 * To reset a previously initialized state, use the #OPUS_RESET_STATE CTL.<br>
	 * @see opus_multistream_decoder_create<br>
	 * @see opus_multistream_deocder_get_size<br>
	 * @param st <tt>OpusMSEncoder*</tt>: Multistream encoder state to initialize.<br>
	 * @param Fs <tt>opus_int32</tt>: Sampling rate to decode at (in Hz).<br>
	 *                                This must be one of 8000, 12000, 16000,<br>
	 *                                24000, or 48000.<br>
	 * @param channels <tt>int</tt>: Number of channels to output.<br>
	 *                               This must be at most 255.<br>
	 *                               It may be different from the number of coded<br>
	 *                               channels (<code>streams +<br>
	 *                               coupled_streams</code>).<br>
	 * @param streams <tt>int</tt>: The total number of streams coded in the<br>
	 *                              input.<br>
	 *                              This must be no more than 255.<br>
	 * @param coupled_streams <tt>int</tt>: Number of streams to decode as coupled<br>
	 *                                      (2 channel) streams.<br>
	 *                                      This must be no larger than the total<br>
	 *                                      number of streams.<br>
	 *                                      Additionally, The total number of<br>
	 *                                      coded channels (<code>streams +<br>
	 *                                      coupled_streams</code>) must be no<br>
	 *                                      more than 255.<br>
	 * @param[in] mapping <code>const unsigned char[channels]</code>: Mapping from<br>
	 *                    coded channels to output channels, as described in<br>
	 *                    @ref opus_multistream.<br>
	 * @returns #OPUS_OK on success, or an error code (see @ref opus_errorcodes)<br>
	 *          on failure.<br>
	 * Original signature : <code>int opus_multistream_decoder_init(OpusMSDecoder*, opus_int32, int, int, int, const unsigned char*)</code><br>
	 * <i>native declaration : /tmp/opus_multistream.h:546</i>
	 */
	int opus_multistream_decoder_init(PointerByReference st, int Fs, int channels, int streams, int coupled_streams, Pointer mapping);
	/**
	 * Decode a multistream Opus packet.<br>
	 * @param st <tt>OpusMSDecoder*</tt>: Multistream decoder state.<br>
	 * @param[in] data <tt>const unsigned char*</tt>: Input payload.<br>
	 *                                                Use a <code>NULL</code><br>
	 *                                                pointer to indicate packet<br>
	 *                                                loss.<br>
	 * @param len <tt>opus_int32</tt>: Number of bytes in payload.<br>
	 * @param[out] pcm <tt>opus_int16*</tt>: Output signal, with interleaved<br>
	 *                                       samples.<br>
	 *                                       This must contain room for<br>
	 *                                       <code>frame_size*channels</code><br>
	 *                                       samples.<br>
	 * @param frame_size <tt>int</tt>: The number of samples per channel of<br>
	 *                                 available space in \a pcm.<br>
	 *                                 If this is less than the maximum packet duration<br>
	 *                                 (120 ms; 5760 for 48kHz), this function will not be capable<br>
	 *                                 of decoding some packets. In the case of PLC (data==NULL)<br>
	 *                                 or FEC (decode_fec=1), then frame_size needs to be exactly<br>
	 *                                 the duration of audio that is missing, otherwise the<br>
	 *                                 decoder will not be in the optimal state to decode the<br>
	 *                                 next incoming packet. For the PLC and FEC cases, frame_size<br>
	 *                                 <b>must</b> be a multiple of 2.5 ms.<br>
	 * @param decode_fec <tt>int</tt>: Flag (0 or 1) to request that any in-band<br>
	 *                                 forward error correction data be decoded.<br>
	 *                                 If no such data is available, the frame is<br>
	 *                                 decoded as if it were lost.<br>
	 * @returns Number of samples decoded on success or a negative error code<br>
	 *          (see @ref opus_errorcodes) on failure.<br>
	 * Original signature : <code>int opus_multistream_decode(OpusMSDecoder*, const unsigned char*, opus_int32, opus_int16*, int, int)</code><br>
	 * <i>native declaration : /tmp/opus_multistream.h:584</i>
	 */
	int opus_multistream_decode(PointerByReference st, byte data[], int len, ShortBuffer pcm, int frame_size, int decode_fec);
	/**
	 * Decode a multistream Opus packet.<br>
	 * @param st <tt>OpusMSDecoder*</tt>: Multistream decoder state.<br>
	 * @param[in] data <tt>const unsigned char*</tt>: Input payload.<br>
	 *                                                Use a <code>NULL</code><br>
	 *                                                pointer to indicate packet<br>
	 *                                                loss.<br>
	 * @param len <tt>opus_int32</tt>: Number of bytes in payload.<br>
	 * @param[out] pcm <tt>opus_int16*</tt>: Output signal, with interleaved<br>
	 *                                       samples.<br>
	 *                                       This must contain room for<br>
	 *                                       <code>frame_size*channels</code><br>
	 *                                       samples.<br>
	 * @param frame_size <tt>int</tt>: The number of samples per channel of<br>
	 *                                 available space in \a pcm.<br>
	 *                                 If this is less than the maximum packet duration<br>
	 *                                 (120 ms; 5760 for 48kHz), this function will not be capable<br>
	 *                                 of decoding some packets. In the case of PLC (data==NULL)<br>
	 *                                 or FEC (decode_fec=1), then frame_size needs to be exactly<br>
	 *                                 the duration of audio that is missing, otherwise the<br>
	 *                                 decoder will not be in the optimal state to decode the<br>
	 *                                 next incoming packet. For the PLC and FEC cases, frame_size<br>
	 *                                 <b>must</b> be a multiple of 2.5 ms.<br>
	 * @param decode_fec <tt>int</tt>: Flag (0 or 1) to request that any in-band<br>
	 *                                 forward error correction data be decoded.<br>
	 *                                 If no such data is available, the frame is<br>
	 *                                 decoded as if it were lost.<br>
	 * @returns Number of samples decoded on success or a negative error code<br>
	 *          (see @ref opus_errorcodes) on failure.<br>
	 * Original signature : <code>int opus_multistream_decode(OpusMSDecoder*, const unsigned char*, opus_int32, opus_int16*, int, int)</code><br>
	 * <i>native declaration : /tmp/opus_multistream.h:584</i>
	 */
	int opus_multistream_decode(PointerByReference st, Pointer data, int len, ShortByReference pcm, int frame_size, int decode_fec);
	/**
	 * Decode a multistream Opus packet with floating point output.<br>
	 * @param st <tt>OpusMSDecoder*</tt>: Multistream decoder state.<br>
	 * @param[in] data <tt>const unsigned char*</tt>: Input payload.<br>
	 *                                                Use a <code>NULL</code><br>
	 *                                                pointer to indicate packet<br>
	 *                                                loss.<br>
	 * @param len <tt>opus_int32</tt>: Number of bytes in payload.<br>
	 * @param[out] pcm <tt>opus_int16*</tt>: Output signal, with interleaved<br>
	 *                                       samples.<br>
	 *                                       This must contain room for<br>
	 *                                       <code>frame_size*channels</code><br>
	 *                                       samples.<br>
	 * @param frame_size <tt>int</tt>: The number of samples per channel of<br>
	 *                                 available space in \a pcm.<br>
	 *                                 If this is less than the maximum packet duration<br>
	 *                                 (120 ms; 5760 for 48kHz), this function will not be capable<br>
	 *                                 of decoding some packets. In the case of PLC (data==NULL)<br>
	 *                                 or FEC (decode_fec=1), then frame_size needs to be exactly<br>
	 *                                 the duration of audio that is missing, otherwise the<br>
	 *                                 decoder will not be in the optimal state to decode the<br>
	 *                                 next incoming packet. For the PLC and FEC cases, frame_size<br>
	 *                                 <b>must</b> be a multiple of 2.5 ms.<br>
	 * @param decode_fec <tt>int</tt>: Flag (0 or 1) to request that any in-band<br>
	 *                                 forward error correction data be decoded.<br>
	 *                                 If no such data is available, the frame is<br>
	 *                                 decoded as if it were lost.<br>
	 * @returns Number of samples decoded on success or a negative error code<br>
	 *          (see @ref opus_errorcodes) on failure.<br>
	 * Original signature : <code>int opus_multistream_decode_float(OpusMSDecoder*, const unsigned char*, opus_int32, float*, int, int)</code><br>
	 * <i>native declaration : /tmp/opus_multistream.h:622</i>
	 */
	int opus_multistream_decode_float(PointerByReference st, byte data[], int len, FloatBuffer pcm, int frame_size, int decode_fec);
	/**
	 * Decode a multistream Opus packet with floating point output.<br>
	 * @param st <tt>OpusMSDecoder*</tt>: Multistream decoder state.<br>
	 * @param[in] data <tt>const unsigned char*</tt>: Input payload.<br>
	 *                                                Use a <code>NULL</code><br>
	 *                                                pointer to indicate packet<br>
	 *                                                loss.<br>
	 * @param len <tt>opus_int32</tt>: Number of bytes in payload.<br>
	 * @param[out] pcm <tt>opus_int16*</tt>: Output signal, with interleaved<br>
	 *                                       samples.<br>
	 *                                       This must contain room for<br>
	 *                                       <code>frame_size*channels</code><br>
	 *                                       samples.<br>
	 * @param frame_size <tt>int</tt>: The number of samples per channel of<br>
	 *                                 available space in \a pcm.<br>
	 *                                 If this is less than the maximum packet duration<br>
	 *                                 (120 ms; 5760 for 48kHz), this function will not be capable<br>
	 *                                 of decoding some packets. In the case of PLC (data==NULL)<br>
	 *                                 or FEC (decode_fec=1), then frame_size needs to be exactly<br>
	 *                                 the duration of audio that is missing, otherwise the<br>
	 *                                 decoder will not be in the optimal state to decode the<br>
	 *                                 next incoming packet. For the PLC and FEC cases, frame_size<br>
	 *                                 <b>must</b> be a multiple of 2.5 ms.<br>
	 * @param decode_fec <tt>int</tt>: Flag (0 or 1) to request that any in-band<br>
	 *                                 forward error correction data be decoded.<br>
	 *                                 If no such data is available, the frame is<br>
	 *                                 decoded as if it were lost.<br>
	 * @returns Number of samples decoded on success or a negative error code<br>
	 *          (see @ref opus_errorcodes) on failure.<br>
	 * Original signature : <code>int opus_multistream_decode_float(OpusMSDecoder*, const unsigned char*, opus_int32, float*, int, int)</code><br>
	 * <i>native declaration : /tmp/opus_multistream.h:622</i>
	 */
	int opus_multistream_decode_float(PointerByReference st, Pointer data, int len, FloatByReference pcm, int frame_size, int decode_fec);
	/**
	 * Perform a CTL function on a multistream Opus decoder.<br>
	 * * Generally the request and subsequent arguments are generated by a<br>
	 * convenience macro.<br>
	 * @param st <tt>OpusMSDecoder*</tt>: Multistream decoder state.<br>
	 * @param request This and all remaining parameters should be replaced by one<br>
	 *                of the convenience macros in @ref opus_genericctls,<br>
	 *                @ref opus_decoderctls, or @ref opus_multistream_ctls.<br>
	 * @see opus_genericctls<br>
	 * @see opus_decoderctls<br>
	 * @see opus_multistream_ctls<br>
	 * Original signature : <code>int opus_multistream_decoder_ctl(OpusMSDecoder*, int, null)</code><br>
	 * <i>native declaration : /tmp/opus_multistream.h:643</i>
	 */
	int opus_multistream_decoder_ctl(PointerByReference st, int request, Object... varargs);
	/**
	 * Frees an <code>OpusMSDecoder</code> allocated by<br>
	 * opus_multistream_decoder_create().<br>
	 * @param st <tt>OpusMSDecoder</tt>: Multistream decoder state to be freed.<br>
	 * Original signature : <code>void opus_multistream_decoder_destroy(OpusMSDecoder*)</code><br>
	 * <i>native declaration : /tmp/opus_multistream.h:649</i>
	 */
	void opus_multistream_decoder_destroy(PointerByReference st);
	public static class OpusMSEncoder extends PointerType {
		public OpusMSEncoder(Pointer address) {
			super(address);
		}
		public OpusMSEncoder() {
			super();
		}
	};
	public static class OpusMSDecoder extends PointerType {
		public OpusMSDecoder(Pointer address) {
			super(address);
		}
		public OpusMSDecoder() {
			super();
		}
	};
	
	// ******************** Custom Support
	
	/**
	 * Creates a new mode struct. This will be passed to an encoder or<br>
	 * decoder. The mode MUST NOT BE DESTROYED until the encoders and<br>
	 * decoders that use it are destroyed as well.<br>
	 * @param [in] Fs <tt>int</tt>: Sampling rate (8000 to 96000 Hz)<br>
	 * @param [in] frame_size <tt>int</tt>: Number of samples (per channel) to encode in each<br>
	 *        packet (64 - 1024, prime factorization must contain zero or more 2s, 3s, or 5s and no other primes)<br>
	 * @param [out] error <tt>int*</tt>: Returned error code (if NULL, no error will be returned)<br>
	 * @return A newly created mode<br>
	 * Original signature : <code>OpusCustomMode* opus_custom_mode_create(opus_int32, int, int*)</code><br>
	 * <i>native declaration : /tmp/opus_custom.h:120</i>
	 */
	PointerByReference opus_custom_mode_create(int Fs, int frame_size, IntBuffer error);
	/**
	 * Destroys a mode struct. Only call this after all encoders and<br>
	 * decoders using this mode are destroyed as well.<br>
	 * @param [in] mode <tt>OpusCustomMode*</tt>: Mode to be freed.<br>
	 * Original signature : <code>void opus_custom_mode_destroy(OpusCustomMode*)</code><br>
	 * <i>native declaration : /tmp/opus_custom.h:126</i>
	 */
	void opus_custom_mode_destroy(PointerByReference mode);
	/**
	 * Gets the size of an OpusCustomEncoder structure.<br>
	 * @param [in] mode <tt>OpusCustomMode *</tt>: Mode configuration<br>
	 * @param [in] channels <tt>int</tt>: Number of channels<br>
	 * @returns size<br>
	 * Original signature : <code>int opus_custom_encoder_get_size(const OpusCustomMode*, int)</code><br>
	 * <i>native declaration : /tmp/opus_custom.h:137</i>
	 */
	int opus_custom_encoder_get_size(PointerByReference mode, int channels);
	/**
	 * Creates a new encoder state. Each stream needs its own encoder<br>
	 * state (can't be shared across simultaneous streams).<br>
	 * @param [in] mode <tt>OpusCustomMode*</tt>: Contains all the information about the characteristics of<br>
	 *  the stream (must be the same characteristics as used for the<br>
	 *  decoder)<br>
	 * @param [in] channels <tt>int</tt>: Number of channels<br>
	 * @param [out] error <tt>int*</tt>: Returns an error code<br>
	 * @return Newly created encoder state.<br>
	 * Original signature : <code>OpusCustomEncoder* opus_custom_encoder_create(const OpusCustomMode*, int, int*)</code><br>
	 * <i>native declaration : /tmp/opus_custom.h:173</i>
	 */
	PointerByReference opus_custom_encoder_create(PointerByReference mode, int channels, IntBuffer error);
	/**
	 * Creates a new encoder state. Each stream needs its own encoder<br>
	 * state (can't be shared across simultaneous streams).<br>
	 * @param [in] mode <tt>OpusCustomMode*</tt>: Contains all the information about the characteristics of<br>
	 *  the stream (must be the same characteristics as used for the<br>
	 *  decoder)<br>
	 * @param [in] channels <tt>int</tt>: Number of channels<br>
	 * @param [out] error <tt>int*</tt>: Returns an error code<br>
	 * @return Newly created encoder state.<br>
	 * Original signature : <code>OpusCustomEncoder* opus_custom_encoder_create(const OpusCustomMode*, int, int*)</code><br>
	 * <i>native declaration : /tmp/opus_custom.h:173</i>
	 */
	PointerByReference opus_custom_encoder_create(PointerByReference mode, int channels, IntByReference error);
	/**
	 * Destroys a an encoder state.<br>
	 * @param[in] st <tt>OpusCustomEncoder*</tt>: State to be freed.<br>
	 * Original signature : <code>void opus_custom_encoder_destroy(OpusCustomEncoder*)</code><br>
	 * <i>native declaration : /tmp/opus_custom.h:183</i>
	 */
	void opus_custom_encoder_destroy(PointerByReference st);
	/**
	 * Encodes a frame of audio.<br>
	 * @param [in] st <tt>OpusCustomEncoder*</tt>: Encoder state<br>
	 * @param [in] pcm <tt>float*</tt>: PCM audio in float format, with a normal range of +/-1.0.<br>
	 *          Samples with a range beyond +/-1.0 are supported but will<br>
	 *          be clipped by decoders using the integer API and should<br>
	 *          only be used if it is known that the far end supports<br>
	 *          extended dynamic range. There must be exactly<br>
	 *          frame_size samples per channel.<br>
	 * @param [in] frame_size <tt>int</tt>: Number of samples per frame of input signal<br>
	 * @param [out] compressed <tt>char *</tt>: The compressed data is written here. This may not alias pcm and must be at least maxCompressedBytes long.<br>
	 * @param [in] maxCompressedBytes <tt>int</tt>: Maximum number of bytes to use for compressing the frame<br>
	 *          (can change from one frame to another)<br>
	 * @return Number of bytes written to "compressed".<br>
	 *       If negative, an error has occurred (see error codes). It is IMPORTANT that<br>
	 *       the length returned be somehow transmitted to the decoder. Otherwise, no<br>
	 *       decoding is possible.<br>
	 * Original signature : <code>int opus_custom_encode_float(OpusCustomEncoder*, const float*, int, unsigned char*, int)</code><br>
	 * <i>native declaration : /tmp/opus_custom.h:202</i>
	 */
	int opus_custom_encode_float(PointerByReference st, float pcm[], int frame_size, ByteBuffer compressed, int maxCompressedBytes);
	/**
	 * Encodes a frame of audio.<br>
	 * @param [in] st <tt>OpusCustomEncoder*</tt>: Encoder state<br>
	 * @param [in] pcm <tt>float*</tt>: PCM audio in float format, with a normal range of +/-1.0.<br>
	 *          Samples with a range beyond +/-1.0 are supported but will<br>
	 *          be clipped by decoders using the integer API and should<br>
	 *          only be used if it is known that the far end supports<br>
	 *          extended dynamic range. There must be exactly<br>
	 *          frame_size samples per channel.<br>
	 * @param [in] frame_size <tt>int</tt>: Number of samples per frame of input signal<br>
	 * @param [out] compressed <tt>char *</tt>: The compressed data is written here. This may not alias pcm and must be at least maxCompressedBytes long.<br>
	 * @param [in] maxCompressedBytes <tt>int</tt>: Maximum number of bytes to use for compressing the frame<br>
	 *          (can change from one frame to another)<br>
	 * @return Number of bytes written to "compressed".<br>
	 *       If negative, an error has occurred (see error codes). It is IMPORTANT that<br>
	 *       the length returned be somehow transmitted to the decoder. Otherwise, no<br>
	 *       decoding is possible.<br>
	 * Original signature : <code>int opus_custom_encode_float(OpusCustomEncoder*, const float*, int, unsigned char*, int)</code><br>
	 * <i>native declaration : /tmp/opus_custom.h:202</i>
	 */
	int opus_custom_encode_float(PointerByReference st, FloatByReference pcm, int frame_size, Pointer compressed, int maxCompressedBytes);
	/**
	 * Encodes a frame of audio.<br>
	 * @param [in] st <tt>OpusCustomEncoder*</tt>: Encoder state<br>
	 * @param [in] pcm <tt>opus_int16*</tt>: PCM audio in signed 16-bit format (native endian).<br>
	 *          There must be exactly frame_size samples per channel.<br>
	 * @param [in] frame_size <tt>int</tt>: Number of samples per frame of input signal<br>
	 * @param [out] compressed <tt>char *</tt>: The compressed data is written here. This may not alias pcm and must be at least maxCompressedBytes long.<br>
	 * @param [in] maxCompressedBytes <tt>int</tt>: Maximum number of bytes to use for compressing the frame<br>
	 *          (can change from one frame to another)<br>
	 * @return Number of bytes written to "compressed".<br>
	 *       If negative, an error has occurred (see error codes). It is IMPORTANT that<br>
	 *       the length returned be somehow transmitted to the decoder. Otherwise, no<br>
	 *       decoding is possible.<br>
	 * Original signature : <code>int opus_custom_encode(OpusCustomEncoder*, const opus_int16*, int, unsigned char*, int)</code><br>
	 * <i>native declaration : /tmp/opus_custom.h:223</i>
	 */
	int opus_custom_encode(PointerByReference st, ShortBuffer pcm, int frame_size, ByteBuffer compressed, int maxCompressedBytes);
	/**
	 * Encodes a frame of audio.<br>
	 * @param [in] st <tt>OpusCustomEncoder*</tt>: Encoder state<br>
	 * @param [in] pcm <tt>opus_int16*</tt>: PCM audio in signed 16-bit format (native endian).<br>
	 *          There must be exactly frame_size samples per channel.<br>
	 * @param [in] frame_size <tt>int</tt>: Number of samples per frame of input signal<br>
	 * @param [out] compressed <tt>char *</tt>: The compressed data is written here. This may not alias pcm and must be at least maxCompressedBytes long.<br>
	 * @param [in] maxCompressedBytes <tt>int</tt>: Maximum number of bytes to use for compressing the frame<br>
	 *          (can change from one frame to another)<br>
	 * @return Number of bytes written to "compressed".<br>
	 *       If negative, an error has occurred (see error codes). It is IMPORTANT that<br>
	 *       the length returned be somehow transmitted to the decoder. Otherwise, no<br>
	 *       decoding is possible.<br>
	 * Original signature : <code>int opus_custom_encode(OpusCustomEncoder*, const opus_int16*, int, unsigned char*, int)</code><br>
	 * <i>native declaration : /tmp/opus_custom.h:223</i>
	 */
	int opus_custom_encode(PointerByReference st, ShortByReference pcm, int frame_size, Pointer compressed, int maxCompressedBytes);
	/**
	 * Perform a CTL function on an Opus custom encoder.<br>
	 * * Generally the request and subsequent arguments are generated<br>
	 * by a convenience macro.<br>
	 * @see opus_encoderctls<br>
	 * Original signature : <code>int opus_custom_encoder_ctl(OpusCustomEncoder*, int, null)</code><br>
	 * <i>native declaration : /tmp/opus_custom.h:237</i>
	 */
	int opus_custom_encoder_ctl(PointerByReference st, int request, Object... varargs);
	/**
	 * Gets the size of an OpusCustomDecoder structure.<br>
	 * @param [in] mode <tt>OpusCustomMode *</tt>: Mode configuration<br>
	 * @param [in] channels <tt>int</tt>: Number of channels<br>
	 * @returns size<br>
	 * Original signature : <code>int opus_custom_decoder_get_size(const OpusCustomMode*, int)</code><br>
	 * <i>native declaration : /tmp/opus_custom.h:248</i>
	 */
	int opus_custom_decoder_get_size(PointerByReference mode, int channels);
	/**
	 * Initializes a previously allocated decoder state<br>
	 * The memory pointed to by st must be the size returned by opus_custom_decoder_get_size.<br>
	 * This is intended for applications which use their own allocator instead of malloc.<br>
	 * @see opus_custom_decoder_create(),opus_custom_decoder_get_size()<br>
	 * To reset a previously initialized state use the OPUS_RESET_STATE CTL.<br>
	 * @param [in] st <tt>OpusCustomDecoder*</tt>: Decoder state<br>
	 * @param [in] mode <tt>OpusCustomMode *</tt>: Contains all the information about the characteristics of<br>
	 *  the stream (must be the same characteristics as used for the<br>
	 *  encoder)<br>
	 * @param [in] channels <tt>int</tt>: Number of channels<br>
	 * @return OPUS_OK Success or @ref opus_errorcodes<br>
	 * Original signature : <code>int opus_custom_decoder_init(OpusCustomDecoder*, const OpusCustomMode*, int)</code><br>
	 * <i>native declaration : /tmp/opus_custom.h:265</i>
	 */
	int opus_custom_decoder_init(PointerByReference st, PointerByReference mode, int channels);
	/**
	 * Creates a new decoder state. Each stream needs its own decoder state (can't<br>
	 * be shared across simultaneous streams).<br>
	 * @param [in] mode <tt>OpusCustomMode</tt>: Contains all the information about the characteristics of the<br>
	 *          stream (must be the same characteristics as used for the encoder)<br>
	 * @param [in] channels <tt>int</tt>: Number of channels<br>
	 * @param [out] error <tt>int*</tt>: Returns an error code<br>
	 * @return Newly created decoder state.<br>
	 * Original signature : <code>OpusCustomDecoder* opus_custom_decoder_create(const OpusCustomMode*, int, int*)</code><br>
	 * <i>native declaration : /tmp/opus_custom.h:282</i>
	 */
	PointerByReference opus_custom_decoder_create(PointerByReference mode, int channels, IntBuffer error);
	/**
	 * Creates a new decoder state. Each stream needs its own decoder state (can't<br>
	 * be shared across simultaneous streams).<br>
	 * @param [in] mode <tt>OpusCustomMode</tt>: Contains all the information about the characteristics of the<br>
	 *          stream (must be the same characteristics as used for the encoder)<br>
	 * @param [in] channels <tt>int</tt>: Number of channels<br>
	 * @param [out] error <tt>int*</tt>: Returns an error code<br>
	 * @return Newly created decoder state.<br>
	 * Original signature : <code>OpusCustomDecoder* opus_custom_decoder_create(const OpusCustomMode*, int, int*)</code><br>
	 * <i>native declaration : /tmp/opus_custom.h:282</i>
	 */
	PointerByReference opus_custom_decoder_create(PointerByReference mode, int channels, IntByReference error);
	/**
	 * Destroys a an decoder state.<br>
	 * @param[in] st <tt>OpusCustomDecoder*</tt>: State to be freed.<br>
	 * Original signature : <code>void opus_custom_decoder_destroy(OpusCustomDecoder*)</code><br>
	 * <i>native declaration : /tmp/opus_custom.h:291</i>
	 */
	void opus_custom_decoder_destroy(PointerByReference st);
	/**
	 * Decode an opus custom frame with floating point output<br>
	 * @param [in] st <tt>OpusCustomDecoder*</tt>: Decoder state<br>
	 * @param [in] data <tt>char*</tt>: Input payload. Use a NULL pointer to indicate packet loss<br>
	 * @param [in] len <tt>int</tt>: Number of bytes in payload<br>
	 * @param [out] pcm <tt>float*</tt>: Output signal (interleaved if 2 channels). length<br>
	 *  is frame_size*channels*sizeof(float)<br>
	 * @param [in] frame_size Number of samples per channel of available space in *pcm.<br>
	 * @returns Number of decoded samples or @ref opus_errorcodes<br>
	 * Original signature : <code>int opus_custom_decode_float(OpusCustomDecoder*, const unsigned char*, int, float*, int)</code><br>
	 * <i>native declaration : /tmp/opus_custom.h:302</i>
	 */
	int opus_custom_decode_float(PointerByReference st, byte data[], int len, FloatBuffer pcm, int frame_size);
	/**
	 * Decode an opus custom frame with floating point output<br>
	 * @param [in] st <tt>OpusCustomDecoder*</tt>: Decoder state<br>
	 * @param [in] data <tt>char*</tt>: Input payload. Use a NULL pointer to indicate packet loss<br>
	 * @param [in] len <tt>int</tt>: Number of bytes in payload<br>
	 * @param [out] pcm <tt>float*</tt>: Output signal (interleaved if 2 channels). length<br>
	 *  is frame_size*channels*sizeof(float)<br>
	 * @param [in] frame_size Number of samples per channel of available space in *pcm.<br>
	 * @returns Number of decoded samples or @ref opus_errorcodes<br>
	 * Original signature : <code>int opus_custom_decode_float(OpusCustomDecoder*, const unsigned char*, int, float*, int)</code><br>
	 * <i>native declaration : /tmp/opus_custom.h:302</i>
	 */
	int opus_custom_decode_float(PointerByReference st, Pointer data, int len, FloatByReference pcm, int frame_size);
	/**
	 * Decode an opus custom frame<br>
	 * @param [in] st <tt>OpusCustomDecoder*</tt>: Decoder state<br>
	 * @param [in] data <tt>char*</tt>: Input payload. Use a NULL pointer to indicate packet loss<br>
	 * @param [in] len <tt>int</tt>: Number of bytes in payload<br>
	 * @param [out] pcm <tt>opus_int16*</tt>: Output signal (interleaved if 2 channels). length<br>
	 *  is frame_size*channels*sizeof(opus_int16)<br>
	 * @param [in] frame_size Number of samples per channel of available space in *pcm.<br>
	 * @returns Number of decoded samples or @ref opus_errorcodes<br>
	 * Original signature : <code>int opus_custom_decode(OpusCustomDecoder*, const unsigned char*, int, opus_int16*, int)</code><br>
	 * <i>native declaration : /tmp/opus_custom.h:319</i>
	 */
	int opus_custom_decode(PointerByReference st, byte data[], int len, ShortBuffer pcm, int frame_size);
	/**
	 * Decode an opus custom frame<br>
	 * @param [in] st <tt>OpusCustomDecoder*</tt>: Decoder state<br>
	 * @param [in] data <tt>char*</tt>: Input payload. Use a NULL pointer to indicate packet loss<br>
	 * @param [in] len <tt>int</tt>: Number of bytes in payload<br>
	 * @param [out] pcm <tt>opus_int16*</tt>: Output signal (interleaved if 2 channels). length<br>
	 *  is frame_size*channels*sizeof(opus_int16)<br>
	 * @param [in] frame_size Number of samples per channel of available space in *pcm.<br>
	 * @returns Number of decoded samples or @ref opus_errorcodes<br>
	 * Original signature : <code>int opus_custom_decode(OpusCustomDecoder*, const unsigned char*, int, opus_int16*, int)</code><br>
	 * <i>native declaration : /tmp/opus_custom.h:319</i>
	 */
	int opus_custom_decode(PointerByReference st, Pointer data, int len, ShortByReference pcm, int frame_size);
	/**
	 * Perform a CTL function on an Opus custom decoder.<br>
	 * * Generally the request and subsequent arguments are generated<br>
	 * by a convenience macro.<br>
	 * @see opus_genericctls<br>
	 * Original signature : <code>int opus_custom_decoder_ctl(OpusCustomDecoder*, int, null)</code><br>
	 * <i>native declaration : /tmp/opus_custom.h:333</i>
	 */
	int opus_custom_decoder_ctl(PointerByReference st, int request, Object... varargs);
	public static class OpusCustomDecoder extends PointerType {
		public OpusCustomDecoder(Pointer address) {
			super(address);
		}
		public OpusCustomDecoder() {
			super();
		}
	};
	public static class OpusCustomEncoder extends PointerType {
		public OpusCustomEncoder(Pointer address) {
			super(address);
		}
		public OpusCustomEncoder() {
			super();
		}
	};
	public static class OpusCustomMode extends PointerType {
		public OpusCustomMode(Pointer address) {
			super(address);
		}
		public OpusCustomMode() {
			super();
		}
	};
}
