/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.rpc;

import java.io.IOException;
import java.security.PublicKey;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.SortedMap;
import java.util.concurrent.locks.Lock;
import net.tomp2p.connection.ChannelCreator;
import net.tomp2p.connection.ConnectionBean;
import net.tomp2p.connection.PeerBean;
import net.tomp2p.futures.FutureResponse;
import net.tomp2p.futures.FutureSuccessEvaluator;
import net.tomp2p.message.Message;
import net.tomp2p.peers.Number160;
import net.tomp2p.peers.Number320;
import net.tomp2p.peers.Number480;
import net.tomp2p.peers.PeerAddress;
import net.tomp2p.rpc.CacheKey;
import net.tomp2p.rpc.DigestInfo;
import net.tomp2p.rpc.HashData;
import net.tomp2p.rpc.ReplyHandler;
import net.tomp2p.rpc.RequestHandlerTCP;
import net.tomp2p.rpc.RequestHandlerUDP;
import net.tomp2p.rpc.SenderCacheStrategy;
import net.tomp2p.rpc.SimpleBloomFilter;
import net.tomp2p.storage.Data;
import net.tomp2p.storage.StorageGeneric;
import net.tomp2p.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StorageRPC
extends ReplyHandler {
    private static final Logger logger = LoggerFactory.getLogger(StorageRPC.class);
    static final int bitArraySize = 9000;
    static final int expectedElements = 1000;
    private static final Random rnd = new Random();

    public StorageRPC(PeerBean peerBean, ConnectionBean connectionBean) {
        super(peerBean, connectionBean);
        this.registerIoHandler(Message.Command.COMPARE_PUT, Message.Command.PUT, Message.Command.GET, Message.Command.ADD, Message.Command.REMOVE);
    }

    public PeerAddress getPeerAddress() {
        return this.getPeerBean().getServerPeerAddress();
    }

    public FutureResponse put(PeerAddress remotePeer, Number160 locationKey, Number160 domainKey, Map<Number160, Data> dataMap, boolean protectDomain, boolean protectEntry, boolean signMessage, ChannelCreator channelCreator, boolean forceUDP, SenderCacheStrategy senderCacheStrategy) {
        Message.Type request = protectDomain ? Message.Type.REQUEST_2 : Message.Type.REQUEST_1;
        return this.put(remotePeer, locationKey, domainKey, dataMap, request, protectDomain || signMessage || protectEntry, channelCreator, forceUDP, senderCacheStrategy);
    }

    public FutureResponse putIfAbsent(PeerAddress remotePeer, Number160 locationKey, Number160 domainKey, Map<Number160, Data> dataMap, boolean protectDomain, boolean protectEntry, boolean signMessage, ChannelCreator channelCreator, boolean forceUDP, SenderCacheStrategy senderCacheStrategy) {
        Message.Type request = protectDomain ? Message.Type.REQUEST_4 : Message.Type.REQUEST_3;
        return this.put(remotePeer, locationKey, domainKey, dataMap, request, protectDomain || signMessage || protectEntry, channelCreator, forceUDP, senderCacheStrategy);
    }

    public FutureResponse compareAndPut(PeerAddress remotePeer, Number160 locationKey, Number160 domainKey, Map<Number160, HashData> hashDataMap, FutureSuccessEvaluator futureSuccessEvaluator, boolean protectDomain, boolean protectEntry, boolean signMessage, boolean partialPut, ChannelCreator channelCreator, boolean forceUDP) {
        Utils.nullCheck(remotePeer, locationKey, domainKey, hashDataMap);
        Message message = protectDomain ? this.createMessage(remotePeer, Message.Command.COMPARE_PUT, partialPut ? Message.Type.REQUEST_4 : Message.Type.REQUEST_2) : this.createMessage(remotePeer, Message.Command.COMPARE_PUT, partialPut ? Message.Type.REQUEST_3 : Message.Type.REQUEST_1);
        if (signMessage) {
            message.setPublicKeyAndSign(this.getPeerBean().getKeyPair());
        }
        message.setKeyKey(locationKey, domainKey);
        message.setHashDataMap(hashDataMap);
        FutureResponse futureResponse = new FutureResponse(message, futureSuccessEvaluator);
        if (!forceUDP) {
            RequestHandlerTCP<FutureResponse> request = new RequestHandlerTCP<FutureResponse>(futureResponse, this.getPeerBean(), this.getConnectionBean(), message);
            return request.sendTCP(channelCreator);
        }
        RequestHandlerUDP<FutureResponse> request = new RequestHandlerUDP<FutureResponse>(futureResponse, this.getPeerBean(), this.getConnectionBean(), message);
        return request.sendUDP(channelCreator);
    }

    private FutureResponse put(PeerAddress remotePeer, Number160 locationKey, Number160 domainKey, Map<Number160, Data> dataMap, Message.Type type, boolean signMessage, ChannelCreator channelCreator, boolean forceUDP, SenderCacheStrategy senderCacheStrategy) {
        Utils.nullCheck(remotePeer, locationKey, domainKey, dataMap);
        Message message = this.createMessage(remotePeer, Message.Command.PUT, type);
        if (signMessage) {
            message.setPublicKeyAndSign(this.getPeerBean().getKeyPair());
        }
        message.setKeyKey(locationKey, domainKey);
        message.setDataMap(dataMap);
        FutureResponse futureResponse = new FutureResponse(message);
        if (senderCacheStrategy == null) {
            if (!forceUDP) {
                RequestHandlerTCP<FutureResponse> request = new RequestHandlerTCP<FutureResponse>(futureResponse, this.getPeerBean(), this.getConnectionBean(), message);
                return request.sendTCP(channelCreator);
            }
            RequestHandlerUDP<FutureResponse> request = new RequestHandlerUDP<FutureResponse>(futureResponse, this.getPeerBean(), this.getConnectionBean(), message);
            return request.sendUDP(channelCreator);
        }
        if (forceUDP) {
            throw new IllegalArgumentException("cannot bulk transfer with UDP");
        }
        RequestHandlerTCP<FutureResponse> request = new RequestHandlerTCP<FutureResponse>(futureResponse, this.getPeerBean(), this.getConnectionBean(), message);
        CacheKey cacheKey = new CacheKey(remotePeer, type, signMessage);
        return senderCacheStrategy.putIfAbsent(cacheKey, request, channelCreator);
    }

    public FutureResponse add(PeerAddress remotePeer, Number160 locationKey, Number160 domainKey, Collection<Data> dataSet, boolean protectDomain, boolean signMessage, boolean list, ChannelCreator channelCreator, boolean forceUDP, SenderCacheStrategy senderCacheStrategy) {
        Utils.nullCheck(remotePeer, locationKey, domainKey, dataSet);
        Message.Type type = protectDomain ? (list ? Message.Type.REQUEST_4 : Message.Type.REQUEST_2) : (list ? Message.Type.REQUEST_3 : Message.Type.REQUEST_1);
        HashMap<Number160, Data> dataMap = new HashMap<Number160, Data>(dataSet.size());
        for (Data data : dataSet) {
            dataMap.put(data.getHash(), data);
        }
        Message message = this.createMessage(remotePeer, Message.Command.ADD, type);
        if (protectDomain || signMessage) {
            message.setPublicKeyAndSign(this.getPeerBean().getKeyPair());
        }
        message.setKeyKey(locationKey, domainKey);
        message.setDataMap(dataMap);
        FutureResponse futureResponse = new FutureResponse(message);
        if (senderCacheStrategy == null) {
            if (!forceUDP) {
                RequestHandlerTCP<FutureResponse> request = new RequestHandlerTCP<FutureResponse>(futureResponse, this.getPeerBean(), this.getConnectionBean(), message);
                return request.sendTCP(channelCreator);
            }
            RequestHandlerUDP<FutureResponse> request = new RequestHandlerUDP<FutureResponse>(futureResponse, this.getPeerBean(), this.getConnectionBean(), message);
            return request.sendUDP(channelCreator);
        }
        if (forceUDP) {
            throw new IllegalArgumentException("cannot bulk transfer with UDP");
        }
        RequestHandlerTCP<FutureResponse> request = new RequestHandlerTCP<FutureResponse>(futureResponse, this.getPeerBean(), this.getConnectionBean(), message);
        CacheKey cacheKey = new CacheKey(remotePeer, type, signMessage);
        return senderCacheStrategy.putIfAbsent(cacheKey, request, channelCreator);
    }

    public FutureResponse get(PeerAddress remotePeer, Number160 locationKey, Number160 domainKey, Collection<Number160> contentKeys, SimpleBloomFilter<Number160> keyBloomFilter, SimpleBloomFilter<Number160> contentBloomFilter, boolean signMessage, boolean digest, boolean returnBloomFilter, boolean range, ChannelCreator channelCreator, boolean forceUDP) {
        Utils.nullCheck(remotePeer, locationKey, domainKey);
        Message.Type type = range && !digest ? Message.Type.REQUEST_4 : (!range && !digest ? Message.Type.REQUEST_1 : (digest && !returnBloomFilter ? Message.Type.REQUEST_2 : Message.Type.REQUEST_3));
        Message message = this.createMessage(remotePeer, Message.Command.GET, type);
        if (signMessage) {
            message.setPublicKeyAndSign(this.getPeerBean().getKeyPair());
        }
        message.setKeyKey(locationKey, domainKey);
        if (contentKeys != null) {
            message.setKeys(contentKeys);
        } else if (keyBloomFilter != null || contentBloomFilter != null) {
            message.setTwoBloomFilter(keyBloomFilter, contentBloomFilter);
        }
        FutureResponse futureResponse = new FutureResponse(message);
        if (!forceUDP) {
            RequestHandlerTCP<FutureResponse> request = new RequestHandlerTCP<FutureResponse>(futureResponse, this.getPeerBean(), this.getConnectionBean(), message);
            return request.sendTCP(channelCreator);
        }
        RequestHandlerUDP<FutureResponse> request = new RequestHandlerUDP<FutureResponse>(futureResponse, this.getPeerBean(), this.getConnectionBean(), message);
        return request.sendUDP(channelCreator);
    }

    public FutureResponse remove(PeerAddress remotePeer, Number160 locationKey, Number160 domainKey, Collection<Number160> contentKeys, boolean sendBackResults, boolean signMessage, ChannelCreator channelCreator, boolean forceUDP) {
        Utils.nullCheck(remotePeer, locationKey, domainKey);
        Message message = this.createMessage(remotePeer, Message.Command.REMOVE, sendBackResults ? Message.Type.REQUEST_2 : Message.Type.REQUEST_1);
        if (signMessage) {
            message.setPublicKeyAndSign(this.getPeerBean().getKeyPair());
        }
        message.setKeyKey(locationKey, domainKey);
        if (contentKeys != null) {
            message.setKeys(contentKeys);
        }
        FutureResponse futureResponse = new FutureResponse(message);
        RequestHandlerTCP<FutureResponse> request = new RequestHandlerTCP<FutureResponse>(futureResponse, this.getPeerBean(), this.getConnectionBean(), message);
        return request.sendTCP(channelCreator);
    }

    @Override
    public Message handleResponse(Message message, boolean sign) throws IOException {
        if (message.getCommand() != Message.Command.ADD && message.getCommand() != Message.Command.PUT && message.getCommand() != Message.Command.GET && message.getCommand() != Message.Command.REMOVE && message.getCommand() != Message.Command.COMPARE_PUT) {
            throw new IllegalArgumentException("Message content is wrong");
        }
        Message responseMessage = this.createResponseMessage(message, Message.Type.OK);
        if (sign) {
            responseMessage.setPublicKeyAndSign(this.getPeerBean().getKeyPair());
        }
        switch (message.getCommand()) {
            case ADD: {
                boolean isNull = Utils.nullCheckRetVal(message.getKeyKey1(), message.getKeyKey2(), message.getDataMap());
                if (isNull) {
                    Utils.nullCheck(message.getDataMap480());
                }
                return this.handleAdd(message, responseMessage, this.isDomainProtected(message), isNull);
            }
            case PUT: {
                boolean isNull = Utils.nullCheckRetVal(message.getKeyKey1(), message.getKeyKey2(), message.getDataMap());
                if (isNull) {
                    Utils.nullCheck(message.getDataMap480());
                }
                return this.handlePut(message, responseMessage, this.isStoreIfAbsent(message), this.isDomainProtected(message), isNull);
            }
            case GET: {
                Utils.nullCheck(message.getKeyKey1(), message.getKeyKey2());
                return this.handleGet(message, responseMessage);
            }
            case REMOVE: {
                Utils.nullCheck(message.getKeyKey1(), message.getKeyKey2());
                return this.handleRemove(message, responseMessage, message.getType() == Message.Type.REQUEST_2);
            }
            case COMPARE_PUT: {
                Utils.nullCheck(message.getKeyKey1(), message.getKeyKey2(), message.getHashDataMap());
                return this.handleCompareAndPut(message, responseMessage, this.isPartial(message), this.isDomainProtected(message));
            }
        }
        throw new IllegalArgumentException("Message content is wrong");
    }

    private boolean isDomainProtected(Message message) {
        boolean protectDomain = message.getPublicKey() != null && (message.getType() == Message.Type.REQUEST_2 || message.getType() == Message.Type.REQUEST_4);
        return protectDomain;
    }

    private boolean isStoreIfAbsent(Message message) {
        boolean absent = message.getType() == Message.Type.REQUEST_3 || message.getType() == Message.Type.REQUEST_4;
        return absent;
    }

    private boolean isPartial(Message message) {
        boolean partial = message.getType() == Message.Type.REQUEST_3 || message.getType() == Message.Type.REQUEST_4;
        return partial;
    }

    private boolean isList(Message message) {
        boolean partial = message.getType() == Message.Type.REQUEST_3 || message.getType() == Message.Type.REQUEST_4;
        return partial;
    }

    private Message handlePut(Message message, Message responseMessage, boolean putIfAbsent, boolean protectDomain, boolean isDataMap480) throws IOException {
        PublicKey publicKey = message.getPublicKey();
        if (isDataMap480) {
            HashSet<Number480> result = new HashSet<Number480>();
            Map<Number480, Data> toStore = message.getDataMap480();
            int dataSize = toStore.size();
            for (Map.Entry<Number480, Data> entry : toStore.entrySet()) {
                if (!this.doPut(putIfAbsent, protectDomain, publicKey, entry.getKey().getLocationKey(), entry.getKey().getDomainKey(), entry.getKey().getContentKey(), entry.getValue())) continue;
                result.add(entry.getKey());
                if (this.getPeerBean().getReplicationStorage() == null) continue;
                this.getPeerBean().getReplicationStorage().updateAndNotifyResponsibilities(entry.getKey().getLocationKey());
            }
            if (result.size() == 0 && !putIfAbsent) {
                responseMessage.setType(Message.Type.DENIED);
            } else if (result.size() == 0 && putIfAbsent) {
                responseMessage.setType(Message.Type.OK);
                responseMessage.setKeys480(result);
            } else {
                responseMessage.setKeys480(result);
                if (result.size() != dataSize) {
                    responseMessage.setType(Message.Type.PARTIALLY_OK);
                }
            }
        } else {
            HashSet<Number160> result = new HashSet<Number160>();
            Number160 locationKey = message.getKeyKey1();
            Number160 domainKey = message.getKeyKey2();
            Map<Number160, Data> toStore = message.getDataMap();
            int dataSize = toStore.size();
            for (Map.Entry<Number160, Data> entry : toStore.entrySet()) {
                if (!this.doPut(putIfAbsent, protectDomain, publicKey, locationKey, domainKey, entry.getKey(), entry.getValue())) continue;
                result.add(entry.getKey());
            }
            if (result.size() > 0 && this.getPeerBean().getReplicationStorage() != null) {
                this.getPeerBean().getReplicationStorage().updateAndNotifyResponsibilities(locationKey);
            }
            if (result.size() == 0 && !putIfAbsent) {
                responseMessage.setType(Message.Type.DENIED);
            } else if (result.size() == 0 && putIfAbsent) {
                responseMessage.setType(Message.Type.OK);
                responseMessage.setKeys(result);
            } else {
                responseMessage.setKeys(result);
                if (result.size() != dataSize) {
                    responseMessage.setType(Message.Type.PARTIALLY_OK);
                }
            }
        }
        return responseMessage;
    }

    private boolean doPut(boolean putIfAbsent, boolean protectDomain, PublicKey publicKey, Number160 locationKey, Number160 domainKey, Number160 contentKey, Data value) {
        if (this.getPeerBean().getStorage().put(locationKey, domainKey, contentKey, value, publicKey, putIfAbsent, protectDomain) == StorageGeneric.PutStatus.OK) {
            if (logger.isDebugEnabled()) {
                logger.debug("put data with key " + locationKey + " on " + this.getPeerBean().getServerPeerAddress());
            }
            return true;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("could not add " + locationKey + " on " + this.getPeerBean().getServerPeerAddress());
        }
        return false;
    }

    private Message handleAdd(Message message, Message responseMessage, boolean protectDomain, boolean isDataMap480) {
        if (isDataMap480) {
            HashSet<Number480> result = new HashSet<Number480>();
            Map<Number480, Data> data480 = message.getDataMap480();
            PublicKey publicKey = message.getPublicKey();
            boolean list = this.isList(message);
            for (Map.Entry<Number480, Data> entry : data480.entrySet()) {
                Number160 contentKey = StorageRPC.doAdd(protectDomain, entry.getKey().getLocationKey(), entry.getKey().getDomainKey(), entry.getKey().getContentKey(), entry.getValue(), publicKey, list, this.getPeerBean());
                if (contentKey != null) {
                    result.add(new Number480(entry.getKey().getLocationKey(), entry.getKey().getDomainKey(), contentKey));
                }
                if (result.size() <= 0 || this.getPeerBean().getReplicationStorage() == null) continue;
                this.getPeerBean().getReplicationStorage().updateAndNotifyResponsibilities(entry.getKey().getLocationKey());
            }
            responseMessage.setKeys480(result);
        } else {
            Number160 locationKey = message.getKeyKey1();
            Number160 domainKey = message.getKeyKey2();
            Map<Number160, Data> data = message.getDataMap();
            PublicKey publicKey = message.getPublicKey();
            boolean list = this.isList(message);
            HashSet<Number160> result = new HashSet<Number160>();
            for (Map.Entry<Number160, Data> entry : data.entrySet()) {
                Number160 contentKey = StorageRPC.doAdd(protectDomain, locationKey, domainKey, entry.getKey(), entry.getValue(), publicKey, list, this.getPeerBean());
                if (contentKey == null) continue;
                result.add(contentKey);
            }
            if (result.size() > 0 && this.getPeerBean().getReplicationStorage() != null) {
                this.getPeerBean().getReplicationStorage().updateAndNotifyResponsibilities(locationKey);
            }
            responseMessage.setKeys(result);
        }
        return responseMessage;
    }

    private static Number160 doAdd(boolean protectDomain, Number160 locationKey, Number160 domainKey, Number160 contentKey, Data value, PublicKey publicKey, boolean list, PeerBean peerBean) {
        if (list) {
            StorageGeneric.PutStatus status;
            Number160 contentKey2 = new Number160(rnd);
            while ((status = peerBean.getStorage().put(locationKey, domainKey, contentKey2, value, publicKey, true, protectDomain)) == StorageGeneric.PutStatus.FAILED_NOT_ABSENT) {
                contentKey2 = new Number160(rnd);
            }
            if (status == StorageGeneric.PutStatus.OK) {
                if (logger.isDebugEnabled()) {
                    logger.debug("add list data with key " + locationKey + " on " + peerBean.getServerPeerAddress());
                }
                return contentKey2;
            }
        } else if (peerBean.getStorage().put(locationKey, domainKey, contentKey, value, publicKey, false, protectDomain) == StorageGeneric.PutStatus.OK) {
            if (logger.isDebugEnabled()) {
                logger.debug("add data with key " + locationKey + " on " + peerBean.getServerPeerAddress());
            }
            return contentKey;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Message handleGet(Message message, Message responseMessage) {
        HashMap<Number480, Data> result;
        boolean digest;
        Number160 locationKey = message.getKeyKey1();
        Number160 domainKey = message.getKeyKey2();
        Collection<Number160> contentKeys = message.getKeys();
        SimpleBloomFilter<Number160> keyBloomFilter = message.getBloomFilter1();
        SimpleBloomFilter<Number160> contentBloomFilter = message.getBloomFilter2();
        boolean range = message.getType() == Message.Type.REQUEST_4;
        boolean bl = digest = message.getType() == Message.Type.REQUEST_2 || message.getType() == Message.Type.REQUEST_3;
        if (digest) {
            DigestInfo digestInfo = keyBloomFilter != null || contentBloomFilter != null ? this.getPeerBean().getStorage().digest(locationKey, domainKey, keyBloomFilter, contentBloomFilter) : this.getPeerBean().getStorage().digest(locationKey, domainKey, contentKeys);
            if (message.getType() == Message.Type.REQUEST_2) {
                responseMessage.setKeyMap(digestInfo.getDigests());
            } else if (message.getType() == Message.Type.REQUEST_3) {
                responseMessage.setTwoBloomFilter(digestInfo.getKeyBloomFilter(9000, 1000), digestInfo.getContentBloomFilter(9000, 1000));
            }
            return responseMessage;
        }
        if (contentKeys != null) {
            result = new HashMap();
            if (!range || contentKeys.size() != 2) {
                for (Number160 contentKey : contentKeys) {
                    Data data = this.getPeerBean().getStorage().get(locationKey, domainKey, contentKey);
                    if (data == null) continue;
                    Number480 key = new Number480(locationKey, domainKey, contentKey);
                    result.put(key, data);
                }
            } else {
                Iterator<Number160> iterator = contentKeys.iterator();
                Number160 min = iterator.next();
                Number160 max = iterator.next();
                SortedMap<Number480, Data> map = this.getPeerBean().getStorage().get(locationKey, domainKey, min, max);
                Number320 lockKey = new Number320(locationKey, domainKey);
                Lock lock = this.getPeerBean().getStorage().getLockNumber320().lock(lockKey);
                try {
                    result.putAll(map);
                }
                finally {
                    this.getPeerBean().getStorage().getLockNumber320().unlock(lockKey, lock);
                }
            }
        } else if (keyBloomFilter != null || contentBloomFilter != null) {
            result = new HashMap();
            SortedMap<Number480, Data> tmp = this.getPeerBean().getStorage().get(locationKey, domainKey, Number160.ZERO, Number160.MAX_VALUE);
            Number320 lockKey = new Number320(locationKey, domainKey);
            Lock lock = this.getPeerBean().getStorage().getLockNumber320().lock(lockKey);
            try {
                for (Map.Entry<Number480, Data> entry : tmp.entrySet()) {
                    if (keyBloomFilter != null && !keyBloomFilter.contains(entry.getKey().getContentKey()) || contentBloomFilter != null && !contentBloomFilter.contains(entry.getValue().getHash())) continue;
                    result.put(entry.getKey(), entry.getValue());
                }
            }
            finally {
                this.getPeerBean().getStorage().getLockNumber320().unlock(lockKey, lock);
            }
        } else {
            result = this.getPeerBean().getStorage().get(locationKey, domainKey, Number160.ZERO, Number160.MAX_VALUE);
        }
        responseMessage.setDataMapConvert(result);
        return responseMessage;
    }

    private Message handleRemove(Message message, Message responseMessage, boolean sendBackResults) {
        Map<Object, Object> result;
        Number160 locationKey = message.getKeyKey1();
        Number160 domainKey = message.getKeyKey2();
        Collection<Number160> contentKeys = message.getKeys();
        PublicKey publicKey = message.getPublicKey();
        if (contentKeys != null) {
            result = new HashMap();
            for (Number160 contentKey : contentKeys) {
                Number480 key = new Number480(locationKey, domainKey, contentKey);
                Data data = this.getPeerBean().getStorage().remove(locationKey, domainKey, contentKey, publicKey);
                if (data == null) continue;
                result.put(key, data);
            }
        } else {
            result = this.getPeerBean().getStorage().remove(locationKey, domainKey, Number160.ZERO, Number160.MAX_VALUE, publicKey);
        }
        if (!sendBackResults) {
            responseMessage.setKeysConvert(result.keySet());
        } else {
            responseMessage.setDataMapConvert(result);
        }
        return responseMessage;
    }

    private Message handleCompareAndPut(Message message, Message responseMessage, boolean partial, boolean protectDomain) {
        Number160 locationKey = message.getKeyKey1();
        Number160 domainKey = message.getKeyKey2();
        Map<Number160, HashData> hashDataMap = message.getHashDataMap();
        PublicKey publicKey = message.getPublicKey();
        Collection<Number160> result = this.getPeerBean().getStorage().compareAndPut(locationKey, domainKey, hashDataMap, publicKey, partial, protectDomain);
        if (logger.isDebugEnabled()) {
            logger.debug("stored " + result.size());
        }
        if (result.size() > 0 && this.getPeerBean().getReplicationStorage() != null) {
            this.getPeerBean().getReplicationStorage().updateAndNotifyResponsibilities(locationKey);
        }
        responseMessage.setKeys(result);
        if (result.size() == 0) {
            responseMessage.setType(Message.Type.NOT_FOUND);
        } else if (result.size() != hashDataMap.size()) {
            responseMessage.setType(Message.Type.PARTIALLY_OK);
        }
        return responseMessage;
    }
}

